/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class CompanyDirectory
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        return "IncludeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListEmployees(ActionContext context) {
        if (!this.hasPermission(context, "contacts-internal_contacts-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo companyDirectoryInfo = this.getPagedListInfo(context, "CompanyDirectoryInfo");
        companyDirectoryInfo.setLink("CompanyDirectory.do?command=ListEmployees");
        Connection db = null;
        ContactList employeeList = new ContactList();
        try {
            db = this.getConnection(context);
            employeeList.setPagedListInfo(companyDirectoryInfo);
            employeeList.setEmployeesOnly(1);
            employeeList.setLeadsOnly(0);
            employeeList.setCheckEnabledUserAccess(true);
            employeeList.setBuildDetails(true);
            employeeList.setPersonalId(-2);
            employeeList.setBuildTypes(false);
            employeeList.setSiteId(this.getUserSiteId(context));
            employeeList.setExclusiveToSite(true);
            if (this.getUser(context, this.getUserId(context)).getSiteId() == -1) {
                employeeList.setIncludeAllSites(true);
            }
            employeeList.buildList(db);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Internal Contacts", "Internal List");
        if (errorMessage == null) {
            context.getRequest().setAttribute("EmployeeList", (Object)employeeList);
            return "ListEmployeesOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEmployeeDetails(ActionContext context) {
        if (!this.hasPermission(context, "contacts-internal_contacts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisEmployee = null;
        String employeeId = context.getRequest().getParameter("empid");
        try {
            db = this.getConnection(context);
            thisEmployee = new Contact(db, employeeId);
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisEmployee)) {
                String string = "PermissionError";
                return string;
            }
            thisEmployee.checkEnabledUserAccount(db);
            context.getRequest().setAttribute("ContactDetails", (Object)thisEmployee);
            this.addRecentItem(context, (Object)thisEmployee);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Internal Contacts", "View Employee Details");
        return CompanyDirectory.getReturn(context, "EmployeeDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyEmployee(ActionContext context) {
        if (!this.hasPermission(context, "contacts-internal_contacts-view")) {
            return "PermissionError";
        }
        String employeeId = context.getRequest().getParameter("empid");
        Connection db = null;
        Contact thisEmployee = null;
        try {
            db = this.getConnection(context);
            thisEmployee = (Contact)((Object)context.getFormBean());
            thisEmployee.queryRecord(db, Integer.parseInt(employeeId));
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisEmployee)) {
                String string = "PermissionError";
                return string;
            }
            thisEmployee.checkEnabledUserAccount(db);
            this.addRecentItem(context, (Object)thisEmployee);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Internal Contacts", "Modify Employee Details");
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        int resultCount = 0;
        boolean recordInserted = false;
        boolean isValid = false;
        String permission = "contacts-internal_contacts-add";
        Contact thisEmployee = (Contact)((Object)context.getFormBean());
        thisEmployee.setEmployee(true);
        thisEmployee.setRequestItems(context);
        thisEmployee.setEnteredBy(this.getUserId(context));
        thisEmployee.setModifiedBy(this.getUserId(context));
        if (thisEmployee.getId() > 0) {
            permission = "accounts-accounts-contacts-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypes = this.getSystemStatus(context).getAccessTypeList(db, 626030332);
            thisEmployee.setAccessType(accessTypes.getDefaultItem());
            if (thisEmployee.getId() == -1) {
                thisEmployee.setOrgId(0);
                this.addModuleBean(context, "Internal Contacts", "Internal Insert");
                isValid = this.validateObject(context, db, (Object)thisEmployee);
                if (isValid) {
                    if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisEmployee)) {
                        String string = "PermissionError";
                        return string;
                    }
                    recordInserted = thisEmployee.insert(db);
                }
            } else {
                this.addModuleBean(context, "Internal Contacts", "Update Employee");
                isValid = this.validateObject(context, db, (Object)thisEmployee);
                if (isValid) {
                    if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisEmployee)) {
                        String string = "PermissionError";
                        return string;
                    }
                    resultCount = thisEmployee.update(db);
                }
            }
            if (recordInserted) {
                thisEmployee = new Contact(db, thisEmployee.getId());
                context.getRequest().setAttribute("ContactDetails", (Object)thisEmployee);
                this.addRecentItem(context, (Object)thisEmployee);
            } else if (resultCount == 1) {
                thisEmployee.checkUserAccount(db);
                this.updateUserContact(db, context, thisEmployee.getUserId());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            if ("true".equals(context.getRequest().getParameter("saveAndNew"))) {
                context.getRequest().setAttribute("ContactDetails", (Object)new Contact());
                return this.executeCommandPrepare(context);
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisEmployee);
            if ("true".equals(context.getRequest().getParameter("popup"))) {
                if ("troubletickets".equals(context.getRequest().getParameter("source"))) {
                    return "TroubleTicketsCloseInsertPopup";
                }
                return "CloseInsertContactPopup";
            }
            return "EmployeeDetailsOK";
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandListEmployees(context);
            }
            return "EmployeeDetailsUpdateOK";
        }
        if (thisEmployee.getId() == -1) {
            if (!"true".equals(context.getRequest().getParameter("popup")) || "troubletickets".equals(context.getRequest().getParameter("source"))) {
                return this.executeCommandPrepare(context);
            }
            return "ReloadAddContactPopup";
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandPrepare(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Contact thisContact = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (!this.hasPermission(context, "contacts-internal_contacts-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisContact = new Contact(db, id);
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisContact.checkUserAccount(db);
            DependencyList dependencies = thisContact.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (!thisContact.hasAccount()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.employeeUserAccountHeader"));
            }
            htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='CompanyDirectory.do?command=TrashEmployee&empid=" + id + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId|popup|sourcePopup") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Contact thisContact = (Contact)((Object)context.getFormBean());
        if (thisContact.getId() == -1) {
            if (!this.hasPermission(context, "contacts-internal_contacts-add")) {
                return "PermissionError";
            }
            this.addModuleBean(context, "Internal Contacts", "Add a new Employee");
        }
        try {
            db = this.getConnection(context);
            LookupList departmentList = new LookupList(db, "lookup_department");
            departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getRequest().getParameter("actionSource") != null) {
            return CompanyDirectory.getReturn(context, "EmployeePrepare");
        }
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteEmployee(ActionContext context) {
        if (!this.hasPermission(context, "contacts-internal_contacts-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("empid"));
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContact.delete(db, CompanyDirectory.getDbNamePath(context));
            this.processErrors(context, thisContact.getErrors());
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Internal Contacts", "Internal Delete");
        if (errorMessage == null) {
            if (recordDeleted) {
                this.deleteRecentItem(context, (Object)thisContact);
                if ("true".equals(context.getRequest().getParameter("popup"))) {
                    context.getRequest().setAttribute("refreshUrl", (Object)"CompanyDirectory.do?command=ListEmployees");
                    return "EmployeeDeletePopupOK";
                }
                return "EmployeeDeleteOK";
            }
            this.processErrors(context, thisContact.getErrors());
            return this.executeCommandListEmployees(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrashEmployee(ActionContext context) {
        if (!this.hasPermission(context, "contacts-internal_contacts-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        String popup = context.getRequest().getParameter("sourcePopup");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("empid"));
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContact.updateStatus(db, context, true, this.getUserId(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Internal Contacts", "Internal Delete");
        if (errorMessage == null) {
            if (recordDeleted) {
                this.deleteRecentItem(context, (Object)thisContact);
                if (popup != null && "true".equals(popup)) {
                    return "EmployeeDeletePopupOK";
                }
                context.getRequest().setAttribute("refreshUrl", (Object)"CompanyDirectory.do?command=ListEmployees");
                return "EmployeeDeleteOK";
            }
            this.processErrors(context, thisContact.getErrors());
            return this.executeCommandListEmployees(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFolderList(ActionContext context) {
        Contact thisContact;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "contacts-internal_contacts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisContact = null;
            String empId = context.getRequest().getParameter("empid");
            db = this.getConnection(context);
            thisContact = new Contact(db, Integer.parseInt(empId));
            if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200513);
            thisList.setLinkItemId(thisContact.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Employees", "Custom Fields Details");
        return CompanyDirectory.getReturn(context, "FolderList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFields(ActionContext context) {
        boolean showRecords;
        String recordId;
        String catId;
        Contact thisContact;
        Connection db;
        block15: {
            if (!this.hasPermission(context, "contacts-internal_contacts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisContact = null;
            catId = null;
            recordId = null;
            showRecords = true;
            String empId = context.getRequest().getParameter("empid");
            db = this.getConnection(context);
            thisContact = new Contact(db, Integer.parseInt(empId));
            if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block15;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200513);
            thisList.setLinkItemId(thisContact.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            catId = context.getRequest().getParameter("catId");
            if (Integer.parseInt(catId) > 0) {
                recordId = context.getRequest().getParameter("recId");
                String recordDeleted = (String)context.getRequest().getAttribute("recordDeleted");
                if (recordDeleted != null) {
                    recordId = null;
                }
                CustomFieldCategory thisCategory = thisList.getCategory(Integer.parseInt(catId));
                if (recordId == null && thisCategory.getAllowMultipleRecords()) {
                    CustomFieldRecordList recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(120200513);
                    recordList.setLinkItemId(thisContact.getId());
                    recordList.setCategoryId(thisCategory.getId());
                    recordList.buildList(db);
                    recordList.buildRecordColumns(db, thisCategory);
                    context.getRequest().setAttribute("Records", (Object)recordList);
                } else {
                    thisCategory.setLinkModuleId(120200513);
                    thisCategory.setLinkItemId(thisContact.getId());
                    if (recordId != null) {
                        thisCategory.setRecordId(Integer.parseInt(recordId));
                    } else {
                        thisCategory.buildRecordId(db);
                        recordId = String.valueOf(thisCategory.getRecordId());
                    }
                    thisCategory.setIncludeEnabled(1);
                    thisCategory.setIncludeScheduled(1);
                    thisCategory.setBuildResources(true);
                    thisCategory.buildResources(db);
                    showRecords = false;
                    if (thisCategory.getRecordId() > -1) {
                        CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                        context.getRequest().setAttribute("Record", (Object)thisRecord);
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Employees", "Custom Fields Details");
        if (catId != null && Integer.parseInt(catId) <= 0) {
            return CompanyDirectory.getReturn(context, "FieldsEmpty");
        }
        if (recordId == null && showRecords) {
            return CompanyDirectory.getReturn(context, "FieldRecordList");
        }
        return CompanyDirectory.getReturn(context, "Fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolderRecord(ActionContext context) {
        Contact thisContact;
        Connection db;
        block5: {
            db = null;
            thisContact = null;
            String contactId = context.getRequest().getParameter("empid");
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block5;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String selectedCatId = context.getRequest().getParameter("catId");
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200513);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Employees", "Add Folder Record");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return CompanyDirectory.getReturn(context, "AddFolderRecord");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFields(ActionContext context) {
        Connection db;
        block14: {
            String string;
            boolean isValid;
            Contact thisContact;
            int resultCode;
            block13: {
                block12: {
                    db = null;
                    resultCode = -1;
                    thisContact = null;
                    isValid = false;
                    String empId = context.getRequest().getParameter("empid");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, empId);
                    if (this.hasPermission(context, "contacts-internal_contacts-folders-add")) break block12;
                    String string2 = "PermissionError";
                    this.freeConnection(context, db);
                    return string2;
                }
                if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block13;
                String string3 = "PermissionError";
                this.freeConnection(context, db);
                return string3;
            }
            try {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                thisList.setLinkModuleId(2);
                thisList.setIncludeEnabled(1);
                thisList.setIncludeScheduled(1);
                thisList.setBuildResources(false);
                thisList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)thisList);
                String selectedCatId = context.getRequest().getParameter("catId");
                context.getRequest().setAttribute("catId", (Object)selectedCatId);
                CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
                thisCategory.setLinkModuleId(120200513);
                thisCategory.setLinkItemId(thisContact.getId());
                thisCategory.setIncludeEnabled(1);
                thisCategory.setIncludeScheduled(1);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                thisCategory.setParameters(context);
                thisCategory.setEnteredBy(this.getUserId(context));
                thisCategory.setModifiedBy(this.getUserId(context));
                if (!thisCategory.getReadOnly()) {
                    thisCategory.setCanNotContinue(true);
                    resultCode = thisCategory.insert(db);
                    Iterator groups = thisCategory.iterator();
                    isValid = true;
                    while (groups.hasNext()) {
                        CustomFieldGroup group = (CustomFieldGroup)groups.next();
                        for (CustomField field : group) {
                            field.setValidateData(true);
                            field.setRecordId(thisCategory.getRecordId());
                            isValid = this.validateObject(context, db, field) && isValid;
                        }
                    }
                    thisCategory.setCanNotContinue(false);
                    if (isValid && resultCode != -1) {
                        resultCode = thisCategory.insertGroup(db, thisCategory.getRecordId());
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
                if (resultCode != -1 && isValid) break block14;
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                if (thisCategory.getRecordId() != -1) {
                    CustomFieldRecord record = new CustomFieldRecord(db, thisCategory.getRecordId());
                    record.delete(db);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Employees-> InsertField validation error");
                }
                string = CompanyDirectory.getReturn(context, "AddFolderRecord");
            }
            catch (Exception errorMessage) {
                String string4;
                try {
                    context.getRequest().setAttribute("Error", (Object)errorMessage);
                    string4 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string4;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return this.executeCommandFields(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFields(ActionContext context) {
        String recordId;
        String selectedCatId;
        Contact thisContact;
        Connection db;
        block8: {
            block7: {
                db = null;
                thisContact = null;
                selectedCatId = context.getRequest().getParameter("catId");
                recordId = context.getRequest().getParameter("recId");
                String contactId = context.getRequest().getParameter("empid");
                db = this.getConnection(context);
                thisContact = new Contact(db, contactId);
                if (this.hasPermission(context, "contacts-internal_contacts-folders-edit")) break block7;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200513);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Modify Custom Fields");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        if (recordId.equals("-1")) {
            return CompanyDirectory.getReturn(context, "AddFolderRecord");
        }
        return CompanyDirectory.getReturn(context, "ModifyFields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFields(ActionContext context) {
        CustomFieldCategory thisCategory;
        int resultCount;
        Connection db;
        block16: {
            boolean isValid;
            Contact thisContact;
            block15: {
                block14: {
                    db = null;
                    thisContact = null;
                    resultCount = 0;
                    isValid = false;
                    context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                    String contactId = context.getRequest().getParameter("empid");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "contacts-internal_contacts-folders-edit")) break block14;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) break block15;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200513);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200513);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            thisCategory.setParameters(context);
            thisCategory.setModifiedBy(this.getUserId(context));
            if (!thisCategory.getReadOnly()) {
                thisCategory.setCanNotContinue(true);
                isValid = this.validateObject(context, db, thisCategory);
                if (isValid) {
                    for (CustomFieldGroup group : thisCategory) {
                        for (CustomField field : group) {
                            field.setValidateData(true);
                            field.setRecordId(thisCategory.getRecordId());
                            isValid = this.validateObject(context, db, field) && isValid;
                        }
                    }
                }
                if (isValid && resultCount != -1) {
                    thisCategory.setCanNotContinue(true);
                    resultCount = thisCategory.update(db);
                    thisCategory.setCanNotContinue(false);
                    resultCount = thisCategory.insertGroup(db, thisCategory.getRecordId());
                }
            }
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            if (resultCount != -1 && isValid) break block16;
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Employees-> ModifyField validation error");
            }
            String groups = CompanyDirectory.getReturn(context, "ModifyFields");
            this.freeConnection(context, db);
            return groups;
        }
        try {
            thisCategory.buildResources(db);
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
            context.getRequest().setAttribute("Record", (Object)thisRecord);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            return CompanyDirectory.getReturn(context, "UpdateFields");
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFields(ActionContext context) {
        Connection db = null;
        boolean recordDeleted = false;
        try {
            db = this.getConnection(context);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            String contactId = context.getRequest().getParameter("empid");
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            if (!this.hasPermission(context, "contacts-internal_contacts-folders-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!CompanyDirectory.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
            thisRecord.setLinkModuleId(120200513);
            thisRecord.setLinkItemId(Integer.parseInt(contactId));
            thisRecord.setCategoryId(Integer.parseInt(selectedCatId));
            if (!thisCategory.getReadOnly()) {
                recordDeleted = thisRecord.delete(db);
            }
            context.getRequest().setAttribute("recordDeleted", (Object)"true");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteFieldsOK";
    }
}

