/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.ProjectList;
import com.zeroio.iteam.base.TeamMemberList;
import java.sql.Connection;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class CompanyDirectoryProjects
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "contacts-internal_contacts-projects-view")) {
            return "PermissionError";
        }
        String employeeId = context.getRequest().getParameter("empid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact contactDetails = new Contact(db, Integer.parseInt(employeeId));
            if (!CompanyDirectoryProjects.isRecordAccessPermitted(context, (Object)contactDetails)) {
                String string = "PermissionError";
                return string;
            }
            contactDetails.checkUserAccount(db);
            context.getRequest().setAttribute("ContactDetails", (Object)contactDetails);
            ProjectList projects = new ProjectList();
            PagedListInfo companyDirectoryProjectsInfo = this.getPagedListInfo(context, "CompanyDirectoryProjectsInfo");
            companyDirectoryProjectsInfo.setLink("CompanyDirectoryProjects.do?command=List&empid=" + employeeId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            companyDirectoryProjectsInfo.setItemsPerPage(0);
            projects.setPagedListInfo(companyDirectoryProjectsInfo);
            projects.setGroupId(-1);
            if (contactDetails.hasAccount()) {
                projects.setProjectsForUser(contactDetails.getUserId());
                projects.setIncludeGuestProjects(true);
                projects.setPortalState(0);
                projects.setBuildOverallProgress(true);
                projects.buildList(db);
            }
            for (Project thisProject : projects) {
                thisProject.setHasAccess(TeamMemberList.isOnTeam((Connection)db, (int)thisProject.getId(), (int)this.getUserId(context)));
            }
            context.getRequest().setAttribute("projectList", (Object)projects);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return CompanyDirectoryProjects.getReturn(context, "ListProjects");
    }
}

