/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webdav.utils.VCard;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.communications.base.ContactMessageList;
import org.aspcfs.modules.communications.base.InstantCampaign;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactReport;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;
import org.aspcfs.utils.web.StateSelect;

public final class ExternalContacts
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-view")) {
            return "DefaultError";
        }
        return this.executeCommandSearchContactsForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReports(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        FileItemList files = new FileItemList();
        files.setLinkModuleId(11);
        files.setLinkItemId(-1);
        PagedListInfo rptListInfo = this.getPagedListInfo(context, "ContactRptListInfo");
        rptListInfo.setLink("ExternalContacts.do?command=Reports");
        files.setPagedListInfo(rptListInfo);
        if ("all".equals(rptListInfo.getListView())) {
            files.setOwnerIdRange(this.getUserRange(context));
        } else {
            files.setOwner(this.getUserId(context));
        }
        try {
            db = this.getConnection(context);
            files.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "ViewReports");
        context.getRequest().setAttribute("FileList", (Object)files);
        return "ReportsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadVCard(ActionContext context) {
        block10: {
            Connection db = null;
            try {
                db = this.getConnection(context);
                String id = context.getRequest().getParameter("id");
                Contact thisContact = new Contact();
                thisContact.setBuildDetails(true);
                thisContact.setBuildTypes(false);
                thisContact.queryRecord(db, Integer.parseInt(id));
                if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                if (thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-view") || thisContact.getOrgId() == -1 && !this.hasPermission(context, "contacts-external_contacts-view") && !this.hasAuthority(db, context, (Object)thisContact) || thisContact.getOrgId() == 0 && !this.hasPermission(context, "contacts-internal_contacts-view")) {
                    String string = "PermissionError";
                    return string;
                }
                VCard card = new VCard(thisContact);
                byte[] bytes = card.getBytes();
                if (bytes != null) {
                    FileDownload download = new FileDownload();
                    download.setDisplayName(card.getFormattedName() + ".vcf");
                    download.sendFile(context, bytes, "application/x-vcard");
                    break block10;
                }
                String string = "SystemError";
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadCSVReport(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-view")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("fid");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 11);
            if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItem itemToDownload = null;
            itemToDownload = thisItem;
            String filePath = this.getPath(context, "contact-reports") + ExternalContacts.getDatePath(itemToDownload.getEntered()) + itemToDownload.getFilename() + ".csv";
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("PMF-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteReport(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 11);
            if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            if (thisItem.getEnteredBy() == this.getUserId(context)) {
                String filePath2;
                File fileToDelete2;
                recordDeleted = thisItem.delete(db, this.getPath(context, "contact-reports"));
                String filePath1 = this.getPath(context, "contact-reports") + ExternalContacts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".csv";
                File fileToDelete1 = new File(filePath1);
                if (!fileToDelete1.delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath1);
                }
                if (!(fileToDelete2 = new File(filePath2 = this.getPath(context, "contact-reports") + ExternalContacts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html")).delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath2);
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Reports del");
        if (recordDeleted) {
            return "DeleteReportOK";
        }
        return "DeleteReportERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGenerateForm(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setAllSelectOption(true);
            thisList.setBuildResources(false);
            db = this.getConnection(context);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            this.freeConnection(context, db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Generate new");
        return "GenerateFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowReportHtml(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        FileItem thisItem = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId));
            String filePath = this.getPath(context, "contact-reports") + ExternalContacts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html";
            String textToShow = ExternalContacts.includeFile(filePath);
            context.getRequest().setAttribute("ReportText", (Object)textToShow);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
            return "PermissionError";
        }
        return "ReportHtmlOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportReport(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        String subject = context.getRequest().getParameter("subject");
        String ownerCriteria = context.getRequest().getParameter("criteria1");
        String type = context.getRequest().getParameter("type");
        String filePath = this.getPath(context, "contact-reports");
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
        String datePathToUse1 = formatter1.format(new Date());
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
        String datePathToUse2 = formatter2.format(new Date());
        filePath = filePath + datePathToUse1 + fs + datePathToUse2 + fs;
        ContactReport contactReport = new ContactReport();
        contactReport.setCriteria(context.getRequest().getParameterValues("selectedList"));
        contactReport.setFilePath(filePath);
        contactReport.setSubject(subject);
        contactReport.addIgnoreTypeId(1);
        contactReport.addIgnoreTypeId(2);
        PagedListInfo thisInfo = new PagedListInfo();
        thisInfo.setColumnToSortBy(context.getRequest().getParameter("sort"));
        thisInfo.setItemsPerPage(0);
        contactReport.setPagedListInfo(thisInfo);
        contactReport.setSiteId(this.getUserSiteId(context));
        contactReport.setExclusiveToSite(true);
        if (this.getUserSiteId(context) == -1) {
            contactReport.setIncludeAllSites(true);
        }
        int folderId = Integer.parseInt(context.getRequest().getParameter("catId"));
        if (type.equals("4") && folderId == 0) {
            contactReport.setIncludeFolders(true);
        } else if (type.equals("4") && folderId > 0) {
            contactReport.setFolderId(folderId);
        }
        if (!this.hasPermission(context, "accounts-accounts-contacts-view")) {
            contactReport.setExcludeAccountContacts(true);
        }
        if (ownerCriteria.equals("my")) {
            contactReport.setOwner(this.getUserId(context));
            contactReport.setPersonalId(-2);
        } else if (ownerCriteria.equals("hierarchy")) {
            contactReport.setControlledHierarchyOnly(true, this.getUserRange(context));
            contactReport.setPersonalId(this.getUserId(context));
        } else if (ownerCriteria.equals("all")) {
            contactReport.setAllContacts(true, this.getUserId(context), this.getUserRange(context));
        } else if (ownerCriteria.equals("public")) {
            contactReport.setRuleId(626030334);
        } else if (ownerCriteria.equals("personal")) {
            contactReport.setRuleId(626030333);
            contactReport.setPersonalId(this.getUserId(context));
        }
        try {
            db = this.getConnection(context);
            contactReport.buildReportFull(db, this.getUserTable(context));
            contactReport.setEnteredBy(this.getUserId(context));
            contactReport.setModifiedBy(this.getUserId(context));
            contactReport.saveAndInsert(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandReports(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchContacts(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-view")) {
            return "PermissionError";
        }
        User user = this.getUser(context, this.getUserId(context));
        PagedListInfo searchContactsInfo = this.getPagedListInfo(context, "SearchContactsInfo");
        searchContactsInfo.setLink("ExternalContacts.do?command=SearchContacts");
        String source = context.getRequest().getParameter("source");
        this.addModuleBean(context, "External Contacts", "Search Results");
        ContactList contactList = new ContactList();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            if ((searchContactsInfo.getListView() == null || "".equals(searchContactsInfo.getListView())) && !"searchForm".equals(source)) {
                String string = "ListContactsOK";
                return string;
            }
            contactList.setPagedListInfo(searchContactsInfo);
            searchContactsInfo.setSearchCriteria(contactList, context);
            if (!this.hasPermission(context, "accounts-accounts-contacts-view")) {
                contactList.setExcludeAccountContacts(true);
            }
            contactList.setBuildDetails(true);
            contactList.setBuildTypes(false);
            contactList.setExclusiveToSite(true);
            if (contactList.getSiteId() == -2) {
                contactList.setIncludeAllSites(true);
            }
            contactList.addIgnoreTypeId(1);
            contactList.addIgnoreTypeId(2);
            contactList.setTypeId(searchContactsInfo.getFilterKey("listFilter1"));
            if ("all".equals(searchContactsInfo.getListView())) {
                contactList.setAllContacts(true, this.getUserId(context), this.getUserRange(context));
            } else if ("hierarchy".equals(searchContactsInfo.getListView())) {
                contactList.setControlledHierarchyOnly(true, this.getUserRange(context));
                contactList.setPersonalId(this.getUserId(context));
            } else if ("archived".equals(searchContactsInfo.getListView())) {
                contactList.setIncludeEnabled(0);
                contactList.setPersonalId(this.getUserId(context));
            } else if ("my".equals(searchContactsInfo.getListView())) {
                contactList.setOwner(this.getUserId(context));
                contactList.setPersonalId(-2);
            }
            contactList.buildList(db);
            context.getSession().removeAttribute("contactHistoryListInfo");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        return "ListContactsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMessageDetails(ActionContext context) {
        this.addModuleBean(context, "External Contacts", "Message Details");
        Connection db = null;
        Contact thisContact = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            String contactId = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-messages-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean popup = "true".equals(context.getRequest().getParameter("popup"));
        this.addModuleBean(context, "External Contacts", "Messages");
        context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        if (popup) {
            return "MessageDetailsPopupOK";
        }
        return "MessageDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewMessages(ActionContext context) {
        Object receivedMessageListInfo;
        String view;
        String selected;
        int MINIMIZED_ITEMS_PER_PAGE = 5;
        Connection db = null;
        Contact thisContact = null;
        CampaignList campaignList = new CampaignList();
        String contactId = context.getRequest().getParameter("contactId");
        if (context.getSession().getAttribute("contactMessageListView") == null) {
            context.getSession().setAttribute("contactMessageListView", (Object)"all");
        }
        if ((selected = context.getRequest().getParameter("listView")) != null && !"".equals(selected)) {
            context.getSession().setAttribute("contactMessageListView", (Object)selected);
        }
        if ((view = (String)context.getSession().getAttribute("contactMesssageListView")) != null && !"".equals(view)) {
            context.getRequest().setAttribute("selected", (Object)view);
        } else if (selected != null && !"".equals(selected)) {
            context.getRequest().setAttribute("selected", (Object)selected);
        }
        if ("true".equals(context.getRequest().getParameter("resetList"))) {
            context.getSession().removeAttribute("contactSentMessageListInfo");
            context.getSession().removeAttribute("contactReceivedMessageListInfo");
        }
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        String sentPagedListId = "contactSentMessageListInfo";
        if (sectionId == null || sentPagedListId.equals(sectionId)) {
            PagedListInfo sentMessageListInfo = this.getPagedListInfo(context, "contactSentMessageListInfo");
            sentMessageListInfo.setLink("ExternalContacts.do?command=ViewMessages&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            if (sectionId == null) {
                if (!sentMessageListInfo.getExpandedSelection()) {
                    if (sentMessageListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        sentMessageListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (sentMessageListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    sentMessageListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(sentMessageListInfo.getId())) {
                sentMessageListInfo.setExpandedSelection(true);
            }
            campaignList.setPagedListInfo(sentMessageListInfo);
            campaignList.setCompleteOnly(true);
            campaignList.setContactId(Integer.parseInt(contactId));
            if ("all".equals(view)) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
                campaignList.setUserGroupUserId(this.getUserId(context));
            } else {
                campaignList.setOwner(this.getUserId(context));
            }
        }
        ContactMessageList receivedList = new ContactMessageList();
        String receivedPagedListId = "contactReceivedMessageListInfo";
        if (sectionId == null || receivedPagedListId.equals(sectionId)) {
            receivedMessageListInfo = this.getPagedListInfo(context, "contactReceivedMessageListInfo");
            ((PagedListInfo)receivedMessageListInfo).setLink("ExternalContacts.do?command=ViewMessages&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            if (sectionId == null) {
                if (!((PagedListInfo)receivedMessageListInfo).getExpandedSelection()) {
                    if (((PagedListInfo)receivedMessageListInfo).getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        ((PagedListInfo)receivedMessageListInfo).setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (((PagedListInfo)receivedMessageListInfo).getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    ((PagedListInfo)receivedMessageListInfo).setItemsPerPage(10);
                }
            } else if (sectionId.equals(((PagedListInfo)receivedMessageListInfo).getId())) {
                ((PagedListInfo)receivedMessageListInfo).setExpandedSelection(true);
            }
            receivedList.setPagedListInfo((PagedListInfo)receivedMessageListInfo);
            if ("all".equals(view)) {
                receivedList.setReceivedByRange(this.getUserRange(context));
            } else {
                receivedList.setReceivedBy(this.getUserId(context));
            }
            receivedList.setBuildMessage(true);
        }
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-messages-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-view")) {
                receivedMessageListInfo = "PermissionError";
                return receivedMessageListInfo;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                receivedMessageListInfo = "PermissionError";
                return receivedMessageListInfo;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                receivedMessageListInfo = "PermissionError";
                return receivedMessageListInfo;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            if (sectionId == null || sentPagedListId.equals(sectionId)) {
                campaignList.buildList(db);
            }
            if (sectionId == null || receivedPagedListId.equals(sectionId)) {
                receivedList.setReceivedFrom(thisContact.getId());
                receivedList.buildList(db);
            }
            context.getRequest().setAttribute("campList", (Object)campaignList);
            context.getRequest().setAttribute("receivedList", (Object)receivedList);
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean popup = "true".equals(context.getRequest().getParameter("popup"));
        this.addModuleBean(context, "External Contacts", "Messages");
        if (popup) {
            return "ViewMessagesPopupOK";
        }
        return "ViewMessagesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolderRecord(ActionContext context) {
        Contact thisContact;
        Connection db;
        block9: {
            block8: {
                block7: {
                    db = null;
                    thisContact = null;
                    String contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "contacts-external_contacts-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block7;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (this.hasAuthority(db, context, (Object)thisContact)) break block8;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block9;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String selectedCatId = context.getRequest().getParameter("catId");
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Add Folder Record");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return ExternalContacts.getReturn(context, "AddFolderRecord");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFolderList(ActionContext context) {
        Contact thisContact;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "contacts-external_contacts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisContact = null;
            String empId = context.getRequest().getParameter("contactId");
            db = this.getConnection(context);
            thisContact = new Contact(db, Integer.parseInt(empId));
            if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setLinkItemId(thisContact.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Custom Fields Details");
        return ExternalContacts.getReturn(context, "FolderList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFields(ActionContext context) {
        String contactId;
        String selectedCatId;
        boolean showRecords;
        String recordId;
        Contact thisContact;
        Connection db;
        block20: {
            block19: {
                block18: {
                    db = null;
                    thisContact = null;
                    recordId = null;
                    showRecords = true;
                    selectedCatId = null;
                    contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "contacts-external_contacts-folders-view") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-view"))) break block18;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (this.hasAuthority(db, context, (Object)thisContact)) break block19;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block20;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            selectedCatId = context.getRequest().getParameter("catId");
            if (selectedCatId == null) {
                selectedCatId = (String)context.getRequest().getAttribute("catId");
            }
            if (selectedCatId == null) {
                selectedCatId = String.valueOf(thisList.getDefaultCategoryId());
            }
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            if (Integer.parseInt(selectedCatId) > 0) {
                recordId = context.getRequest().getParameter("recId");
                String recordDeleted = (String)context.getRequest().getAttribute("recordDeleted");
                if (recordDeleted != null) {
                    recordId = null;
                }
                CustomFieldCategory thisCategory = thisList.getCategory(Integer.parseInt(selectedCatId));
                if (recordId == null && thisCategory.getAllowMultipleRecords()) {
                    PagedListInfo folderListInfo = this.getPagedListInfo(context, "ContactFolderInfo");
                    folderListInfo.setLink("ExternalContacts.do?command=Fields&contactId=" + contactId + "&catId=" + selectedCatId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
                    CustomFieldRecordList recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(2);
                    recordList.setLinkItemId(thisContact.getId());
                    recordList.setCategoryId(thisCategory.getId());
                    recordList.buildList(db);
                    recordList.buildRecordColumns(db, thisCategory);
                    context.getRequest().setAttribute("Records", (Object)recordList);
                } else {
                    thisCategory.setLinkModuleId(2);
                    thisCategory.setLinkItemId(thisContact.getId());
                    if (recordId != null) {
                        thisCategory.setRecordId(Integer.parseInt(recordId));
                    } else {
                        thisCategory.buildRecordId(db);
                        recordId = String.valueOf(thisCategory.getRecordId());
                    }
                    thisCategory.setIncludeEnabled(1);
                    thisCategory.setIncludeScheduled(1);
                    thisCategory.setBuildResources(true);
                    thisCategory.buildResources(db);
                    showRecords = false;
                    if (thisCategory.getRecordId() > -1) {
                        CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                        context.getRequest().setAttribute("Record", (Object)thisRecord);
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Custom Fields Details");
        if (Integer.parseInt(selectedCatId) <= 0) {
            return ExternalContacts.getReturn(context, "FieldsEmpty");
        }
        if (recordId == null && showRecords) {
            return ExternalContacts.getReturn(context, "FieldRecordList");
        }
        return ExternalContacts.getReturn(context, "Fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchContactsForm(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        ContactTypeList contactTypeList = new ContactTypeList();
        try {
            PagedListInfo searchContactsInfo = this.getPagedListInfo(context, "SearchContactsInfo");
            db = this.getConnection(context);
            contactTypeList.setIncludeDefinedByUser(this.getUserId(context));
            contactTypeList.addItem(-1, this.getSystemStatus(context).getLabel("contacts.typeList.allContactTypes"));
            contactTypeList.buildList(db);
            context.getRequest().setAttribute("ContactTypeList", (Object)contactTypeList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Search Contacts", "Contacts Search");
        return "SearchContactsFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandContactDetails(ActionContext context) {
        String contactId = context.getRequest().getParameter("id");
        String action = context.getRequest().getParameter("cmd");
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-view")) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ExternalContacts-> permission error");
                }
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact) && !OpportunityHeaderList.isComponentOwner(db, this.getUserId(context))) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ExternalContacts-> authority or isComponentOwner error");
                }
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ExternalContacts-> isRecordAccessPermitted error");
                }
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList salutationList = new LookupList(db, "lookup_title");
            salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SalutationList", (Object)salutationList);
            if (!thisContact.getEmployee()) {
                thisContact.checkEnabledOwnerAccount(db);
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            this.addRecentItem(context, (Object)thisContact);
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "External Contacts", "View Contact Details");
        context.getSession().removeAttribute("ContactMessageListInfo");
        if ("true".equals(context.getRequest().getParameter("popup"))) {
            return "ContactDetailsPopupOK";
        }
        return "ContactDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyContact(ActionContext context) {
        String contactId = context.getRequest().getParameter("id");
        Contact thisContact = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            thisContact = (Contact)((Object)context.getFormBean());
            thisContact.queryRecord(db, Integer.parseInt(contactId));
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            StateSelect stateSelect = new StateSelect(systemStatus, thisContact.getAddressList().getCountries() + "," + prefs.get("SYSTEM.COUNTRY"));
            stateSelect.setPreviousStates(thisContact.getAddressList().getSelectedStatesHashMap());
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            if (!this.hasPermission(context, "contacts-external_contacts-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact) && !OpportunityHeaderList.isComponentOwner(db, this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            AccessTypeList accessTypeList = null;
            accessTypeList = thisContact.getOrgId() > 0 ? this.getSystemStatus(context).getAccessTypeList(db, 626030331) : this.getSystemStatus(context).getAccessTypeList(db, 626030330);
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
            LookupList salutationList = new LookupList(db, "lookup_title");
            salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SalutationList", (Object)salutationList);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            if (!thisContact.getEmployee()) {
                thisContact.checkEnabledOwnerAccount(db);
            }
            this.addRecentItem(context, (Object)thisContact);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "External Contacts", "Modify Contact Details");
        context.getSession().removeAttribute("ContactMessageListInfo");
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        Connection db = null;
        Contact thisContact = (Contact)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        StateSelect stateSelect = (StateSelect)context.getRequest().getAttribute("StateSelect");
        boolean addUser = "adduser".equals(context.getRequest().getParameter("source"));
        if (thisContact.getId() == -1) {
            if (!this.hasPermission(context, "contacts-external_contacts-add")) {
                return "PermissionError";
            }
            this.addModuleBean(context, "Add Contact", "Add Contact to Account");
        }
        try {
            db = this.getConnection(context);
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            if (stateSelect == null) {
                stateSelect = new StateSelect(systemStatus, prefs.get("SYSTEM.COUNTRY"));
            }
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            ContactTypeList contactTypeList = new ContactTypeList();
            contactTypeList.setIncludeDefinedByUser(this.getUserId(context));
            contactTypeList.buildList(db);
            context.getRequest().setAttribute("ContactTypeList", (Object)contactTypeList);
            if (addUser) {
                LookupList departmentList = new LookupList(db, "lookup_department");
                departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
            }
            UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
            User thisRec = thisUser.getUserRecord();
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList.setMyId(this.getUserId(context));
            userList.setMyValue(thisUser.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            context.getRequest().setAttribute("UserList", (Object)userList);
            AccessTypeList accessTypeList = null;
            if (context.getRequest().getAttribute("AccessTypeList") == null) {
                accessTypeList = thisContact.getOrgId() > 0 ? this.getSystemStatus(context).getAccessTypeList(db, 626030331) : (addUser ? this.getSystemStatus(context).getAccessTypeList(db, 626030332) : this.getSystemStatus(context).getAccessTypeList(db, 626030330));
                context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
            }
            LookupList salutationList = new LookupList(db, "lookup_title");
            salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SalutationList", (Object)salutationList);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            if (thisContact.getOrgId() > -1) {
                Organization thisOrg = new Organization(db, thisContact.getOrgId());
                thisContact.setCompany(thisOrg.getName());
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        context.getSession().removeAttribute("ContactMessageListInfo");
        if (context.getRequest().getParameter("actionSource") != null) {
            return ExternalContacts.getReturn(context, "PrepareContact");
        }
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Add Contact", "Clone Contact");
        Connection db = null;
        String contactId = context.getRequest().getParameter("id");
        Contact cloneContact = null;
        try {
            db = this.getConnection(context);
            cloneContact = new Contact(db, contactId);
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)cloneContact)) {
                String string = "PermissionError";
                return string;
            }
            cloneContact.resetBaseInfo();
            context.getRequest().setAttribute("ContactDetails", (Object)cloneContact);
            AccessTypeList accessTypeList = null;
            accessTypeList = cloneContact.getOrgId() > 0 ? this.getSystemStatus(context).getAccessTypeList(db, 626030331) : this.getSystemStatus(context).getAccessTypeList(db, 626030330);
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        boolean recordInserted = false;
        int resultCount = 0;
        boolean isValid = false;
        String id = context.getRequest().getParameter("id");
        String permission = "contacts-external_contacts-add";
        Organization thisOrg = null;
        Contact thisContact = (Contact)((Object)context.getFormBean());
        thisContact.setRequestItems(context);
        thisContact.setTypeList(context.getRequest().getParameterValues("selectedList"));
        thisContact.setEnteredBy(this.getUserId(context));
        thisContact.setModifiedBy(this.getUserId(context));
        if (thisContact.getOrgId() == -1) {
            if (thisContact.getId() > 0) {
                permission = "contacts-external_contacts-edit";
            }
        } else {
            permission = thisContact.getId() > 0 ? "accounts-accounts-contacts-edit" : "accounts-accounts-contacts-add";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("primaryContact") != null && context.getRequest().getParameter("primaryContact").equalsIgnoreCase("true")) {
            thisContact.setPrimaryContact(true);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (thisContact.getOrgId() > 0) {
                thisOrg = new Organization(db, thisContact.getOrgId());
                thisContact.setOrgName(thisOrg.getName());
            }
            if (thisContact.getId() > 0) {
                this.addModuleBean(context, "External Contacts", "Update Contact");
                Contact oldContact = new Contact(db, id);
                if (oldContact.getOrgId() == -1 && thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-add")) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(db, context, (Object)oldContact)) {
                    String string = "PermissionError";
                    return string;
                }
                isValid = this.validateObject(context, db, (Object)thisContact);
                if (isValid) {
                    if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                        String string = "PermissionError";
                        return string;
                    }
                    resultCount = thisContact.update(db, context);
                }
            } else {
                this.addModuleBean(context, "External Contacts", "Add a new contact");
                thisContact.setOwner(this.getUserId(context));
                isValid = this.validateObject(context, db, (Object)thisContact);
                if (isValid) {
                    if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                        String oldContact = "PermissionError";
                        return oldContact;
                    }
                    recordInserted = thisContact.insert(db);
                }
            }
            if (recordInserted) {
                thisContact = new Contact(db, thisContact.getId());
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                this.addRecentItem(context, (Object)thisContact);
            } else if (resultCount == 1) {
                thisContact.checkUserAccount(db);
                this.updateUserContact(db, context, thisContact.getUserId());
            } else {
                context.getRequest().setAttribute("TypeList", (Object)thisContact.getTypeList());
            }
            if ("true".equals(context.getRequest().getParameter("saveAndNew")) || !recordInserted && resultCount != 1) {
                AccessTypeList accessTypeList = null;
                accessTypeList = "true".equals(context.getRequest().getParameter("saveAndNew")) || thisContact.getOrgId() == -1 ? this.getSystemStatus(context).getAccessTypeList(db, 626030330) : this.getSystemStatus(context).getAccessTypeList(db, 626030331);
                context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            if ("true".equals(context.getRequest().getParameter("saveAndNew"))) {
                context.getRequest().removeAttribute("ContactDetails");
                return this.executeCommandPrepare(context);
            }
            if (context.getRequest().getParameter("popup") != null) {
                String source;
                if (context.getRequest().getParameter("source") != null && "addactivity".equals(source = context.getRequest().getParameter("source"))) {
                    return "CloseInsertContactPopup";
                }
                return "ClosePopup";
            }
            return "ContactDetailsOK";
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandSearchContacts(context);
            }
            return "ContactDetailsUpdateOK";
        }
        if (thisContact.getId() > 0) {
            if (resultCount == -1 || !isValid) {
                return this.executeCommandPrepare(context);
            }
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
            return "UserError";
        }
        context.getRequest().setAttribute("TypeList", (Object)thisContact.getTypeList());
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteContact(ActionContext context) {
        boolean recordDeleted = false;
        Contact thisContact = null;
        String popup = context.getRequest().getParameter("sourcePopup");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            thisContact.setForceDelete(DatabaseUtils.parseBoolean(context.getRequest().getParameter("forceDelete")));
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContact.delete(db, context, ExternalContacts.getDbNamePath(context));
            this.processErrors(context, thisContact.getErrors());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "External Contacts", "Delete a contact");
        if (recordDeleted) {
            context.getSession().removeAttribute("ContactMessageListInfo");
            this.deleteRecentItem(context, (Object)thisContact);
            if (popup != null && "true".equals(popup)) {
                context.getRequest().setAttribute("id", (Object)("" + thisContact.getId()));
                return "ContactDeletePopupOK";
            }
            context.getRequest().setAttribute("refreshUrl", (Object)"ExternalContacts.do?command=SearchContacts");
            return "ContactDeleteOK";
        }
        this.processErrors(context, thisContact.getErrors());
        return this.executeCommandSearchContacts(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        boolean recordUpdated = false;
        Contact thisContact = null;
        String popup = context.getRequest().getParameter("sourcePopup");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisContact.updateStatus(db, context, true, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisContact.getOwner());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "External Contacts", "Delete a contact");
        if (recordUpdated) {
            context.getSession().removeAttribute("ContactMessageListInfo");
            this.deleteRecentItem(context, (Object)thisContact);
            if (popup != null && "true".equals(popup)) {
                context.getRequest().setAttribute("id", (Object)("" + thisContact.getId()));
                return "ContactDeletePopupOK";
            }
            context.getRequest().setAttribute("refreshUrl", (Object)"ExternalContacts.do?command=SearchContacts");
            return "ContactDeleteOK";
        }
        this.processErrors(context, thisContact.getErrors());
        return this.executeCommandSearchContacts(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        boolean recordUpdated = false;
        Contact thisContact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisContact.updateStatus(db, context, false, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisContact.getOwner());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated && context.getRequest().getParameter("return") != null && "list".equals(context.getRequest().getParameter("return"))) {
            return this.executeCommandSearchContacts(context);
        }
        return "ContactDetailsUpdateOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFields(ActionContext context) {
        String recordId;
        String selectedCatId;
        Contact thisContact;
        Connection db;
        block10: {
            block9: {
                block8: {
                    db = null;
                    thisContact = null;
                    selectedCatId = context.getRequest().getParameter("catId");
                    recordId = context.getRequest().getParameter("recId");
                    String contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "contacts-external_contacts-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block8;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (this.hasAuthority(db, context, (Object)thisContact)) break block9;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block10;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Modify Custom Fields");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        if (recordId.equals("-1")) {
            return ExternalContacts.getReturn(context, "AddFolderRecord");
        }
        return ExternalContacts.getReturn(context, "ModifyFields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFields(ActionContext context) {
        CustomFieldCategory thisCategory;
        int resultCount;
        Connection db;
        block18: {
            boolean isValid;
            Contact thisContact;
            block17: {
                block16: {
                    block15: {
                        db = null;
                        thisContact = null;
                        resultCount = 0;
                        isValid = false;
                        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                        String contactId = context.getRequest().getParameter("contactId");
                        db = this.getConnection(context);
                        thisContact = new Contact(db, contactId);
                        if (this.hasPermission(context, "contacts-external_contacts-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block15;
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    }
                    if (this.hasAuthority(db, context, (Object)thisContact)) break block16;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block17;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            thisCategory.setParameters(context);
            thisCategory.setModifiedBy(this.getUserId(context));
            if (!thisCategory.getReadOnly()) {
                thisCategory.setCanNotContinue(true);
                isValid = this.validateObject(context, db, thisCategory);
                if (isValid) {
                    for (CustomFieldGroup group : thisCategory) {
                        for (CustomField field : group) {
                            field.setValidateData(true);
                            field.setRecordId(thisCategory.getRecordId());
                            isValid = this.validateObject(context, db, field) && isValid;
                        }
                    }
                }
                if (isValid && resultCount != -1) {
                    thisCategory.setCanNotContinue(true);
                    resultCount = thisCategory.update(db);
                    thisCategory.setCanNotContinue(false);
                    resultCount = thisCategory.insertGroup(db, thisCategory.getRecordId());
                }
            }
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            if (resultCount != -1 && isValid) break block18;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Contacts-> ModifyField validation error");
            }
            String groups = ExternalContacts.getReturn(context, "ModifyFields");
            this.freeConnection(context, db);
            return groups;
        }
        try {
            thisCategory.buildResources(db);
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
            context.getRequest().setAttribute("Record", (Object)thisRecord);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            return ExternalContacts.getReturn(context, "UpdateFields");
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFields(ActionContext context) {
        Connection db;
        block14: {
            String string;
            boolean isValid;
            Contact thisContact;
            int resultCode;
            block13: {
                block12: {
                    db = null;
                    resultCode = -1;
                    thisContact = null;
                    isValid = false;
                    String contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "contacts-external_contacts-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block12;
                    String string2 = "PermissionError";
                    this.freeConnection(context, db);
                    return string2;
                }
                if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block13;
                String string3 = "PermissionError";
                this.freeConnection(context, db);
                return string3;
            }
            try {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                thisList.setLinkModuleId(2);
                thisList.setIncludeEnabled(1);
                thisList.setIncludeScheduled(1);
                thisList.setBuildResources(false);
                thisList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)thisList);
                String selectedCatId = context.getRequest().getParameter("catId");
                context.getRequest().setAttribute("catId", (Object)selectedCatId);
                CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
                thisCategory.setLinkModuleId(2);
                thisCategory.setLinkItemId(thisContact.getId());
                thisCategory.setIncludeEnabled(1);
                thisCategory.setIncludeScheduled(1);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                thisCategory.setParameters(context);
                thisCategory.setEnteredBy(this.getUserId(context));
                thisCategory.setModifiedBy(this.getUserId(context));
                if (!thisCategory.getReadOnly()) {
                    thisCategory.setCanNotContinue(true);
                    resultCode = thisCategory.insert(db);
                    Iterator groups = thisCategory.iterator();
                    isValid = true;
                    while (groups.hasNext()) {
                        CustomFieldGroup group = (CustomFieldGroup)groups.next();
                        for (CustomField field : group) {
                            field.setValidateData(true);
                            field.setRecordId(thisCategory.getRecordId());
                            isValid = this.validateObject(context, db, field) && isValid;
                        }
                    }
                    thisCategory.setCanNotContinue(false);
                    if (isValid && resultCode != -1) {
                        resultCode = thisCategory.insertGroup(db, thisCategory.getRecordId());
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
                if (resultCode != -1 && isValid) break block14;
                SystemStatus systemStatus = this.getSystemStatus(context);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                if (thisCategory.getRecordId() != -1) {
                    CustomFieldRecord record = new CustomFieldRecord(db, thisCategory.getRecordId());
                    record.delete(db);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Contacts-> InsertField validation error");
                }
                string = ExternalContacts.getReturn(context, "AddFolderRecord");
            }
            catch (Exception errorMessage) {
                String string4;
                try {
                    context.getRequest().setAttribute("Error", (Object)errorMessage);
                    string4 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string4;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return this.executeCommandFields(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFields(ActionContext context) {
        Connection db = null;
        boolean recordDeleted = false;
        try {
            db = this.getConnection(context);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            String contactId = context.getRequest().getParameter("contactId");
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            if (!this.hasPermission(context, "contacts-external_contacts-folders-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
            thisRecord.setLinkModuleId(2);
            thisRecord.setLinkItemId(Integer.parseInt(contactId));
            thisRecord.setCategoryId(Integer.parseInt(selectedCatId));
            if (!thisCategory.getReadOnly()) {
                recordDeleted = thisRecord.delete(db);
            }
            context.getRequest().setAttribute("recordDeleted", (Object)"true");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteFieldsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        Contact thisContact = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisContact = new Contact(db, id);
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisContact.checkUserAccount(db);
            DependencyList dependencies = thisContact.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (thisContact.getPrimaryContact()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.contactIndividualAccountHeader"));
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            }
            htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='ExternalContacts.do?command=Trash&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId|popup|sourcePopup") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPopupSelector(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String displayFieldId = null;
        ContactTypeList contactTypeList = null;
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("ContactTypeSelectorInfo");
        }
        PagedListInfo lookupSelectorInfo = this.getPagedListInfo(context, "ContactTypeSelectorInfo");
        HashMap selectedList = new HashMap();
        HashMap finalElementList = (HashMap)context.getSession().getAttribute("finalElements");
        String category = context.getRequest().getParameter("category");
        String contactId = context.getRequest().getParameter("contactId");
        String previousSelection = context.getRequest().getParameter("previousSelection");
        String previousSelectionDisplay = context.getRequest().getParameter("previousSelectionDisplay");
        if (previousSelection != null) {
            StringTokenizer st = new StringTokenizer(previousSelection, "|");
            StringTokenizer st1 = new StringTokenizer(previousSelectionDisplay, "|");
            while (st.hasMoreTokens()) {
                selectedList.put(new Integer(st.nextToken()), st1.nextToken());
            }
        } else {
            selectedList = (HashMap)context.getSession().getAttribute("selectedElements");
        }
        if (context.getRequest().getParameter("displayFieldId") != null) {
            displayFieldId = context.getRequest().getParameter("displayFieldId");
        }
        if ("true".equals(context.getRequest().getParameter("reset")) && context.getSession().getAttribute("finalElements") != null && context.getRequest().getParameter("previousSelection") == null) {
            selectedList = (HashMap)((HashMap)context.getSession().getAttribute("finalElements")).clone();
        }
        int rowCount = 1;
        while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
            int elementId = 0;
            String elementValue = "";
            elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
            if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                if (context.getRequest().getParameter("elementvalue" + rowCount) != null) {
                    elementValue = context.getRequest().getParameter("elementvalue" + rowCount);
                }
                if (selectedList.get(new Integer(elementId)) == null) {
                    selectedList.put(new Integer(elementId), elementValue);
                } else {
                    selectedList.remove(new Integer(elementId));
                    selectedList.put(new Integer(elementId), elementValue);
                }
            } else {
                selectedList.remove(new Integer(elementId));
            }
            ++rowCount;
        }
        if ("true".equals(context.getRequest().getParameter("finalsubmit"))) {
            finalElementList = selectedList;
            context.getSession().setAttribute("finalElements", (Object)finalElementList);
        }
        try {
            db = this.getConnection(context);
            contactTypeList = new ContactTypeList();
            contactTypeList.setPagedListInfo(lookupSelectorInfo);
            contactTypeList.setShowDisabled(false);
            contactTypeList.setIncludeDefinedByUser(this.getUserId(context));
            contactTypeList.setIncludeSelectedByUser(Integer.parseInt(contactId));
            if (previousSelection != null) {
                contactTypeList.setIncludeIds(previousSelection.replace('|', ','));
            }
            if ("accounts".equals(category)) {
                contactTypeList.setCategory(1);
            } else {
                contactTypeList.setCategory(0);
            }
            contactTypeList.buildList(db);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                context.getRequest().setAttribute("ContactTypeList", contactTypeList);
                this.freeConnection(context, db);
                throw throwable;
            }
            context.getRequest().setAttribute("ContactTypeList", (Object)contactTypeList);
            this.freeConnection(context, db);
            return string;
        }
        context.getRequest().setAttribute("ContactTypeList", (Object)contactTypeList);
        this.freeConnection(context, db);
        context.getSession().setAttribute("selectedElements", (Object)selectedList);
        context.getRequest().setAttribute("DisplayFieldId", (Object)displayFieldId);
        return "PopupContactTypeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendAddressUpdateRequest(ActionContext context) {
        String cc;
        String bcc;
        Contact thisContact;
        Connection db;
        block11: {
            if (!this.hasPermission(context, "campaign-campaign-contact-updater-view")) {
                return "PermissionError";
            }
            db = null;
            thisContact = null;
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            bcc = context.getRequest().getParameter("bcc");
            cc = context.getRequest().getParameter("cc");
            int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
            thisContact = new Contact(db, contactId);
            if (ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) break block11;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            ContactEmailAddressList emailList = thisContact.getEmailAddressList();
            Iterator itr = emailList.iterator();
            ContactEmailAddress emailAddress = null;
            while (itr.hasNext() && !(emailAddress = (ContactEmailAddress)((Object)itr.next())).getPrimaryEmail()) {
            }
            if (emailAddress == null) {
                throw new Exception("The contact does not have an email address");
            }
            SMTPMessage mail = new SMTPMessage();
            mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
            mail.setFrom(ApplicationPrefs.getPref(context.getServletContext(), "EMAILADDRESS"));
            mail.setType("text/html");
            mail.setTo(emailAddress.getEmail());
            mail.setSubject("Address update request");
            if (bcc != null && !"".equals(bcc)) {
                mail.addBcc(bcc);
                context.getRequest().setAttribute("bcc", (Object)bcc);
            }
            if (cc != null && !"".equals(cc)) {
                mail.addCc(cc);
                context.getRequest().setAttribute("cc", (Object)cc);
            }
            int tmpAddressSurveyId = Survey.getAddressSurveyId(db);
            String serverName = RequestUtils.getServerUrl(context.getRequest());
            Template template = new Template();
            template.setText("<br>Please update your address at: <a href=\"http://" + serverName + "/ProcessAddressSurvey.do?id=${addressSurveyId=" + tmpAddressSurveyId + "}\">http://" + serverName + "/ProcessAddressSurvey.do?id=${addressSurveyId=" + tmpAddressSurveyId + "}</a>");
            String filePath = ExternalContacts.getDbNamePath(context) + "keys" + fs;
            File f = new File(filePath);
            f.mkdirs();
            PrivateString thisKey = new PrivateString(filePath + "survey2.key");
            template.addParseElement("${addressSurveyId=" + tmpAddressSurveyId + "}", URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "addressSurveyId=" + tmpAddressSurveyId + ",cid=" + thisContact.getId()), "UTF-8"));
            mail.setBody(template.getParsedText());
            if (mail.send() == 2) {
                System.err.println(mail.getErrorMsg());
                throw new Exception("Error sending email");
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return this.executeCommandSearchContacts(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccessTypeJSList(ActionContext context) {
        String category = context.getRequest().getParameter("category");
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, Integer.parseInt(category));
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContacts.getReturn(context, "AccessTypeJSList");
    }

    private void resetPagedListInfo(ActionContext context) {
        this.deletePagedListInfo(context, "ExternalOppsPagedListInfo");
        this.deletePagedListInfo(context, "CallListInfo");
        this.deletePagedListInfo(context, "ContactMessageListInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveToAccount(ActionContext context) {
        Connection db = null;
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        HtmlDialog htmlDialog = new HtmlDialog();
        int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-move-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisContact.checkUserAccount(db);
            DependencyList dependencies = thisContact.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + thisContact.getHtmlString(dependencies, systemStatus));
            if (thisContact.getPrimaryContact()) {
                htmlDialog.setTitle(systemStatus.getLabel("accounts.contacts.moveTitle"));
                htmlDialog.setHeader(systemStatus.getLabel("accounts.contacts.contactIndividualAccountHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
                context.getSession().setAttribute("Dialog", (Object)htmlDialog);
                String string = "ConfirmDeleteOK";
                return string;
            }
            if (!thisContact.canMoveContact(dependencies)) {
                htmlDialog.setTitle(systemStatus.getLabel("accounts.contacts.moveTitle"));
                htmlDialog.setHeader(systemStatus.getLabel("accounts.contacts.unableToMoveHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
                context.getSession().setAttribute("Dialog", (Object)htmlDialog);
                String string = "ConfirmDeleteOK";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("dependencies", (Object)dependencies);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MoveToAccountOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveContact(ActionContext context) {
        Connection db = null;
        Contact thisContact = null;
        Object organization = null;
        int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
        int moveOpportunities = Integer.parseInt(context.getRequest().getParameter("moveOpportunities"));
        int moveFolders = Integer.parseInt(context.getRequest().getParameter("moveFolders"));
        int moveActivities = Integer.parseInt(context.getRequest().getParameter("moveActivities"));
        int orgId = Integer.parseInt(context.getRequest().getParameter("neworgId"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-move-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!ExternalContacts.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisContact.setModifiedBy(this.getUserId(context));
            thisContact.moveContact(db, context, ExternalContacts.getDbNamePath(context), orgId, moveOpportunities, moveFolders, moveActivities);
            thisContact.queryRecord(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MoveContactOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepareMessage(ActionContext context) {
        String actionSource = context.getRequest().getParameter("actionSource");
        boolean hasAccountContactsMessagesPermission = this.hasPermission(context, "accounts-accounts-contacts-messages-view");
        boolean hasExternalContactsMessagesPermission = this.hasPermission(context, "contacts-external_contacts-messages-view");
        if (actionSource != null && "AccountContactsMessages".equals(actionSource) ? !hasAccountContactsMessagesPermission : !hasExternalContactsMessagesPermission) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        String msgId = context.getRequest().getParameter("messageId");
        String contactId = context.getRequest().getParameter("contactId");
        String bcc = context.getRequest().getParameter("bcc");
        String cc = context.getRequest().getParameter("cc");
        String[] attachments = context.getRequest().getParameterValues("selectedList");
        Message thisMessage = null;
        Connection db = null;
        try {
            String messageType;
            db = this.getConnection(context);
            Contact recipient = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("ContactDetails", (Object)recipient);
            if (msgId != null && !"0".equals(msgId) && !"".equals(msgId)) {
                thisMessage = new Message(db, Integer.parseInt(msgId));
                context.getRequest().setAttribute("Message", (Object)thisMessage);
            }
            if ("".equals(recipient.getPrimaryEmailAddress())) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.contactNoEmail"));
            }
            if ((messageType = (String)context.getRequest().getAttribute("messageType")) == null || "".equals(messageType)) {
                messageType = context.getRequest().getParameter("messageType");
            }
            if (messageType != null && !"".equals(messageType)) {
                context.getRequest().setAttribute("messageType", (Object)messageType);
            }
            if (bcc != null && !"".equals(bcc)) {
                context.getRequest().setAttribute("bcc", (Object)bcc);
            }
            if (cc != null && !"".equals(cc)) {
                context.getRequest().setAttribute("cc", (Object)cc);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PrepareMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendMessage(ActionContext context) {
        String actionSource = context.getRequest().getParameter("actionSource");
        boolean hasAccountContactsMessagesPermission = this.hasPermission(context, "accounts-accounts-contacts-messages-view");
        boolean hasExternalContactsMessagesPermission = this.hasPermission(context, "contacts-external_contacts-messages-view");
        if (actionSource != null && "AccountContactsMessages".equals(actionSource) ? !hasAccountContactsMessagesPermission : !hasExternalContactsMessagesPermission) {
            return "PermissionError";
        }
        String msgId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        String bcc = context.getRequest().getParameter("bcc");
        String cc = context.getRequest().getParameter("cc");
        boolean messageSent = false;
        boolean activated = false;
        Message thisMessage = (Message)((Object)context.getFormBean());
        Connection db = null;
        Contact recipient = null;
        boolean isValid = true;
        InstantCampaign actionCampaign = new InstantCampaign();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            recipient = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)recipient);
            if ("".equals(recipient.getPrimaryEmailAddress())) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.contactNoEmail"));
                isValid = false;
            }
            if (isValid) {
                thisMessage.setDisableNameValidation(true);
                isValid = this.validateObject(context, db, (Object)thisMessage);
                if (isValid) {
                    if (msgId != null && !"".equals(msgId)) {
                        thisMessage.setModifiedBy(this.getUserId(context));
                        thisMessage.update(db);
                    } else {
                        LookupList list = systemStatus.getLookupList(db, "lookup_access_types");
                        thisMessage.setAccessType(list.getIdFromValue("Public"));
                        thisMessage.setModifiedBy(this.getUserId(context));
                        thisMessage.setEnteredBy(this.getUserId(context));
                    }
                }
                actionCampaign.setName(thisMessage.getMessageSubject());
                actionCampaign.setEnteredBy(this.getUserId(context));
                actionCampaign.setModifiedBy(this.getUserId(context));
                actionCampaign.addRecipient(db, Integer.parseInt(contactId));
                actionCampaign.setMessage(thisMessage);
                actionCampaign.setAttachmentList(context.getRequest().getParameterValues("selectedList"));
                if (bcc != null && !"".equals(bcc)) {
                    actionCampaign.setBcc(bcc);
                    context.getRequest().setAttribute("bcc", (Object)bcc);
                }
                if (cc != null && !"".equals(cc)) {
                    actionCampaign.setCc(cc);
                    context.getRequest().setAttribute("cc", (Object)cc);
                }
                boolean bl = isValid = this.validateObject(context, db, (Object)actionCampaign) && isValid;
                if (isValid) {
                    activated = actionCampaign.activate(db);
                }
                if (activated) {
                    messageSent = true;
                    actionCampaign.setContactList(actionCampaign.getRecipients());
                    this.processInsertHook(context, (Object)actionCampaign);
                    context.getRequest().setAttribute("ContactDetails", (Object)new Contact(db, Integer.parseInt(contactId)));
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (messageSent) {
            if (actionSource != null && !"".equals(actionSource)) {
                return ExternalContacts.getReturn(context, "SendMessage" + actionSource);
            }
            return ExternalContacts.getReturn(context, "SendMessage");
        }
        if (actionSource != null && !"".equals(actionSource)) {
            return "SendMessage" + actionSource + "ERROR";
        }
        return this.executeCommandPrepareMessage(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandWorkAsAccount(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        this.addModuleBean(context, "Add Account", "Add Account");
        String contactId = context.getRequest().getParameter("contactId");
        int orgId = -1;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            boolean status = false;
            int resultCount = -1;
            Contact contact = new Contact(db, contactId);
            Contact oldContact = new Contact(db, contactId);
            orgId = contact.getCompany() != null && !"".equals(contact.getCompany().trim()) ? Organization.lookupAccount(db, contact.getCompany(), -1, contact.getSiteId()) : Organization.lookupAccount(db, contact.getNameFirst(), contact.getNameMiddle(), contact.getNameLast(), -1, contact.getSiteId());
            if (orgId > 0) {
                thisOrg = new Organization(db, orgId);
            }
            if (orgId < 0) {
                thisOrg = new Organization();
                thisOrg.setEnteredBy(this.getUserId(context));
                if (contact.getCompany() == null || "".equals(contact.getCompany().trim())) {
                    contact.setPrimaryContact(true);
                    thisOrg.setNameFirst(contact.getNameFirst());
                    thisOrg.setNameLast(contact.getNameLast());
                    thisOrg.setNameMiddle(contact.getNameMiddle());
                    thisOrg.setName(thisOrg.getNameLastFirstMiddle());
                } else {
                    thisOrg.setName(contact.getCompany());
                }
            }
            thisOrg.setSiteId(contact.getSiteId());
            thisOrg.setModifiedBy(this.getUserId(context));
            if (thisOrg.getId() > 0 && thisOrg.getAccountNumber() != null && contact.getAccountNumber() != null && !contact.getAccountNumber().equals(thisOrg.getAccountNumber()) || thisOrg.getOrgId() == -1) {
                thisOrg.setAccountNumber(contact.getAccountNumber());
            }
            if (thisOrg.getId() > 0 && contact.getOwner() != thisOrg.getOwner() || thisOrg.getOrgId() == -1) {
                thisOrg.setOwner(contact.getOwner());
            }
            if (thisOrg.getId() > 0 && contact.getPotential() != thisOrg.getPotential() || thisOrg.getOrgId() == -1) {
                thisOrg.setPotential(contact.getPotential());
            }
            if (thisOrg.getId() > 0 && contact.getIndustryTempCode() != thisOrg.getIndustry() || thisOrg.getOrgId() == -1) {
                thisOrg.setIndustry(contact.getIndustryTempCode());
            }
            if (thisOrg.getId() > 0 && contact.getSource() != thisOrg.getSource() || thisOrg.getOrgId() == -1) {
                thisOrg.setSource(contact.getSource());
            }
            if (thisOrg.getId() > 0 && contact.getRating() != thisOrg.getRating() || thisOrg.getOrgId() == -1) {
                thisOrg.setRating(contact.getRating());
            }
            ExternalContacts.copyPropertiesFromContactToOrganization(contact, thisOrg);
            ContactAddressList contactAddressList = new ContactAddressList();
            contactAddressList.setContactId(contact.getId());
            contactAddressList.buildList(db);
            for (ContactAddress contactAddress : contactAddressList) {
                OrganizationAddress organizationAddress = new OrganizationAddress();
                organizationAddress.setStreetAddressLine1(contactAddress.getStreetAddressLine1());
                organizationAddress.setStreetAddressLine2(contactAddress.getStreetAddressLine2());
                organizationAddress.setStreetAddressLine3(contactAddress.getStreetAddressLine3());
                organizationAddress.setCity(contactAddress.getCity());
                organizationAddress.setState(contactAddress.getState());
                organizationAddress.setZip(contactAddress.getZip());
                organizationAddress.setCountry(contactAddress.getCountry());
                LookupList contactAddressTypeList = new LookupList(db, "lookup_contactaddress_types");
                LookupList orgAddressTypeList = null;
                String contactAddressType = contactAddressTypeList.getValueFromId(contactAddress.getType());
                int orgAddressType = -1;
                if (contactAddress.getType() != -1) {
                    if (contactAddressType.indexOf("Business") > -1) {
                        orgAddressTypeList = new LookupList(db, "lookup_orgaddress_types");
                        orgAddressType = orgAddressTypeList.getIdFromValue("Primary");
                    } else {
                        orgAddressTypeList = new LookupList(db, "lookup_orgaddress_types");
                        orgAddressType = orgAddressTypeList.getIdFromValue("Auxiliary");
                    }
                    organizationAddress.setType(orgAddressType);
                }
                organizationAddress.setPrimaryAddress(contactAddress.getPrimaryAddress());
                thisOrg.getAddressList().add(organizationAddress);
            }
            ContactEmailAddressList contactEmailAddressList = new ContactEmailAddressList();
            contactEmailAddressList.setContactId(contact.getId());
            contactEmailAddressList.buildList(db);
            for (ContactEmailAddress contactEmailAddress : contactEmailAddressList) {
                OrganizationEmailAddress organizationEmailAddress = new OrganizationEmailAddress();
                organizationEmailAddress.setEmail(contactEmailAddress.getEmail());
                LookupList contactEmailAddressTypeList = new LookupList(db, "lookup_contactemail_types");
                LookupList orgEmailAddressTypeList = null;
                String contactEmailAddressType = contactEmailAddressTypeList.getValueFromId(contactEmailAddress.getType());
                int orgEmailAddressType = -1;
                if (contactEmailAddressType.indexOf("Business") > -1) {
                    orgEmailAddressTypeList = new LookupList(db, "lookup_orgemail_types");
                    orgEmailAddressType = orgEmailAddressTypeList.getIdFromValue("Primary");
                } else {
                    orgEmailAddressTypeList = new LookupList(db, "lookup_orgemail_types");
                    orgEmailAddressType = orgEmailAddressTypeList.getIdFromValue("Auxiliary");
                }
                organizationEmailAddress.setType(orgEmailAddressType);
                organizationEmailAddress.setPrimaryEmail(contactEmailAddress.getPrimaryEmail());
                thisOrg.getEmailAddressList().add(organizationEmailAddress);
            }
            ContactPhoneNumberList contactPhoneNumberList = new ContactPhoneNumberList();
            contactPhoneNumberList.setContactId(contact.getId());
            contactPhoneNumberList.buildList(db);
            for (ContactPhoneNumber contactPhoneNumber : contactPhoneNumberList) {
                OrganizationPhoneNumber organizationPhoneNumber = new OrganizationPhoneNumber();
                organizationPhoneNumber.setNumber(contactPhoneNumber.getNumber());
                organizationPhoneNumber.setExtension(contactPhoneNumber.getExtension());
                LookupList contactPhoneNumberTypeList = new LookupList(db, "lookup_contactphone_types");
                LookupList orgPhoneNumberTypeList = null;
                String contactPhoneNumberType = contactPhoneNumberTypeList.getValueFromId(contactPhoneNumber.getType());
                int orgPhoneNumberType = -1;
                if (contactPhoneNumberType.indexOf("Fax") > -1) {
                    orgPhoneNumberTypeList = new LookupList(db, "lookup_orgphone_types");
                    orgPhoneNumberType = orgPhoneNumberTypeList.getIdFromValue("Fax");
                } else {
                    orgPhoneNumberTypeList = new LookupList(db, "lookup_orgphone_types");
                    orgPhoneNumberType = orgPhoneNumberTypeList.getIdFromValue("Main");
                }
                organizationPhoneNumber.setType(orgPhoneNumberType);
                organizationPhoneNumber.setPrimaryNumber(contactPhoneNumber.getPrimaryNumber());
                thisOrg.getPhoneNumberList().add(organizationPhoneNumber);
            }
            if (thisOrg.getOrgId() > 0) {
                status = thisOrg.update(db) == 1;
            } else {
                thisOrg.setInsertPrimaryContact(false);
                status = thisOrg.insert(db);
            }
            if (status) {
                context.getRequest().setAttribute("orgId", (Object)String.valueOf(thisOrg.getOrgId()));
            }
            contact.setOrgId(thisOrg.getOrgId());
            contact.setOrgName(thisOrg.getName());
            if (status) {
                resultCount = contact.update(db, context);
                if (contact.getNameLast() == null || "".equals(contact.getNameLast().trim())) {
                    contact.disable(db);
                }
                this.addRecentItem(context, (Object)thisOrg);
                this.deleteRecentItem(context, (Object)oldContact);
                this.processUpdateHook(context, (Object)oldContact, (Object)contact);
                this.processInsertHook(context, (Object)thisOrg);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("true".equals(context.getRequest().getParameter("popup"))) {
            return "CloseAndReloadOK";
        }
        return "WorkAccountOK";
    }

    private static void copyPropertiesFromContactToOrganization(Contact from, Organization to) {
        to.setRevenue(from.getRevenue());
        to.setEmployees(from.getEmployees());
        to.setDunsType(from.getDunsType());
        to.setYearStarted(from.getYearStarted());
        to.setDunsNumber(from.getDunsNumber());
        to.setBusinessNameTwo(from.getBusinessNameTwo());
        to.setSicDescription(from.getSicDescription());
        to.setSicCode(from.getSicCode());
    }

    public String executeCommandStates(ActionContext context) {
        String country = context.getRequest().getParameter("country");
        String form = context.getRequest().getParameter("form");
        String obj = context.getRequest().getParameter("obj");
        String stateObj = context.getRequest().getParameter("stateObj");
        String defaultValue = context.getRequest().getParameter("selected");
        SystemStatus systemStatus = this.getSystemStatus(context);
        StateSelect stateSelect = new StateSelect(systemStatus, country);
        context.getRequest().setAttribute("stateSelect", (Object)stateSelect.getHtmlSelectObj(country));
        context.getRequest().setAttribute("form", (Object)form);
        context.getRequest().setAttribute("obj", (Object)obj);
        context.getRequest().setAttribute("stateObj", (Object)stateObj);
        if (defaultValue != null) {
            context.getRequest().setAttribute("selected", (Object)defaultValue);
        }
        return "StatesOK";
    }
}

