/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.CallResult;
import org.aspcfs.modules.contacts.base.CallResultList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class ExternalContactsCalls
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        int MINIMIZED_ITEMS_PER_PAGE = 5;
        if (!this.hasPermission(context, "contacts-external_contacts-calls-view")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        String source = context.getRequest().getParameter("source");
        if ("true".equals(context.getRequest().getParameter("resetList"))) {
            if ("calendar".equals(source)) {
                context.getSession().removeAttribute("CalCallsListInfo");
                context.getSession().removeAttribute("CalCompletedCallsListInfo");
            } else {
                context.getSession().removeAttribute("CallsListInfo");
                context.getSession().removeAttribute("CompletedCallsListInfo");
            }
        }
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        this.addModuleBean(context, "External Contacts", "View Activities");
        Connection db = null;
        CallList callList = new CallList();
        String pendingPagedListId = "CallsListInfo";
        if ("calendar".equals(source)) {
            pendingPagedListId = "Cal" + pendingPagedListId;
        }
        if (sectionId == null || pendingPagedListId.equals(sectionId)) {
            PagedListInfo callListInfo = this.getPagedListInfo(context, pendingPagedListId, "c.alertdate", null);
            callListInfo.setLink("ExternalContactsCalls.do?command=View&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            if (sectionId == null) {
                if (!callListInfo.getExpandedSelection()) {
                    if (callListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        callListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (callListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    callListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(callListInfo.getId())) {
                callListInfo.setExpandedSelection(true);
            }
            callList.setPagedListInfo(callListInfo);
            callList.setOnlyPending(true);
            callList.setContactId(contactId);
        }
        CallList completedCallList = new CallList();
        String completedPagedListId = "CompletedCallsListInfo";
        if ("calendar".equals(source)) {
            completedPagedListId = "Cal" + completedPagedListId;
        }
        if (sectionId == null || completedPagedListId.equals(sectionId)) {
            PagedListInfo completedCallListInfo = this.getPagedListInfo(context, completedPagedListId, "c.entered", "desc");
            if ("calendar".equals(source)) {
                completedCallListInfo.setItemsPerPage(10);
                completedCallListInfo.setLink("CalendarCalls.do?command=View&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId|source"));
                completedCallListInfo.setExpandedSelection(true);
            } else {
                completedCallListInfo.setLink("ExternalContactsCalls.do?command=View&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
                if (sectionId == null) {
                    if (!completedCallListInfo.getExpandedSelection()) {
                        if (completedCallListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                            completedCallListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                        }
                    } else if (completedCallListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                        completedCallListInfo.setItemsPerPage(10);
                    }
                } else if (sectionId.equals(completedCallListInfo.getId())) {
                    completedCallListInfo.setExpandedSelection(true);
                }
            }
            completedCallList.setPagedListInfo(completedCallListInfo);
            completedCallList.setContactId(contactId);
            completedCallList.setOnlyCompletedOrCanceled(true);
        }
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (thisContact.getTrashedDate() != null) {
                callList.setIncludeOnlyTrashed(true);
            }
            if (sectionId == null || pendingPagedListId.equals(sectionId)) {
                callList.buildList(db);
            }
            if (thisContact.getTrashedDate() != null) {
                completedCallList.setIncludeOnlyTrashed(true);
            }
            if (sectionId == null || completedPagedListId.equals(sectionId)) {
                completedCallList.buildList(db);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallList", (Object)callList);
        context.getRequest().setAttribute("CompletedCallList", (Object)completedCallList);
        return ExternalContactsCalls.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        String permission = "contacts-external_contacts-calls-add";
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = -1;
        Contact thisContact = null;
        Call parentCall = null;
        Call previousCall = null;
        int tmpStatusId = -1;
        this.addModuleBean(context, "External Contacts", "Save an Activity");
        String contactId = context.getRequest().getParameter("contactId");
        String followupContactId = context.getRequest().getParameter("followupContactId");
        String parentId = context.getRequest().getParameter("parentId");
        String action = context.getRequest().getParameter("action");
        if ("schedule".equals(context.getRequest().getParameter("action"))) {
            context.getRequest().setAttribute("action", (Object)"schedule");
        }
        Call thisCall = (Call)((Object)context.getFormBean());
        Call previousParentCall = null;
        thisCall.setModifiedBy(this.getUserId(context));
        if (thisCall.getId() > 0) {
            permission = "contacts-external_contacts-calls-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (parentId != null && Integer.parseInt(parentId) > -1) {
                parentCall = new Call(db, Integer.parseInt(parentId));
            }
            if ((tmpStatusId = thisCall.getStatusId()) == 3 && !"pending".equals(context.getRequest().getParameter("view"))) {
                thisCall.setCheckAlertDate(false);
            }
            if (thisCall.getId() > 0) {
                previousCall = new Call(db, thisCall.getId());
                if (thisCall.getStatusId() == 2 && previousCall.getAlertDate() == null && thisCall.getAlertDate() != null) {
                    thisCall.setStatusId(3);
                }
                if (isValid = this.validateObject(context, db, (Object)thisCall)) {
                    resultCount = thisCall.update(db, context);
                }
            } else {
                if (thisCall.getId() == -1) {
                    if ("cancel".equals(action)) {
                        thisCall.setStatusId(1);
                    } else if (thisCall.getAlertDate() != null) {
                        thisCall.setStatusId(3);
                    } else {
                        thisCall.setStatusId(2);
                    }
                }
                thisCall.setEnteredBy(this.getUserId(context));
                if (parentCall != null && parentCall.getOppHeaderId() != -1) {
                    thisCall.setOppHeaderId(parentCall.getOppHeaderId());
                }
                if (isValid = this.validateObject(context, db, (Object)thisCall)) {
                    recordInserted = thisCall.insert(db, context);
                }
            }
            this.addModifyFormElements(db, context, thisCall);
            if (contactId != null && !"-1".equals(contactId)) {
                thisContact = new Contact(db, contactId);
                if (!this.hasPermission(context, "contacts-external_contacts-calls-add") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
                    String string = "PermissionError";
                    return string;
                }
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            } else if (followupContactId != null && !"-1".equals(followupContactId)) {
                thisContact = new Contact(db, followupContactId);
                if (!this.hasPermission(context, "contacts-external_contacts-calls-add") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
                    String string = "PermissionError";
                    return string;
                }
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            }
            if (!recordInserted && resultCount == -1) {
                thisCall.setStatusId(tmpStatusId);
                if (thisCall.getAlertText() != null && !"".equals(thisCall.getAlertText())) {
                    thisCall.setHasFollowup(true);
                }
                if (thisCall.getId() > 0) {
                    Call tempCall = new Call(db, thisCall.getId());
                    if (thisCall.getAlertText() != null && !"".equals(thisCall.getAlertText())) {
                        thisCall.setHasFollowup(true);
                    }
                    thisCall.setCallType(tempCall.getCallType());
                    this.addModifyFormElements(db, context, thisCall);
                    if (resultCount == 0) {
                        HashMap<String, String> errors = new HashMap<String, String>();
                        SystemStatus systemStatus = this.getSystemStatus(context);
                        errors.put("actionError", systemStatus.getLabel("object.validation.recordUpdatedByAnotherUser"));
                        this.processErrors(context, errors);
                        context.getRequest().setAttribute("CallDetails", (Object)tempCall);
                    }
                }
            } else {
                if (parentCall != null) {
                    previousParentCall = new Call(db, parentCall.getId());
                    parentCall.setStatusId(2);
                    parentCall.update(db, context);
                    this.processUpdateHook(context, (Object)previousParentCall, (Object)parentCall);
                }
                thisCall = new Call(db, thisCall.getId());
                if (recordInserted) {
                    this.processInsertHook(context, (Object)thisCall);
                } else if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)previousCall, (Object)thisCall);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String errors = "SystemError";
            return errors;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean popup = "true".equals(context.getRequest().getParameter("popup"));
        boolean inlinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordInserted) {
            if (context.getRequest().getParameter("actionSource") != null) {
                return ExternalContactsCalls.getReturn(context, "InsertCall");
            }
            return ExternalContactsCalls.getReturn(context, "Insert");
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandView(context);
            }
            if (popup && !inlinePopup) {
                return "PopupCloseOK";
            }
            return "UpdateOK";
        }
        if (parentId != null && Integer.parseInt(parentId) > -1) {
            if (action != null && "cancel".equals(action)) {
                return this.executeCommandCancel(context);
            }
            return this.executeCommandComplete(context);
        }
        if (thisCall.getId() > 0) {
            return ExternalContactsCalls.getReturn(context, "Modify");
        }
        return this.executeCommandLog(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        this.addModuleBean(context, "External Contacts", "Calls");
        String callId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        Call thisCall = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            if (thisCall.getAlertDate() != null) {
                SystemStatus systemStatus = this.getSystemStatus(context);
                LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
                context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            }
            if (thisCall.getResultId() > -1) {
                CallResult thisResult = new CallResult(db, thisCall.getResultId());
                context.getRequest().setAttribute("CallResult", (Object)thisResult);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        return ExternalContactsCalls.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        HtmlDialog htmlDialog = new HtmlDialog();
        Call thisCall = null;
        String id = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisCall = new Call(db, Integer.parseInt(id));
            DependencyList dependencies = thisCall.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='ExternalContactsCalls.do?command=Delete&contactId=" + contactId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            } else {
                dependencies.setSystemStatus(systemStatus);
                htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ExternalContactsCalls.do?command=Delete&contactId=" + contactId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        boolean recordDeleted = false;
        String contactId = context.getRequest().getParameter("contactId");
        Call thisCall = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            thisCall = new Call(db, context.getRequest().getParameter("id"));
            this.processDeleteHook(context, (Object)thisCall);
            recordDeleted = thisCall.delete(db);
            if (!recordDeleted) {
                thisCall.getErrors().put("actionError", systemStatus.getLabel("obejct.validation.actionError.callDeletion"));
                this.processErrors(context, thisCall.getErrors());
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean inLinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordDeleted) {
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("refreshUrl", (Object)("ExternalContactsCalls.do?command=View&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId" + (inLinePopup ? "|popup" : ""))));
            return ExternalContactsCalls.getReturn(context, "Delete");
        }
        this.processErrors(context, thisCall.getErrors());
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLog(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-calls-add")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        this.addModuleBean(context, "External Contacts", "Log an Activity");
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            if (contactId != null && !"".equals(contactId.trim()) && Integer.parseInt(contactId) > -1) {
                thisContact = new Contact(db, contactId);
                if (!this.hasPermission(context, "contacts-external_contacts-calls-add") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getRequest().getParameter("actionSource") != null) {
            return ExternalContactsCalls.getReturn(context, "LogCall");
        }
        return ExternalContactsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSchedule(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-calls-add")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        this.addModuleBean(context, "External Contacts", "Schedule an Activity");
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            if (contactId != null && !"".equals(contactId.trim()) && Integer.parseInt(contactId) > -1) {
                thisContact = new Contact(db, contactId);
                if (!this.hasPermission(context, "contacts-external_contacts-calls-add") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)"schedule");
        if (context.getRequest().getParameter("actionSource") != null) {
            return ExternalContactsCalls.getReturn(context, "LogCall");
        }
        return ExternalContactsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        this.addModuleBean(context, "External Contacts", "Activities");
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        int callId = Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            this.addModifyFormElements(db, context, thisCall);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        return ExternalContactsCalls.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComplete(ActionContext context) {
        this.addModuleBean(context, "External Contacts", "Complete Activity");
        String contactId = context.getRequest().getParameter("contactId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            Contact thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandForwardCall(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-calls-view")) {
            return "PermissionError";
        }
        String msgId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        CFSNote newNote = null;
        Contact thisContact = null;
        this.addModuleBean(context, "External Contacts", "Forward Message");
        int noteType = Integer.parseInt(context.getRequest().getParameter("forwardType"));
        context.getRequest().setAttribute("forwardType", (Object)"15");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            newNote = new CFSNote();
            Call thisCall = new Call(db, msgId);
            String contactName = "Contact Name: ";
            String type = "Type: ";
            String length = "Length: ";
            String subject = "Subject: ";
            String notes = "Notes: ";
            String entered = "Entered: ";
            String modified = "Modified: ";
            contactName = systemStatus.getLabel("mail.label.contactName");
            type = systemStatus.getLabel("mail.label.type");
            length = systemStatus.getLabel("mail.label.length");
            subject = systemStatus.getLabel("mail.label.subject.colon");
            notes = systemStatus.getLabel("mail.label.notes");
            entered = systemStatus.getLabel("mail.label.entered");
            modified = systemStatus.getLabel("mail.label.modified");
            newNote.setBody(contactName + StringUtils.toString(thisCall.getContactName()) + "\n" + type + StringUtils.toString(thisCall.getCallType()) + "\n" + length + StringUtils.toString(thisCall.getLengthText()) + "\n" + subject + StringUtils.toString(thisCall.getSubject()) + (!StringUtils.toString(thisCall.getSubject()).equals(StringUtils.toString(thisCall.getAlertText())) && !"".equals(StringUtils.toString(thisCall.getAlertText())) ? "\\" + StringUtils.toString(thisCall.getAlertText()) : "") + "\n" + notes + StringUtils.toString(thisCall.getNotes()) + "\n" + entered + this.getUser(context, thisCall.getEnteredBy()).getContact().getNameFirstLast() + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getEntered()) + "\n" + modified + this.getUser(context, thisCall.getModifiedBy()).getContact().getNameFirstLast() + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getModified()));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Note", (Object)newNote);
        return ExternalContactsCalls.getReturn(context, "ForwardCall");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-calls-delete")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "External Contacts", "Cancel Activity");
        String contactId = context.getRequest().getParameter("contactId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            Call nextCall = new Call();
            nextCall.setCallTypeId(thisCall.getAlertCallTypeId());
            nextCall.setSubject(thisCall.getAlertText());
            nextCall.setNotes(thisCall.getFollowupNotes());
            if (thisCall.getOppHeaderId() != -1) {
                nextCall.setOppHeaderId(thisCall.getOppHeaderId());
            }
            context.getRequest().setAttribute("CallDetails", (Object)nextCall);
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendCall(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-calls-view")) {
            return "PermissionError";
        }
        String callId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        this.addModuleBean(context, "External Contacts", "Send Message");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-calls-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-calls-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            Call thisCall = new Call(db, callId);
            context.getRequest().setAttribute("CallDetails", (Object)thisCall);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsCalls.getReturn(context, "SendCall");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSuggestCall(ActionContext context) {
        String resultId = context.getRequest().getParameter("resultId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            CallResult thisResult = new CallResult(db, Integer.parseInt(resultId));
            context.getRequest().setAttribute("CallResult", (Object)thisResult);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsCalls.getReturn(context, "SuggestCall");
    }

    private void addModifyFormElements(Connection db, ActionContext context, Call thisCall) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
        callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
        LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
        context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
        context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        if ("pending".equals(context.getRequest().getParameter("view")) || thisCall.getStatusId() == 2 && (thisCall.getAlertDate() == null || context.getRequest().getAttribute("alertDateWarning") != null)) {
            if (thisCall.getResultId() > -1) {
                CallResult thisResult = new CallResult(db, thisCall.getResultId());
                context.getRequest().setAttribute("CallResult", (Object)thisResult);
            }
            if (!"pending".equals(context.getRequest().getParameter("view"))) {
                CallResultList resultList = new CallResultList();
                resultList.buildList(db);
                context.getRequest().setAttribute("callResultList", (Object)resultList);
            }
        } else {
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
    }
}

