/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.Contact;

public final class ExternalContactsDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "contacts-external_contacts-documents-view")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null && !"".equals(contactId)) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        Exception errorMessage = null;
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, Integer.parseInt(contactId))) {
                String string = "PermissionError";
                return string;
            }
            thisContact = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            FileFolderList folders = new FileFolderList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                folders.setTopLevelOnly(true);
            } else {
                folders.setParentId(Integer.parseInt(folderId));
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            folders.setLinkModuleId(2);
            folders.setLinkItemId(thisContact.getId());
            folders.setBuildItemCount(true);
            folders.buildList(db);
            FileItemList files = new FileItemList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                files.setTopLevelOnly(true);
            } else {
                files.setFolderId(Integer.parseInt(folderId));
            }
            files.setBuildPortalRecords(ExternalContactsDocuments.isPortalUser(context) ? 1 : -1);
            files.setLinkModuleId(2);
            files.setLinkItemId(thisContact.getId());
            files.buildList(db);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("fileItemList", (Object)files);
            context.getRequest().setAttribute("fileFolderList", (Object)folders);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "View Documents");
        if (errorMessage == null) {
            String contactfolders = context.getRequest().getParameter("contactfolders");
            if (contactfolders != null && "true".equals(contactfolders)) {
                return "ViewContactFolderPopupOK";
            }
            return ExternalContactsDocuments.getReturn(context, "View");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contact", "Upload Document");
        if (errorMessage == null) {
            return ExternalContactsDocuments.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "contacts");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            String allowPortalAccess = (String)parts.get("allowPortalAccess");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db = this.getConnection(context), (thisContact = this.addContact(context, db, id)).getId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(2);
                thisItem.setLinkItemId(thisContact.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                thisItem.setAllowPortalAccess(allowPortalAccess);
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                if (recordInserted) {
                    this.processInsertHook(context, thisItem);
                    context.getRequest().setAttribute("fileItem", (Object)thisItem);
                    context.getRequest().setAttribute("subject", (Object)"");
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "contacts-external_contacts-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Contact thisContact = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "Upload New Document Version");
        if (errorMessage == null) {
            return ExternalContactsDocuments.getReturn(context, "AddVersion");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "contacts");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            String folderId = (String)parts.get("folderId");
            String allowPortalAccess = (String)parts.get("allowPortalAccess");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db = this.getConnection(context), (thisContact = this.addContact(context, db, id)).getId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem previousItem = null;
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(2);
                thisItem.setLinkItemId(thisContact.getId());
                thisItem.setId(Integer.parseInt(itemId));
                previousItem = new FileItem(db, Integer.parseInt(itemId), thisItem.getLinkItemId(), thisItem.getLinkModuleId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                thisItem.setAllowPortalAccess(allowPortalAccess);
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
                if (recordInserted) {
                    this.processUpdateHook(context, previousItem, thisItem);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String folderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            Contact thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            thisItem.buildVersionList(db, ExternalContactsDocuments.isPortalUser(context));
            if (folderId == null) {
                folderId = "" + thisItem.getFolderId();
            }
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (!(folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId.trim()))) {
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "Document Details");
        if (errorMessage == null) {
            return ExternalContactsDocuments.getReturn(context, "Details");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block29: {
            if (!this.hasPermission(context, "contacts-external_contacts-documents-view")) {
                return "PermissionError";
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String view = context.getRequest().getParameter("view");
            FileItem thisItem = null;
            Connection db = null;
            Contact thisContact = null;
            try {
                db = this.getConnection(context);
                thisContact = this.addContact(context, db);
                if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "contacts") + ExternalContactsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("ContactsDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block29;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "contacts") + ExternalContactsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block29;
                }
                db = null;
                System.err.println("ContactsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "View Contacts", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "Modify Document Information");
        if (errorMessage == null) {
            return ExternalContactsDocuments.getReturn(context, "Modify");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        String allowPortalAccess = context.getRequest().getParameter("allowPortalAccess");
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            FileItem previousItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            thisItem.setAllowPortalAccess(allowPortalAccess);
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.update(db);
            }
            if (recordInserted) {
                this.processUpdateHook(context, previousItem, thisItem);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "");
        if (recordInserted && isValid) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            recordDeleted = thisItem.delete(db, this.getPath(context, "contacts"));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Contacts", "Delete Document");
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private Contact addContact(ActionContext context, Connection db) throws SQLException {
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        return this.addContact(context, db, contactId);
    }

    private Contact addContact(ActionContext context, Connection db, String contactId) throws SQLException {
        context.getRequest().setAttribute("contactId", (Object)contactId);
        Contact thisContact = new Contact(db, Integer.parseInt(contactId));
        context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        return thisContact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(2);
            hierarchy.setLinkItemId(thisContact.getId());
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addContact(context, db);
            if (!ExternalContactsDocuments.isRecordAccessPermitted(context, db, thisContact.getId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisContact.getId(), 2);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

