/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.base.ImportList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactImport;
import org.aspcfs.modules.contacts.base.ContactImportValidate;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ExternalContactsImports
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ExternalContactsImportListInfo");
        pagedListInfo.setLink("ExternalContactsImports.do?command=View");
        pagedListInfo.setDefaultListView("my");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            ImportList thisList = new ImportList();
            thisList.setType(33020041);
            thisList.setPagedListInfo(pagedListInfo);
            if ("my".equals(pagedListInfo.getListView())) {
                thisList.setEnteredBy(this.getUserId(context));
            } else {
                thisList.setEnteredIdRange(this.getUserRange(context));
            }
            thisList.setManager(manager);
            thisList.setSystemStatus(systemStatus);
            thisList.buildList(db);
            thisList.updateRecordCounts();
            context.getRequest().setAttribute("ImportList", (Object)thisList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandNew(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.buildFormElements(db, context);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "New");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String executeCommandSave(ActionContext context) {
        block12: {
            block13: {
                if (!this.hasPermission(context, "contacts-external_contacts-imports-add")) {
                    return "PermissionError";
                }
                errors = new HashMap<String, String>();
                isValid = false;
                db = null;
                contactRecordInserted = false;
                fileRecordInserted = false;
                systemStatus = this.getSystemStatus(context);
                thisImport = (ContactImport)context.getFormBean();
                db = this.getConnection(context);
                filePath = this.getPath(context, "contacts");
                multiPart = new HttpMultiPartParser();
                multiPart.setUsePathParam(false);
                multiPart.setUseUniqueName(true);
                multiPart.setUseDateForFolder(true);
                multiPart.setExtensionId(this.getUserId(context));
                parts = multiPart.parseData(context.getRequest(), filePath);
                subject = (String)parts.get("name");
                description = (String)parts.get("description");
                sourceType = (String)parts.get("sourceType");
                rating = (String)parts.get("rating");
                comments = (String)parts.get("comments");
                siteId = (String)parts.get("siteId");
                thisImport.setEnteredBy(this.getUserId(context));
                thisImport.setModifiedBy(this.getUserId(context));
                thisImport.setType(33020041);
                thisImport.setName(subject);
                thisImport.setDescription(description);
                thisImport.setSourceType(sourceType);
                thisImport.setRating(rating);
                thisImport.setComments(comments);
                thisImport.setSiteId(siteId);
                if (parts.get("id") instanceof FileInfo) break block13;
                fileRecordInserted = false;
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
                isValid = this.validateObject(context, db, thisImport);
                context.getRequest().setAttribute("name", (Object)subject);
                isValid = false;
                ** GOTO lbl68
            }
            isValid = this.validateObject(context, db, thisImport);
            if (!isValid) ** GOTO lbl68
            if (ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) break block12;
            var18_19 = "PermissionError";
            this.freeConnection(context, db);
            return var18_19;
        }
        try {
            contactRecordInserted = thisImport.insert(db);
            if (contactRecordInserted && parts.get("id") instanceof FileInfo) {
                newFileInfo = (FileInfo)parts.get("id");
                thisItem = new FileItem();
                thisItem.setLinkModuleId(33020041);
                thisItem.setLinkItemId(thisImport.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    fileRecordInserted = thisItem.insert(db);
                }
            }
lbl68:
            // 7 sources

            if (contactRecordInserted && fileRecordInserted) {
                thisImport = new ContactImport(db, thisImport.getId());
                thisImport.buildFileDetails(db);
                thisImport.setSystemStatus(systemStatus);
            } else if (contactRecordInserted) {
                thisImport.delete(db);
                thisImport.setId(-1);
            }
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                var8_9 = "SystemError";
            }
            catch (Throwable var20_22) {
                this.freeConnection(context, db);
                throw var20_22;
            }
            this.freeConnection(context, db);
            return var8_9;
        }
        this.freeConnection(context, db);
        if (fileRecordInserted && contactRecordInserted) {
            return ExternalContactsImports.getReturn(context, "Save");
        }
        return this.executeCommandNew(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            String importId = context.getRequest().getParameter("importId");
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            thisImport.buildFileDetails(db);
            thisImport.setSystemStatus(systemStatus);
            ConnectionPool cPool = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (thisImport.isRunning() && activeImport != null) {
                thisImport.updateRecordCounts(manager);
            } else if (thisImport.isRunning() && activeImport == null) {
                thisImport.updateStatus(db, 4);
            }
            this.buildFormElements(db, context);
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInitValidate(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            String importId = context.getRequest().getParameter("importId");
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            thisImport.buildFileDetails(db);
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "generalContact");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            String filePath = this.getPath(context, "contacts") + ExternalContactsImports.getDatePath(importFile.getModified()) + importFile.getFilename();
            if (FileUtils.fileExists(filePath)) {
                ContactImportValidate validator = new ContactImportValidate();
                validator.setContactImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.initialize();
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.incorrectFileName"));
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "InitValidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandValidate(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            String importId = context.getRequest().getParameter("importId");
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            thisImport.buildFileDetails(db);
            thisImport.setProperties(context.getRequest());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "generalContact");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            String filePath = this.getPath(context, "contacts") + ExternalContactsImports.getDatePath(importFile.getModified()) + importFile.getFilename();
            if (FileUtils.fileExists(filePath)) {
                ContactImportValidate validator = new ContactImportValidate();
                validator.setContactImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.validate(context.getRequest());
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
                if (validator.getErrors().size() == 0) {
                    String string = this.executeCommandProcess(context);
                    return string;
                }
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.incorrectFileName"));
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "Validate");
    }

    public String executeCommandProcess(ActionContext context) {
        try {
            SystemStatus systemStatus = this.getSystemStatus(context);
            ContactImportValidate validator = (ContactImportValidate)context.getRequest().getAttribute("ImportValidator");
            ContactImport thisImport = (ContactImport)context.getRequest().getAttribute("ImportDetails");
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                return "PermissionError";
            }
            FileItem thisItem = (FileItem)context.getRequest().getAttribute("FileItem");
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (activeImport == null) {
                thisImport.setSystemStatus(systemStatus);
                thisImport.setPropertyMap(validator.getPropertyMap());
                thisImport.setFilePath(validator.getFilePath());
                thisImport.setUserId(this.getUserId(context));
                thisImport.setConnectionElement(ce);
                thisImport.setFileItem(thisItem);
                manager.add(thisImport);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${thisImport.name}", thisImport.getName());
                Template template = new Template(systemStatus.getLabel("object.validation.actionError.importAlreadyRunning"));
                template.setParseElements(map);
                context.getRequest().setAttribute("actionError", (Object)template.getParsedText());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return ExternalContactsImports.getReturn(context, "Process");
    }

    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-add")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            if (!manager.cancel(Integer.parseInt(importId))) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importCancelFailed"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return ExternalContactsImports.getReturn(context, "Cancel");
        }
        return ExternalContactsImports.getReturn(context, "CancelDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        if (!this.hasPermission(context, "contacts-external_contacts-imports-delete")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisImport.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='ExternalContactsImports.do?command=Delete&importId=" + importId + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ExternalContactsImports.do?command=Delete&importId=" + importId + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Connection db = null;
        if (!this.hasPermission(context, "contacts-external_contacts-imports-delete")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            int recordDeleted = thisImport.updateStatus(db, 8);
            if (recordDeleted > 0) {
                FileItem importFile = new FileItem(db, thisImport.getId(), 33020041);
                importFile.delete(db, this.getPath(context, "contacts"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"ExternalContactsImports.do?command=View");
        return ExternalContactsImports.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        block26: {
            if (!this.hasPermission(context, "contacts-external_contacts-imports-view")) {
                return "PermissionError";
            }
            Exception errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String importId = context.getRequest().getParameter("importId");
            String stream = context.getRequest().getParameter("stream");
            String version = context.getRequest().getParameter("ver");
            FileItem thisItem = null;
            ContactImport thisImport = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            Connection db = null;
            try {
                db = this.getConnection(context);
                thisImport = new ContactImport(db, Integer.parseInt(importId));
                if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(importId), 33020041);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "contacts") + ExternalContactsImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if ("true".equals(stream)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("ExternalContactsImports-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
                        context.getRequest().setAttribute("FileItem", (Object)itemToDownload);
                        String string = ExternalContactsImports.getReturn(context, "Details");
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block26;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "contacts") + ExternalContactsImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block26;
                }
                db = null;
                System.err.println("ExternalContactsImports-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandApprove(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            if (thisImport.canApprove()) {
                thisImport.updateStatus(db, 7);
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importNotProcessed"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "Approve");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewResults(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ExternalContactsImportResultsInfo");
        pagedListInfo.setLink("ExternalContactsImports.do?command=ViewResults&importId=" + importId);
        try {
            db = this.getConnection(context);
            ContactImport thisImport = new ContactImport(db, Integer.parseInt(importId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, thisImport)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            ContactList thisList = new ContactList();
            thisList.setPagedListInfo(pagedListInfo);
            pagedListInfo.setSearchCriteria(thisList, context);
            thisList.setImportId(Integer.parseInt(importId));
            thisList.setIncludeAllSites(true);
            thisList.setBuildDetails(true);
            thisList.setExcludeUnapprovedContacts(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("ImportResults", (Object)thisList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "ViewResults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandContactDetails(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(true);
            thisContact.queryRecord(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            Import thisImport = new Import(db, thisContact.getImportId());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            if (!ExternalContactsImports.isRecordAccessPermitted(context, (Object)thisImport)) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsImports.getReturn(context, "ContactDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteContact(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-imports-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordDeleted = false;
        String contactId = context.getRequest().getParameter("contactId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            if (!ExternalContactsImports.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (thisContact.getStatusId() != 7) {
                recordDeleted = thisContact.delete(db, context, this.getPath(context, "contacts"));
                this.processErrors(context, thisContact.getErrors());
                if (!recordDeleted) {
                    context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            return ExternalContactsImports.getReturn(context, "DeleteContact");
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return ExternalContactsImports.getReturn(context, "DeleteContactFailedList");
        }
        return ExternalContactsImports.getReturn(context, "DeleteContactFailedDetails");
    }

    private void buildValidateFormElements(Connection db, ActionContext context, ContactImport thisImport) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        AccessTypeList accessTypeList = null;
        accessTypeList = thisImport.getType() == 33020043 ? systemStatus.getAccessTypeList(db, 626030331) : systemStatus.getAccessTypeList(db, 626030330);
        context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        LookupList emailTypeList = systemStatus.getLookupList(db, "lookup_contactemail_types");
        context.getRequest().setAttribute("ContactEmailTypeList", (Object)emailTypeList);
        LookupList phoneTypeList = systemStatus.getLookupList(db, "lookup_contactphone_types");
        context.getRequest().setAttribute("ContactPhoneTypeList", (Object)phoneTypeList);
        LookupList addressTypeList = systemStatus.getLookupList(db, "lookup_contactaddress_types");
        context.getRequest().setAttribute("ContactAddressTypeList", (Object)addressTypeList);
    }

    private void buildFormElements(Connection db, ActionContext context) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList sourceList = new LookupList(db, "lookup_contact_source");
        sourceList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SourceTypeList", (Object)sourceList);
        LookupList ratings = new LookupList(db, "lookup_contact_rating");
        ratings.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("RatingList", (Object)ratings);
        LookupList siteList = new LookupList(db, "lookup_site_id");
        siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteList", (Object)siteList);
    }
}

