/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLogList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class ExternalContactsOpps
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewOpps(ActionContext context) {
        Exception errorMessage = null;
        String contactId = context.getRequest().getParameter("contactId");
        this.addModuleBean(context, "External Contacts", "Opportunities");
        PagedListInfo oppPagedListInfo = this.getPagedListInfo(context, "ExternalOppsPagedListInfo");
        oppPagedListInfo.setLink("ExternalContactsOpps.do?command=ViewOpps&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
        Connection db = null;
        OpportunityHeaderList oppList = new OpportunityHeaderList();
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            oppList.setPagedListInfo(oppPagedListInfo);
            oppList.setAllowMultipleComponents(this.allowMultiple(context));
            oppList.setContactId(contactId);
            oppList.setBuildTotalValues(true);
            if ("my".equals(oppPagedListInfo.getListView())) {
                oppList.setControlledHierarchyOnly(-1);
                oppList.setOwner(this.getUserId(context));
                oppList.setQueryOpenOnly(true);
            } else if ("closed".equals(oppPagedListInfo.getListView())) {
                if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context));
                    oppList.setAccessType(accessTypeList.getCode(626030334));
                } else {
                    oppList.setControlledHierarchyOnly(-1);
                }
                oppList.setQueryClosedOnly(true);
            } else {
                if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context));
                    oppList.setAccessType(accessTypeList.getCode(626030334));
                } else {
                    oppList.setControlledHierarchyOnly(-1);
                }
                oppList.setQueryOpenOnly(true);
            }
            if (thisContact.isTrashed()) {
                oppList.setIncludeOnlyTrashed(true);
            }
            oppList.buildList(db);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("OpportunityHeaderList", (Object)oppList);
            return ExternalContactsOpps.getReturn(context, "ListOpps");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        Exception errorMessage = null;
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        Connection db = null;
        String id = context.getRequest().getParameter("headerId");
        if (id == null || "".equals(id)) {
            id = (String)context.getRequest().getAttribute("headerId");
        }
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (context.getRequest().getAttribute("ContactDetails") == null) {
                thisContact = new Contact(db, contactId);
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            } else {
                thisContact = (Contact)((Object)context.getRequest().getAttribute("ContactDetails"));
            }
            if (!(id == null || "-1".equals(id) || this.hasPermission(context, "contacts-external_contacts-opportunities-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-add")))) {
                String string = "PermissionError";
                return string;
            }
            if (id != null && !"-1".equals(id)) {
                OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(id));
                context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "External Contacts", "Opportunities");
            return "PrepareOppOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        boolean recordInserted = false;
        boolean isValid = false;
        OpportunityBean newOpp = (OpportunityBean)((Object)context.getRequest().getAttribute("OppDetails"));
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newOpp.getComponent().setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newOpp.getComponent().setEnteredBy(this.getUserId(context));
        newOpp.getComponent().setModifiedBy(this.getUserId(context));
        newOpp.getHeader().setEnteredBy(this.getUserId(context));
        newOpp.getHeader().setModifiedBy(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            thisContact = new Contact(db, contactId);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-add") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-add")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            isValid = this.validateObject(context, db, (Object)newOpp);
            isValid = this.validateObject(context, db, (Object)newOpp.getHeader()) && isValid;
            boolean bl = isValid = this.validateObject(context, db, (Object)newOpp.getComponent()) && isValid;
            if (isValid) {
                recordInserted = newOpp.insert(db, context);
            }
            if (recordInserted) {
                OpportunityHeader header = newOpp.getHeader();
                OpportunityComponent component = newOpp.getComponent();
                component.setContactId(header.getContactLink());
                component.setOrgId(header.getAccountLink());
                this.processInsertHook(context, (Object)component);
            } else {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newOpp.getComponent().getTypeList());
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            this.addRecentItem(context, (Object)newOpp.getHeader());
            context.getRequest().setAttribute("headerId", (Object)String.valueOf(newOpp.getHeader().getId()));
            return this.executeCommandDetailsOpp(context);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateOpp(ActionContext context) {
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        String headerId = context.getRequest().getParameter("headerId");
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            OpportunityHeader oldHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            if (!this.hasAuthority(context, oppHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            oppHeader.setModifiedBy(this.getUserId(context));
            oppHeader.setDescription(context.getRequest().getParameter("description"));
            isValid = this.validateObject(context, db, (Object)oppHeader);
            if (isValid) {
                resultCount = oppHeader.update(db);
            }
            if (resultCount == 1) {
                this.processUpdateHook(context, (Object)oldHeader, (Object)oppHeader);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandViewOpps(context);
            }
            return this.executeCommandDetailsOpp(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModifyOpp(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveComponent(ActionContext context) {
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = 0;
        Contact thisContact = null;
        String permission = "contacts-external_contacts-opportunities-add";
        SystemStatus systemStatus = this.getSystemStatus(context);
        OpportunityHeader header = null;
        OpportunityBean bean = new OpportunityBean();
        OpportunityComponent newComponent = (OpportunityComponent)((Object)context.getFormBean());
        OpportunityComponent oldComponent = null;
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newComponent.setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newComponent.setEnteredBy(this.getUserId(context));
        newComponent.setModifiedBy(this.getUserId(context));
        String action = newComponent.getId() > 0 ? "modify" : "insert";
        String contactId = context.getRequest().getParameter("contactId");
        if ("modify".equals(action)) {
            permission = "contacts-external_contacts-opportunities-edit";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            header = new OpportunityHeader(db, newComponent.getHeaderId());
            newComponent.setContactId(header.getContactLink());
            newComponent.setOrgId(header.getAccountLink());
            bean.setHeader(header);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (!this.hasPermission(context, permission) || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (newComponent.getId() > 0) {
                newComponent.setModifiedBy(this.getUserId(context));
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(context, header.getManager()) && !this.hasAuthority(context, newComponent.getOwner())) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    oldComponent = new OpportunityComponent(db, newComponent.getId());
                    resultCount = newComponent.update(db, context);
                }
                if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)oldComponent, (Object)newComponent);
                }
            } else {
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(context, header.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    recordInserted = newComponent.insert(db, context);
                }
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)newComponent);
                this.addRecentItem(context, (Object)newComponent);
            } else if (resultCount == 1) {
                newComponent.queryRecord(db, newComponent.getId());
            } else {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newComponent.getTypeList());
                if ("modify".equals(action) && resultCount == -1) {
                    UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
                    User thisRec = thisUser.getUserRecord();
                    UserList shortChildList = thisRec.getShortChildList();
                    UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
                    userList.setMyId(this.getUserId(context));
                    userList.setMyValue(thisUser.getContact().getNameLastFirst());
                    userList.setIncludeMe(true);
                    userList.setExcludeDisabledIfUnselected(true);
                    userList.setExcludeExpiredIfUnselected(true);
                    context.getRequest().setAttribute("UserList", (Object)userList);
                }
            }
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            context.getRequest().setAttribute("ComponentDetails", (Object)newComponent);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("insert".equals(action)) {
            if (recordInserted) {
                return this.executeCommandDetailsOpp(context);
            }
            return this.executeCommandPrepare(context);
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandDetailsOpp(context);
            }
            return this.executeCommandDetailsComponent(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandPrepare(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsOpp(ActionContext context) {
        Object errorMessage = null;
        int headerId = -1;
        this.addModuleBean(context, "External Contacts", "Opportunities");
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        Contact thisContact = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentList componentList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        PagedListInfo oppPagedListInfo = this.getPagedListInfo(context, "ExternalOppsPagedListInfo", false);
        PagedListInfo componentListInfo = this.getPagedListInfo(context, "ComponentListInfo");
        componentListInfo.setLink("ExternalContactsOpps.do?command=DetailsOpp&headerId=" + headerId + "&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!thisContact.getEnabled() || thisContact.isTrashed()) {
                String string = "ContactDisabledError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            componentList = new OpportunityComponentList();
            componentList.setPagedListInfo(componentListInfo);
            componentList.setAccessType(thisHeader.getAccessType());
            if (oppPagedListInfo != null && oppPagedListInfo.getListView() != null) {
                if ("my".equals(oppPagedListInfo.getListView())) {
                    componentList.setControlledHierarchyOnly(-1);
                    componentList.setOwner(this.getUserId(context));
                    componentList.setQueryOpenOnly(true);
                } else if (!this.excludeHierarchy(context)) {
                    componentList.setControlledHierarchy(0, this.getUserRange(context));
                } else {
                    componentList.setControlledHierarchyOnly(-1);
                }
            } else {
                componentList.setControlledHierarchy(0, this.getUserRange(context));
            }
            componentList.setHeaderId(thisHeader.getId());
            if (thisHeader.isTrashed()) {
                componentList.setIncludeOnlyTrashed(true);
            }
            componentList.buildList(db);
            context.getRequest().setAttribute("componentList", (Object)componentList);
            if (!this.allowMultiple(context) && componentList.size() > 0) {
                OpportunityComponent thisComponent = (OpportunityComponent)((Object)componentList.get(0));
                context.getRequest().setAttribute("oppComponentDetails", (Object)thisComponent);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addRecentItem(context, (Object)thisHeader);
        if (!this.allowMultiple(context) && componentList.size() > 0) {
            return ExternalContactsOpps.getReturn(context, "DetailsComponent");
        }
        return ExternalContactsOpps.getReturn(context, "DetailsOpp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyOpp(ActionContext context) {
        Exception errorMessage = null;
        this.addModuleBean(context, "External Contacts", "Opportunities");
        int headerId = Integer.parseInt(context.getRequest().getParameter("headerId"));
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        OpportunityHeader thisHeader = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            if (!this.hasAuthority(context, thisHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("opportunityHeader", thisHeader);
            this.addRecentItem(context, (Object)thisHeader);
            return ExternalContactsOpps.getReturn(context, "ModifyOpp");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsComponent(ActionContext context) {
        OpportunityComponent thisComponent = null;
        Contact thisContact = null;
        Connection db = null;
        this.addModuleBean(context, "External Contacts", "Opportunities");
        String componentId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-view") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent(db, Integer.parseInt(componentId));
            OpportunityHeader oppHeader = new OpportunityHeader(db, thisComponent.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, oppHeader.getManager()) && !this.hasAuthority(context, thisComponent.getOwner()) && accessTypeList.getCode(626030334) != oppHeader.getAccessType()) {
                String string = "PermissionError";
                return string;
            }
            thisComponent.checkEnabledOwnerAccount(db);
            context.getRequest().setAttribute("oppComponentDetails", (Object)thisComponent);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addRecentItem(context, (Object)thisComponent);
        return ExternalContactsOpps.getReturn(context, "DetailsComponent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        HtmlDialog htmlDialog = new HtmlDialog();
        String headerId = context.getRequest().getParameter("headerId");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            OpportunityHeader thisOpp = new OpportunityHeader(db, headerId);
            if (!this.hasAuthority(context, thisOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisOpp.processDependencies(db, this.allowMultiple(context));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ExternalContactsOpps.do?command=DeleteOpp&contactId=" + contactId + "&id=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId|sourcePopup") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmComponentDelete(ActionContext context) {
        Exception errorMessage = null;
        OpportunityComponent thisComponent = null;
        OpportunityHeader header = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            thisComponent = new OpportunityComponent(db, id);
            header = new OpportunityHeader(db, thisComponent.getHeaderId());
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, header.getManager()) && !this.hasAuthority(context, thisComponent.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.contact.opps.delete"));
            htmlDialog.setShowAndConfirm(false);
            htmlDialog.setDeleteUrl("javascript:window.location.href='ExternalContactsOppComponents.do?command=DeleteComponent&contactId=" + contactId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId|sourcePopup") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteOpp(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-opportunities-delete")) {
            return "PermissionError";
        }
        String popup = context.getRequest().getParameter("sourcePopup");
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String contactId = context.getRequest().getParameter("contactId");
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasAuthority(context, newOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = newOpp.delete(db, context, this.getPath(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("contactId", (Object)contactId);
                this.deleteRecentItem(context, (Object)newOpp);
                if (popup != null && "true".equals(popup)) {
                    context.getRequest().setAttribute("id", (Object)("" + newOpp.getId()));
                    return "OppDeletePopupOK";
                }
                context.getRequest().setAttribute("refreshUrl", (Object)("ExternalContactsOpps.do?command=ViewOpps&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId")));
                return "OppDeleteOK";
            }
            this.processErrors(context, newOpp.getErrors());
            return this.executeCommandViewOpps(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteComponent(ActionContext context) {
        Exception errorMessage = null;
        String popup = context.getRequest().getParameter("sourcePopup");
        boolean recordDeleted = false;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
                String string = "PermissionError";
                return string;
            }
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            component = new OpportunityComponent(db, context.getRequest().getParameter("id"));
            header = new OpportunityHeader(db, component.getHeaderId());
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, header.getManager()) && !this.hasAuthority(context, component.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = component.delete(db, context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                this.deleteRecentItem(context, (Object)component);
                if (popup != null && "true".equals(popup)) {
                    context.getRequest().setAttribute("id", (Object)("" + component.getHeaderId()));
                    return "OppDeletePopupOK";
                }
                context.getRequest().setAttribute("refreshUrl", (Object)("ExternalContactsOpps.do?command=DetailsOpp&headerId=" + component.getHeaderId() + "&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId")));
                return "ComponentDeleteOK";
            }
            this.processErrors(context, component.getErrors());
            return this.executeCommandViewOpps(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyComponent(ActionContext context) {
        Exception errorMessage = null;
        Contact thisContact = null;
        Connection db = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        this.addModuleBean(context, "External Contacts", "Opportunities");
        String contactId = context.getRequest().getParameter("contactId");
        String componentId = context.getRequest().getParameter("id");
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            component = new OpportunityComponent(db, componentId);
            header = new OpportunityHeader(db, component.getHeaderId());
            context.getRequest().setAttribute("headerId", (Object)String.valueOf(component.getHeaderId()));
            thisContact = new Contact(db, contactId);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (!this.hasPermission(context, "contacts-external_contacts-opportunities-edit") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, header.getManager()) && !this.hasAuthority(context, component.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ComponentDetails", component);
            this.addRecentItem(context, (Object)component);
            return this.executeCommandPrepare(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistory(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-opportunities-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        int headerId = -1;
        int componentId = -1;
        this.addModuleBean(context, "View Contacts", "View Opportunity History List");
        componentId = context.getRequest().getParameter("id") != null ? Integer.parseInt(context.getRequest().getParameter("id")) : Integer.parseInt((String)context.getRequest().getAttribute("id"));
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        Contact thisContact = null;
        OpportunityComponent thisComponent = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentLogList componentLogList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("contactComponentHistoryListInfo");
        }
        PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "opportunityPagedInfo");
        PagedListInfo componentHistoryListInfo = this.getPagedListInfo(context, "contactComponentHistoryListInfo");
        componentHistoryListInfo.setLink("ExternalContactsOppComponents.do?command=ComponentHistory&contactId=" + contactId + "&id=" + componentId + RequestUtils.addLinkParams(context.getRequest(), "viewSource|popup"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("contactDetails", (Object)thisContact);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent();
            thisComponent.queryRecord(db, componentId);
            context.getRequest().setAttribute("opportunityComponent", (Object)thisComponent);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, thisComponent.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            componentLogList = new OpportunityComponentLogList();
            componentLogList.setPagedListInfo(componentHistoryListInfo);
            componentLogList.setHeaderId(thisHeader.getId());
            componentLogList.setComponentId(componentId);
            componentLogList.buildList(db);
            context.getRequest().setAttribute("componentHistoryList", (Object)componentLogList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsOpps.getReturn(context, "ComponentHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistoryDetails(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-opportunities-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Contacts", "View Opportunity History Details");
        String historyId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        OpportunityComponentLog thisComponentLog = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("contactDetails", (Object)thisContact);
            thisComponentLog = new OpportunityComponentLog(db, Integer.parseInt(historyId));
            context.getRequest().setAttribute("componentLogDetails", (Object)thisComponentLog);
            component = new OpportunityComponent(db, thisComponentLog.getComponentId());
            context.getRequest().setAttribute("opportunityComponent", (Object)component);
            header = new OpportunityHeader(db, component.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ExternalContactsOpps.getReturn(context, "ComponentHistoryDetails");
    }

    private boolean allowMultiple(ActionContext context) {
        String multiple = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "multiple");
        return OpportunityComponent.allowMultiple(multiple);
    }

    private boolean excludeHierarchy(ActionContext context) {
        String exclude = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "excludeHierarchy");
        return DatabaseUtils.parseBoolean(exclude);
    }
}

