/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webutils.FileDownload;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.GraphSummaryList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactImport;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactReport;
import org.aspcfs.modules.contacts.base.SalesEmail;
import org.aspcfs.modules.contacts.utils.QualifiedLeadsCount;
import org.aspcfs.modules.contacts.utils.QualifiedLeadsCounter;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.ContactUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.LeadUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;
import org.aspcfs.utils.web.StateSelect;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class Sales
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandDashboard(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDashboard(ActionContext context) {
        if (!this.hasPermission(context, "sales-dashboard-view")) {
            if (!this.hasPermission(context, "sales-view")) {
                return "PermissionError";
            }
            return this.executeCommandSearchForm(context);
        }
        int idToUse = 0;
        User thisRec = null;
        int userId = this.getUserId(context);
        this.addModuleBean(context, "Dashboard", "Dashboard");
        int overrideId = StringUtils.parseInt(context.getRequest().getParameter("oid"), -1);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            overrideId = -1;
            context.getSession().removeAttribute("salesoverride");
            context.getSession().removeAttribute("salesothername");
            context.getSession().removeAttribute("salespreviousId");
        }
        if (overrideId < 0) {
            overrideId = context.getSession().getAttribute("salesoverride") != null ? StringUtils.parseInt((String)context.getSession().getAttribute("salesoverride"), -1) : userId;
        }
        String myLeads = context.getRequest().getParameter("myLeads");
        String savedValue = (String)context.getSession().getAttribute("myLeads");
        if (!(myLeads == null || savedValue == null || "".equals(myLeads) || "".equals(savedValue) || savedValue.equals(myLeads))) {
            context.getSession().removeAttribute("myLeads");
            context.getSession().setAttribute("myLeads", (Object)myLeads);
        }
        if ((myLeads == null || "".equals(myLeads)) && savedValue != null && !"".equals(savedValue)) {
            myLeads = savedValue;
        }
        if ((savedValue == null || "".equals(savedValue)) && myLeads != null && !"".equals(myLeads)) {
            context.getSession().setAttribute("myLeads", (Object)myLeads);
        }
        String checkFileName = null;
        Connection db = null;
        UserList fullChildList = new UserList();
        UserList shortChildList = new UserList();
        ContactList realFullLeadList = new ContactList();
        String graphString = "lccr";
        Locale locale = this.getUser(context, this.getUserId(context)).getLocale();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            File checkFile;
            db = this.getConnection(context);
            idToUse = this.hasAuthority(context, overrideId) ? overrideId : this.getUserId(context);
            thisRec = this.getUser(context, idToUse);
            shortChildList = thisRec.getShortChildList();
            shortChildList = UserList.sortEnabledUsers(shortChildList, new UserList());
            if (context.getRequest().getParameter("oid") != null && !"true".equals(context.getRequest().getParameter("reset"))) {
                context.getRequest().setAttribute("override", (Object)String.valueOf(idToUse));
                context.getRequest().setAttribute("othername", (Object)thisRec.getContact().getNameFull());
                context.getRequest().setAttribute("previousId", (Object)String.valueOf(thisRec.getManagerId()));
                context.getSession().setAttribute("salesoverride", (Object)String.valueOf(overrideId));
                context.getSession().setAttribute("salesothername", (Object)thisRec.getContact().getNameFull());
                context.getSession().setAttribute("salespreviousId", (Object)String.valueOf(thisRec.getManagerId()));
            }
            if (thisRec.getIsValidLead() && graphString.equals("lccr")) {
                checkFileName = thisRec.getLccr().getLastFileName();
            }
            if (checkFileName != null && !(checkFile = new File(context.getServletContext().getRealPath("/") + "graphs" + fs + checkFileName + ".jpg")).exists()) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Sales-> Invalidating data, file not found: " + context.getServletContext().getRealPath("/") + "graphs" + fs + checkFileName + ".jpg");
                }
                thisRec.setIsValidLead(false, true);
                checkFileName = null;
            }
            PagedListInfo dashboardListInfo = this.getPagedListInfo(context, "SalesDashboardListInfo");
            dashboardListInfo.setLink("Sales.do?command=Dashboard");
            dashboardListInfo.setColumnToSortBy("c.entered DESC");
            ContactList leads = new ContactList();
            leads.setPagedListInfo(dashboardListInfo);
            dashboardListInfo.setSearchCriteria(leads, context);
            leads.setExcludeUnapprovedContacts(true);
            leads.setOldestFirst(0);
            leads.setSiteId(thisRec.getSiteId());
            leads.setExclusiveToSite(true);
            leads.setBuildDetails(false);
            leads.setBuildTypes(false);
            if (thisRec.getSiteId() == -1) {
                leads.setIncludeAllSites(true);
            }
            if (myLeads != null && "true".equals(myLeads)) {
                leads.setOwnerOrReader(true);
                leads.setLeadsOnly(1);
                leads.setZipCodeAscPotentialDesc(true);
                leads.setReadBy(idToUse);
                leads.setOwner(idToUse);
                context.getRequest().setAttribute("myLeads", (Object)"false");
            } else {
                leads.setZipCodeAscPotentialDesc(true);
                leads.setLeadStatusExists(1);
                context.getRequest().setAttribute("myLeads", (Object)"true");
            }
            leads.setBuildTypes(false);
            leads.setBuildDetails(false);
            leads.buildShortList(db);
            context.getRequest().setAttribute("contactList", (Object)leads);
            if (checkFileName == null) {
                fullChildList = thisRec.getFullChildList(shortChildList, new UserList());
                fullChildList = UserList.sortEnabledUsers(fullChildList, new UserList());
                String range = fullChildList.getUserListIds(idToUse);
                realFullLeadList.setOwnerIdRange(range);
                realFullLeadList.setLeadsOnly(0);
                realFullLeadList.setEmployeesOnly(0);
                realFullLeadList.setHasConversionDate(1);
                realFullLeadList.setSiteId(thisRec.getSiteId());
                realFullLeadList.setExclusiveToSite(true);
                realFullLeadList.setBuildDetails(false);
                realFullLeadList.setBuildTypes(false);
                if (thisRec.getSiteId() == -1) {
                    realFullLeadList.setIncludeAllSites(true);
                }
                realFullLeadList.setBuildTypes(false);
                realFullLeadList.setBuildDetails(false);
                realFullLeadList.buildList(db);
            }
            LookupList sources = new LookupList(db, "lookup_contact_source");
            sources.addItem(-1, systemStatus.getLabel("pipeline.any"));
            context.getRequest().setAttribute("SourceList", (Object)sources);
            LookupList ratings = new LookupList(db, "lookup_contact_rating");
            ratings.addItem(-1, systemStatus.getLabel("pipeline.any"));
            context.getRequest().setAttribute("RatingList", (Object)ratings);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String leads = "SystemError";
            return leads;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            if (checkFileName != null) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Sales-> Using cached chart");
                }
                context.getRequest().setAttribute("GraphFileName", (Object)checkFileName);
            } else {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Sales-> Preparing the chart");
                }
                ContactList tempLeadList = new ContactList();
                for (Contact tempLead : realFullLeadList) {
                    if (tempLead.getOwner() != idToUse) continue;
                    tempLeadList.add(tempLead);
                }
                QualifiedLeadsCounter gqlc = QualifiedLeadsCounter.getQualifiedLeadsCounter(db);
                UserList tempUserList = new UserList();
                for (User thisRecord : fullChildList) {
                    if (thisRec.getId() != thisRecord.getManagerId()) continue;
                    tempUserList = this.prepareLines(thisRecord, tempUserList, gqlc);
                }
                UserList linesToDraw = new UserList();
                linesToDraw = this.calculateLine(tempUserList, linesToDraw);
                tempUserList = this.prepareLines(thisRec, tempUserList, gqlc);
                linesToDraw = this.calculateLine(thisRec, linesToDraw);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Sales-> Drawing the chart");
                }
                XYSeriesCollection categoryData = this.createCategoryDataset(linesToDraw, graphString);
                JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)categoryData, (boolean)false, (boolean)true, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
                XYPlot plot = chart.getXYPlot();
                ValueAxis yAxis = plot.getRangeAxis();
                yAxis.setTickMarksVisible(true);
                yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)locale));
                DateAxis axis = (DateAxis)plot.getDomainAxis();
                axis.setDateFormatOverride((DateFormat)sdf);
                XYItemRenderer renderer = plot.getRenderer();
                if (renderer instanceof StandardXYItemRenderer) {
                    StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
                    rr.setPlotShapes(true);
                    rr.setShapesFilled(false);
                    rr.setItemLabelsVisible(true);
                    StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("{2} ({1})", (DateFormat)sdf, NumberFormat.getInstance(locale));
                    rr.setToolTipGenerator((XYToolTipGenerator)ttg);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Sales-> Drawing the chart");
                }
                int width = 275;
                int height = 200;
                String filePath = context.getServletContext().getRealPath("/") + "graphs" + fs;
                File graphDirectory = new File(filePath);
                if (!graphDirectory.exists()) {
                    graphDirectory.mkdirs();
                }
                java.util.Date testDate = new java.util.Date();
                String fileName = "leads" + String.valueOf(testDate.getTime()) + String.valueOf(context.getSession().getCreationTime());
                ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                File imageFile = new File(filePath + fileName + ".jpg");
                ChartUtilities.saveChartAsJPEG((File)imageFile, (float)1.0f, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
                PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new FileWriter(filePath + fileName + ".map")), true);
                ChartUtilities.writeImageMap((PrintWriter)pw, (String)fileName, (ChartRenderingInfo)info, (boolean)false);
                if (graphString.equals("lccr")) {
                    thisRec.getLccr().setLastFileName(fileName);
                }
                context.getRequest().setAttribute("GraphFileName", (Object)fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            System.out.println("Sales-> GraphicsError exception occurred here");
            return "GraphicsError";
        }
        context.getRequest().setAttribute("ShortChildList", (Object)shortChildList);
        return "DashboardOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "sales-view")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            PagedListInfo salesListInfo = this.getPagedListInfo(context, "SalesListInfo");
            salesListInfo.setCurrentLetter("");
            salesListInfo.setCurrentOffset(0);
            LookupList sources = new LookupList(db, "lookup_contact_source");
            if (sources.size() > 0) {
                sources.addItem(-1, systemStatus.getLabel("pipeline.any"));
            }
            context.getRequest().setAttribute("SourceList", (Object)sources);
            LookupList ratings = new LookupList(db, "lookup_contact_rating");
            if (ratings.size() > 0) {
                ratings.addItem(-1, systemStatus.getLabel("pipeline.any"));
            }
            context.getRequest().setAttribute("RatingList", (Object)ratings);
            CountrySelect countrySelect = new CountrySelect(systemStatus.getLabel("pipeline.any"));
            context.getRequest().setAttribute("countrySelect", (Object)countrySelect);
            context.getRequest().setAttribute("listForm", (Object)"true");
            LookupList siteList = new LookupList(db, "lookup_site_id");
            if (siteList.size() > 0) {
                siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
                siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            }
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        String addAnother = (String)context.getRequest().getAttribute("addAnother");
        thisContact = addAnother == null || "".equals(addAnother.trim()) ? (Contact)((Object)context.getFormBean()) : new Contact();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
            User thisRec = thisUser.getUserRecord();
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList.setMyId(this.getUserId(context));
            userList.setMyValue(thisUser.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            LookupList industryList = new LookupList(db, "lookup_industry");
            industryList.addItem(-1, systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
            context.getRequest().setAttribute("IndustryList", (Object)industryList);
            context.getRequest().setAttribute("UserList", (Object)userList);
            if (thisContact != null) {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-add")) {
            return "PermissionError";
        }
        Connection db = null;
        String reset = context.getRequest().getParameter("reset");
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null || "".equals(contactId.trim())) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        Contact thisContact = (Contact)((Object)context.getFormBean());
        String addAnother = (String)context.getRequest().getAttribute("addAnother");
        thisContact = (Contact)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (reset == null || !"true".equals(reset)) {
                thisContact = new Contact();
                thisContact.setBuildDetails(true);
                thisContact.queryRecord(db, Integer.parseInt(contactId));
            }
            UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
            User thisRec = thisUser.getUserRecord();
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList.setMyId(this.getUserId(context));
            userList.setMyValue(thisUser.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            LookupList industryList = new LookupList(db, "lookup_industry");
            industryList.addItem(-1, systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
            context.getRequest().setAttribute("IndustryList", (Object)industryList);
            context.getRequest().setAttribute("UserList", (Object)userList);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        int resultCount;
        boolean recordInserted;
        block22: {
            if (!this.hasPermission(context, "sales-leads-add")) {
                return "PermissionError";
            }
            recordInserted = false;
            resultCount = -1;
            boolean isValid = false;
            Contact oldContact = null;
            Contact thisContact = (Contact)((Object)context.getFormBean());
            thisContact.setRequestItems(context);
            if (thisContact.getId() == -1) {
                thisContact.setEnteredBy(this.getUserId(context));
            }
            thisContact.setModifiedBy(this.getUserId(context));
            thisContact.setIsLead(true);
            thisContact.setLeadStatus(1);
            Connection db = null;
            try {
                db = this.getConnection(context);
                AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
                thisContact.setAccessType(accessTypeList.getCode(626030334));
                isValid = this.validateObject(context, db, (Object)thisContact);
                if (isValid) {
                    if (thisContact.getId() > 0) {
                        oldContact = new Contact(db, thisContact.getId());
                        resultCount = thisContact.update(db);
                        if (resultCount > 0) {
                            this.processUpdateHook(context, (Object)oldContact, (Object)thisContact);
                        }
                    } else {
                        recordInserted = thisContact.insert(db);
                        if (recordInserted) {
                            this.processInsertHook(context, (Object)thisContact);
                        }
                    }
                }
                if (isValid && (recordInserted || resultCount != -1)) {
                    thisContact = new Contact(db, thisContact.getId());
                    context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                    context.getRequest().setAttribute("contactId", (Object)("" + thisContact.getId()));
                    if (resultCount != -1) {
                        ActionPlanWork actionPlanWork = ActionPlanWork.getActionPlanWork(db, ActionPlan.getMapIdGivenConstantId(db, 2), thisContact.getId());
                        if (oldContact.getSiteId() != thisContact.getSiteId() && actionPlanWork != null && actionPlanWork.getId() > 0) {
                            actionPlanWork.setManagerId(this.getUserId(context));
                            actionPlanWork.update(db);
                        }
                        context.getRequest().setAttribute("actionPlanWork", (Object)actionPlanWork);
                    }
                    break block22;
                }
                if (thisContact.getId() > -1) {
                    String string = this.executeCommandModify(context);
                    return string;
                }
                String string = this.executeCommandAdd(context);
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                e.printStackTrace();
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        this.addModuleBean(context, "Leads", "Add a Lead");
        if (recordInserted) {
            if ("true".equals(context.getRequest().getParameter("saveAndNew"))) {
                context.getRequest().removeAttribute("ContactDetails");
                context.getRequest().setAttribute("addAnother", (Object)"true");
                return this.executeCommandAdd(context);
            }
            if ("true".equals(context.getRequest().getParameter("saveAndClone"))) {
                return "SaveOK";
            }
        } else if (resultCount != -1) {
            return "SaveOK";
        }
        return this.executeCommandDashboard(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-view")) {
            return "PermissionError";
        }
        String nextValue = (String)context.getRequest().getAttribute("nextValue");
        if (nextValue == null || "".equals(nextValue)) {
            nextValue = context.getRequest().getParameter("nextValue");
        }
        context.getRequest().setAttribute("nextValue", (Object)nextValue);
        String from = context.getRequest().getParameter("from");
        context.getRequest().setAttribute("from", (Object)from);
        String listForm = context.getRequest().getParameter("listForm");
        if (listForm != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        boolean isValid = false;
        boolean fetchedList = false;
        User user = this.getUser(context, this.getUserId(context));
        ContactList contacts = new ContactList();
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SalesListInfo");
        searchListInfo.setLink("Sales.do?command=List&listForm=" + (listForm != null ? listForm : ""));
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            StateSelect stateSelect;
            db = this.getConnection(context);
            if (searchListInfo.getSearchOptionValue("searchcodeCountry") != null) {
                stateSelect = new StateSelect(systemStatus, searchListInfo.getSearchOptionValue("searchcodeCountry"));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(searchListInfo.getSearchOptionValue("searchcodeOtherState"), searchListInfo.getSearchOptionValue("searchcodeOtherState"));
                stateSelect.setPreviousStates(map);
                context.getRequest().setAttribute("stateSelect", (Object)stateSelect);
            } else {
                stateSelect = new StateSelect(systemStatus);
                context.getRequest().setAttribute("stateSelect", (Object)stateSelect);
            }
            LookupList sources = systemStatus.getLookupList(db, "lookup_contact_source");
            sources.addItem(-1, systemStatus.getLabel("quotes.all"));
            context.getRequest().setAttribute("sourceList", (Object)sources);
            LookupList ratings = systemStatus.getLookupList(db, "lookup_contact_rating");
            ratings.addItem(-1, systemStatus.getLabel("quotes.all"));
            context.getRequest().setAttribute("ratingList", (Object)ratings);
            LookupList segments = systemStatus.getLookupList(db, "lookup_industry");
            segments.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("segmentList", (Object)segments);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            contacts.setPagedListInfo(searchListInfo);
            searchListInfo.setIsValid(true);
            searchListInfo.setSearchCriteria(contacts, context);
            if (contacts.getSiteId() == -2) {
                contacts.setSiteId(user.getSiteId());
                contacts.setIncludeAllSites(true);
            }
            if (contacts.getOwner() == -1) {
                contacts.setControlledHierarchyOnly(true, this.getUserRange(context));
            }
            if (contacts.getLeadStatus() == 4) {
                contacts.setLeadsOnly(0);
                contacts.setLeadStatus(-1);
                contacts.setHasConversionDate(1);
            } else if (contacts.getLeadStatus() == 0) {
                contacts.setLeadsOnly(1);
            } else if (contacts.getLeadStatus() == 2) {
                contacts.setLeadsOnly(1);
            } else if (contacts.getLeadStatus() == -1) {
                contacts.setLeadStatus(-1);
                contacts.setLeadsOnly(-1);
            }
            contacts.setLeadStatusExists(1);
            contacts.setBuildDetails(false);
            contacts.setBuildTypes(false);
            isValid = searchListInfo.getIsValid();
            if (isValid) {
                fetchedList = contacts.buildList(db);
            }
            context.getRequest().setAttribute("contacts", (Object)contacts);
            CountrySelect countrySelect = new CountrySelect(systemStatus);
            context.getRequest().setAttribute("countrySelect", (Object)countrySelect);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            if (!fetchedList) {
                this.processErrors(context, contacts.getErrors());
                String string = this.executeCommandSearchForm(context);
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Search Results");
        if (nextValue != null && !"".equals(nextValue) && contacts.size() > 0) {
            return this.executeCommandDetails(context);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        String listForm;
        if (!this.hasPermission(context, "sales-leads-view")) {
            return "PermissionError";
        }
        User user = this.getUser(context, this.getUserId(context));
        String from = context.getRequest().getParameter("from");
        context.getRequest().setAttribute("from", (Object)from);
        int readStatus = -1;
        String nextValue = (String)context.getRequest().getAttribute("nextValue");
        if (nextValue == null || "".equals(nextValue)) {
            nextValue = context.getRequest().getParameter("nextValue");
        }
        if ((listForm = context.getRequest().getParameter("listForm")) != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        String readStatusString = (String)context.getRequest().getAttribute("readStatus");
        String contactId = (String)context.getRequest().getAttribute("contactId");
        if (contactId == null || "".equals(contactId)) {
            contactId = context.getRequest().getParameter("contactId");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        ContactList contacts = new ContactList();
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SalesListInfo", false);
        Contact contact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (nextValue != null && !"".equals(nextValue.trim())) {
                contacts.setPagedListInfo(searchListInfo);
                searchListInfo.setSearchCriteria(contacts, context);
                if (contacts.getSiteId() == -2) {
                    contacts.setSiteId(user.getSiteId());
                    if (user.getSiteId() == -1) {
                        contacts.setIncludeAllSites(true);
                    } else {
                        contacts.setExclusiveToSite(true);
                    }
                }
                if (contacts.getLeadStatus() == 4) {
                    contacts.setLeadsOnly(0);
                    contacts.setLeadStatus(-1);
                    contacts.setHasConversionDate(1);
                } else if (contacts.getLeadStatus() == 0) {
                    contacts.setLeadsOnly(1);
                } else if (contacts.getLeadStatus() == -1) {
                    contacts.setLeadStatus(-1);
                    contacts.setLeadsOnly(-1);
                }
                contactId = "" + LeadUtils.getNextLead(db, Integer.parseInt(contactId), contacts, contacts.getSiteId(), contacts.getSiteId() == -2);
            }
            LookupList sources = new LookupList(db, "lookup_contact_source");
            sources.addItem(-1, systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
            context.getRequest().setAttribute("SourceList", (Object)sources);
            LookupList ratings = new LookupList(db, "lookup_contact_rating");
            ratings.addItem(-1, systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
            context.getRequest().setAttribute("RatingList", (Object)ratings);
            LookupList industryList = new LookupList(db, "lookup_industry");
            industryList.addItem(-1, systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
            context.getRequest().setAttribute("IndustryList", (Object)industryList);
            if (readStatusString == null || "".equals(readStatusString.trim())) {
                if (this.hasPermission(context, "sales-leads-edit")) {
                    readStatus = LeadUtils.setReadStatus(db, Integer.parseInt(contactId), this.getUserId(context));
                }
            } else {
                try {
                    readStatus = Integer.parseInt(readStatusString);
                }
                catch (Exception error1) {
                    // empty catch block
                }
            }
            context.getRequest().setAttribute("readStatus", (Object)("" + readStatus));
            if (contactId != null && !"".equals(contactId) && Integer.parseInt(contactId) != -1) {
                contact = new Contact(db, contactId);
                if (!Sales.isRecordAccessPermitted(context, (Object)contact)) {
                    String error1 = "PermissionError";
                    return error1;
                }
            } else {
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("actionError", systemStatus.getLabel("object.validation.leadsSearchActionError"));
                this.processErrors(context, errors);
                String actionPlanSelect = this.executeCommandSearchForm(context);
                return actionPlanSelect;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)contact);
            ActionPlanList actionPlanList = new ActionPlanList();
            actionPlanList.setIncludeOnlyApproved(1);
            actionPlanList.setEnabled(1);
            actionPlanList.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            actionPlanList.setSiteId(contact.getSiteId());
            actionPlanList.buildList(db);
            HtmlSelect actionPlanSelect = actionPlanList.getHtmlSelectObj();
            actionPlanSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "-- None --"));
            context.getRequest().setAttribute("actionPlanSelect", (Object)actionPlanSelect);
            ActionPlanWork actionPlanWork = ActionPlanWork.getActionPlanWork(db, ActionPlan.getMapIdGivenConstantId(db, 2), contact.getId());
            context.getRequest().setAttribute("actionPlanWork", (Object)actionPlanWork);
            if (contact.getImportId() != -1) {
                ContactImport thisImport = new ContactImport(db, contact.getImportId());
                context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            }
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            boolean hasGcPermission = this.hasPermission(context, "contacts-external_contacts-view");
            boolean hasAcPermission = this.hasPermission(context, "accounts-accounts-contacts-view");
            boolean hasAccountPermission = this.hasPermission(context, "accounts-accounts-view");
            if (hasGcPermission || hasAcPermission) {
                context.getRequest().setAttribute("hasDuplicateLastName", (Object)("" + ContactUtils.hasDuplicateLastName(db, contact.getNameLast(), user.getIdRange(), hasGcPermission, hasAcPermission)));
                if (contact.getEmailAddressList().size() > 0) {
                    context.getRequest().setAttribute("hasDuplicateEmailAddress", (Object)ContactUtils.hasDuplicateEmailAddresses(db, contact.getEmailAddressList().getConcatenatedList(), user.getIdRange(), hasGcPermission, hasAcPermission));
                }
            }
            if ((hasGcPermission || hasAccountPermission) && contact.getCompany() != null && !"".equals(contact.getCompany().trim())) {
                context.getRequest().setAttribute("hasDuplicateCompany", (Object)ContactUtils.hasDuplicateCompany(db, contact.getCompany(), user.getIdRange(), hasGcPermission, hasAccountPermission));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAssignLead(ActionContext context) {
        String listForm;
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        int readStatus = -1;
        SystemStatus systemStatus = this.getSystemStatus(context);
        String from = context.getRequest().getParameter("from");
        context.getRequest().setAttribute("from", (Object)from);
        String type = context.getRequest().getParameter("type");
        String nextValue = (String)context.getRequest().getAttribute("nextValue");
        if (nextValue == null || "".equals(nextValue)) {
            nextValue = context.getRequest().getParameter("nextValue");
        }
        if ((listForm = context.getRequest().getParameter("listForm")) != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        String readStatusString = (String)context.getRequest().getAttribute("readStatus");
        String contactId = (String)context.getRequest().getAttribute("contactId");
        if (contactId == null || "".equals(contactId)) {
            contactId = context.getRequest().getParameter("contactId");
        }
        ContactList contacts = new ContactList();
        Contact contact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (nextValue != null && !"".equals(nextValue.trim())) {
                contactId = "" + LeadUtils.getNextLead(db, Integer.parseInt(contactId), contacts, this.getUserSiteId(context), true);
            }
            LookupList ratings = new LookupList(db, "lookup_contact_rating");
            ratings.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ratingList", (Object)ratings);
            LookupList sources = new LookupList(db, "lookup_contact_source");
            sources.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SourceList", (Object)sources);
            LookupList sites = new LookupList(db, "lookup_site_id");
            sites.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)sites);
            if (readStatusString == null || "".equals(readStatusString.trim())) {
                if (this.hasPermission(context, "sales-leads-edit")) {
                    readStatus = LeadUtils.setReadStatus(db, Integer.parseInt(contactId), this.getUserId(context));
                }
            } else {
                try {
                    readStatus = Integer.parseInt(readStatusString);
                }
                catch (Exception error1) {
                    // empty catch block
                }
            }
            context.getRequest().setAttribute("readStatus", (Object)("" + readStatus));
            if (contactId != null && !"".equals(contactId) && Integer.parseInt(contactId) != -1) {
                contact = new Contact(db, contactId);
                context.getRequest().setAttribute("contactDetails", (Object)contact);
                ActionPlanList actionPlanList = new ActionPlanList();
                actionPlanList.setIncludeOnlyApproved(1);
                actionPlanList.setEnabled(1);
                actionPlanList.setSiteId(contact.getSiteId());
                actionPlanList.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
                actionPlanList.buildList(db);
                HtmlSelect actionPlanSelect = new HtmlSelect();
                actionPlanSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "-- None --"));
                actionPlanSelect.addItems(actionPlanList.getHtmlSelectObj());
                context.getRequest().setAttribute("actionPlanSelect", (Object)actionPlanSelect);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        if (type != null && "assignLead".equals(type)) {
            return "ReassignLeadOK";
        }
        return "AssignLeadOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCheckAssignStatus(ActionContext context) {
        String nextValue;
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        String from = (String)context.getRequest().getAttribute("from");
        if (from == null || "".equals(from)) {
            from = context.getRequest().getParameter("from");
        }
        if ((nextValue = (String)context.getRequest().getAttribute("nextValue")) == null || "".equals(nextValue)) {
            nextValue = context.getRequest().getParameter("nextValue");
        }
        context.getRequest().setAttribute("from", (Object)from);
        String listForm = context.getRequest().getParameter("listForm");
        if (listForm != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        String contactId = context.getRequest().getParameter("contactId");
        context.getRequest().setAttribute("contactId", (Object)contactId);
        String next = context.getRequest().getParameter("next");
        String owner = context.getRequest().getParameter("owner");
        context.getRequest().setAttribute("next", (Object)next);
        if (next == null || contactId == null) {
            return "PermissionError";
        }
        boolean assignStatus = false;
        boolean skippedStatus = false;
        int userId = this.getUserId(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!"skip".equals(next)) {
                assignStatus = owner != null && !"".equals(owner) ? LeadUtils.tryToAssignLead(db, Integer.parseInt(contactId), userId, Integer.parseInt(owner)) : LeadUtils.tryToAssignLead(db, Integer.parseInt(contactId), userId);
                if (assignStatus) {
                    context.getRequest().setAttribute("assignStatus", (Object)"assigned");
                } else {
                    context.getRequest().setAttribute("assignStatus", (Object)"notAssigned");
                }
            } else {
                skippedStatus = LeadUtils.skipLead(db, Integer.parseInt(contactId), userId);
                context.getRequest().setAttribute("assignStatus", (Object)"skipped");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "CheckAssignStatusOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandWorkLead(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        this.addModuleBean(context, "Add Contact", "Add Contact to Account");
        String contactId = context.getRequest().getParameter("id");
        String rating = context.getRequest().getParameter("rating");
        String comments = context.getRequest().getParameter("comments");
        try {
            db = this.getConnection(context);
            Contact contact = new Contact(db, contactId);
            Contact oldContact = new Contact(db, contactId);
            if (contact.getOwner() == -1) {
                contact.setOwner(this.getUserId(context));
            }
            if (contact.getLeadStatus() != 2) {
                contact.setLeadStatus(2);
            }
            contact.setIsLead(false);
            contact.setConversionDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            if (rating != null && !"".equals(rating)) {
                contact.setRating(Integer.parseInt(rating));
            }
            if (comments != null && !"".equals(comments.trim())) {
                contact.setComments(comments);
            }
            contact.update(db, context);
            this.processUpdateHook(context, (Object)oldContact, (Object)contact);
            int size = LeadUtils.cleanUpContact(db, contact.getId(), this.getUserId(context));
            this.sendEmail(context, db, contact, contact.getOwner(), null);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "WorkLeadOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandWorkAccount(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        this.addModuleBean(context, "Add Account", "Add Account");
        String contactId = context.getRequest().getParameter("id");
        String rating = context.getRequest().getParameter("rating");
        String comments = context.getRequest().getParameter("comments");
        int orgId = -1;
        User assigned = null;
        User manager = null;
        ActionPlanWork actionPlanWork = new ActionPlanWork();
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            boolean status = false;
            int resultCount = -1;
            Contact contact = new Contact(db, contactId);
            Contact oldContact = new Contact(db, contactId);
            if (contact.getOwner() == -1) {
                contact.setOwner(this.getUserId(context));
            }
            if (contact.getLeadStatus() != 2) {
                contact.setLeadStatus(2);
            }
            if ((orgId = contact.getCompany() != null && !"".equals(contact.getCompany().trim()) ? Organization.lookupAccount(db, contact.getCompany(), -1, contact.getSiteId()) : Organization.lookupAccount(db, contact.getNameFirst(), contact.getNameMiddle(), contact.getNameLast(), -1, contact.getSiteId())) > 0) {
                thisOrg = new Organization(db, orgId);
            }
            if (orgId < 0) {
                thisOrg = new Organization();
                thisOrg.setEnteredBy(this.getUserId(context));
                if (contact.getCompany() == null || "".equals(contact.getCompany().trim())) {
                    contact.setPrimaryContact(true);
                    thisOrg.setNameFirst(contact.getNameFirst());
                    thisOrg.setNameLast(contact.getNameLast());
                    thisOrg.setNameMiddle(contact.getNameMiddle());
                    thisOrg.setName(thisOrg.getNameLastFirstMiddle());
                    thisOrg.setInsertPrimaryContact(false);
                } else {
                    thisOrg.setName(contact.getCompany());
                }
            }
            thisOrg.setSiteId(contact.getSiteId());
            thisOrg.setModifiedBy(this.getUserId(context));
            if (thisOrg.getId() > 0 && thisOrg.getAccountNumber() != null && contact.getAccountNumber() != null && !contact.getAccountNumber().equals(thisOrg.getAccountNumber()) || thisOrg.getOrgId() == -1) {
                thisOrg.setAccountNumber(contact.getAccountNumber());
            }
            if (thisOrg.getId() > 0 && contact.getOwner() != thisOrg.getOwner() || thisOrg.getOrgId() == -1) {
                thisOrg.setOwner(contact.getOwner());
            }
            if (thisOrg.getId() > 0 && contact.getPotential() != thisOrg.getPotential() || thisOrg.getOrgId() == -1) {
                thisOrg.setPotential(contact.getPotential());
            }
            if (thisOrg.getId() > 0 && contact.getIndustryTempCode() != thisOrg.getIndustry() || thisOrg.getOrgId() == -1) {
                thisOrg.setIndustry(contact.getIndustryTempCode());
            }
            if (thisOrg.getId() > 0 && contact.getSource() != thisOrg.getSource() || thisOrg.getOrgId() == -1) {
                thisOrg.setSource(contact.getSource());
            }
            if (thisOrg.getId() > 0 && contact.getRating() != thisOrg.getRating() || thisOrg.getOrgId() == -1) {
                thisOrg.setRating(contact.getRating());
            }
            Sales.copyPropertiesFromContactToOrganization(contact, thisOrg);
            ContactAddressList contactAddressList = new ContactAddressList();
            contactAddressList.setContactId(contact.getId());
            contactAddressList.buildList(db);
            for (ContactAddress contactAddress : contactAddressList) {
                OrganizationAddress organizationAddress = new OrganizationAddress();
                organizationAddress.setStreetAddressLine1(contactAddress.getStreetAddressLine1());
                organizationAddress.setStreetAddressLine2(contactAddress.getStreetAddressLine2());
                organizationAddress.setStreetAddressLine3(contactAddress.getStreetAddressLine3());
                organizationAddress.setCity(contactAddress.getCity());
                organizationAddress.setState(contactAddress.getState());
                organizationAddress.setZip(contactAddress.getZip());
                organizationAddress.setCountry(contactAddress.getCountry());
                LookupList contactAddressTypeList = new LookupList(db, "lookup_contactaddress_types");
                LookupList orgAddressTypeList = null;
                String contactAddressType = contactAddressTypeList.getValueFromId(contactAddress.getType());
                int orgAddressType = -1;
                if (contactAddress.getType() != -1) {
                    if (contactAddressType.indexOf("Business") > -1) {
                        orgAddressTypeList = new LookupList(db, "lookup_orgaddress_types");
                        orgAddressType = orgAddressTypeList.getIdFromValue("Primary");
                    } else {
                        orgAddressTypeList = new LookupList(db, "lookup_orgaddress_types");
                        orgAddressType = orgAddressTypeList.getIdFromValue("Auxiliary");
                    }
                    organizationAddress.setType(orgAddressType);
                }
                organizationAddress.setPrimaryAddress(contactAddress.getPrimaryAddress());
                thisOrg.getAddressList().add(organizationAddress);
            }
            ContactEmailAddressList contactEmailAddressList = new ContactEmailAddressList();
            contactEmailAddressList.setContactId(contact.getId());
            contactEmailAddressList.buildList(db);
            for (ContactEmailAddress contactEmailAddress : contactEmailAddressList) {
                OrganizationEmailAddress organizationEmailAddress = new OrganizationEmailAddress();
                organizationEmailAddress.setEmail(contactEmailAddress.getEmail());
                LookupList contactEmailAddressTypeList = new LookupList(db, "lookup_contactemail_types");
                LookupList orgEmailAddressTypeList = null;
                String contactEmailAddressType = contactEmailAddressTypeList.getValueFromId(contactEmailAddress.getType());
                int orgEmailAddressType = -1;
                if (contactEmailAddressType.indexOf("Business") > -1) {
                    orgEmailAddressTypeList = new LookupList(db, "lookup_orgemail_types");
                    orgEmailAddressType = orgEmailAddressTypeList.getIdFromValue("Primary");
                } else {
                    orgEmailAddressTypeList = new LookupList(db, "lookup_orgemail_types");
                    orgEmailAddressType = orgEmailAddressTypeList.getIdFromValue("Auxiliary");
                }
                organizationEmailAddress.setType(orgEmailAddressType);
                organizationEmailAddress.setPrimaryEmail(contactEmailAddress.getPrimaryEmail());
                thisOrg.getEmailAddressList().add(organizationEmailAddress);
            }
            ContactPhoneNumberList contactPhoneNumberList = new ContactPhoneNumberList();
            contactPhoneNumberList.setContactId(contact.getId());
            contactPhoneNumberList.buildList(db);
            for (ContactPhoneNumber contactPhoneNumber : contactPhoneNumberList) {
                OrganizationPhoneNumber organizationPhoneNumber = new OrganizationPhoneNumber();
                organizationPhoneNumber.setNumber(contactPhoneNumber.getNumber());
                organizationPhoneNumber.setExtension(contactPhoneNumber.getExtension());
                LookupList contactPhoneNumberTypeList = new LookupList(db, "lookup_contactphone_types");
                LookupList orgPhoneNumberTypeList = null;
                String contactPhoneNumberType = contactPhoneNumberTypeList.getValueFromId(contactPhoneNumber.getType());
                int orgPhoneNumberType = -1;
                if (contactPhoneNumberType.indexOf("Fax") > -1) {
                    orgPhoneNumberTypeList = new LookupList(db, "lookup_orgphone_types");
                    orgPhoneNumberType = orgPhoneNumberTypeList.getIdFromValue("Fax");
                } else {
                    orgPhoneNumberTypeList = new LookupList(db, "lookup_orgphone_types");
                    orgPhoneNumberType = orgPhoneNumberTypeList.getIdFromValue("Main");
                }
                organizationPhoneNumber.setType(orgPhoneNumberType);
                organizationPhoneNumber.setPrimaryNumber(contactPhoneNumber.getPrimaryNumber());
                thisOrg.getPhoneNumberList().add(organizationPhoneNumber);
            }
            status = thisOrg.getOrgId() > 0 ? thisOrg.update(db) == 1 : thisOrg.insert(db);
            if (status) {
                this.addRecentItem(context, (Object)thisOrg);
                context.getRequest().setAttribute("orgId", (Object)String.valueOf(thisOrg.getOrgId()));
            }
            contact.setOrgId(thisOrg.getOrgId());
            contact.setOrgName(thisOrg.getName());
            if (status) {
                contact.setIsLead(false);
                contact.setConversionDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                if (rating != null && !"".equals(rating)) {
                    contact.setRating(Integer.parseInt(rating));
                }
                contact.setComments(comments);
                resultCount = contact.update(db, context);
                if (contact.getNameLast() == null || "".equals(contact.getNameLast())) {
                    contact.disable(db);
                }
                this.processUpdateHook(context, (Object)oldContact, (Object)contact);
                int size = LeadUtils.cleanUpContact(db, contact.getId(), this.getUserId(context));
            }
            if (status && resultCount > 0) {
                String actionPlanId = context.getRequest().getParameter("actionPlan");
                String managerId = context.getRequest().getParameter("manager");
                String owner = context.getRequest().getParameter("owner");
                if (actionPlanId != null && !"".equals(actionPlanId.trim()) && !"-1".equals(actionPlanId)) {
                    ActionPlan actionPlan = new ActionPlan();
                    actionPlan.setBuildPhases(true);
                    actionPlan.setBuildSteps(true);
                    actionPlan.queryRecord(db, Integer.parseInt(actionPlanId));
                    actionPlanWork.setActionPlanId(actionPlanId);
                    actionPlanWork.setManagerId(managerId);
                    actionPlanWork.setAssignedTo(owner);
                    actionPlanWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
                    actionPlanWork.setLinkItemId(thisOrg.getOrgId());
                    actionPlanWork.setEnteredBy(this.getUserId(context));
                    actionPlanWork.setModifiedBy(this.getUserId(context));
                    actionPlanWork.insert(db, actionPlan);
                    this.processInsertHook(context, (Object)actionPlanWork);
                    assigned = this.getUser(context, actionPlanWork.getAssignedTo());
                    assigned.setBuildContact(true);
                    assigned.setBuildContactDetails(true);
                    assigned.buildResources(db);
                    manager = this.getUser(context, actionPlanWork.getManagerId());
                    manager.setBuildContact(true);
                    manager.setBuildContactDetails(true);
                    manager.buildResources(db);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (actionPlanWork.getId() > -1) {
            try {
                String templateFile = Sales.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
                if (!FileUtils.fileExists(templateFile)) {
                    templateFile = Sales.getDbNamePath(context) + "templates_en_US.xml";
                }
                actionPlanWork.sendEmail(context, assigned.getContact(), manager.getContact(), thisOrg.getName(), templateFile);
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                return "SystemError";
            }
        }
        this.addModuleBean(context, "Leads", "Leads");
        return Sales.getReturn(context, "WorkAccount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        String nextValue;
        if (!this.hasPermission(context, "sales-leads-edit")) {
            return "PermissionError";
        }
        int resultCount = 0;
        boolean isValid = false;
        String from = (String)context.getRequest().getAttribute("from");
        if (from == null || "".equals(from)) {
            from = context.getRequest().getParameter("from");
        }
        context.getRequest().setAttribute("from", (Object)from);
        String listForm = context.getRequest().getParameter("listForm");
        if (listForm != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        if ((nextValue = (String)context.getRequest().getAttribute("nextValue")) == null || "".equals(nextValue)) {
            nextValue = context.getRequest().getParameter("nextValue");
        }
        context.getRequest().setAttribute("nextValue", (Object)(nextValue != null ? nextValue : ""));
        String contactId = context.getRequest().getParameter("contactId");
        String owner = context.getRequest().getParameter("owner");
        String leadStatus = context.getRequest().getParameter("leadStatus");
        String comments = context.getRequest().getParameter("comments");
        String rating = context.getRequest().getParameter("rating");
        Contact thisContact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!Sales.isRecordAccessPermitted(context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            Contact oldContact = new Contact(db, contactId);
            thisContact.setModifiedBy(this.getUserId(context));
            thisContact.setIsLead(true);
            if (owner != null && !"".equals(owner)) {
                thisContact.setOwner(Integer.parseInt(owner));
            }
            if (leadStatus != null && !"".equals(leadStatus)) {
                thisContact.setLeadStatus(Integer.parseInt(leadStatus));
                if (Integer.parseInt(leadStatus) == 2) {
                    thisContact.setAssignedDate(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
                } else if (Integer.parseInt(leadStatus) == 3) {
                    thisContact.setLeadTrashedDate(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
                }
            }
            if (comments != null && !"".equals(comments)) {
                thisContact.setComments(comments);
            }
            if (rating != null && !"".equals(rating)) {
                thisContact.setRating(Integer.parseInt(rating));
            }
            if (isValid = this.validateObject(context, db, (Object)thisContact)) {
                resultCount = thisContact.update(db, context);
            }
            if (isValid && resultCount == 1) {
                if (oldContact.getOwner() != thisContact.getOwner()) {
                    this.sendEmail(context, db, thisContact, thisContact.getOwner(), "leads.assigned");
                }
                this.processUpdateHook(context, (Object)oldContact, (Object)thisContact);
                thisContact = new Contact(db, thisContact.getId());
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                context.getRequest().setAttribute("contactId", (Object)("" + thisContact.getId()));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (isValid && resultCount == 1) {
            String next = context.getRequest().getParameter("next");
            String leadAssignment = context.getRequest().getParameter("leadAssignment");
            if (next != null && "assignaccount".equals(next)) {
                if (from != null && !"list".equals(from)) {
                    context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=Dashboard" + RequestUtils.addLinkParams(context.getRequest(), "actionId")));
                } else {
                    context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=List" + RequestUtils.addLinkParams(context.getRequest(), "actionId|listForm|from")));
                }
                if (leadAssignment != null && "true".equals(leadAssignment)) {
                    context.getRequest().setAttribute("id", (Object)contactId);
                    return "CloseOK";
                }
                this.executeCommandWorkAccount(context);
                return Sales.getReturn(context, "WorkAccount");
            }
        }
        this.addModuleBean(context, "Leads", "Update Lead");
        if (from != null && "dashboard".equals(from)) {
            return this.executeCommandDashboard(context);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-delete")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        Contact contact = null;
        Connection db = null;
        String listForm = context.getRequest().getParameter("listForm");
        if (listForm != null && !"".equals(listForm)) {
            context.getRequest().setAttribute("listForm", (Object)listForm);
        }
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            contact = new Contact(db, contactId);
            if (!Sales.isRecordAccessPermitted(context, (Object)contact)) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = contact.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='Sales.do?command=Delete&contactId=" + contactId + "&listForm=" + (listForm != null ? listForm : "") + RequestUtils.addLinkParams(context.getRequest(), "from|nextValue") + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header2"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='Sales.do?command=Trash&contactId=" + contactId + "&listForm=" + (listForm != null ? listForm : "") + RequestUtils.addLinkParams(context.getRequest(), "popup|from|nextValue") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-delete")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        String listForm = context.getRequest().getParameter("listForm");
        Contact contact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            contact = new Contact(db, contactId);
            int size = LeadUtils.cleanUpContact(db, contact.getId(), this.getUserId(context));
            if (!this.hasAuthority(context, contact.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            contact.updateStatus(db, context, true, this.getUserId(context));
            String returnType = context.getRequest().getParameter("from");
            if (returnType != null && !"list".equals(returnType)) {
                context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=Dashboard" + RequestUtils.addLinkParams(context.getRequest(), "actionId")));
            } else {
                context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=List" + RequestUtils.addLinkParams(context.getRequest(), "actionId|listForm|from")));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "sales-leads-delete")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        String listForm = context.getRequest().getParameter("listForm");
        Contact contact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            contact = new Contact(db, contactId);
            int size = LeadUtils.cleanUpContact(db, contact.getId(), this.getUserId(context));
            if (!this.hasAuthority(context, contact.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            contact.delete(db, context, Sales.getDbNamePath(context));
            String returnType = context.getRequest().getParameter("from");
            if (returnType != null && !"list".equals(returnType)) {
                context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=Dashboard" + RequestUtils.addLinkParams(context.getRequest(), "actionId")));
            } else {
                context.getRequest().setAttribute("refreshUrl", (Object)("Sales.do?command=List" + RequestUtils.addLinkParams(context.getRequest(), "actionId|listForm|from")));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Leads", "Leads");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandContactList(ActionContext context) {
        if (!this.hasPermission(context, "contacts-external_contacts-view")) {
            return "PermissionError";
        }
        PagedListInfo searchContactsInfo = this.getPagedListInfo(context, "SalesContactListInfo");
        searchContactsInfo.setLink("Sales.do?command=ContactList");
        String source = context.getRequest().getParameter("source");
        this.addModuleBean(context, "Sales Contacts", "Search Results");
        ContactList contactList = new ContactList();
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            searchContactsInfo.setSearchCriteria(contactList, context);
            if (!this.hasPermission(context, "accounts-accounts-contacts-view")) {
                contactList.setExcludeAccountContacts(true);
            }
            contactList.setPagedListInfo(searchContactsInfo);
            contactList.setBuildDetails(true);
            contactList.setBuildTypes(false);
            contactList.addIgnoreTypeId(1);
            contactList.addIgnoreTypeId(2);
            contactList.setControlledHierarchyOnly(false, this.getUserRange(context));
            contactList.setAllContacts(true);
            contactList.setPersonalId(this.getUserId(context));
            contactList.setSiteId(user.getSiteId());
            contactList.setExclusiveToSite(true);
            if (user.getSiteId() == -1) {
                contactList.setIncludeAllSites(true);
            }
            contactList.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        return "ContactListOK";
    }

    private UserList prepareLines(User pertainsTo, UserList usersToGraph, QualifiedLeadsCounter gqlc) {
        Date myDate = null;
        Calendar readDate = Calendar.getInstance();
        Calendar readDateAdjusted = Calendar.getInstance();
        Double lccrAddTerm = new Double(0.0);
        String valKey = "";
        if (!pertainsTo.getIsValidLead()) {
            pertainsTo.doLeadsLock();
            if (!pertainsTo.getIsValidLead()) {
                try {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Sales-> (RE)BUILDING LEADS DATA FOR " + pertainsTo.getId());
                    }
                    pertainsTo.setLccr(new GraphSummaryList(8, 3, false));
                    List leadCountList = gqlc.getQualifiedLeadsCounter(pertainsTo.getId());
                    if (leadCountList == null) {
                        return new UserList();
                    }
                    for (QualifiedLeadsCount tempLeadCounter : leadCountList) {
                        myDate = tempLeadCounter.getConversionDate();
                        readDate.setTime(myDate);
                        readDateAdjusted.setTime(myDate);
                        readDate.add(7, -(readDate.get(7) - readDate.getFirstDayOfWeek()));
                        valKey = String.valueOf(readDate.get(1)) + String.valueOf(readDate.get(2)) + String.valueOf(readDate.get(5));
                        lccrAddTerm = new Double(tempLeadCounter.getCountOfConversion());
                        pertainsTo.setGraphValuesLeads(valKey, lccrAddTerm);
                    }
                    pertainsTo.setIsValidLead(true, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Sales-> Unwanted exception occurred: " + e.toString());
                }
            }
            pertainsTo.doLeadsUnlock();
        }
        usersToGraph.add(pertainsTo);
        return usersToGraph;
    }

    private XYSeriesCollection createCategoryDataset(UserList linesToDraw, String whichGraph) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Sales-> Lines to draw: " + linesToDraw.size());
        }
        if (linesToDraw.size() == 0) {
            return xyDataset;
        }
        for (User thisUser : linesToDraw) {
            XYSeries dataSeries = new XYSeries((Comparable)((Object)""));
            String[] valKeys = thisUser.getLccr().getWeekRange(8);
            Calendar iteratorDate = Calendar.getInstance();
            for (int count = 0; count < 8; ++count) {
                java.util.Date dateValue = Sales.createDate(iteratorDate.get(1), iteratorDate.get(2), iteratorDate.get(5));
                Double itemValue = new Double(0.0);
                if (whichGraph.equals("lccr")) {
                    itemValue = thisUser.getLccr().getValue(valKeys[count]);
                }
                iteratorDate.add(3, -1);
                dataSeries.add((double)dateValue.getTime(), (Number)itemValue);
            }
            xyDataset.addSeries(dataSeries);
        }
        return xyDataset;
    }

    private UserList calculateLine(User primaryNode, UserList currentLines) {
        if (currentLines.size() == 0) {
            currentLines.add(primaryNode);
            return currentLines;
        }
        primaryNode.getLccr().setIsFutureDateRange(false);
        currentLines.add(primaryNode);
        return currentLines;
    }

    private UserList calculateLine(UserList toRollUp, UserList currentLines) {
        if (toRollUp.size() == 0) {
            return new UserList();
        }
        User thisLine = new User();
        thisLine.getLccr().setIsFutureDateRange(false);
        String[] valKeys = thisLine.getLccr().getWeekRange(8);
        for (User thisUser : toRollUp) {
            for (int count = 0; count < 8; ++count) {
                thisLine.getLccr().setValue(valKeys[count], thisUser.getLccr().getValue(valKeys[count]));
            }
        }
        currentLines.add(thisLine);
        return currentLines;
    }

    public static java.util.Date createDate(int y, int m, int d) {
        GregorianCalendar calendar = new GregorianCalendar(y, m, d, 0, 0, 0);
        return calendar.getTime();
    }

    public boolean sendEmail(ActionContext context, Connection db, Contact currentContact, int owner, String type) throws Exception {
        User user = this.getUser(context, owner);
        user.setBuildContact(true);
        user.setBuildContactDetails(true);
        user.buildResources(db);
        if (type != null && !"".equals(type) && user.getId() == this.getUserId(context)) {
            return true;
        }
        String templateFile = Sales.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
        if (!FileUtils.fileExists(templateFile)) {
            templateFile = Sales.getDbNamePath(context) + "templates_en_US.xml";
        }
        SalesEmail salesEmail = null;
        salesEmail = type != null && !"".equals(type) ? new SalesEmail(templateFile, currentContact, context, type) : new SalesEmail(templateFile, currentContact, context);
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(Sales.getPref(context, "MAILSERVER"));
        mail.setFrom(Sales.getPref(context, "EMAILADDRESS"));
        mail.addReplyTo(user.getContact().getPrimaryEmailAddress(), user.getContact().getNameFirstLast());
        mail.setType("text/html");
        mail.setSubject(salesEmail.getSubject());
        mail.setBody(salesEmail.getBody());
        if (user.getContact().getPrimaryEmailAddress() != null && !"".equals(user.getContact().getPrimaryEmailAddress())) {
            mail.addTo(user.getContact().getPrimaryEmailAddress());
            mail.send();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReports(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        FileItemList files = new FileItemList();
        files.setLinkModuleId(2006031313);
        files.setLinkItemId(-1);
        PagedListInfo rptListInfo = this.getPagedListInfo(context, "salesRptListInfo");
        rptListInfo.setLink("Sales.do?command=Reports");
        files.setPagedListInfo(rptListInfo);
        if ("all".equals(rptListInfo.getListView())) {
            files.setOwnerIdRange(this.getUserRange(context));
        } else {
            files.setOwner(this.getUserId(context));
        }
        try {
            db = this.getConnection(context);
            files.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "ViewReports");
        context.getRequest().setAttribute("fileList", (Object)files);
        return "ReportsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGenerateForm(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList industryList = systemStatus.getLookupList(db, "lookup_industry");
            industryList.addItem(-1, systemStatus.getLabel("pipeline.any"));
            context.getRequest().setAttribute("industryList", (Object)industryList);
            LookupList sources = systemStatus.getLookupList(db, "lookup_contact_source");
            sources.addItem(-1, systemStatus.getLabel("pipeline.any"));
            context.getRequest().setAttribute("sourceList", (Object)sources);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Generate new");
        return "GenerateFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportReport(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        String subject = context.getRequest().getParameter("subject");
        String leadStatus = context.getRequest().getParameter("leadStatus");
        String sourceCode = context.getRequest().getParameter("sourceCode");
        String industryCode = context.getRequest().getParameter("industryCode");
        String filePath = this.getPath(context, "sales-reports");
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
        String datePathToUse1 = formatter1.format(new java.util.Date());
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
        String datePathToUse2 = formatter2.format(new java.util.Date());
        filePath = filePath + datePathToUse1 + fs + datePathToUse2 + fs;
        ContactReport leadReport = new ContactReport();
        leadReport.setType(2);
        leadReport.setCriteria(context.getRequest().getParameterValues("selectedList"));
        leadReport.setFilePath(filePath);
        leadReport.setSubject(subject);
        leadReport.setUserId(this.getUserId(context));
        leadReport.setLeadStatus(leadStatus);
        if (Integer.parseInt(leadStatus) == 4) {
            leadReport.setLeadsOnly(0);
            leadReport.setLeadStatus(-1);
            leadReport.setHasConversionDate(1);
        } else if (Integer.parseInt(leadStatus) == 0) {
            leadReport.setLeadsOnly(1);
        } else if (Integer.parseInt(leadStatus) == -1) {
            leadReport.setLeadStatus(-1);
            leadReport.setLeadsOnly(-1);
        }
        leadReport.setLeadStatusExists(1);
        PagedListInfo thisInfo = new PagedListInfo();
        thisInfo.setColumnToSortBy(context.getRequest().getParameter("sort"));
        thisInfo.setItemsPerPage(0);
        leadReport.setPagedListInfo(thisInfo);
        leadReport.setSiteId(this.getUserSiteId(context));
        leadReport.setExclusiveToSite(true);
        if (this.getUserSiteId(context) == -1) {
            leadReport.setIncludeAllSites(true);
        }
        if (sourceCode != null) {
            leadReport.setSource(sourceCode);
        }
        if (industryCode != null) {
            leadReport.setIndustry(industryCode);
        }
        leadReport.setControlledHierarchyOnly(true, this.getUserRange(context));
        try {
            db = this.getConnection(context);
            leadReport.buildReportFull(db, this.getUserTable(context));
            leadReport.setEnteredBy(this.getUserId(context));
            leadReport.setModifiedBy(this.getUserId(context));
            leadReport.saveAndInsert(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandReports(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowReportHtml(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        FileItem thisItem = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId));
            String filePath = this.getPath(context, "sales-reports") + Sales.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html";
            String textToShow = Sales.includeFile(filePath);
            context.getRequest().setAttribute("ReportText", (Object)textToShow);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
            return "PermissionError";
        }
        return "ReportHtmlOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadCSVReport(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-view")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("fid");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 2006031313);
            if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItem itemToDownload = null;
            itemToDownload = thisItem;
            String filePath = this.getPath(context, "sales-reports") + Sales.getDatePath(itemToDownload.getEntered()) + itemToDownload.getFilename() + ".csv";
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("PMF-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteReport(ActionContext context) {
        if (!this.hasPermission(context, "sales-reports-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 2006031313);
            if (!this.hasAuthority(context, thisItem.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            if (thisItem.getEnteredBy() == this.getUserId(context)) {
                String filePath2;
                File fileToDelete2;
                recordDeleted = thisItem.delete(db, this.getPath(context, "sales-reports"));
                String filePath1 = this.getPath(context, "sales-reports") + Sales.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".csv";
                File fileToDelete1 = new File(filePath1);
                if (!fileToDelete1.delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath1);
                }
                if (!(fileToDelete2 = new File(filePath2 = this.getPath(context, "sales-reports") + Sales.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html")).delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath2);
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Reports del");
        if (recordDeleted) {
            return "DeleteReportOK";
        }
        return "DeleteReportERROR";
    }

    private static void copyPropertiesFromContactToOrganization(Contact from, Organization to) {
        to.setRevenue(from.getRevenue());
        to.setEmployees(from.getEmployees());
        to.setDunsType(from.getDunsType());
        to.setYearStarted(from.getYearStarted());
        to.setDunsNumber(from.getDunsNumber());
        to.setBusinessNameTwo(from.getBusinessNameTwo());
        to.setSicCode(from.getSicCode());
    }
}

