/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.webdav.utils.ICalendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionlist.base.ActionItemLogList;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class Call
extends GenericBean {
    public static final int CANCELED = 1;
    public static final int COMPLETE = 2;
    public static final int COMPLETE_FOLLOWUP_PENDING = 3;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int callTypeId = -1;
    private int followupContactId = -1;
    private int oppHeaderId = -1;
    private int length = 0;
    private int enteredBy = -1;
    private String enteredName = "";
    private int modifiedBy = -1;
    private String modifiedName = "";
    private int alertCallTypeId = -1;
    private int owner = -1;
    private int assignedBy = -1;
    private int completedBy = -1;
    private int resultId = -1;
    private int priorityId = -1;
    private int statusId = -1;
    private int reminderTypeId = -1;
    private int reminderId = -1;
    private int parentId = -1;
    private int contactOrgId = -1;
    private String callType = "";
    private String subject = null;
    private String notes = null;
    private String followupNotes = null;
    private String contactName = "";
    private String followupContactName = "";
    private String alertText = null;
    private String alertCallType = "";
    private String priorityString = "";
    private String orgName = null;
    private String alertDateTimeZone = null;
    private String action = null;
    private Timestamp alertDate = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private Timestamp followupDate = null;
    private Timestamp assignDate = null;
    private Timestamp completeDate = null;
    private boolean hasFollowup = false;
    private Timestamp trashedDate = null;
    private int actionId = -1;
    private boolean checkAlertDate = true;
    private boolean updateOrganization = false;
    Contact contact = new Contact();

    public Call() {
    }

    public Call(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Call(Connection db, String callId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(callId));
    }

    public Call(Connection db, int callId) throws SQLException {
        this.queryRecord(db, callId);
    }

    public void queryRecord(Connection db, int callId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c.call_id, c.org_id, c.contact_id, c.opp_id, c.call_type_id, c." + DatabaseUtils.addQuotes(db, "length") + ", " + "c.subject, c.notes, c.entered, c.enteredby, c.modified, c.modifiedby, c.alertdate, " + "c.followup_date, c.parent_id, c.owner, c.assignedby, c.assign_date, c.completedby, " + "c.complete_date, c.result_id, c.priority_id, c.status_id, c.reminder_value, c.reminder_type_id, " + "c.alert_call_type_id, c.alert, c.followup_notes, c.alertdate_timezone, c.trashed_date, c.followup_contact_Id, t.*, talert.description AS alertType, " + "ct.namelast AS ctlast, ct.namefirst AS ctfirst, ct.org_name AS ctcompany, fct.namelast AS fctlast, fct.namefirst AS fctfirst, fct.org_name AS fctcompany, o.name AS orgname, p.description AS priority " + "FROM call_log c " + "LEFT JOIN contact ct ON (c.contact_id = ct.contact_id) " + "LEFT JOIN contact fct ON (c.followup_contact_id = fct.contact_id) " + "LEFT JOIN lookup_call_types t ON (c.call_type_id = t.code) " + "LEFT JOIN lookup_call_types talert ON (c.alert_call_type_id = talert.code) " + "LEFT JOIN lookup_call_priority p ON (c.priority_id = p.code) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "WHERE call_id > -1 ");
        if (callId <= -1) {
            throw new SQLException("Valid call ID not specified.");
        }
        sql.append("AND call_id = " + callId + " ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Call record not found.");
        }
    }

    public void setOppHeaderId(int oppHeaderId) {
        this.oppHeaderId = oppHeaderId;
    }

    public void setOppHeaderId(String oppHeaderId) {
        this.oppHeaderId = Integer.parseInt(oppHeaderId);
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setAssignDate(String tmp) {
        this.assignDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setCompleteDate(String tmp) {
        this.completeDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setCompletedBy(String tmp) {
        this.completedBy = Integer.parseInt(tmp);
    }

    public void setAlertDate(Timestamp alertDate) {
        this.alertDate = alertDate;
    }

    public void setAlertDate(String tmp) {
        this.alertDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setId(String tmp) {
        try {
            this.id = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = Integer.parseInt(actionId);
    }

    public int getFollowupContactId() {
        return this.followupContactId;
    }

    public void setFollowupContactId(int followupContactId) {
        this.followupContactId = followupContactId;
    }

    public void setFollowupContactId(String followupContactId) {
        this.followupContactId = Integer.parseInt(followupContactId);
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = Integer.parseInt(parentId);
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setHasFollowup(boolean hasFollowup) {
        this.hasFollowup = hasFollowup;
    }

    public void setHasFollowup(String hasFollowup) {
        this.hasFollowup = DatabaseUtils.parseBoolean(hasFollowup);
    }

    public boolean getHasFollowup() {
        return this.hasFollowup;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setAssignedBy(int assignedBy) {
        this.assignedBy = assignedBy;
    }

    public void setCompletedBy(int completedBy) {
        this.completedBy = completedBy;
    }

    public void setPriorityId(int priorityId) {
        this.priorityId = priorityId;
    }

    public void setPriorityId(String priorityId) {
        if (Integer.parseInt(priorityId) > 0) {
            this.priorityId = Integer.parseInt(priorityId);
        }
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = Integer.parseInt(statusId);
    }

    public void setReminderTypeId(int reminderTypeId) {
        this.reminderTypeId = reminderTypeId;
    }

    public void setReminderTypeId(String reminderTypeId) {
        if (Integer.parseInt(reminderTypeId) > 0) {
            this.reminderTypeId = Integer.parseInt(reminderTypeId);
        }
    }

    public void setReminderId(int reminderId) {
        this.reminderId = reminderId;
    }

    public void setReminderId(String reminderId) {
        this.reminderId = Integer.parseInt(reminderId);
    }

    public void setFollowupDate(Timestamp followupDate) {
        this.followupDate = followupDate;
    }

    public void setFollowupDate(String tmp) {
        this.followupDate = DateUtils.parseTimestampString(tmp);
    }

    public void setAssignDate(Timestamp assignDate) {
        this.assignDate = assignDate;
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public void setAlertCallType(String alertCallType) {
        this.alertCallType = alertCallType;
    }

    public void setFollowupNotes(String followupNotes) {
        this.followupNotes = followupNotes;
    }

    public void setPriorityString(String priorityString) {
        this.priorityString = priorityString;
    }

    public void setCheckAlertDate(boolean tmp) {
        this.checkAlertDate = tmp;
    }

    public void setCheckAlertDate(String tmp) {
        this.checkAlertDate = DatabaseUtils.parseBoolean(tmp);
    }

    public void setContactOrgId(int contactOrgId) {
        this.contactOrgId = contactOrgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public void setAlertDateTimeZone(String tmp) {
        this.alertDateTimeZone = tmp;
    }

    public String getAlertDateTimeZone() {
        return this.alertDateTimeZone;
    }

    public Contact getContact() {
        return this.contact;
    }

    public String getEnteredName() {
        return this.enteredName;
    }

    public String getModifiedName() {
        return this.modifiedName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public int getContactOrgId() {
        return this.contactOrgId;
    }

    public String getPriorityString() {
        return this.priorityString;
    }

    public String getFollowupNotes() {
        return this.followupNotes;
    }

    public String getAlertCallType() {
        return this.alertCallType;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getPriorityId() {
        return this.priorityId;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getAssignedBy() {
        return this.assignedBy;
    }

    public int getCompletedBy() {
        return this.completedBy;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getStatusString() {
        String tmp = "";
        if (this.statusId == 2 || this.statusId == 3) {
            tmp = "Complete";
        } else if (this.statusId == 1) {
            tmp = "Canceled";
        }
        return tmp;
    }

    public int getReminderTypeId() {
        return this.reminderTypeId;
    }

    public int getReminderId() {
        return this.reminderId;
    }

    public int getAlertCallTypeId() {
        return this.alertCallTypeId;
    }

    public Timestamp getFollowupDate() {
        return this.followupDate;
    }

    public Timestamp getAssignDate() {
        return this.assignDate;
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public void setOrgId(String tmp) {
        try {
            this.orgId = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        try {
            this.contactId = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCallTypeId(int tmp) {
        this.callTypeId = tmp;
    }

    public void setCallTypeId(String tmp) {
        try {
            this.callTypeId = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLength(int tmp) {
        this.length = tmp;
    }

    public void setLength(String tmp) {
        try {
            this.length = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getCheckAlertDate() {
        return this.checkAlertDate;
    }

    public int getOppHeaderId() {
        return this.oppHeaderId;
    }

    public String getContactName() {
        return this.contactName;
    }

    public Timestamp getAlertDate() {
        return this.alertDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getIdString() {
        return String.valueOf(this.id);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getCallTypeId() {
        return this.callTypeId;
    }

    public String getCallType() {
        return this.callType;
    }

    public void setCallType(String tmp) {
        this.callType = tmp;
    }

    public int getLength() {
        return this.length;
    }

    public String getLengthString() {
        return String.valueOf(this.length);
    }

    public String getLengthText() {
        if (this.length > 0) {
            return this.length + " min.";
        }
        return "";
    }

    public boolean hasLength() {
        return this.length > 0;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setResultId(int tmp) {
        this.resultId = tmp;
    }

    public void setResultId(String tmp) {
        this.resultId = Integer.parseInt(tmp);
    }

    public int getResultId() {
        return this.resultId;
    }

    public void setAlertCallTypeId(int tmp) {
        this.alertCallTypeId = tmp;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void setAlertCallTypeId(String tmp) {
        if (Integer.parseInt(tmp) > 0) {
            this.alertCallTypeId = Integer.parseInt(tmp);
        }
    }

    public void setUpdateOrganization(boolean tmp) {
        this.updateOrganization = tmp;
    }

    public void setUpdateOrganization(String tmp) {
        this.updateOrganization = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getUpdateOrganization() {
        return this.updateOrganization;
    }

    public int lookupReminderSeconds(Connection db) throws SQLException {
        if (this.getReminderTypeId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int scds = 0;
        PreparedStatement pst = db.prepareStatement("SELECT base_value FROM lookup_call_reminder WHERE code = ? ");
        pst.setInt(1, this.reminderTypeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            scds = rs.getInt("base_value");
        }
        rs.close();
        pst.close();
        return scds;
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        return this.insert(db);
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            Contact thisContact = new Contact();
            if (this.getContactId() > 0) {
                thisContact = new Contact(db, this.getContactId());
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "call_log_call_id_seq");
            sql.append("INSERT INTO call_log (org_id, contact_id, opp_id, call_type_id, " + DatabaseUtils.addQuotes(db, "length") + ", subject, notes, " + "alertdate, alert, alert_call_type_id, result_id, parent_id, owner, followup_notes, status_id, " + "reminder_value, reminder_type_id, priority_id, followup_date, alertdate_timezone, followup_contact_id, ");
            if (this.id > -1) {
                sql.append("call_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (thisContact.getOrgId() > 0) {
                pst.setInt(++i, thisContact.getOrgId());
            } else if (this.getOrgId() > 0) {
                pst.setInt(++i, this.getOrgId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getContactId() > 0) {
                pst.setInt(++i, this.getContactId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getOppHeaderId() > 0) {
                pst.setInt(++i, this.getOppHeaderId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getCallTypeId() > 0) {
                pst.setInt(++i, this.getCallTypeId());
            } else {
                pst.setNull(++i, 4);
            }
            pst.setInt(++i, this.getLength());
            pst.setString(++i, this.getSubject());
            pst.setString(++i, this.getNotes());
            DatabaseUtils.setTimestamp(pst, ++i, this.alertDate);
            pst.setString(++i, this.getAlertText());
            DatabaseUtils.setInt(pst, ++i, this.alertCallTypeId);
            DatabaseUtils.setInt(pst, ++i, this.resultId);
            DatabaseUtils.setInt(pst, ++i, this.parentId);
            DatabaseUtils.setInt(pst, ++i, this.owner);
            pst.setString(++i, this.getFollowupNotes());
            pst.setInt(++i, this.statusId);
            DatabaseUtils.setInt(pst, ++i, this.reminderId);
            DatabaseUtils.setInt(pst, ++i, this.reminderTypeId);
            DatabaseUtils.setInt(pst, ++i, this.priorityId);
            DatabaseUtils.setTimestamp(pst, ++i, this.followupDate);
            pst.setString(++i, this.alertDateTimeZone);
            if (this.getFollowupContactId() > 0) {
                pst.setInt(++i, this.getFollowupContactId());
            } else if (this.getContactId() > 0) {
                pst.setInt(++i, this.getContactId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "call_log_call_id_seq", this.id);
            if (this.getStatusId() == 2 || this.getStatusId() == 3) {
                this.markComplete(db, this.getEnteredBy());
            } else if (this.getStatusId() == 1) {
                this.markCanceled(db, this.getEnteredBy());
            }
            if (this.actionId > 0) {
                this.updateLog(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void updateLog(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog thisLog = new ActionItemLog();
            thisLog.setEnteredBy(this.getEnteredBy());
            thisLog.setModifiedBy(this.getModifiedBy());
            thisLog.setItemId(this.getActionId());
            thisLog.setLinkItemId(this.getId());
            thisLog.setType(42420031);
            thisLog.insert(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        DependencyList dependencyList = new DependencyList();
        ActionList actionList = ActionItemLogList.isItemLinked(db, this.getId(), 42420031);
        if (actionList != null) {
            thisDependency = new Dependency();
            thisDependency.setName(actionList.getDescription());
            thisDependency.setCount(1);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        thisDependency = new Dependency();
        thisDependency.setName("contact.history");
        if (this.getStatusId() == 2 || this.getStatusId() == 3) {
            thisDependency.setCount(ContactHistory.retrieveRecordCount(db, 3, this.getId()));
        } else {
            thisDependency.setCount(ContactHistory.retrieveRecordCount(db, 13, this.getId()));
        }
        thisDependency.setCanDelete(true);
        if (thisDependency.getCount() > 0) {
            dependencyList.add(thisDependency);
        }
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int recordCount = 0;
        ActionItemLog.deleteLink(db, this.getId(), 42420031);
        if (this.getStatusId() == 2 || this.getStatusId() == 3) {
            ContactHistory.deleteObject(db, 3, this.getId());
        } else {
            ContactHistory.deleteObject(db, 13, this.getId());
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM call_log WHERE call_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Call ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE call_log SET " + (this.updateOrganization ? " org_id = ?," : "") + " call_type_id = ?, " + DatabaseUtils.addQuotes(db, "length") + " = ?, subject = ?, notes = ?, " + "modifiedby = ?, alertdate = ?, alert = ?, alert_call_type_id = ?, " + "followup_notes = ?, status_id = ?, result_id = ?, owner = ?, " + "reminder_value = ?, reminder_type_id = ?, priority_id = ?, " + "followup_date = ?, alertdate_timezone = ?, trashed_date = ?, opp_id = ?, followup_contact_id=?, contact_id=?, " + "modified = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE call_id = ? " + "AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (this.updateOrganization) {
            DatabaseUtils.setInt(pst, ++i, this.getOrgId());
        }
        if (this.getCallTypeId() > 0) {
            pst.setInt(++i, this.getCallTypeId());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setInt(++i, this.length);
        pst.setString(++i, this.subject);
        pst.setString(++i, this.notes);
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setTimestamp(pst, ++i, this.alertDate);
        pst.setString(++i, this.getAlertText());
        DatabaseUtils.setInt(pst, ++i, this.alertCallTypeId);
        pst.setString(++i, this.getFollowupNotes());
        pst.setInt(++i, this.statusId);
        DatabaseUtils.setInt(pst, ++i, this.resultId);
        if (this.getOwner() > 0) {
            pst.setInt(++i, this.getOwner());
        } else {
            pst.setNull(++i, 4);
        }
        DatabaseUtils.setInt(pst, ++i, this.reminderId);
        DatabaseUtils.setInt(pst, ++i, this.reminderTypeId);
        DatabaseUtils.setInt(pst, ++i, this.priorityId);
        DatabaseUtils.setTimestamp(pst, ++i, this.followupDate);
        pst.setString(++i, this.alertDateTimeZone);
        DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
        DatabaseUtils.setInt(pst, ++i, this.getOppHeaderId());
        DatabaseUtils.setInt(pst, ++i, this.getFollowupContactId());
        DatabaseUtils.setInt(pst, ++i, this.getContactId());
        pst.setInt(++i, this.getId());
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean count = false;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE call_log SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE call_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            if (this.getStatusString().equals("Complete")) {
                ContactHistory.trash(db, 3, this.getId(), !toTrash);
            } else {
                ContactHistory.trash(db, 13, this.getId(), !toTrash);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int markComplete(Connection db, int userId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Call ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE call_log SET completedby = ?, complete_date = " + DatabaseUtils.getCurrentTimestamp(db) + ", status_id = ? " + "WHERE call_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, userId);
        if (this.getStatusId() == 3) {
            pst.setInt(++i, 3);
        } else {
            pst.setInt(++i, 2);
        }
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int markCanceled(Connection db, int userId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Call ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE call_log SET completedby = ?, complete_date = CURRENT_TIMESTAMP, status_id = ? WHERE call_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, userId);
        pst.setInt(++i, 1);
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("call_id");
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.oppHeaderId = DatabaseUtils.getInt(rs, "opp_id");
        this.callTypeId = DatabaseUtils.getInt(rs, "call_type_id");
        this.length = rs.getInt("length");
        this.subject = rs.getString("subject");
        this.notes = rs.getString("notes");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.alertDate = rs.getTimestamp("alertdate");
        this.followupDate = rs.getTimestamp("followup_date");
        this.parentId = DatabaseUtils.getInt(rs, "parent_id");
        this.owner = DatabaseUtils.getInt(rs, "owner");
        this.assignedBy = DatabaseUtils.getInt(rs, "assignedBy");
        this.assignDate = rs.getTimestamp("assign_date");
        this.completedBy = DatabaseUtils.getInt(rs, "completedBy");
        this.completeDate = rs.getTimestamp("complete_date");
        this.resultId = DatabaseUtils.getInt(rs, "result_id");
        this.priorityId = DatabaseUtils.getInt(rs, "priority_id");
        this.statusId = rs.getInt("status_id");
        this.reminderId = DatabaseUtils.getInt(rs, "reminder_value");
        this.reminderTypeId = DatabaseUtils.getInt(rs, "reminder_type_id");
        this.alertCallTypeId = DatabaseUtils.getInt(rs, "alert_call_type_id");
        this.alertText = rs.getString("alert");
        this.followupNotes = rs.getString("followup_notes");
        this.alertDateTimeZone = rs.getString("alertdate_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.followupContactId = DatabaseUtils.getInt(rs, "followup_contact_id");
        this.callTypeId = DatabaseUtils.getInt(rs, "code");
        this.callType = rs.getString("description");
        this.alertCallType = rs.getString("alertType");
        this.contactName = Contact.getNameLastFirst(rs.getString("ctlast"), rs.getString("ctfirst"));
        if (this.contactName == null || "".equals(this.contactName)) {
            this.contactName = rs.getString("ctcompany");
        }
        this.followupContactName = Contact.getNameLastFirst(rs.getString("fctlast"), rs.getString("fctfirst"));
        if (this.followupContactName == null || "".equals(this.followupContactName)) {
            this.followupContactName = rs.getString("fctcompany");
        }
        this.orgName = rs.getString("orgname");
        this.priorityString = rs.getString("priority");
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("alertDate");
        return thisList;
    }

    public boolean reassign(Connection db, ActionContext context, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db, context);
        return result != -1;
    }

    public boolean reassignAccount(Connection db, ActionContext context, int newOrgId) throws SQLException {
        int result = -1;
        this.setOrgId(newOrgId);
        this.setUpdateOrganization(true);
        result = this.update(db, context);
        return result != -1;
    }

    public String generateWebcalEvent(TimeZone tz, Timestamp created, int type) {
        StringBuffer webcal = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        String description = "";
        if (this.contactName != null && !"".equals(this.contactName.trim())) {
            description = description + this.contactName;
        }
        if (this.orgName != null && !"".equals(this.orgName.trim())) {
            description = description + "\\n";
            description = description + this.orgName;
        }
        if (type == 3) {
            if (this.contact != null) {
                for (PhoneNumber thisNumber : this.contact.getPhoneNumberList()) {
                    description = description + "\\n" + String.valueOf(thisNumber.getTypeName().charAt(0)) + ":" + thisNumber.getNumber();
                }
            }
            if (this.followupNotes != null) {
                description = description + "\\n\\n";
                description = description + this.followupNotes;
            }
        }
        if (type == 2 && this.notes != null) {
            description = description + "\\n\\n";
            description = description + this.notes;
        }
        webcal.append("BEGIN:VEVENT" + CRLF);
        if (type == 3) {
            webcal.append("UID:www.centriccrm.com-myhomepage-pending-calls-" + this.getId() + CRLF);
        } else if (type == 2) {
            webcal.append("UID:www.centriccrm.com-myhomepage-completed-calls-" + this.getId() + CRLF);
        }
        if (created != null) {
            webcal.append("DTSTAMP:" + ICalendar.getDateTimeUTC((Timestamp)created) + CRLF);
        }
        if (this.entered != null) {
            webcal.append("CREATED:" + ICalendar.getDateTimeUTC((Timestamp)this.entered) + CRLF);
        }
        if (type == 3) {
            if (this.alertDate != null) {
                webcal.append("DTSTART;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)this.alertDate) + CRLF);
            }
        } else if (type == 2 && this.completeDate != null) {
            webcal.append("DTSTART;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)this.completeDate) + CRLF);
        }
        if (type == 2 && this.length != -1) {
            webcal.append("DURATION:PT" + this.length + "M" + CRLF);
        }
        if (type == 3) {
            if (this.alertText != null) {
                webcal.append(ICalendar.foldLine((String)("SUMMARY:" + this.alertText)) + CRLF);
            }
        } else if (type == 2 && this.subject != null) {
            webcal.append(ICalendar.foldLine((String)("SUMMARY:" + this.subject)) + CRLF);
        }
        if (description != null) {
            webcal.append(ICalendar.foldLine((String)("DESCRIPTION:" + ICalendar.parseNewLine((String)description))) + CRLF);
        }
        if (this.priorityString != null) {
            webcal.append("PRIORITY:" + this.priorityString + CRLF);
        }
        webcal.append("END:VEVENT" + CRLF);
        return webcal.toString();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getFollowupContactName() {
        return this.followupContactName;
    }

    public void setFollowupContactName(String followupContactName) {
        this.followupContactName = followupContactName;
    }
}

