/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class CallList
extends ArrayList {
    public static final String tableName = "call_log";
    public static final String uniqueField = "call_id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected int contactId = -1;
    protected int orgId = -1;
    protected int oppHeaderId = -1;
    protected int enteredBy = -1;
    protected int owner = -1;
    protected boolean hasAlertDate = false;
    protected Timestamp alertDate = null;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected Timestamp notificationRangeStart = null;
    protected Timestamp notificationRangeEnd = null;
    protected boolean onlyPending = false;
    protected boolean excludeCanceled = false;
    protected boolean onlyCompleted = false;
    protected boolean onlyCompletedOrCanceled = false;
    protected boolean allContactsInAccount = false;
    protected int contactOrgId = -1;
    protected Timestamp trashedDate = null;
    protected boolean includeOnlyTrashed = false;
    protected int oppCallsOnly = -1;
    protected int avoidDisabledContacts = -1;

    public boolean isOnlyCompletedOrCanceled() {
        return this.onlyCompletedOrCanceled;
    }

    public void setOnlyCompletedOrCanceled(boolean tmp) {
        this.onlyCompletedOrCanceled = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOppHeaderId(int oppHeaderId) {
        this.oppHeaderId = oppHeaderId;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setAlertDate(Timestamp alertDate) {
        this.alertDate = alertDate;
    }

    public void setHasAlertDate(boolean tmp) {
        this.hasAlertDate = tmp;
    }

    public void setOppHeaderId(String oppHeaderId) {
        this.oppHeaderId = Integer.parseInt(oppHeaderId);
    }

    public void setAlertRangeStart(Timestamp alertRangeStart) {
        this.alertRangeStart = alertRangeStart;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = Timestamp.valueOf(tmp);
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setAlertRangeEnd(Timestamp tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = Timestamp.valueOf(tmp);
    }

    public void setOnlyPending(boolean tmp) {
        this.onlyPending = tmp;
    }

    public void setOnlyPending(String tmp) {
        this.onlyPending = DatabaseUtils.parseBoolean(tmp);
    }

    public void setExcludeCanceled(boolean excludeCanceled) {
        this.excludeCanceled = excludeCanceled;
    }

    public void setOnlyCompleted(boolean onlyCompleted) {
        this.onlyCompleted = onlyCompleted;
    }

    public void setNotificationRangeStart(Timestamp notificationRangeStart) {
        this.notificationRangeStart = notificationRangeStart;
    }

    public void setNotificationRangeEnd(Timestamp notificationRangeEnd) {
        this.notificationRangeEnd = notificationRangeEnd;
    }

    public void setAllContactsInAccount(boolean allContactsInAccount, int contactOrgId) {
        this.allContactsInAccount = allContactsInAccount;
        this.contactOrgId = contactOrgId;
    }

    public boolean getAllContactsInAccount() {
        return this.allContactsInAccount;
    }

    public int getContactOrgId() {
        return this.contactOrgId;
    }

    public Timestamp getNotificationRangeStart() {
        return this.notificationRangeStart;
    }

    public Timestamp getNotificationRangeEnd() {
        return this.notificationRangeEnd;
    }

    public boolean getOnlyCompleted() {
        return this.onlyCompleted;
    }

    public boolean getExcludeCanceled() {
        return this.excludeCanceled;
    }

    public Timestamp getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Timestamp getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public Timestamp getAlertDate() {
        return this.alertDate;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public boolean getHasAlertDate() {
        return this.hasAlertDate;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getOppHeaderId() {
        return this.oppHeaderId;
    }

    public boolean getOnlyPending() {
        return this.onlyPending;
    }

    public int getOppCallsOnly() {
        return this.oppCallsOnly;
    }

    public void setOppCallsOnly(int tmp) {
        this.oppCallsOnly = tmp;
    }

    public void setOppCallsOnly(String tmp) {
        this.oppCallsOnly = Integer.parseInt(tmp);
    }

    public int getAvoidDisabledContacts() {
        return this.avoidDisabledContacts;
    }

    public void setAvoidDisabledContacts(int tmp) {
        this.avoidDisabledContacts = tmp;
    }

    public void setAvoidDisabledContacts(String tmp) {
        this.avoidDisabledContacts = Integer.parseInt(tmp);
    }

    public HashMap queryRecordCount(Connection db, TimeZone timeZone) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        HashMap<String, Integer> events = new HashMap<String, Integer>();
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlTail = new StringBuffer();
        String sqlDate = this.onlyPending ? "alertdate" : "entered";
        this.createFilter(sqlFilter);
        sqlSelect.append("SELECT " + sqlDate + " AS " + DatabaseUtils.addQuotes(db, "date") + " " + "FROM call_log c " + "WHERE call_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlTail.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, rs.getTimestamp("date"));
            if (events.containsKey(alertDate)) {
                Integer count = (Integer)events.get(alertDate);
                int tmpCount = count;
                events.put(alertDate, new Integer(++tmpCount));
                continue;
            }
            events.put(alertDate, new Integer(1));
        }
        rs.close();
        pst.close();
        return events;
    }

    public void buildShortList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        this.createFilter(sqlFilter);
        sqlSelect.append("SELECT c.call_id, c.subject, c.contact_id, c.opp_id, c.opp_id, c.alertdate, c.alert, c.owner, c.notes, c." + DatabaseUtils.addQuotes(db, "length") + ", c.followup_notes, c.complete_date, c.org_id as contact_org_id, ct.namelast as ctlast, ct.namefirst as ctfirst, " + "ct.org_name as ctcompany, o.name as orgname, c.status_id, c.entered, p.description as priority, fct.namelast AS fctlast, fct.namefirst AS fctfirst, fct.org_name AS fctcompany, " + "c.followup_contact_id " + "FROM call_log c " + "LEFT JOIN contact fct ON (c.followup_contact_id = fct.contact_id) " + "LEFT JOIN lookup_call_priority p ON (c.priority_id = p.code) " + "LEFT JOIN contact ct ON (c.contact_id = ct.contact_id) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "WHERE c.call_id > -1 ");
        if (this.onlyCompleted) {
            sqlOrder.append("ORDER BY c.entered ");
        } else {
            sqlOrder.append("ORDER BY c.alertdate, p.weight DESC ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Contact thisContact;
            Call thisCall = new Call();
            thisCall.setId(rs.getInt(uniqueField));
            thisCall.setSubject(rs.getString("subject"));
            thisCall.setContactId(DatabaseUtils.getInt(rs, "contact_id"));
            thisCall.setOppHeaderId(DatabaseUtils.getInt(rs, "opp_id"));
            thisCall.setAlertDate(rs.getTimestamp("alertdate"));
            thisCall.setAlertText(rs.getString("alert"));
            thisCall.setOwner(rs.getInt("owner"));
            thisCall.setNotes(rs.getString("notes"));
            thisCall.setLength(rs.getInt("length"));
            thisCall.setFollowupNotes(rs.getString("followup_notes"));
            thisCall.setCompleteDate(rs.getTimestamp("complete_date"));
            thisCall.setContactOrgId(DatabaseUtils.getInt(rs, "contact_org_id"));
            String contactName = Contact.getNameLastFirst(rs.getString("ctlast"), rs.getString("ctfirst"));
            if (contactName == null || "".equals(contactName)) {
                contactName = rs.getString("ctcompany");
            }
            thisCall.setOrgName(rs.getString("orgname"));
            thisCall.setContactName(contactName);
            thisCall.setStatusId(rs.getInt("status_id"));
            thisCall.setEntered(rs.getTimestamp("entered"));
            thisCall.setPriorityString(rs.getString("priority"));
            thisCall.setFollowupContactId(DatabaseUtils.getInt(rs, "followup_contact_id"));
            String followupContactName = Contact.getNameLastFirst(rs.getString("fctlast"), rs.getString("fctfirst"));
            if (followupContactName == null || "".equals(followupContactName)) {
                followupContactName = rs.getString("fctcompany");
            }
            thisCall.setFollowupContactName(followupContactName);
            if (thisCall.getContactId() > 0) {
                thisContact = new Contact();
                thisContact.setId(thisCall.getContactId());
                thisCall.setContact(thisContact);
            } else if (thisCall.getFollowupContactId() > 0) {
                thisContact = new Contact();
                thisContact.setId(thisCall.getFollowupContactId());
                thisCall.setContact(thisContact);
            }
            this.add(thisCall);
        }
        rs.close();
        pst.close();
        for (Call thisCall : this) {
            thisCall.getContact().buildPhoneNumberList(db);
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM call_log c LEFT JOIN contact ct ON (c.contact_id = ct.contact_id) LEFT JOIN lookup_call_types t ON (c.call_type_id = t.code) LEFT JOIN lookup_call_types talert ON (c.alert_call_type_id = talert.code) LEFT JOIN lookup_call_priority p ON (c.priority_id = p.code) LEFT JOIN contact ct2 ON (c.followup_contact_id = ct2.contact_id) WHERE call_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("c.entered", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.entered DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.call_id, c.org_id, c.contact_id, c.opp_id, c.call_type_id, c." + DatabaseUtils.addQuotes(db, "length") + ", " + "c.subject, c.notes, c.entered, c.enteredby, c.modified, c.modifiedby, c.alertdate, " + "c.followup_date, c.parent_id, c.owner, c.assignedby, c.assign_date, c.completedby, " + "c.complete_date, c.result_id, c.priority_id, c.status_id, c.reminder_value, c.reminder_type_id, " + "c.alert_call_type_id, c.followup_contact_id, c.alert, c.followup_notes, c.alertdate_timezone, c.trashed_date, t.*, talert.description as alertType, " + "ct.namelast as ctlast, ct.namefirst as ctfirst, ct.org_name as ctcompany, fct.namelast AS fctlast, fct.namefirst AS fctfirst, fct.org_name AS fctcompany, o.name as orgname, p.description as priority " + "FROM call_log c " + "LEFT JOIN contact ct ON (c.contact_id = ct.contact_id) " + "LEFT JOIN contact fct ON (c.followup_contact_id = fct.contact_id) " + "LEFT JOIN lookup_call_types t ON (c.call_type_id = t.code) " + "LEFT JOIN lookup_call_types talert ON (c.alert_call_type_id = talert.code) " + "LEFT JOIN lookup_call_priority p ON (c.priority_id = p.code) " + "LEFT JOIN contact ct2 ON (c.followup_contact_id = ct2.contact_id) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "WHERE call_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Call thisCall = new Call(rs);
            this.add(thisCall);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        for (Call thisCall : this) {
            thisCall.delete(db);
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND (c.contact_id = ? ");
            sqlFilter.append("OR c.followup_contact_id = ? )");
        }
        if (this.allContactsInAccount) {
            sqlFilter.append("AND ");
            sqlFilter.append("(");
            sqlFilter.append("c.contact_id IN ( SELECT contact_id  FROM contact cnt WHERE cnt.org_id = ? ");
            if (this.getAvoidDisabledContacts() == 1) {
                sqlFilter.append("AND cnt.enabled = ? AND cnt.trashed_date IS NULL ");
            } else if (this.getAvoidDisabledContacts() == 0) {
                sqlFilter.append("AND (cnt.enabled = ? OR cnt.trashed_date IS NOT NULL) ");
            }
            sqlFilter.append(") ");
            sqlFilter.append("OR c.contact_id IS NULL) ");
        }
        if (this.hasAlertDate) {
            sqlFilter.append("AND c.alertdate IS NOT NULL ");
        }
        if (this.oppHeaderId != -1) {
            sqlFilter.append("AND c.opp_id = ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND c.enteredby = ? ");
        }
        if (this.alertDate != null) {
            sqlFilter.append("AND c.alertdate = ? ");
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND c.org_id = ? ");
        }
        if (this.owner != -1) {
            sqlFilter.append("AND c.owner = ? ");
        }
        if (this.alertRangeStart != null) {
            if (this.onlyCompleted) {
                sqlFilter.append("AND c.entered >= ? ");
            } else {
                sqlFilter.append("AND c.alertdate >= ? ");
            }
        }
        if (this.alertRangeEnd != null) {
            if (this.onlyCompleted) {
                sqlFilter.append("AND c.entered < ? ");
            } else {
                sqlFilter.append("AND c.alertdate < ? ");
            }
        }
        if (this.notificationRangeStart != null) {
            sqlFilter.append("AND c.followup_date >= ? ");
        }
        if (this.notificationRangeEnd != null) {
            sqlFilter.append("AND c.followup_date < ? ");
        }
        if (this.onlyPending) {
            sqlFilter.append("AND c.status_id = ? AND c.alertdate is NOT NULL ");
        }
        if (this.onlyCompleted) {
            sqlFilter.append("AND (c.status_id = ? OR c.status_id = ?) AND result_id IS NOT NULL ");
        }
        if (this.excludeCanceled) {
            sqlFilter.append("AND c.status_id != ? ");
        }
        if (this.onlyCompletedOrCanceled) {
            sqlFilter.append("AND (c.status_id = ?  OR  c.status_id = ? OR  c.status_id = ?) AND result_id is not NULL ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND c.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND c.trashed_date = ? ");
        } else {
            sqlFilter.append("AND c.trashed_date IS NULL ");
        }
        if (this.oppCallsOnly == 1) {
            sqlFilter.append("AND c.opp_id IS NOT NULL ");
        } else if (this.oppCallsOnly == 0) {
            sqlFilter.append("AND c.opp_id IS NULL ");
        }
        if (!this.allContactsInAccount) {
            if (this.getAvoidDisabledContacts() == 1) {
                sqlFilter.append("AND ct.enabled = ? AND ct.trashed_date IS NULL ");
            } else if (this.getAvoidDisabledContacts() == 0) {
                sqlFilter.append("AND (ct.enabled = ? OR ct.trashed_date IS NOT NULL) ");
            }
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
            pst.setInt(++i, this.contactId);
        }
        if (this.allContactsInAccount) {
            pst.setInt(++i, this.contactOrgId);
            if (this.getAvoidDisabledContacts() == 1) {
                pst.setBoolean(++i, true);
            } else if (this.getAvoidDisabledContacts() == 0) {
                pst.setBoolean(++i, false);
            }
        }
        if (this.oppHeaderId != -1) {
            pst.setInt(++i, this.oppHeaderId);
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.alertDate != null) {
            pst.setTimestamp(++i, this.alertDate);
        }
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.alertRangeStart != null) {
            pst.setTimestamp(++i, this.alertRangeStart);
        }
        if (this.alertRangeEnd != null) {
            pst.setTimestamp(++i, this.alertRangeEnd);
        }
        if (this.notificationRangeStart != null) {
            pst.setTimestamp(++i, this.notificationRangeStart);
        }
        if (this.notificationRangeEnd != null) {
            pst.setTimestamp(++i, this.notificationRangeEnd);
        }
        if (this.onlyPending) {
            pst.setInt(++i, 3);
        }
        if (this.onlyCompleted) {
            pst.setInt(++i, 3);
            pst.setInt(++i, 2);
        }
        if (this.excludeCanceled) {
            pst.setInt(++i, 1);
        }
        if (this.onlyCompletedOrCanceled) {
            pst.setInt(++i, 1);
            pst.setInt(++i, 2);
            pst.setInt(++i, 3);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (!this.allContactsInAccount) {
            if (this.getAvoidDisabledContacts() == 1) {
                pst.setBoolean(++i, true);
            } else if (this.getAvoidDisabledContacts() == 0) {
                pst.setBoolean(++i, false);
            }
        }
        return i;
    }

    public int reassignElements(Connection db, ActionContext context, int newOwner) throws SQLException {
        int total = 0;
        for (Call thisActivity : this) {
            if (!thisActivity.reassign(db, context, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, ActionContext context, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Call thisActivity : this) {
            thisActivity.setModifiedBy(userId);
            if (!thisActivity.reassign(db, context, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignAccount(Connection db, ActionContext context, int newOrgId) throws SQLException {
        int total = 0;
        for (Call thisActivity : this) {
            if (!thisActivity.reassignAccount(db, context, newOrgId)) continue;
            ++total;
        }
        return total;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (Call tmpCall : this) {
            tmpCall.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

