/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.ScheduledActions;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.mycfs.base.CallEventList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.CalendarView;

public class CallListScheduledActions
extends CallList
implements ScheduledActions {
    private ActionContext context = null;
    private CFSModule module = null;
    private int userId = -1;

    public void setModule(CFSModule tmp) {
        this.module = tmp;
    }

    public void setContext(ActionContext tmp) {
        this.context = tmp;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public ActionContext getContext() {
        return this.context;
    }

    public CFSModule getModule() {
        return this.module;
    }

    public int getUserId() {
        return this.userId;
    }

    public void buildAlerts(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CallListScheduledActions --> Building Call Alerts ");
        }
        try {
            CallEventList thisList;
            String alertDate;
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOnlyPending(true);
            this.setOwner(this.userId);
            this.buildShortList(db);
            for (Call thisCall : this) {
                alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisCall.getAlertDate());
                thisList = (CallEventList)companyCalendar.getEventList(alertDate, CalendarEventList.EVENT_TYPES[1]);
                thisList.getPendingCalls().add(thisCall);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("CallListScheduledActions-> Pending Call: " + thisCall.getAlertText() + " added on " + alertDate);
            }
            this.clear();
            this.setOnlyPending(false);
            this.setOnlyCompleted(true);
            this.setOwner(-1);
            this.setEnteredBy(this.userId);
            this.buildShortList(db);
            for (Call thisCall : this) {
                alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisCall.getEntered());
                thisList = (CallEventList)companyCalendar.getEventList(alertDate, CalendarEventList.EVENT_TYPES[1]);
                thisList.getCompletedCalls().add(thisCall);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("CallListScheduledActions-> Complete Call: " + thisCall.getSubject() + " added on " + alertDate);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Call Calendar Alerts: " + e.getMessage());
        }
    }

    public void buildAlertCount(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CallListScheduledActions --> Building Alert Counts ");
        }
        try {
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOwner(this.userId);
            this.setOnlyPending(true);
            HashMap pendingEvents = this.queryRecordCount(db, timeZone);
            for (String thisDay : pendingEvents.keySet()) {
                companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[13], pendingEvents.get(thisDay));
            }
            this.clear();
            this.setOnlyPending(false);
            this.setOnlyCompleted(true);
            this.setOwner(-1);
            this.setEnteredBy(this.userId);
            HashMap completedEvents = this.queryRecordCount(db, timeZone);
            for (String thisDay : completedEvents.keySet()) {
                companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[1], completedEvents.get(thisDay));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Call Calendar Alert Counts");
        }
    }
}

