/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.contacts.base.CallResult;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public class CallResultList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private boolean enabledOnly = false;
    private boolean canceledOnly = false;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnabledOnly(boolean tmp) {
        this.enabledOnly = tmp;
    }

    public void setEnabledOnly(String tmp) {
        this.enabledOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCanceledOnly(boolean canceledOnly) {
        this.canceledOnly = canceledOnly;
    }

    public boolean getCanceledOnly() {
        return this.canceledOnly;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public boolean getEnabledOnly() {
        return this.enabledOnly;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM lookup_call_result r WHERE result_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("r." + DatabaseUtils.addQuotes(db, "level") + ", r.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY r." + DatabaseUtils.addQuotes(db, "level") + ", r.description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("r.* FROM lookup_call_result r WHERE result_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CallResult thisResult = new CallResult(rs);
            this.add(thisResult);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabledOnly) {
            sqlFilter.append("AND r.enabled = ? ");
        }
        if (this.canceledOnly) {
            sqlFilter.append("AND r.canceled_type = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledOnly) {
            pst.setBoolean(++i, true);
        }
        if (this.canceledOnly) {
            pst.setBoolean(++i, true);
        }
        return i;
    }

    public LookupList getLookupList(int defaultKey) {
        LookupList select = new LookupList();
        for (CallResult thisResult : this) {
            if (thisResult.getEnabled()) {
                select.appendItem(thisResult.getId(), thisResult.getDescription());
                continue;
            }
            if (thisResult.getId() != defaultKey) continue;
            select.appendItem(thisResult.getId(), thisResult.getDescription() + " (X)");
        }
        return select;
    }

    public LookupList getCanceledLookupList(int defaultKey) {
        LookupList select = new LookupList();
        for (CallResult thisResult : this) {
            if (!thisResult.getCanceledType()) continue;
            if (thisResult.getEnabled()) {
                select.appendItem(thisResult.getId(), thisResult.getDescription());
                continue;
            }
            if (thisResult.getId() != defaultKey) continue;
            select.appendItem(thisResult.getId(), thisResult.getDescription() + " (X)");
        }
        return select;
    }

    public LookupList getCompletedLookupList(int defaultKey) {
        LookupList select = new LookupList();
        for (CallResult thisResult : this) {
            if (thisResult.getCanceledType()) continue;
            if (thisResult.getEnabled()) {
                select.appendItem(thisResult.getId(), thisResult.getDescription());
                continue;
            }
            if (thisResult.getId() != defaultKey) continue;
            select.appendItem(thisResult.getId(), thisResult.getDescription() + " (X)");
        }
        return select;
    }

    public int getIdFromValue(String value) {
        for (CallResult thisResult : this) {
            if (!value.equals(thisResult.getDescription())) continue;
            return thisResult.getId();
        }
        return -1;
    }
}

