/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationHistoryList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.base.Address;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.ExcludedRecipient;
import org.aspcfs.modules.communications.base.RecipientList;
import org.aspcfs.modules.communications.base.SurveyResponseList;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactHistoryList;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddress;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddress;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddressList;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.servicecontracts.base.ServiceContractList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class Contact
extends GenericBean {
    protected String permission = "contacts-external_contacts";
    public static final int EMPLOYEE_TYPE = 1;
    public static final int LEAD_TYPE = 2;
    public static final int LEAD_UNREAD = 0;
    public static final int LEAD_UNPROCESSED = 1;
    public static final int LEAD_ASSIGNED = 2;
    public static final int LEAD_TRASHED = 3;
    public static final int LEAD_WORKED = 4;
    private int id = -1;
    private int orgId = -1;
    private String orgName = "";
    private String company = "";
    private String accountNumber = "";
    private String title = "";
    private int department = -1;
    private String nameSalutation = "";
    private int listSalutation = -1;
    private int orgSiteId = -1;
    private boolean prospectClient = false;
    private boolean noEmail = false;
    private boolean noMail = false;
    private boolean noPhone = false;
    private boolean noTextMessage = false;
    private boolean noInstantMessage = false;
    private boolean noFax = false;
    private String nameFirst = "";
    private String nameMiddle = "";
    private String nameLast = "";
    private String nameSuffix = "";
    private int assistant = -1;
    private String additionalNames = "";
    private String nickname = "";
    private String role = "";
    private Timestamp birthDate = null;
    private String site = "";
    private String notes = "";
    private int locale = -1;
    private String employeeId = null;
    private int employmentType = -1;
    private String startOfDay = "";
    private String endOfDay = "";
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean hasAccount = false;
    private boolean excludedFromCampaign = false;
    private int owner = -1;
    private int custom1 = -1;
    private String url = null;
    private int userId = -1;
    private int accessType = -1;
    private int clientId = -1;
    private int statusId = -1;
    private int importId = -1;
    private boolean isLead = false;
    private int leadStatus = -1;
    private int source = -1;
    private int rating = -1;
    private String comments = null;
    private Timestamp conversionDate = null;
    private Timestamp assignedDate = null;
    private Timestamp leadTrashedDate = null;
    private String secretWord = null;
    private double revenue = 0.0;
    private double potential = 0.0;
    private int industryTempCode = -1;
    private String city = null;
    private String postalcode = null;
    private int siteId = -1;
    private String siteName = null;
    private ContactEmailAddressList emailAddressList = new ContactEmailAddressList();
    private ContactPhoneNumberList phoneNumberList = new ContactPhoneNumberList();
    private ContactAddressList addressList = new ContactAddressList();
    private ContactTextMessageAddressList textMessageAddressList = new ContactTextMessageAddressList();
    private ContactInstantMessageAddressList instantMessageAddressList = new ContactInstantMessageAddressList();
    private String departmentName = "";
    private String ownerName = "";
    private String enteredByName = "";
    private String modifiedByName = "";
    private String industryName = "";
    private String sourceName = "";
    private String ratingName = "";
    private boolean orgEnabled = true;
    private Timestamp orgTrashedDate = null;
    private boolean hasEnabledOwnerAccount = true;
    private boolean hasEnabledAccount = true;
    private boolean primaryContact = false;
    private boolean employee = false;
    private boolean hasOpportunities = false;
    private LookupList types = new LookupList();
    private ArrayList typeList = null;
    private boolean buildDetails = true;
    private boolean buildTypes = true;
    private boolean hasAccess = false;
    private boolean isEnabled = false;
    private Timestamp trashedDate = null;
    private boolean forceDelete = false;
    private boolean checkRevertingBackToLead = false;
    private int employees = -1;
    private String dunsType = null;
    private String dunsNumber = null;
    private String businessNameTwo = null;
    private int sicCode = -1;
    private int yearStarted = -1;
    private String sicDescription = null;
    private static long milies = -1L;

    public String getPermission() {
        if (this.orgId != -1) {
            this.permission = "accounts-accounts-contacts";
        } else if (this.employee) {
            this.permission = "contacts-internal_contacts";
        }
        return this.permission;
    }

    public String getIndustryName() {
        return this.industryName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getRatingName() {
        return this.ratingName;
    }

    public ContactInstantMessageAddressList getInstantMessageAddressList() {
        return this.instantMessageAddressList;
    }

    public void setInstantMessageAddressList(ContactInstantMessageAddressList tmp) {
        this.instantMessageAddressList = tmp;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public void setPostalcode(String tmp) {
        this.postalcode = tmp;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public Contact() {
    }

    public Contact(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Contact(Connection db, String contactId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(contactId));
    }

    public Contact(Connection db, int contactId) throws SQLException {
        this.queryRecord(db, contactId);
    }

    public boolean equals(Object obj) {
        return this.getId() == ((Contact)((Object)obj)).getId();
    }

    public void build(Connection db) throws SQLException {
        this.queryRecord(db, this.getId());
    }

    public void queryRecord(Connection db, int contactId) throws SQLException {
        if (contactId < 0) {
            throw new SQLException("Contact ID not specified.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c.*, o.enabled AS orgenabled, o.trashed_date AS orgtrasheddate, d.description as departmentname,  ca.city AS city,  ca.postalcode AS postalcode,  lsi.description AS site_id_name,  lind.description AS industry_name,  lcs.description AS source_name,  lcr.description AS rating_name FROM contact c LEFT JOIN organization o ON (c.org_id = o.org_id) LEFT JOIN lookup_department d ON (c.department = d.code) LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) LEFT JOIN lookup_site_id lsi ON (c.site_id = lsi.code) WHERE c.contact_id = ? AND (ca.address_id IS NULL OR ca.address_id IN ( SELECT cta.address_id FROM contact_address cta WHERE cta.contact_id = c.contact_id AND cta.primary_address = ?) OR ca.address_id IN (SELECT MIN(ctadd.address_id) FROM contact_address ctadd WHERE ctadd.contact_id = c.contact_id AND  ctadd.contact_id NOT IN (SELECT contact_id FROM contact_address WHERE contact_address.primary_address = ?))) ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, contactId);
        pst.setBoolean(2, true);
        pst.setBoolean(3, true);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildDetails) {
            this.phoneNumberList.setContactId(this.getId());
            this.phoneNumberList.buildList(db);
            this.addressList.setContactId(this.getId());
            this.addressList.buildList(db);
            this.emailAddressList.setContactId(this.getId());
            this.emailAddressList.buildList(db);
            this.textMessageAddressList.setContactId(this.getId());
            this.textMessageAddressList.buildList(db);
            this.instantMessageAddressList.setContactId(this.getId());
            this.instantMessageAddressList.buildList(db);
        }
        if (this.buildTypes) {
            this.buildTypes(db);
        }
    }

    public String getAdditionalNames() {
        return this.additionalNames;
    }

    public void setAdditionalNames(String tmp) {
        this.additionalNames = tmp;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String tmp) {
        this.nickname = tmp;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String tmp) {
        this.role = tmp;
    }

    public Timestamp getBirthDate() {
        return this.birthDate;
    }

    public String getSecretWord() {
        return this.secretWord;
    }

    public void setSecretWord(String tmp) {
        this.secretWord = tmp;
    }

    public void setRevenue(double tmp) {
        this.revenue = tmp;
    }

    public void setPotential(double tmp) {
        this.potential = tmp;
    }

    public void setPotential(String tmp) {
        this.potential = Double.parseDouble(tmp);
    }

    public void setIndustryTempCode(int tmp) {
        this.industryTempCode = tmp;
    }

    public void setIndustryTempCode(String tmp) {
        this.industryTempCode = Integer.parseInt(tmp);
    }

    public double getRevenue() {
        return this.revenue;
    }

    public double getPotential() {
        return this.potential;
    }

    public double getGrossPotential(int divisor) {
        return (double)Math.round(this.potential) / (double)divisor;
    }

    public int getIndustryTempCode() {
        return this.industryTempCode;
    }

    public void setBirthDate(Timestamp tmp) {
        this.birthDate = tmp;
    }

    public void setBirthDate(String tmp) {
        this.birthDate = DatabaseUtils.parseTimestamp(tmp, Locale.getDefault(), true);
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setHasEnabledOwnerAccount(boolean hasEnabledOwnerAccount) {
        this.hasEnabledOwnerAccount = hasEnabledOwnerAccount;
    }

    public void setNoEmail(boolean tmp) {
        this.noEmail = tmp;
    }

    public void setEmployee(boolean tmp) {
        this.employee = tmp;
    }

    public void setEmployee(String tmp) {
        this.employee = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNoMail(boolean tmp) {
        this.noMail = tmp;
    }

    public void setNoPhone(boolean tmp) {
        this.noPhone = tmp;
    }

    public void setNoPhone(String tmp) {
        this.noPhone = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNoTextMessage(boolean tmp) {
        this.noTextMessage = tmp;
    }

    public void setNoTextMessage(String tmp) {
        this.noTextMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNoInstantMessage(boolean tmp) {
        this.noInstantMessage = tmp;
    }

    public void setNoInstantMessage(String tmp) {
        this.noInstantMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNoFax(boolean tmp) {
        this.noFax = tmp;
    }

    public void setNoFax(String tmp) {
        this.noFax = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = Integer.parseInt(accessType);
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Integer.parseInt(clientId);
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public void setHasAccess(boolean tmp) {
        this.hasAccess = tmp;
    }

    public void setHasAccess(String tmp) {
        this.hasAccess = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIsEnabled(boolean tmp) {
        this.isEnabled = tmp;
    }

    public void setIsEnabled(String tmp) {
        this.isEnabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setForceDelete(boolean tmp) {
        this.forceDelete = tmp;
    }

    public void setForceDelete(String tmp) {
        this.forceDelete = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHasAccess() {
        return this.hasAccess;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public boolean getForceDelete() {
        return this.forceDelete;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getImportId() {
        return this.importId;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public String getAccessTypeString() {
        return String.valueOf(this.accessType);
    }

    public boolean getEmployee() {
        return this.employee;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getHasOpportunities() {
        return this.hasOpportunities;
    }

    public void setHasOpportunities(boolean hasOpportunities) {
        this.hasOpportunities = hasOpportunities;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPrimaryContact(boolean primaryContact) {
        this.primaryContact = primaryContact;
    }

    public void setPrimaryContact(String tmp) {
        this.primaryContact = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTypeList(ArrayList typeList) {
        this.typeList = typeList;
    }

    public ArrayList getTypeList() {
        return this.typeList;
    }

    public boolean getPrimaryContact() {
        return this.primaryContact;
    }

    public String getValidName() {
        String validName = StringUtils.toString(this.getNameLastFirst());
        if ("".equals(validName) && !"".equals(StringUtils.toString(this.company))) {
            validName = this.company;
        }
        return validName;
    }

    public String getFullNameAbbr() {
        StringBuffer out = new StringBuffer();
        if (this.getNameFirst() != null && this.getNameFirst().length() > 0) {
            out.append(this.getNameFirst().charAt(0) + ". ");
        }
        if (this.getNameLast() != null && this.getNameLast().length() > 0) {
            out.append(this.getNameLast());
        }
        return out.toString();
    }

    public int getCustom1() {
        return this.custom1;
    }

    public void setCustom1(int custom1) {
        this.custom1 = custom1;
    }

    public boolean hasEnabledAccount() {
        return this.hasEnabledAccount;
    }

    public void setHasEnabledAccount(boolean hasEnabledAccount) {
        this.hasEnabledAccount = hasEnabledAccount;
    }

    public void setCustom1(String custom1) {
        this.custom1 = Integer.parseInt(custom1);
    }

    public void setBuildDetails(boolean tmp) {
        this.buildDetails = tmp;
    }

    public void setBuildTypes(boolean tmp) {
        this.buildTypes = tmp;
    }

    public void setBuildTypes(String tmp) {
        this.buildTypes = DatabaseUtils.parseBoolean(tmp);
    }

    public String getBusinessNameTwo() {
        return this.businessNameTwo;
    }

    public String getDunsNumber() {
        return this.dunsNumber;
    }

    public String getDunsType() {
        return this.dunsType;
    }

    public int getEmployees() {
        return this.employees;
    }

    public int getSicCode() {
        return this.sicCode;
    }

    public int getYearStarted() {
        return this.yearStarted;
    }

    public void setSicDescription(String tmp) {
        this.sicDescription = tmp;
    }

    public String getSicDescription() {
        return this.sicDescription;
    }

    public void setBusinessNameTwo(String businessNameTwo) {
        this.businessNameTwo = businessNameTwo;
    }

    public void setDunsNumber(String dunsNumber) {
        this.dunsNumber = dunsNumber;
    }

    public void setDunsType(String dunsType) {
        this.dunsType = dunsType;
    }

    public void setEmployees(int employees) {
        this.employees = employees;
    }

    public void setEmployees(String employees) {
        try {
            this.employees = Integer.parseInt(employees);
        }
        catch (Exception e) {
            this.employees = 0;
        }
    }

    public void setSicCode(int sicCode) {
        this.sicCode = sicCode;
    }

    public void setSicCode(String sicCode) {
        this.sicCode = Integer.parseInt(sicCode);
    }

    public void setYearStarted(int yearStarted) {
        this.yearStarted = yearStarted;
    }

    public void setYearStarted(String yearStarted) {
        if (!"".equals(yearStarted) && yearStarted != null) {
            this.yearStarted = Integer.parseInt(yearStarted);
        }
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getOwner() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getOwner());
        pst.setBoolean(2, true);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
        this.addressList.setContactId(tmp);
        this.phoneNumberList.setContactId(tmp);
        this.emailAddressList.setContactId(tmp);
        this.textMessageAddressList.setContactId(tmp);
        this.instantMessageAddressList.setContactId(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        if (tmp != null) {
            this.orgId = Integer.parseInt(tmp);
        }
    }

    public void setProspectClient(boolean prospectClient) {
        this.prospectClient = prospectClient;
    }

    public boolean getProspectClient() {
        return this.prospectClient;
    }

    public void setListSalutation(String tmp) {
        if (tmp != null) {
            this.listSalutation = Integer.parseInt(tmp);
        }
    }

    public void setListSalutation(int tmp) {
        this.listSalutation = tmp;
    }

    public void setOrgSiteId(int orgSiteId) {
        this.orgSiteId = orgSiteId;
    }

    public void setOrgSiteId(String tmp) {
        this.orgSiteId = Integer.parseInt(tmp);
    }

    public int getOrgSiteId() {
        return this.orgSiteId;
    }

    public void setModifiedByName(String modifiedByName) {
        this.modifiedByName = modifiedByName;
    }

    public void setNameSalutation(String tmp) {
        this.nameSalutation = tmp;
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setEnteredByName(String enteredByName) {
        this.enteredByName = enteredByName;
    }

    public void setNameMiddle(String tmp) {
        this.nameMiddle = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setNameSuffix(String tmp) {
        this.nameSuffix = tmp;
    }

    public int getAssistant() {
        return this.assistant;
    }

    public void setAssistant(int tmp) {
        this.assistant = tmp;
    }

    public void setAssistant(String tmp) {
        this.assistant = Integer.parseInt(tmp);
    }

    public void setCompany(String tmp) {
        this.company = tmp;
    }

    public void setAccountNumber(String tmp) {
        this.accountNumber = tmp;
    }

    public void setTitle(String tmp) {
        if (tmp != null && tmp.length() > 80) {
            tmp = tmp.substring(0, 79);
        }
        this.title = tmp;
    }

    public void setDepartmentName(String tmp) {
        this.departmentName = tmp;
    }

    public void setDepartment(int tmp) {
        this.department = tmp;
    }

    public void setDepartment(String tmp) {
        this.department = Integer.parseInt(tmp);
    }

    public void setEmailAddressList(ContactEmailAddressList tmp) {
        this.emailAddressList = tmp;
    }

    public void setPhoneNumberList(ContactPhoneNumberList tmp) {
        this.phoneNumberList = tmp;
    }

    public void setTextMessageAddressList(ContactTextMessageAddressList tmp) {
        this.textMessageAddressList = tmp;
    }

    public boolean getOrgEnabled() {
        return this.orgEnabled;
    }

    public Timestamp getOrgTrashedDate() {
        return this.orgTrashedDate;
    }

    public boolean getNoEmail() {
        return this.noEmail;
    }

    public void setNoEmail(String tmp) {
        this.noEmail = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNoMail(String tmp) {
        this.noMail = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getNoMail() {
        return this.noMail;
    }

    public boolean getNoPhone() {
        return this.noPhone;
    }

    public boolean getNoTextMessage() {
        return this.noTextMessage;
    }

    public boolean getNoInstantMessage() {
        return this.noInstantMessage;
    }

    public boolean getNoFax() {
        return this.noFax;
    }

    public void setOrgEnabled(boolean orgEnabled) {
        this.orgEnabled = orgEnabled;
    }

    public void setOrgTrashedDate(Timestamp tmp) {
        this.orgTrashedDate = tmp;
    }

    public void setOrgTrashedDate(String tmp) {
        this.orgTrashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setExcludedFromCampaign(boolean excludedFromCampaign) {
        this.excludedFromCampaign = excludedFromCampaign;
    }

    public void setAddressList(ContactAddressList tmp) {
        this.addressList = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setSite(String tmp) {
        this.site = tmp;
    }

    public void setEmploymentType(int tmp) {
        this.employmentType = tmp;
    }

    public void setEmploymentType(String tmp) {
        this.employmentType = Integer.parseInt(tmp);
    }

    public void setLocale(int tmp) {
        this.locale = tmp;
    }

    public void setLocale(String tmp) {
        this.locale = Integer.parseInt(tmp);
    }

    public void setEmployeeId(String tmp) {
        this.employeeId = tmp;
    }

    public void setStartOfDay(String tmp) {
        this.startOfDay = tmp;
    }

    public void setEndOfDay(String tmp) {
        this.endOfDay = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setHasAccount(boolean tmp) {
        this.hasAccount = tmp;
    }

    public boolean isApproved() {
        return this.statusId != 6;
    }

    public void setRequestItems(ActionContext context) {
        this.phoneNumberList = new ContactPhoneNumberList(context);
        this.addressList = new ContactAddressList(context.getRequest());
        this.emailAddressList = new ContactEmailAddressList(context.getRequest());
        this.textMessageAddressList = new ContactTextMessageAddressList(context.getRequest());
        this.instantMessageAddressList = new ContactInstantMessageAddressList(context.getRequest());
    }

    public void setTypeList(String[] criteriaString) {
        if (criteriaString != null) {
            String[] params = criteriaString;
            this.typeList = new ArrayList<String>(Arrays.asList(params));
        } else {
            this.typeList = new ArrayList();
        }
    }

    public void addType(int typeId) {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        this.typeList.add(String.valueOf(typeId));
    }

    public void addType(String typeId) {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        this.typeList.add(typeId);
    }

    public String getTypesNameString() {
        StringBuffer types = new StringBuffer();
        Iterator i = this.getTypes().iterator();
        while (i.hasNext()) {
            LookupElement thisElt = (LookupElement)i.next();
            types.append(thisElt.getDescription());
            if (!i.hasNext()) continue;
            types.append(", ");
        }
        return types.toString();
    }

    public boolean hasType(int type) {
        boolean gotType = false;
        for (LookupElement thisElt : this.getTypes()) {
            if (thisElt.getCode() != type) continue;
            gotType = true;
            break;
        }
        return gotType;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setTypes(LookupList types) {
        this.types = types;
    }

    public LookupList getTypes() {
        return this.types;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getOwner() {
        return this.owner;
    }

    public String getOwnerString() {
        return String.valueOf(this.owner);
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getListSalutation() {
        return this.listSalutation;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getNameSalutation() {
        return this.nameSalutation;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameMiddle() {
        return this.nameMiddle;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String getNameFull() {
        StringBuffer out = new StringBuffer();
        if (this.nameSalutation != null && this.nameSalutation.length() > 0) {
            out.append(this.nameSalutation + " ");
        }
        if (this.nameFirst != null && this.nameFirst.length() > 0) {
            out.append(this.nameFirst + " ");
        }
        if (this.nameMiddle != null && this.nameMiddle.length() > 0) {
            out.append(this.nameMiddle + " ");
        }
        if (this.nameLast != null && this.nameLast.length() > 0) {
            out.append(this.nameLast + " ");
        }
        if (this.nameSuffix != null && this.nameSuffix.length() > 0) {
            out.append(this.nameSuffix + " ");
        }
        if (out.toString().length() == 0) {
            return this.company;
        }
        return out.toString().trim();
    }

    public String getNameFirstLast() {
        StringBuffer out = new StringBuffer();
        if (this.nameFirst != null && this.nameFirst.length() > 0) {
            out.append(this.nameFirst + " ");
        }
        if (this.nameLast != null && this.nameLast.length() > 0) {
            out.append(this.nameLast);
        }
        if (out.toString().length() == 0) {
            return this.company;
        }
        return out.toString().trim();
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        thisList.add("owner");
        return thisList;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("birthDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("revenue");
        thisList.add("potential");
        return thisList;
    }

    public String getNameFirstInitialLast() {
        StringBuffer out = new StringBuffer();
        if (this.nameFirst != null && this.nameFirst.trim().length() > 0) {
            out.append(String.valueOf(this.nameFirst.charAt(0)) + ".");
        }
        if (this.nameLast != null && this.nameLast.trim().length() > 0) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.nameLast);
        }
        if (out.toString().length() == 0) {
            return null;
        }
        return out.toString().trim();
    }

    public String getNameLastFirst() {
        return Contact.getNameLastFirst(this.nameLast, this.nameFirst);
    }

    public String getCompany() {
        if (this.company == null || this.company.trim().equals("")) {
            return this.orgName;
        }
        return this.company;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getAffiliation() {
        if (this.orgId > -1) {
            return this.orgName;
        }
        return this.company;
    }

    public String getCompanyOnly() {
        return this.company;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public int getDepartment() {
        return this.department;
    }

    public ContactEmailAddressList getEmailAddressList() {
        return this.emailAddressList;
    }

    public String getPhoneNumber(String thisType) {
        return this.phoneNumberList.getPhoneNumber(thisType);
    }

    public void resetBaseInfo() {
        this.nameFirst = null;
        this.nameLast = null;
        this.nameMiddle = null;
        this.nameSalutation = null;
        this.nameSuffix = null;
        this.id = -1;
        this.notes = null;
        this.title = null;
        for (ContactEmailAddress thisAddress : this.emailAddressList) {
            thisAddress.setId(-1);
        }
        for (ContactPhoneNumber thisNumber : this.phoneNumberList) {
            thisNumber.setId(-1);
        }
        for (ContactAddress thisAddress : this.addressList) {
            thisAddress.setId(-1);
        }
        for (ContactTextMessageAddress thisAddress : this.textMessageAddressList) {
            thisAddress.setId(-1);
        }
        for (ContactInstantMessageAddress thisAddress : this.instantMessageAddressList) {
            thisAddress.setId(-1);
        }
    }

    public String getPhoneNumber(int position) {
        return this.phoneNumberList.getPhoneNumber(position);
    }

    public String getEmailAddress(String thisType) {
        return this.emailAddressList.getEmailAddress(thisType);
    }

    public String getEmailAddressTag(String thisType, String linkText, String noLinkText) {
        String tmpAddress = this.emailAddressList.getEmailAddress(thisType);
        if ("".equals(thisType) && !"".equals(linkText) && !"&nbsp;".equals(linkText) && linkText != null) {
            return "<a href=\"mailto:" + this.getPrimaryEmailAddress() + "\">" + linkText + "</a>";
        }
        if (tmpAddress != null && !"".equals(tmpAddress)) {
            return "<a href=\"mailto:" + this.getEmailAddress(thisType) + "\">" + linkText + "</a>";
        }
        return noLinkText;
    }

    public String getEmailAddress(int thisPosition) {
        return this.emailAddressList.getEmailAddress(thisPosition);
    }

    public int getEmailAddressTypeId(int thisPosition) {
        return this.emailAddressList.getEmailAddressTypeId(thisPosition);
    }

    public Address getAddress(String thisType) {
        return this.addressList.getAddress(thisType);
    }

    public String getPrimaryEmailAddress() {
        return this.emailAddressList.getPrimaryEmailAddress();
    }

    public String getPrimaryPhoneNumber() {
        return this.phoneNumberList.getPrimaryPhoneNumber();
    }

    public String getPrimaryTextMessageAddress() {
        return this.textMessageAddressList.getPrimaryTextMessageAddress();
    }

    public String getPrimaryInstantMessageAddress() {
        return this.instantMessageAddressList.getPrimaryInstantMessageAddress();
    }

    public Address getPrimaryAddress() {
        return this.addressList.getPrimaryAddress();
    }

    public ContactAddressList getAddressList() {
        return this.addressList;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getSite() {
        return this.site;
    }

    public int getEmploymentType() {
        return this.employmentType;
    }

    public int getLocale() {
        return this.locale;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getStartOfDay() {
        return this.startOfDay;
    }

    public String getEndOfDay() {
        return this.endOfDay;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public ContactPhoneNumberList getPhoneNumberList() {
        return this.phoneNumberList;
    }

    public ContactTextMessageAddressList getTextMessageAddressList() {
        return this.textMessageAddressList;
    }

    public int getTextMessageAddressTypeId(int thisPosition) {
        return this.textMessageAddressList.getTextMessageAddressTypeId(thisPosition);
    }

    public int getInstantMessageAddressTypeId(int thisPosition) {
        return this.instantMessageAddressList.getInstantMessageAddressTypeId(thisPosition);
    }

    public int getInstantMessageAddressServiceId(int thisPosition) {
        return this.instantMessageAddressList.getInstantMessageAddressServiceId(thisPosition);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean excludedFromCampaign() {
        return this.getExcludedFromCampaign();
    }

    public boolean getExcludedFromCampaign() {
        return this.excludedFromCampaign;
    }

    public boolean getIsLead() {
        return this.isLead;
    }

    public void setIsLead(boolean tmp) {
        this.isLead = tmp;
    }

    public void setIsLead(String tmp) {
        this.isLead = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLeadStatus() {
        return this.leadStatus;
    }

    public void setLeadStatus(int tmp) {
        this.leadStatus = tmp;
    }

    public void setLeadStatus(String tmp) {
        this.leadStatus = Integer.parseInt(tmp);
    }

    public String getLeadStatusString() {
        if (this.leadStatus == 2) {
            return "Assigned";
        }
        if (this.leadStatus == 3) {
            return "Archived";
        }
        if (this.leadStatus == 1) {
            return "Unprocessed";
        }
        return "Error";
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int tmp) {
        this.source = tmp;
    }

    public void setSource(String tmp) {
        this.source = Integer.parseInt(tmp);
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int tmp) {
        this.rating = tmp;
    }

    public void setRating(String tmp) {
        this.rating = Integer.parseInt(tmp);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public Timestamp getConversionDate() {
        return this.conversionDate;
    }

    public void setConversionDate(Timestamp tmp) {
        this.conversionDate = tmp;
    }

    public void setConversionDate(String tmp) {
        this.conversionDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getAssignedDate() {
        return this.assignedDate;
    }

    public void setAssignedDate(Timestamp tmp) {
        this.assignedDate = tmp;
    }

    public void setAssignedDate(String tmp) {
        this.assignedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getLeadTrashedDate() {
        return this.leadTrashedDate;
    }

    public void setLeadTrashedDate(Timestamp tmp) {
        this.leadTrashedDate = tmp;
    }

    public void setLeadTrashedDate(String tmp) {
        this.leadTrashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public boolean getCheckRevertingBackToLead() {
        return this.checkRevertingBackToLead;
    }

    public void setCheckRevertingBackToLead(boolean tmp) {
        this.checkRevertingBackToLead = tmp;
    }

    public void setCheckRevertingBackToLead(String tmp) {
        this.checkRevertingBackToLead = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean toggleExcluded(Connection db, int campaignId) throws SQLException {
        if (this.id == -1) {
            return false;
        }
        ExcludedRecipient thisRecipient = new ExcludedRecipient();
        thisRecipient.setCampaignId(campaignId);
        thisRecipient.setContactId(this.getId());
        if (this.excludedFromCampaign()) {
            thisRecipient.delete(db);
        } else {
            thisRecipient.insert(db);
        }
        this.excludedFromCampaign = !this.excludedFromCampaign;
        return true;
    }

    public boolean hasAccount() {
        return this.hasAccount;
    }

    public void buildPhoneNumberList(Connection db) throws SQLException {
        this.phoneNumberList.setContactId(this.getId());
        this.phoneNumberList.buildList(db);
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "contact_contact_id_seq");
            sql.append("INSERT INTO contact (user_id, namefirst, namelast, owner, primary_contact, org_name, account_number, ");
            sql.append("access_type, source, rating, comments, assigned_date, conversion_date, lead_trashed_date, trashed_date, ");
            if (this.id > -1) {
                sql.append("contact_id, ");
            }
            sql.append("additional_names, nickname, birthdate, " + DatabaseUtils.addQuotes(db, "role") + ", site_id, " + "revenue, industry_temp_code, potential, ");
            sql.append("employees, duns_type, duns_number, business_name_two, year_started, sic_code, sic_description, ");
            if (this.getIsLead()) {
                sql.append("lead, lead_status,");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            if (this.employee || this.orgId == 0) {
                sql.append("employee, ");
            }
            if (this.statusId > -1) {
                sql.append("status_id, ");
            }
            if (this.importId > -1) {
                sql.append("import_id, ");
            }
            if (this.secretWord != null) {
                sql.append("secret_word, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?, ?, ?, ?, ?, ?, ");
            sql.append("?,?,?,?,?,?,?,");
            if (this.getIsLead()) {
                sql.append("?, ?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            if (this.employee || this.orgId == 0) {
                sql.append("?, ");
            }
            if (this.statusId > -1) {
                sql.append("?, ");
            }
            if (this.importId > -1) {
                sql.append("?, ");
            }
            if (this.secretWord != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getUserId());
            pst.setString(++i, this.getNameFirst());
            pst.setString(++i, this.getNameLast());
            DatabaseUtils.setInt(pst, ++i, this.getOwner());
            pst.setBoolean(++i, this.getPrimaryContact());
            if (this.orgId > 0) {
                pst.setString(++i, this.orgName);
            } else {
                pst.setString(++i, this.company);
            }
            pst.setString(++i, this.accountNumber);
            pst.setInt(++i, this.accessType);
            DatabaseUtils.setInt(pst, ++i, this.getSource());
            DatabaseUtils.setInt(pst, ++i, this.getRating());
            pst.setString(++i, this.getComments());
            DatabaseUtils.setTimestamp(pst, ++i, this.getAssignedDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getConversionDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getLeadTrashedDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.getAdditionalNames());
            pst.setString(++i, this.getNickname());
            pst.setTimestamp(++i, this.getBirthDate());
            pst.setString(++i, this.getRole());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            pst.setDouble(++i, this.getRevenue());
            DatabaseUtils.setInt(pst, ++i, this.getIndustryTempCode());
            pst.setDouble(++i, this.getPotential());
            DatabaseUtils.setInt(pst, ++i, this.getEmployees());
            pst.setString(++i, this.getDunsType());
            pst.setString(++i, this.getDunsNumber());
            pst.setString(++i, this.getBusinessNameTwo());
            pst.setInt(++i, this.getYearStarted());
            DatabaseUtils.setInt(pst, ++i, this.getSicCode());
            pst.setString(++i, this.getSicDescription());
            if (this.getIsLead()) {
                pst.setBoolean(++i, this.getIsLead());
                DatabaseUtils.setInt(pst, ++i, this.getLeadStatus());
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            if (this.employee || this.orgId == 0) {
                pst.setBoolean(++i, true);
            }
            if (this.statusId > -1) {
                pst.setInt(++i, this.getStatusId());
            }
            if (this.importId > -1) {
                pst.setInt(++i, this.getImportId());
            }
            if (this.secretWord != null) {
                pst.setString(++i, this.getSecretWord());
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "contact_contact_id_seq", this.id);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Contact-> ContactID: " + this.getId());
            }
            for (ContactPhoneNumber thisPhoneNumber : this.phoneNumberList) {
                thisPhoneNumber.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            for (ContactAddress thisAddress : this.addressList) {
                thisAddress.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            for (ContactEmailAddress thisEmailAddress : this.emailAddressList) {
                thisEmailAddress.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            for (ContactTextMessageAddress thisTextMessageAddress : this.textMessageAddressList) {
                thisTextMessageAddress.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            for (ContactInstantMessageAddress thisInstantMessageAddress : this.instantMessageAddressList) {
                thisInstantMessageAddress.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            this.update(db, true);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        boolean doCommit = false;
        try {
            Organization thisOrg;
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db, false);
            if (!(!this.getPrimaryContact() || this.getIsLead() || this.getEmployee() || (thisOrg = new Organization(db, this.getOrgId())).getNameFirst() != null && this.getNameFirst() != null && thisOrg.getNameFirst().equals(this.getNameFirst()) && thisOrg.getNameLast() != null && this.getNameLast() != null && thisOrg.getNameLast().equals(this.getNameLast()) && thisOrg.getNameMiddle() != null && this.getNameMiddle() != null && thisOrg.getNameMiddle().equals(this.getNameMiddle()) && (thisOrg.getOwnerId() == this.getOwner() || this.getLeadStatus() <= -1))) {
                thisOrg.setNameFirst(this.getNameFirst());
                thisOrg.setNameLast(this.getNameLast());
                thisOrg.setNameMiddle(this.getNameMiddle());
                thisOrg.setName(thisOrg.getNameLastFirstMiddle());
                if (this.getLeadStatus() != -1) {
                    thisOrg.setOwner(this.getOwner());
                }
                thisOrg.update(db);
            }
            this.processPhoneNumbers(db);
            this.processAddress(db);
            this.processEmailAddress(db);
            this.processTextMessageAddress(db);
            this.processInstantMessageAddress(db);
            if (doCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    void processPhoneNumbers(Connection db) throws SQLException {
        for (ContactPhoneNumber thisPhoneNumber : this.phoneNumberList) {
            thisPhoneNumber.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    void processAddress(Connection db) throws SQLException {
        for (ContactAddress thisAddress : this.addressList) {
            thisAddress.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    void processEmailAddress(Connection db) throws SQLException {
        for (ContactEmailAddress thisEmailAddress : this.emailAddressList) {
            thisEmailAddress.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    void processTextMessageAddress(Connection db) throws SQLException {
        for (ContactTextMessageAddress thistextMessageAddress : this.textMessageAddressList) {
            thistextMessageAddress.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    void processInstantMessageAddress(Connection db) throws SQLException {
        for (ContactInstantMessageAddress thisInstantMessageAddress : this.instantMessageAddressList) {
            thisInstantMessageAddress.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            if (this.orgId == -1) {
                if (this.hasRelatedRecords(db)) {
                    this.disable(db);
                } else {
                    this.deleteFromDatabase(db, baseFilePath);
                }
            } else if (this.orgId > 0) {
                this.checkUserAccount(db);
                if (this.hasAccount) {
                    User tmpUser = new User(db, this.userId);
                    tmpUser.disable(db);
                    this.disable(db);
                    if (this.forceDelete) {
                        this.setOrgId(-1);
                        this.setCompany(this.getOrgName());
                        if (this.getPrimaryContact()) {
                            this.setPrimaryContact(false);
                        }
                        this.update(db, false);
                    }
                } else if (this.hasRelatedRecords(db)) {
                    this.disable(db);
                    if (this.forceDelete) {
                        this.setOrgId(-1);
                        this.setCompany(this.getOrgName());
                        this.setOrgName("");
                        if (this.getPrimaryContact()) {
                            this.setPrimaryContact(false);
                        }
                        this.update(db, false);
                    }
                } else {
                    this.deleteFromDatabase(db, baseFilePath);
                }
            } else if (this.orgId == 0) {
                this.checkUserAccount(db);
                if (this.hasAccount) {
                    User tmpUser = new User(db, this.userId);
                    tmpUser.disable(db);
                    this.disable(db);
                } else if (this.hasRelatedRecords(db)) {
                    this.disable(db);
                } else {
                    this.deleteFromDatabase(db, baseFilePath);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    private void deleteFromDatabase(Connection db, String baseFilePath) throws SQLException {
        CustomFieldRecordList folderList = new CustomFieldRecordList();
        folderList.setLinkModuleId(2);
        folderList.setLinkItemId(this.getId());
        folderList.buildList(db);
        folderList.delete(db);
        folderList = null;
        CallList callList = new CallList();
        callList.setContactId(this.getId());
        if (this.getOrgId() != -1) {
            callList.setOppCallsOnly(0);
        }
        if (this.isTrashed()) {
            callList.setIncludeOnlyTrashed(true);
        }
        callList.buildList(db);
        callList.delete(db);
        callList = null;
        if (this.getOrgId() == -1) {
            OpportunityHeaderList opportunityHeaderList = new OpportunityHeaderList();
            opportunityHeaderList.setContactId(this.id);
            opportunityHeaderList.buildList(db);
            opportunityHeaderList.delete(db, null, baseFilePath);
            opportunityHeaderList = new OpportunityHeaderList();
            opportunityHeaderList.setContactId(this.id);
            opportunityHeaderList.setIncludeOnlyTrashed(true);
            opportunityHeaderList.buildList(db);
            opportunityHeaderList.delete(db, null, baseFilePath);
        }
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM contact_phone WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_emailaddress WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_address WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_textmessageaddress WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_imaddress WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        int fieldId = -1;
        pst = db.prepareStatement("SELECT id FROM search_fields WHERE description = ? ");
        pst.setString(1, "Contact ID");
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            fieldId = rs.getInt("id");
        }
        rs.close();
        pst.close();
        if (fieldId > -1) {
            pst = db.prepareStatement("DELETE FROM saved_criteriaelement WHERE field = ? AND value_id = ? ");
            pst.setInt(1, fieldId);
            pst.setInt(2, this.getId());
            pst.execute();
            pst.close();
        }
        pst = db.prepareStatement("DELETE FROM excluded_recipient WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_type_levels WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM tasklink_contact WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM history WHERE link_object_id = ? AND link_item_id IN ( SELECT id FROM cfsinbox_messagelink WHERE sent_to = ?) ");
        pst.setInt(1, 14);
        pst.setInt(2, this.getId());
        boolean result = pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM cfsinbox_messagelink WHERE sent_to = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM action_item_log WHERE item_id IN (SELECT item_id FROM action_item WHERE link_item_id = ?) ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM action_item WHERE link_item_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM history WHERE contact_id = ?");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        int i = 0;
        pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
        DatabaseUtils.setInt(pst, ++i, -1);
        pst.setInt(++i, 2);
        pst.setInt(++i, this.getId());
        pst.executeUpdate();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact WHERE contact_id = ?");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
    }

    public boolean resetType(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Contact ID not specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM contact_type_levels WHERE contact_id = ? ");
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        i = 0;
        pst = db.prepareStatement("UPDATE contact set employee = ? WHERE contact_id = ? ");
        pst.setBoolean(++i, false);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean insertType(Connection db, int type_id, int level) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("No Contact ID Specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO contact_type_levels (contact_id, type_id, " + DatabaseUtils.addQuotes(db, "level") + ") " + "VALUES (?, ?, ?) ");
        pst.setInt(++i, this.getId());
        pst.setInt(++i, type_id);
        pst.setInt(++i, level);
        pst.execute();
        pst.close();
        return true;
    }

    public void checkUserAccount(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            this.userId = rs.getInt("user_id");
            this.setHasAccount(true);
        } else {
            this.userId = -1;
            this.setHasAccount(false);
        }
        rs.close();
        pst.close();
    }

    public void buildTypes(Connection db) throws SQLException {
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ctl.type_id, lct.description, lct.enabled FROM contact_type_levels ctl LEFT JOIN lookup_contact_types lct ON ctl.type_id = lct.code WHERE ctl.contact_id = ? ORDER BY ctl." + DatabaseUtils.addQuotes(db, "level") + " ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.id);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        while (rs.next()) {
            LookupElement thisType = new LookupElement();
            thisType.setCode(rs.getInt("type_id"));
            thisType.setDescription(rs.getString("description"));
            thisType.setEnabled(rs.getBoolean("enabled"));
            this.types.add(thisType);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("Contact-> Built contact type: contact/" + this.id + " type/" + thisType.getCode() + " " + thisType.getDescription());
        }
        rs.close();
        pst.close();
    }

    public void checkEnabledUserAccount(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        this.checkUserAccount(db);
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE contact_id = ? " + "AND enabled = ? ");
        pst.setInt(1, this.getId());
        pst.setBoolean(2, true);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            this.setHasEnabledAccount(true);
        } else {
            this.setHasEnabledAccount(false);
        }
        rs.close();
        pst.close();
    }

    public void checkExcludedFromCampaign(Connection db, int campaignId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM excluded_recipient WHERE contact_id = ? AND campaign_id = ? ");
        pst.setInt(1, this.getId());
        pst.setInt(2, campaignId);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            this.setExcludedFromCampaign(true);
        } else {
            this.setExcludedFromCampaign(false);
        }
        rs.close();
        pst.close();
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Contact ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE contact SET company = ?, title = ?, department = ?, namesalutation = ?, namefirst = ?, namelast = ?, namemiddle = ?, namesuffix = ?, notes = ?, owner = ?, custom1 = ?, url = ?, org_id = ?, primary_contact = ?, org_name = ?, access_type = ?,");
        sql.append("source = ?, rating = ?, comments = ?, assigned_date = ?, conversion_date = ?, lead_trashed_date = ?, lead = ?, lead_status = ?, industry_temp_code = ?, potential = ?, ");
        sql.append("no_email = ?, no_mail = ?, no_phone = ?, no_textmessage = ?, no_im = ?, no_fax = ?, ");
        sql.append("trashed_date = ?, additional_names = ?, nickname = ?, birthdate = ?, " + DatabaseUtils.addQuotes(db, "role") + " = ?, employee_id = ?, site_id = ?, ");
        if (this.locale > -1) {
            sql.append("locale = ?, ");
        }
        if (this.employmentType > -1) {
            sql.append("employmentType = ?, ");
        }
        if (this.secretWord != null) {
            sql.append("secret_word = ?, ");
        }
        sql.append("startofday = ?, endofday = ?, ");
        sql.append("employees = ?, duns_type = ?, duns_number = ?, business_name_two = ?, year_started = ?, sic_code = ?, sic_description = ?, ");
        if (!override) {
            sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        }
        sql.append("modifiedby = ? WHERE contact_id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (this.orgId <= 0) {
            pst.setString(++i, this.getCompany());
        } else {
            pst.setNull(++i, 12);
        }
        pst.setString(++i, this.getTitle());
        if (this.department > 0) {
            pst.setInt(++i, this.getDepartment());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getNameSalutation());
        pst.setString(++i, this.getNameFirst());
        pst.setString(++i, this.getNameLast());
        pst.setString(++i, this.getNameMiddle());
        pst.setString(++i, this.getNameSuffix());
        pst.setString(++i, this.getNotes());
        DatabaseUtils.setInt(pst, ++i, this.getOwner());
        pst.setInt(++i, this.getCustom1());
        pst.setString(++i, this.getUrl());
        DatabaseUtils.setInt(pst, ++i, this.orgId);
        pst.setBoolean(++i, this.getPrimaryContact());
        if (this.orgId > 0) {
            pst.setString(++i, this.orgName);
        } else {
            pst.setString(++i, this.company);
        }
        pst.setInt(++i, this.accessType);
        DatabaseUtils.setInt(pst, ++i, this.getSource());
        DatabaseUtils.setInt(pst, ++i, this.getRating());
        pst.setString(++i, this.getComments());
        DatabaseUtils.setTimestamp(pst, ++i, this.getAssignedDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getConversionDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getLeadTrashedDate());
        pst.setBoolean(++i, this.getIsLead());
        DatabaseUtils.setInt(pst, ++i, this.getLeadStatus());
        DatabaseUtils.setInt(pst, ++i, this.getIndustryTempCode());
        pst.setDouble(++i, this.getPotential());
        pst.setBoolean(++i, this.getNoEmail());
        pst.setBoolean(++i, this.getNoMail());
        pst.setBoolean(++i, this.getNoPhone());
        pst.setBoolean(++i, this.getNoTextMessage());
        pst.setBoolean(++i, this.getNoInstantMessage());
        pst.setBoolean(++i, this.getNoFax());
        DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
        pst.setString(++i, this.getAdditionalNames());
        pst.setString(++i, this.getNickname());
        pst.setTimestamp(++i, this.getBirthDate());
        pst.setString(++i, this.getRole());
        if (this.employeeId != null && !"".equals(this.employeeId.trim())) {
            pst.setString(++i, this.getEmployeeId());
        } else {
            pst.setString(++i, null);
        }
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        if (this.locale > -1) {
            pst.setInt(++i, this.getLocale());
        }
        if (this.employmentType > -1) {
            pst.setInt(++i, this.getEmploymentType());
        }
        if (this.secretWord != null) {
            pst.setString(++i, this.getSecretWord());
        }
        pst.setString(++i, this.getStartOfDay());
        pst.setString(++i, this.getEndOfDay());
        DatabaseUtils.setInt(pst, ++i, this.getEmployees());
        pst.setString(++i, this.getDunsType());
        pst.setString(++i, this.getDunsNumber());
        pst.setString(++i, this.getBusinessNameTwo());
        pst.setInt(++i, this.getYearStarted());
        DatabaseUtils.setInt(pst, ++i, this.getSicCode());
        pst.setString(++i, this.getSicDescription());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        if (this.typeList != null) {
            this.resetType(db);
            int lvlcount = 0;
            for (int k = 0; k < this.typeList.size(); ++k) {
                String val = (String)this.typeList.get(k);
                if (val != null && !val.equals("")) {
                    int type_id = Integer.parseInt((String)this.typeList.get(k));
                    this.insertType(db, type_id, ++lvlcount);
                    continue;
                }
                --lvlcount;
            }
        }
        return resultCount;
    }

    public void updateNameandAddress(Connection db) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE contact SET secret_word = ?, additional_names = ?, nickname = ?, birthdate = ?, title = ?, " + DatabaseUtils.addQuotes(db, "role") + " = ?, " + "information_update_date = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE contact_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getSecretWord());
        pst.setString(++i, this.getAdditionalNames());
        pst.setString(++i, this.getNickname());
        pst.setTimestamp(++i, this.getBirthDate());
        pst.setString(++i, this.getTitle());
        pst.setString(++i, this.getRole());
        pst.setInt(++i, this.getId());
        pst.executeUpdate();
        pst.close();
        this.processPhoneNumbers(db);
        this.processAddress(db);
        this.processEmailAddress(db);
        this.processInstantMessageAddress(db);
        this.processTextMessageAddress(db);
    }

    protected void buildShortRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("contact_id"));
        this.userId = DatabaseUtils.getInt(rs, "user_id");
        this.nameLast = rs.getString("namelast");
        this.nameFirst = rs.getString("namefirst");
        this.orgName = rs.getString("name");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.owner = DatabaseUtils.getInt(rs, "owner");
        this.entered = rs.getTimestamp("entered");
        this.isLead = rs.getBoolean("lead");
        this.leadStatus = DatabaseUtils.getInt(rs, "lead_status");
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("contact_id"));
        this.userId = DatabaseUtils.getInt(rs, "user_id");
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.company = rs.getString("company");
        this.title = rs.getString("title");
        this.department = DatabaseUtils.getInt(rs, "department");
        this.nameSalutation = rs.getString("namesalutation");
        this.nameLast = rs.getString("namelast");
        this.nameFirst = rs.getString("namefirst");
        this.nameMiddle = rs.getString("namemiddle");
        this.nameSuffix = rs.getString("namesuffix");
        this.assistant = DatabaseUtils.getInt(rs, "assistant");
        this.notes = rs.getString("notes");
        this.site = rs.getString("site");
        this.locale = rs.getInt("locale");
        this.employeeId = rs.getString("employee_id");
        this.employmentType = rs.getInt("employmenttype");
        this.startOfDay = rs.getString("startofday");
        this.endOfDay = rs.getString("endofday");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.owner = DatabaseUtils.getInt(rs, "owner");
        this.custom1 = rs.getInt("custom1");
        this.url = rs.getString("url");
        this.primaryContact = rs.getBoolean("primary_contact");
        this.employee = rs.getBoolean("employee");
        this.orgName = rs.getString("org_name");
        this.accessType = rs.getInt("access_type");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.importId = DatabaseUtils.getInt(rs, "import_id");
        this.isLead = rs.getBoolean("lead");
        this.leadStatus = DatabaseUtils.getInt(rs, "lead_status");
        this.source = DatabaseUtils.getInt(rs, "source");
        this.rating = DatabaseUtils.getInt(rs, "rating");
        this.comments = rs.getString("comments");
        this.conversionDate = rs.getTimestamp("conversion_date");
        this.additionalNames = rs.getString("additional_names");
        this.nickname = rs.getString("nickname");
        this.birthDate = rs.getTimestamp("birthdate");
        this.role = rs.getString("role");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.secretWord = rs.getString("secret_word");
        this.accountNumber = rs.getString("account_number");
        this.revenue = rs.getDouble("revenue");
        this.industryTempCode = DatabaseUtils.getInt(rs, "industry_temp_code");
        this.potential = rs.getDouble("potential");
        this.noEmail = rs.getBoolean("no_email");
        this.noMail = rs.getBoolean("no_mail");
        this.noPhone = rs.getBoolean("no_phone");
        this.noTextMessage = rs.getBoolean("no_textmessage");
        this.noInstantMessage = rs.getBoolean("no_im");
        this.noFax = rs.getBoolean("no_fax");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.assignedDate = rs.getTimestamp("assigned_date");
        this.leadTrashedDate = rs.getTimestamp("lead_trashed_date");
        this.employees = DatabaseUtils.getInt(rs, "employees");
        this.dunsType = rs.getString("duns_type");
        this.dunsNumber = rs.getString("duns_number");
        this.businessNameTwo = rs.getString("business_name_two");
        this.sicCode = DatabaseUtils.getInt(rs, "sic_code");
        this.yearStarted = rs.getInt("year_started");
        this.sicDescription = rs.getString("sic_description");
        this.orgEnabled = rs.getBoolean("orgenabled");
        this.orgTrashedDate = rs.getTimestamp("orgtrasheddate");
        this.departmentName = rs.getString("departmentname");
        this.city = rs.getString("city");
        this.postalcode = rs.getString("postalcode");
        this.siteName = rs.getString("site_id_name");
        this.industryName = rs.getString("industry_name");
        this.sourceName = rs.getString("source_name");
        this.ratingName = rs.getString("rating_name");
    }

    private boolean hasRelatedRecords(Connection db) throws SQLException {
        if (this.getOrgId() > -1) {
            OpportunityHeaderList opportunityHeaderList = new OpportunityHeaderList();
            opportunityHeaderList.setContactId(this.id);
            opportunityHeaderList.buildList(db);
            if (opportunityHeaderList.size() > 0) {
                return true;
            }
            CallList calls = new CallList();
            calls.setContactId(this.getId());
            calls.setOppCallsOnly(1);
            calls.buildList(db);
            if (calls.size() > 0) {
                return true;
            }
        }
        TicketList ticketList = new TicketList();
        ticketList.setContactId(this.id);
        ticketList.buildList(db);
        if (ticketList.size() > 0) {
            return true;
        }
        AssetList assetList = new AssetList();
        assetList.setContactId(this.id);
        assetList.buildList(db);
        if (assetList.size() > 0) {
            return true;
        }
        ServiceContractList serviceContractList = new ServiceContractList();
        serviceContractList.setContactId(this.id);
        serviceContractList.buildList(db);
        if (serviceContractList.size() > 0) {
            return true;
        }
        QuoteList quoteList = new QuoteList();
        quoteList.setContactId(this.id);
        quoteList.buildList(db);
        if (quoteList.size() > 0) {
            return true;
        }
        RecipientList recipientList = new RecipientList();
        recipientList.setContactId(this.id);
        recipientList.buildList(db);
        if (recipientList.size() > 0) {
            return true;
        }
        SurveyResponseList surveyResponseList = new SurveyResponseList();
        surveyResponseList.setContactId(this.id);
        surveyResponseList.buildList(db);
        if (surveyResponseList.size() > 0) {
            return true;
        }
        int excludedCount = 0;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT COUNT(*) AS  excludedcount FROM excluded_recipient WHERE contact_id = ? ");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            excludedCount = rs.getInt("excludedcount");
        }
        rs.close();
        pst.close();
        if (excludedCount > 0) {
            return true;
        }
        int messageCount = 0;
        pst = null;
        pst = db.prepareStatement("SELECT COUNT(*) AS  messagecount FROM cfsinbox_messagelink WHERE sent_to = ? ");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            messageCount = rs.getInt("messagecount");
        }
        rs.close();
        pst.close();
        if (messageCount > 0) {
            return true;
        }
        int actionItemLogCount = 0;
        pst = db.prepareStatement("SELECT COUNT(*) AS  actionitemlogcount FROM action_item_log WHERE item_id IN (SELECT item_id FROM action_item WHERE link_item_id = ?) ");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            actionItemLogCount = rs.getInt("actionitemlogcount");
        }
        rs.close();
        pst.close();
        if (actionItemLogCount > 0) {
            return true;
        }
        int actionItemCount = 0;
        pst = db.prepareStatement("SELECT COUNT(*) AS  actionitemcount FROM action_item WHERE link_item_id = ? ");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            actionItemCount = rs.getInt("actionitemcount");
        }
        rs.close();
        pst.close();
        return actionItemCount > 0;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public static void move(Connection db, int contactId, int orgId, String orgName, int userId) throws SQLException {
        int i = 0;
        String timestamp = DatabaseUtils.getCurrentTimestamp(db);
        PreparedStatement pst = db.prepareStatement("UPDATE contact SET org_id = ?, org_name = ?, modifiedBy = ?, modified = " + timestamp + " " + "WHERE contact_id = ? ");
        pst.setInt(++i, orgId);
        pst.setString(++i, orgName);
        pst.setInt(++i, userId);
        pst.setInt(++i, contactId);
        pst.executeUpdate();
        pst.close();
    }

    public static String getNameLastFirst(String nameLast, String nameFirst) {
        StringBuffer out = new StringBuffer();
        if (nameLast != null && nameLast.trim().length() > 0) {
            out.append(nameLast);
        }
        if (nameFirst != null && nameFirst.trim().length() > 0) {
            if (out.length() > 0) {
                out.append(", ");
            }
            out.append(nameFirst);
        }
        if (out.toString().length() == 0) {
            return null;
        }
        return out.toString().trim();
    }

    public static String getNameLastFirstAndTitle(String nameLast, String nameFirst, String title) {
        if (title != null && !"".equals(title)) {
            return Contact.getNameLastFirst(nameLast, nameFirst) + " - " + title;
        }
        return Contact.getNameLastFirst(nameLast, nameFirst);
    }

    public static String getNameFirstLast(String nameFirst, String nameLast) {
        StringBuffer out = new StringBuffer();
        if (nameFirst != null && nameFirst.trim().length() > 0) {
            out.append(nameFirst);
        }
        if (nameLast != null && nameLast.trim().length() > 0) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(nameLast);
        }
        if (out.toString().length() == 0) {
            return null;
        }
        return out.toString().trim();
    }

    public static String getNameFirstLastOrCompany(String tmpNameFirst, String tmpNameLast, String tmpCompany) {
        String firstLastOrCompany = Contact.getNameFirstLast(tmpNameFirst, tmpNameLast);
        if (firstLastOrCompany == null || "".equals(firstLastOrCompany)) {
            firstLastOrCompany = tmpCompany;
        }
        return firstLastOrCompany;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        DependencyList dependencyList = new DependencyList();
        try {
            Dependency thisDependency;
            int oppCount = OpportunityList.retrieveRecordCount(db, 2, this.getId());
            if (oppCount > 0) {
                this.setHasOpportunities(true);
                Dependency thisDependency2 = new Dependency();
                thisDependency2.setName("opportunities");
                thisDependency2.setCount(oppCount);
                thisDependency2.setCanDelete(this.getOrgId() == -1);
                dependencyList.add(thisDependency2);
            }
            int i = 0;
            pst = db.prepareStatement("SELECT count(*) as callcount FROM call_log WHERE contact_id = ? " + (this.getOrgId() != -1 ? "AND opp_id IS NULL " : ""));
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("activities");
                thisDependency.setCount(rs.getInt("callcount"));
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as foldercount FROM custom_field_record cfr WHERE cfr.link_module_id = 2 AND cfr.link_item_id = ? ");
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("folders");
                thisDependency.setCount(rs.getInt("foldercount"));
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as ticketcount FROM ticket WHERE contact_id = ? AND trashed_date IS NULL AND ticketid NOT IN (SELECT ticket_id FROM ticketlink_project) ");
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("tickets");
                thisDependency.setCount(rs.getInt("ticketcount"));
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as taskcount FROM tasklink_contact WHERE contact_id = ? ");
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("tasks");
                thisDependency.setCount(rs.getInt("taskcount"));
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as servicecontractcount FROM service_contract WHERE contact_id = ? AND trashed_date IS NULL");
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("contracts");
                thisDependency.setCount(rs.getInt("servicecontractcount"));
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as assetcount FROM asset WHERE contact_id = ? AND trashed_date IS NULL");
            pst.setInt(++i, this.getId());
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
            }
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("assets");
                thisDependency.setCount(rs.getInt("assetcount"));
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            Dependency quoteDependency = new Dependency();
            quoteDependency.setName("quotes");
            quoteDependency.setCount(QuoteList.retrieveRecordCount(db, 2, this.getId()));
            quoteDependency.setCanDelete(false);
            dependencyList.add(quoteDependency);
            int recipientCount = 0;
            recipientCount = RecipientList.retrieveRecordCount(db, 2, this.getId());
            if (recipientCount > 0) {
                Dependency thisDependency3 = new Dependency();
                thisDependency3.setName("campaigns");
                thisDependency3.setCount(recipientCount);
                thisDependency3.setCanDelete(false);
                dependencyList.add(thisDependency3);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public void disable(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact SET enabled = ? WHERE contact_id = ?");
        pst.setBoolean(1, false);
        pst.setInt(2, this.getId());
        pst.executeUpdate();
        pst.close();
        this.setEnabled(false);
        this.setTrashedDate((Timestamp)null);
        this.update(db);
    }

    public static int updateImportStatus(Connection db, int importId, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE contact SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, importId);
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public static int getContactSiteId(Connection db, int tmpContactId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int contactSiteId = -1;
        String sqlSelect = "SELECT site_id FROM contact WHERE contact_id = ? ";
        int i = 0;
        pst = db.prepareStatement(sqlSelect);
        pst.setInt(++i, tmpContactId);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            contactSiteId = DatabaseUtils.getInt(rs, "site_id");
        }
        rs.close();
        pst.close();
        return contactSiteId;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE contact SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE contact_id = ? ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.getId());
            if (!this.getCheckRevertingBackToLead()) {
                count = pst.executeUpdate();
            }
            pst.close();
            if (toTrash) {
                int fieldId = -1;
                pst = db.prepareStatement("SELECT id FROM search_fields WHERE description = ? ");
                pst.setString(1, "Contact ID");
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis();
                }
                ResultSet rs = pst.executeQuery();
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis() - milies;
                }
                if (rs.next()) {
                    fieldId = rs.getInt("id");
                }
                rs.close();
                pst.close();
                if (fieldId > -1) {
                    pst = db.prepareStatement("DELETE FROM saved_criteriaelement WHERE field = ? AND value_id = ? ");
                    pst.setInt(1, fieldId);
                    pst.setInt(2, this.getId());
                    pst.execute();
                    pst.close();
                }
                pst = db.prepareStatement("DELETE FROM action_item_log WHERE item_id IN (SELECT item_id FROM action_item WHERE link_item_id = ?) ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM action_item WHERE link_item_id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
            }
            ContactHistoryList historyList = new ContactHistoryList();
            historyList.setContactId(this.getId());
            historyList.setNotes(true);
            historyList.setActivities(true);
            historyList.setEmail(true);
            historyList.setShowDisabledWithEnabled(true);
            historyList.buildList(db);
            historyList.disableNotesInHistory(db, !toTrash);
            CallList callList = new CallList();
            callList.setContactId(this.getId());
            if (!toTrash) {
                callList.setIncludeOnlyTrashed(true);
            }
            callList.buildList(db);
            callList.updateStatus(db, toTrash, tmpUserId);
            if (this.getOrgId() == -1) {
                OpportunityList opportunityList = new OpportunityList();
                opportunityList.setContactId(this.getId());
                if (!toTrash) {
                    opportunityList.setIncludeOnlyTrashed(true);
                }
                opportunityList.buildList(db);
                opportunityList.updateStatus(db, context, toTrash, tmpUserId);
            }
            this.checkUserAccount(db);
            if (this.hasAccount()) {
                User user = new User(db, this.userId);
                if (toTrash) {
                    user.disable(db);
                } else {
                    user.enable(db);
                }
            }
            i = 0;
            int contactLinkModuleId = ActionPlan.getMapIdGivenConstantId(db, 2);
            pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, contactLinkModuleId);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void enable(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact SET enabled = ? WHERE contact_id = ?");
        pst.setBoolean(1, true);
        pst.setInt(2, this.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void deleteMessages(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM history WHERE link_object_id = ? AND link_item_id IN ( SELECT id FROM cfsinbox_messagelink WHERE sent_to = ?) ");
        pst.setInt(1, 14);
        pst.setInt(2, this.getId());
        boolean result = pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM cfsinbox_messagelink WHERE sent_to = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
    }

    public boolean delete(Connection db, ActionContext context, String baseFilePath) throws SQLException {
        if (this.delete(db, baseFilePath)) {
            this.invalidateUserData(context);
            return true;
        }
        return false;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        int oldId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT owner FROM contact WHERE contact_id = ?");
        pst.setInt(1, this.getId());
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
        }
        if (rs.next()) {
            oldId = rs.getInt("owner");
        }
        rs.close();
        pst.close();
        int result = this.update(db);
        if (result == 1) {
            this.invalidateUserData(context);
            if (oldId != this.getOwner()) {
                this.invalidateUserData(context, oldId);
            }
        }
        return result;
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        if (this.insert(db)) {
            this.invalidateUserData(context);
            return true;
        }
        return false;
    }

    public void invalidateUserData(ActionContext context) {
        this.invalidateUserData(context, this.owner);
    }

    public void invalidateUserData(ActionContext context, int userId) {
        if (userId != -1) {
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
            systemStatus.getHierarchyList().getUser(userId).setIsValidLead(false, true);
        }
    }

    public String getHtmlString(DependencyList dependencies, SystemStatus systemStatus) {
        boolean canMove = true;
        Iterator i = dependencies.iterator();
        StringBuffer html = new StringBuffer();
        html.append("<br />");
        int count = 0;
        while (i.hasNext()) {
            Dependency thisDependency = (Dependency)((Object)i.next());
            if (thisDependency.getCount() <= 0) continue;
            ++count;
            html.append("&nbsp;&nbsp;");
            if (thisDependency.getCanDelete()) {
                html.append("- ");
            } else if (thisDependency.getName().equals("opportunities") && this.getOrgId() == -1 || thisDependency.getName().equals("activities") || thisDependency.getName().equals("folders")) {
                html.append("- ");
            } else {
                html.append("* ");
                canMove = false;
            }
            if (systemStatus != null) {
                html.append(systemStatus.getLabel("dependency." + thisDependency.getName()) + " (" + thisDependency.getCount() + ")");
            }
            html.append("<br />");
        }
        if (count == 0 && systemStatus != null) {
            html.append("&nbsp;&nbsp;" + systemStatus.getLabel("dependency.noDependencyForAction") + "<br />");
        }
        if (!canMove && systemStatus != null) {
            html.append("<br />(*) " + systemStatus.getLabel("dependency.preventingContactMove"));
            html.append("<br />" + systemStatus.getLabel("dependency.note") + "<br />");
        }
        return html.toString();
    }

    public boolean canMoveContact(DependencyList dependencies) {
        Iterator thisList = dependencies.iterator();
        boolean canMove = true;
        boolean othersPresent = false;
        while (thisList.hasNext()) {
            Dependency thisDependency = (Dependency)((Object)thisList.next());
            if (thisDependency.getCanDelete() || thisDependency.getCount() <= 0) continue;
            if (thisDependency.getName().equals("opportunities") || thisDependency.getName().equals("activities") || thisDependency.getName().equals("folders")) {
                canMove = false;
                continue;
            }
            othersPresent = true;
        }
        return !othersPresent && canMove;
    }

    public String toString() {
        return this.getNameFull();
    }

    public void updatePrimaryContactInformation(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact SET primary_contact = ? WHERE contact_id = ? ");
        pst.setBoolean(1, this.getPrimaryContact());
        pst.setInt(2, this.getId());
        pst.executeUpdate();
        pst.close();
    }

    public boolean moveContact(Connection db, ActionContext context, String dbNamePath, int newOrgId, int moveOpportunities, int moveFolders, int moveActivities) throws SQLException {
        Organization organization = new Organization(db, newOrgId);
        OpportunityHeaderList opportunities = new OpportunityHeaderList();
        opportunities.setContactId(this.getId());
        opportunities.buildList(db);
        if (opportunities.size() > 0) {
            if (moveOpportunities == 0) {
                opportunities.delete(db, context, dbNamePath);
            } else if (moveOpportunities == 1) {
                opportunities.moveOpportunitiesToAccount(db, this.getOrgId());
            }
        }
        if (moveFolders == 0) {
            CustomFieldRecordList folderList = new CustomFieldRecordList();
            folderList.setLinkModuleId(2);
            folderList.setLinkItemId(this.getId());
            folderList.buildList(db);
            if (folderList.size() > 0) {
                folderList.delete(db);
            }
        }
        CallList activities = new CallList();
        activities.setContactId(this.getId());
        activities.buildList(db);
        if (activities.size() > 0) {
            if (moveActivities == 1) {
                activities.reassignAccount(db, context, newOrgId);
            } else if (moveActivities == 0) {
                activities.delete(db);
            }
        }
        ActionItemWorkList workList = new ActionItemWorkList();
        workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 2));
        workList.setLinkItemId(this.getId());
        workList.buildList(db);
        workList.resetAttachment(db);
        OrganizationHistoryList historyList = new OrganizationHistoryList();
        historyList.setContactId(this.getId());
        historyList.setNotes(true);
        historyList.buildList(db);
        historyList.moveNotesToAccountHistory(db, this.getOrgId());
        Contact.move(db, this.getId(), newOrgId, organization.getName(), this.getModifiedBy());
        return true;
    }

    public boolean canWorkAsContact() {
        boolean result = true;
        if ((this.getCompany() == null || "".equals(this.getCompany().trim())) && (this.getNameLast() == null || "".equals(this.getNameLast().trim()))) {
            result = false;
        }
        return result;
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            // empty if block
        }
    }
}

