/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.base.Address;
import org.aspcfs.utils.DatabaseUtils;

public class ContactAddress
extends Address {
    public ContactAddress() {
        this.isContact = true;
    }

    public ContactAddress(ResultSet rs) throws SQLException {
        this.isContact = true;
        this.buildRecord(rs);
    }

    public ContactAddress(Connection db, String addressId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(addressId));
    }

    public ContactAddress(Connection db, int addressId) throws SQLException {
        this.queryRecord(db, addressId);
    }

    public void queryRecord(Connection db, int addressId) throws SQLException {
        this.isContact = true;
        PreparedStatement pst = db.prepareStatement("SELECT c.address_id, c.contact_id, c.address_type, c.addrline1, c.addrline1,  c.addrline2, c.addrline3, c.addrline4, c.city, c.state, c.country, c.postalcode, c.county, c.latitude, c.longitude, c.entered, c.enteredby, c.modified, c.modifiedby, c.primary_address, l.description FROM contact_address c, lookup_contactaddress_types l WHERE c.address_type = l.code AND address_id = " + addressId + " ");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Address record not found.");
        }
    }

    public void process(Connection db, int contactId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if ("-1".equals(this.getState())) {
                this.setState("");
            }
            if ("-1".equals(this.getCountry())) {
                this.setCountry("");
            }
            if (this.getId() == -1) {
                this.setContactId(contactId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db, contactId, enteredBy);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getContactId(), this.getEnteredBy());
    }

    public void insert(Connection db, int contactId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.setId(DatabaseUtils.getNextSeq(db, "contact_address_address_id_seq"));
        sql.append("INSERT INTO contact_address (contact_id, address_type, addrline1, addrline2, addrline3, addrline4, city, state, postalcode, country, county, latitude, longitude, primary_address, ");
        if (this.getId() > -1) {
            sql.append("address_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        if (this.getId() > -1) {
            sql.append("?, ");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.getContactId() > -1) {
            pst.setInt(++i, this.getContactId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getStreetAddressLine1());
        pst.setString(++i, this.getStreetAddressLine2());
        pst.setString(++i, this.getStreetAddressLine3());
        pst.setString(++i, this.getStreetAddressLine4());
        pst.setString(++i, this.getCity());
        pst.setString(++i, this.getState());
        pst.setString(++i, this.getZip());
        pst.setString(++i, this.getCountry());
        pst.setString(++i, this.getCounty());
        pst.setDouble(++i, this.getLatitude());
        pst.setDouble(++i, this.getLongitude());
        pst.setBoolean(++i, this.getPrimaryAddress());
        if (this.getId() > -1) {
            pst.setInt(++i, this.getId());
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "contact_address_address_id_seq", this.getId()));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact_address SET address_type = ?, addrline1 = ?, addrline2 = ?, addrline3 = ?, addrline4 = ?, city = ?, state = ?, postalcode = ?, country = ?, county = ?, latitude = ?, longitude =? , primary_address = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE address_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getStreetAddressLine1());
        pst.setString(++i, this.getStreetAddressLine2());
        pst.setString(++i, this.getStreetAddressLine3());
        pst.setString(++i, this.getStreetAddressLine4());
        pst.setString(++i, this.getCity());
        pst.setString(++i, this.getState());
        pst.setString(++i, this.getZip());
        pst.setString(++i, this.getCountry());
        pst.setString(++i, this.getCounty());
        pst.setDouble(++i, this.getLatitude());
        pst.setDouble(++i, this.getLongitude());
        pst.setBoolean(++i, this.getPrimaryAddress());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM contact_address WHERE address_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

