/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.EmailAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class ContactEmailAddressList
extends EmailAddressList {
    public static final String tableName = "contact_emailaddress";
    public static final String uniqueField = "emailaddress_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;

    public ContactEmailAddressList() {
    }

    public ContactEmailAddressList(HttpServletRequest request) {
        int i = 0;
        int primaryEmail = -1;
        if (request.getParameter("primaryEmail") != null) {
            primaryEmail = Integer.parseInt(request.getParameter("primaryEmail"));
        }
        while (request.getParameter("email" + ++i + "type") != null) {
            ContactEmailAddress thisEmailAddress = new ContactEmailAddress();
            thisEmailAddress.buildRecord(request, i);
            if (primaryEmail == i) {
                thisEmailAddress.setPrimaryEmail(true);
            }
            if (!thisEmailAddress.isValid()) continue;
            this.addElement(thisEmailAddress);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM contact_emailaddress e, lookup_contactemail_types l WHERE e.emailaddress_type = l.code ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact_emailaddress e, lookup_contactemail_types l WHERE e.emailaddress_type = l.code ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(email) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", email ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY email ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            ContactEmailAddress thisEmailAddress = new ContactEmailAddress(rs);
            this.addElement(thisEmailAddress);
        }
        rs.close();
        pst.close();
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getEmptyHtmlSelect(SystemStatus thisSystem, String selectName) {
        HtmlSelect emailListSelect = new HtmlSelect();
        emailListSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        return emailListSelect.getHtml(selectName);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect emailListSelect = new HtmlSelect();
        emailListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            emailListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (ContactEmailAddress thisEmailAddress : this) {
            emailListSelect.addItem(thisEmailAddress.getId(), thisEmailAddress.getEmail() + (thisEmailAddress.getPrimaryEmail() ? "*" : ""));
        }
        return emailListSelect.getHtml(selectName, defaultKey);
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

