/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.database.ConnectionElement;
import com.zeroio.iteam.base.FileItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.admin.base.SICCodeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.utils.CFSFileReader;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.formatter.AddressFormatter;
import org.aspcfs.utils.formatter.ContactNameFormatter;
import org.aspcfs.utils.formatter.EmailAddressFormatter;
import org.aspcfs.utils.formatter.PhoneNumberFormatter;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public class ContactImport
extends Import
implements Runnable {
    public static final String fs = System.getProperty("file.separator");
    private PropertyMap propertyMap = null;
    private String filePath = null;
    private int owner = -1;
    private String ownerName = null;
    private int userId = -1;
    private int accessTypeId = -1;
    private boolean lookupAccount = false;
    private ImportManager manager = null;
    private Connection db = null;
    private ConnectionElement connectionElement = null;
    private File errorFile = null;
    private BufferedWriter fos = null;
    private FileItem fileItem = null;
    private Thread importThread = null;
    private boolean lead = false;
    private int leadStatus = -1;
    private int ownerSiteId = -1;

    public ContactImport() {
    }

    public ContactImport(Connection db, int importId) throws SQLException {
        super(db, importId);
    }

    public void setProperties(HttpServletRequest request) {
        if (request.getParameter("owner") != null) {
            this.setOwner(request.getParameter("owner"));
        }
        if (request.getParameter("accessType") != null) {
            this.setAccessTypeId(request.getParameter("accessType"));
        }
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setAccessTypeId(int tmp) {
        this.accessTypeId = tmp;
    }

    public void setAccessTypeId(String tmp) {
        this.accessTypeId = Integer.parseInt(tmp);
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setLookupAccount(boolean tmp) {
        this.lookupAccount = tmp;
    }

    public void setLookupAccount(String tmp) {
        this.lookupAccount = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPropertyMap(PropertyMap tmp) {
        this.propertyMap = tmp;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setDb(Connection tmp) {
        this.db = tmp;
    }

    public void setManager(ImportManager tmp) {
        this.manager = tmp;
    }

    public void setErrorFile(File tmp) {
        this.errorFile = tmp;
    }

    public void setFileItem(FileItem tmp) {
        this.fileItem = tmp;
    }

    public void setImportThread(Thread tmp) {
        this.importThread = tmp;
    }

    public Thread getImportThread() {
        return this.importThread;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public ImportManager getManager() {
        return this.manager;
    }

    public Connection getDb() {
        return this.db;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public boolean getLookupAccount() {
        return this.lookupAccount;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getAccessTypeId() {
        return this.accessTypeId;
    }

    public void setConnectionElement(ConnectionElement tmp) {
        this.connectionElement = tmp;
    }

    public ConnectionElement getConnectionElement() {
        return this.connectionElement;
    }

    public boolean getLead() {
        return this.lead;
    }

    public void setLead(boolean tmp) {
        this.lead = tmp;
    }

    public void setLead(String tmp) {
        this.lead = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLeadStatus() {
        return this.leadStatus;
    }

    public void setLeadStatus(int tmp) {
        this.leadStatus = tmp;
    }

    public void setLeadStatus(String tmp) {
        this.leadStatus = Integer.parseInt(tmp);
    }

    public void start() {
        this.importThread = new Thread(this);
        this.importThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList thisRecord = new ArrayList();
        String line = null;
        StringBuffer error = new StringBuffer();
        int recordCount = 1;
        boolean recordInserted = false;
        boolean done = false;
        ArrayList header = null;
        Thread currentThread = Thread.currentThread();
        ContactNameFormatter nameFormatter = new ContactNameFormatter();
        boolean withoutContact = false;
        try {
            this.db = this.manager.getConnection(this.connectionElement);
            this.errorFile = new File(this.filePath + "_error");
            this.fos = new BufferedWriter(new FileWriter(this.errorFile));
            if (this.db == null) {
                throw new Exception("FATAL: Could not get database connection!");
            }
            if (this.updateStatus(this.db, 3) < 1) {
                throw new Exception("Error updating status to RUNNING");
            }
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.getFileType());
            CFSFileReader.Record record = fileReader.nextLine();
            header = record.data;
            this.recordError(null, record.line, 0);
            LookupList salutationList = new LookupList(this.db, "lookup_title");
            LookupList emailAddressTypeList = new LookupList(this.db, "lookup_contactemail_types");
            LookupList addressTypeList = new LookupList(this.db, "lookup_contactaddress_types");
            LookupList phoneNumberTypeList = new LookupList(this.db, "lookup_contactphone_types");
            SICCodeList sicCodeList = new SICCodeList(this.db);
            LookupList siteIdList = new LookupList(this.db, "lookup_site_id");
            UserList userList = new UserList();
            userList.setBuildContact(true);
            userList.setSiteId(this.getSiteId());
            if (this.getSiteId() != -1) {
                userList.setIncludeUsersWithAccessToAllSites(true);
            }
            userList.buildList(this.db);
            while (this.importThread == currentThread && !done) {
                record = fileReader.nextLine();
                if (record != null) {
                    if (error.length() > 0) {
                        error.delete(0, error.length());
                    }
                    recordInserted = false;
                    withoutContact = false;
                    ++recordCount;
                    try {
                        int orgId;
                        Property accountNumberPropertyForContact;
                        User user;
                        String ownerIdProp;
                        User user2;
                        String propertyValue;
                        if (record.isEmpty()) continue;
                        thisRecord = record.data;
                        line = fileReader.padLine(record.line, header.size() - thisRecord.size());
                        Contact thisContact = new Contact();
                        thisContact.setImportId(this.getId());
                        thisContact.setStatusId(6);
                        thisContact.setSiteId(this.getSiteId());
                        thisContact.setRating(this.getRating());
                        thisContact.setComments(this.getComments());
                        String nameLast = this.getValue(thisRecord, this.propertyMap.getProperty("nameLast"));
                        if (!"".equals(StringUtils.toString(nameLast))) {
                            thisContact.setNameLast(nameLast);
                        } else {
                            String nameFull = this.getValue(thisRecord, this.propertyMap.getProperty("nameFull"));
                            if (!"".equals(StringUtils.toString(nameFull))) {
                                nameFormatter.format(thisContact, nameFull);
                            }
                            if ("".equals(StringUtils.toString(thisContact.getNameLast()))) {
                                if (this.getType() == 33020043) {
                                    withoutContact = true;
                                } else {
                                    String company = this.getValue(thisRecord, this.propertyMap.getProperty("company"));
                                    if ("".equals(StringUtils.toString(company))) {
                                        error.append("Last Name or Company info should be present");
                                    }
                                }
                            }
                        }
                        String nameFirst = this.getValue(thisRecord, this.propertyMap.getProperty("nameFirst"));
                        if (!"".equals(StringUtils.toString(nameFirst))) {
                            thisContact.setNameFirst(nameFirst);
                        }
                        thisContact.setNameMiddle(this.getValue(thisRecord, this.propertyMap.getProperty("nameMiddle")));
                        thisContact.setNameSuffix(this.getValue(thisRecord, this.propertyMap.getProperty("nameSuffix")));
                        thisContact.setAdditionalNames(this.getValue(thisRecord, this.propertyMap.getProperty("additionalNames")));
                        thisContact.setNickname(this.getValue(thisRecord, this.propertyMap.getProperty("nickname")));
                        thisContact.setBirthDate(this.getValue(thisRecord, this.propertyMap.getProperty("birthDate")));
                        thisContact.setRole(this.getValue(thisRecord, this.propertyMap.getProperty("role")));
                        thisContact.setTitle(this.getValue(thisRecord, this.propertyMap.getProperty("title")));
                        thisContact.setNotes(this.getValue(thisRecord, this.propertyMap.getProperty("notes")));
                        thisContact.setUrl(this.getValue(thisRecord, this.propertyMap.getProperty("url")));
                        if (this.lead) {
                            thisContact.setIsLead(true);
                        }
                        if (this.leadStatus != -1) {
                            thisContact.setLeadStatus(this.leadStatus);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("enteredBy"))))) {
                            try {
                                user2 = userList.getUserById(Integer.parseInt(propertyValue));
                                thisContact.setEnteredBy(user2 != null ? user2.getId() : -1);
                            }
                            catch (NumberFormatException nfe) {
                                thisContact.setEnteredBy(userList.getUserIdByName(propertyValue));
                            }
                            if (thisContact.getEnteredBy() == -1) {
                                thisContact.setEnteredBy(this.userId);
                            }
                        } else {
                            thisContact.setEnteredBy(this.userId);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("modifiedBy"))))) {
                            try {
                                user2 = userList.getUserById(Integer.parseInt(propertyValue));
                                thisContact.setModifiedBy(user2 != null ? user2.getId() : -1);
                            }
                            catch (NumberFormatException nfe) {
                                thisContact.setModifiedBy(userList.getUserIdByName(propertyValue));
                            }
                            if (thisContact.getModifiedBy() == -1) {
                                thisContact.setModifiedBy(this.userId);
                            }
                        } else {
                            thisContact.setModifiedBy(this.userId);
                        }
                        if (!"".equals(StringUtils.toString(ownerIdProp = this.getValue(thisRecord, this.propertyMap.getProperty("ownerId"))))) {
                            try {
                                user = userList.getUserById(Integer.parseInt(ownerIdProp));
                                thisContact.setOwner(user != null ? user.getId() : -1);
                            }
                            catch (NumberFormatException nfe) {
                                thisContact.setOwner(userList.getUserIdByName(ownerIdProp));
                            }
                        }
                        if (thisContact.getOwner() < 0) {
                            String ownerNameProp = this.getValue(thisRecord, this.propertyMap.getProperty("ownerName"));
                            if (!"".equals(StringUtils.toString(ownerNameProp))) {
                                thisContact.setOwner(userList.getUserIdByName(ownerNameProp));
                            }
                            if (thisContact.getOwner() < 0) {
                                if (!"".equals(StringUtils.toString(ownerIdProp)) || !"".equals(StringUtils.toString(ownerNameProp))) {
                                    error.append("Owner is not valid");
                                }
                                thisContact.setOwner(this.owner);
                            }
                        }
                        user = userList.getUserById(thisContact.getOwner());
                        int ownerSiteIdProp = user.getSiteId();
                        propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("siteId"));
                        if (!"".equals(StringUtils.toString(propertyValue))) {
                            try {
                                if (siteIdList.hasCode(Integer.parseInt(propertyValue))) {
                                    thisContact.setSiteId(Integer.parseInt(propertyValue));
                                } else {
                                    thisContact.setSiteId(-1);
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("number format exception siteId = " + propertyValue);
                            }
                            if (thisContact.getSiteId() < 0) {
                                error.append("Site id is not valid");
                            } else if (thisContact.getSiteId() != ownerSiteIdProp && ownerSiteIdProp > 0) {
                                error.append("Site name does not match the site of the owner");
                            }
                        } else {
                            propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("siteName"));
                            if (!"".equals(StringUtils.toString(propertyValue))) {
                                thisContact.setSiteId(siteIdList.getIdFromValue(propertyValue));
                                if (thisContact.getSiteId() < 0) {
                                    error.append("Site name is not valid");
                                } else if (thisContact.getSiteId() != ownerSiteIdProp && ownerSiteIdProp > 0) {
                                    error.append("Site name does not match the site of the owner");
                                }
                            } else {
                                thisContact.setSiteId(super.getSiteId());
                            }
                        }
                        if (super.getSiteId() > 0 && thisContact.getSiteId() < 0) {
                            thisContact.setSiteId(super.getSiteId());
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("accessType"))))) {
                            thisContact.setAccessType(propertyValue);
                        } else {
                            thisContact.setAccessType(this.accessTypeId);
                        }
                        Property accountIndustryPropertyForContact = this.propertyMap.getProperty("industryTempCode");
                        propertyValue = this.getValue(thisRecord, accountIndustryPropertyForContact);
                        if (!"".equals(StringUtils.toString(propertyValue))) {
                            LookupList contactIndustryTypeList = new LookupList(this.db, "lookup_industry");
                            int industryCode = contactIndustryTypeList.getIdFromValue(propertyValue);
                            if (industryCode == -1) {
                                LookupElement thisElement = new LookupElement();
                                thisElement.setDescription(propertyValue);
                                thisElement.insertElement(this.db, "lookup_industry");
                                industryCode = thisElement.getCode();
                                this.getSystemStatus().removeLookup("lookup_industry");
                            }
                            thisContact.setIndustryTempCode(industryCode);
                        }
                        propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("potential"));
                        propertyValue = StringUtils.replace(propertyValue, "$", "");
                        propertyValue = StringUtils.replace(propertyValue, ",", "");
                        thisContact.setPotential(StringUtils.parseDouble(propertyValue, 0.0));
                        propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("revenue"));
                        propertyValue = StringUtils.replace(propertyValue, "$", "");
                        propertyValue = StringUtils.replace(propertyValue, ",", "");
                        thisContact.setRevenue(StringUtils.parseDouble(propertyValue, 0.0));
                        if (thisContact.getRevenue() <= 0.0) {
                            propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("revenueInThousands"));
                            propertyValue = StringUtils.replace(propertyValue, "$", "");
                            propertyValue = StringUtils.replace(propertyValue, ",", "");
                            thisContact.setRevenue(StringUtils.parseDouble(propertyValue, 0.0) * 1000.0);
                        }
                        thisContact.setEmployees(this.getValue(thisRecord, this.propertyMap.getProperty("employees")));
                        thisContact.setDunsType(this.getValue(thisRecord, this.propertyMap.getProperty("dunsType")));
                        thisContact.setYearStarted(this.getValue(thisRecord, this.propertyMap.getProperty("yearStarted")));
                        thisContact.setDunsNumber(this.getValue(thisRecord, this.propertyMap.getProperty("dunsNumber")));
                        thisContact.setBusinessNameTwo(this.getValue(thisRecord, this.propertyMap.getProperty("businessNameTwo")));
                        thisContact.setSicDescription(this.getValue(thisRecord, this.propertyMap.getProperty("sicDescription")));
                        propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("sicCode"));
                        thisContact.setSicCode(sicCodeList.getIdFromConstantId(propertyValue));
                        if (!"".equals(propertyValue) && propertyValue != null && thisContact.getSicCode() < 0) {
                            error.append("Error adding SIC");
                        }
                        if (thisContact.getSicCode() > 0) {
                            thisContact.setSicDescription(sicCodeList.getDescriptionByCode(thisContact.getSicCode()));
                        }
                        if ((propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("nameSalutation"))) != null && !"".equals(propertyValue)) {
                            int salutationId = salutationList.getIdFromValue(propertyValue);
                            thisContact.setListSalutation(salutationId);
                        }
                        thisContact.setSource(this.getSourceType());
                        ArrayList addressInstances = this.propertyMap.getDependencyMapList("contactAddress");
                        for (PropertyMap thisMap : addressInstances) {
                            StateSelect stateSelect;
                            String type = this.getValue(thisRecord, thisMap.getProperty("type"));
                            ContactAddress address = new ContactAddress();
                            address.setStreetAddressLine1(this.getValue(thisRecord, thisMap.getProperty("streetAddressLine1")));
                            address.setStreetAddressLine2(this.getValue(thisRecord, thisMap.getProperty("streetAddressLine2")));
                            address.setStreetAddressLine3(this.getValue(thisRecord, thisMap.getProperty("streetAddressLine3")));
                            address.setStreetAddressLine4(this.getValue(thisRecord, thisMap.getProperty("streetAddressLine4")));
                            address.setCity(this.getValue(thisRecord, thisMap.getProperty("city")));
                            address.setCountry(this.getValue(thisRecord, thisMap.getProperty("country")));
                            if (address.getCountry() == null || "".equals(address.getCountry()) && this.getSystemStatus() != null) {
                                address.setCountry(this.getSystemStatus().getApplicationPrefs().get("SYSTEM.COUNTRY"));
                            }
                            if ((stateSelect = new StateSelect(address.getCountry())).hasCountry(address.getCountry())) {
                                address.setState(this.getValue(thisRecord, thisMap.getProperty("state")));
                            } else {
                                address.setOtherState(this.getValue(thisRecord, thisMap.getProperty("state")));
                            }
                            address.setZip(this.getValue(thisRecord, thisMap.getProperty("zip")));
                            address.setCounty(this.getValue(thisRecord, thisMap.getProperty("county")));
                            address.setLatitude(this.getValue(thisRecord, thisMap.getProperty("latitude")));
                            address.setLongitude(this.getValue(thisRecord, thisMap.getProperty("longitude")));
                            if (!"".equals(StringUtils.toString(type).trim())) {
                                try {
                                    address.setType(new Integer(type));
                                }
                                catch (NumberFormatException nfe) {
                                    address.setType(addressTypeList.getIdFromValue(type));
                                }
                            } else {
                                address.setType(addressTypeList.get(0) != null ? ((LookupElement)addressTypeList.get(0)).getCode() : -1);
                            }
                            if (!address.isValid()) continue;
                            AddressFormatter thisFormatter = new AddressFormatter();
                            thisFormatter.format(address);
                            if (address.isValid()) {
                                thisContact.getAddressList().add(address);
                                continue;
                            }
                            error.append("; Invalid Address");
                        }
                        ArrayList emailInstances = this.propertyMap.getDependencyMapList("contactEmail");
                        for (PropertyMap thisMap : emailInstances) {
                            String email = this.getValue(thisRecord, thisMap.getProperty("email"));
                            String type = this.getValue(thisRecord, thisMap.getProperty("type"));
                            EmailAddressFormatter thisFormatter = new EmailAddressFormatter();
                            ContactEmailAddress emailAddress = new ContactEmailAddress();
                            emailAddress.setEmail(email);
                            if (!"".equals(StringUtils.toString(type))) {
                                try {
                                    emailAddress.setType(new Integer(type));
                                }
                                catch (NumberFormatException nfe) {
                                    emailAddress.setType(emailAddressTypeList.getIdFromValue(type));
                                }
                            } else {
                                emailAddress.setType(emailAddressTypeList.get(0) != null ? ((LookupElement)emailAddressTypeList.get(0)).getCode() : -1);
                            }
                            if (!emailAddress.isValid()) continue;
                            thisFormatter.format(emailAddress);
                            if (emailAddress.isValid()) {
                                thisContact.getEmailAddressList().add(emailAddress);
                                continue;
                            }
                            error.append("; Invalid Email");
                        }
                        ArrayList phoneInstances = this.propertyMap.getDependencyMapList("contactPhone");
                        for (PropertyMap thisMap : phoneInstances) {
                            String phone = this.getValue(thisRecord, thisMap.getProperty("number"));
                            String phoneExt = this.getValue(thisRecord, thisMap.getProperty("extension"));
                            String type = this.getValue(thisRecord, thisMap.getProperty("type"));
                            ContactPhoneNumber phoneNumber = new ContactPhoneNumber();
                            if ("".equals(StringUtils.toString(phone))) continue;
                            phoneNumber.setNumber(phone);
                            if (!"".equals(StringUtils.toString(phoneExt))) {
                                phoneNumber.setExtension(phoneExt);
                            }
                            if (!"".equals(StringUtils.toString(type))) {
                                try {
                                    phoneNumber.setType(new Integer(type));
                                }
                                catch (NumberFormatException nfe) {
                                    phoneNumber.setType(phoneNumberTypeList.getIdFromValue(type));
                                }
                            } else {
                                phoneNumber.setType(phoneNumberTypeList.get(0) != null ? ((LookupElement)phoneNumberTypeList.get(0)).getCode() : -1);
                            }
                            if (!phoneNumber.isValid()) continue;
                            PhoneNumberFormatter.format(phoneNumber);
                            if (phoneNumber.isValid()) {
                                thisContact.getPhoneNumberList().add(phoneNumber);
                                continue;
                            }
                            error.append("; Invalid Phone Number");
                        }
                        Property companyProperty = this.propertyMap.getProperty("company");
                        propertyValue = this.getValue(thisRecord, companyProperty);
                        if (!"".equals(StringUtils.toString(propertyValue))) {
                            thisContact.setCompany(propertyValue);
                            thisContact.setOrgName(propertyValue);
                        }
                        if (this.lookupAccount) {
                            if (propertyValue != null && !"".equals(StringUtils.toString(propertyValue))) {
                                Organization thisOrg;
                                int orgId2 = Organization.lookupAccount(this.db, propertyValue, this.getId(), thisContact.getSiteId());
                                if (orgId2 < 0) {
                                    thisOrg = new Organization();
                                    thisOrg.setName(propertyValue);
                                    thisOrg.setEnteredBy(this.userId);
                                    thisOrg.setModifiedBy(this.userId);
                                    thisOrg.setModifiedBy(this.userId);
                                    thisOrg.setOwner(thisContact.getOwner());
                                    thisOrg.setImportId(this.getId());
                                    thisOrg.setPotential(thisContact.getPotential());
                                    thisOrg.setStatusId(6);
                                    thisOrg.setSiteId(thisContact.getSiteId());
                                    thisOrg.setSource(this.getSourceType());
                                    if (withoutContact) {
                                        ContactImport.copyAddressAndPhones(thisContact, thisOrg);
                                    }
                                    ContactImport.copyPropertiesFromContactToOrganization(thisContact, thisOrg);
                                    if (error.length() == 0) {
                                        recordInserted = thisOrg.insert(this.db);
                                        if (!recordInserted) {
                                            error.append("; Error adding account");
                                        } else {
                                            orgId2 = thisOrg.getOrgId();
                                        }
                                    }
                                }
                                if (orgId2 > 0 && (!(thisOrg = new Organization(this.db, orgId2)).getEnabled() || thisOrg.isTrashed())) {
                                    orgId2 = -1;
                                }
                                thisContact.setOrgId(orgId2);
                                thisContact.setOrgName(propertyValue);
                            } else if (thisContact.getNameLastFirst() != null && !"".equals(thisContact.getNameLastFirst())) {
                                Organization thisOrg = new Organization();
                                thisOrg.setInsertPrimaryContact(false);
                                thisOrg.setName(thisContact.getNameLastFirst());
                                thisOrg.setNameLast(thisContact.getNameLast());
                                thisOrg.setNameFirst(thisContact.getNameFirst());
                                thisOrg.setEnteredBy(this.userId);
                                thisOrg.setModifiedBy(this.userId);
                                thisOrg.setModifiedBy(this.userId);
                                thisOrg.setOwner(thisContact.getOwner());
                                thisOrg.setImportId(this.getId());
                                thisOrg.setPotential(thisContact.getPotential());
                                thisOrg.setStatusId(6);
                                thisOrg.setSiteId(this.getSiteId());
                                thisOrg.setSource(this.getSourceType());
                                if (withoutContact) {
                                    ContactImport.copyAddressAndPhones(thisContact, thisOrg);
                                }
                                ContactImport.copyPropertiesFromContactToOrganization(thisContact, thisOrg);
                                if (error.length() == 0) {
                                    recordInserted = thisOrg.insert(this.db);
                                    if (!recordInserted) {
                                        error.append("; Error adding account");
                                    }
                                    thisContact.setOrgId(thisOrg.getOrgId());
                                    thisContact.setOrgName(thisContact.getNameLastFirst());
                                    thisContact.setPrimaryContact(true);
                                }
                            } else {
                                error.append("; Invalid Individual Account Name");
                            }
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, accountNumberPropertyForContact = this.propertyMap.getProperty("accountNumber"))))) {
                            thisContact.setAccountNumber(propertyValue);
                        }
                        if (this.lookupAccount && propertyValue != null && !"".equals(StringUtils.toString(propertyValue)) && (orgId = Organization.lookupAccount(this.db, thisContact.getOrgName(), this.getId(), thisContact.getSiteId())) > 0) {
                            Organization thisOrg = new Organization(this.db, orgId);
                            thisOrg.setAccountNumber(propertyValue);
                            thisOrg.setModifiedBy(this.userId);
                            int resultCount = thisOrg.update(this.db);
                            if (resultCount != 1) {
                                error.append("; Error adding account number");
                            }
                        }
                        if (error.length() == 0) {
                            boolean isValid = ObjectValidator.validate(null, this.db, (Object)thisContact);
                            if (isValid && !withoutContact) {
                                recordInserted = thisContact.insert(this.db);
                            }
                            if (recordInserted) {
                                this.incrementTotalImportedRecords();
                                continue;
                            }
                            this.incrementTotalFailedRecords();
                            continue;
                        }
                        this.recordError(error.toString(), line, recordCount);
                    }
                    catch (Exception unknownException) {
                        unknownException.printStackTrace();
                        if (error.length() == 0) {
                            this.recordError(unknownException.toString(), line, recordCount);
                            continue;
                        }
                        this.recordError(error.toString() + "; " + unknownException.toString(), line, recordCount);
                    }
                    continue;
                }
                done = true;
            }
            if (done) {
                this.setStatusId(6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordError(e.toString(), "", -1);
            try {
                this.setStatusId(4);
            }
            catch (Exception statusException) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.importThread == currentThread) {
                this.stop();
            }
        }
    }

    private static void copyAddressAndPhones(Contact thisContact, Organization thisOrg) {
        Object thisFormatter;
        ContactAddressList addressInstances = thisContact.getAddressList();
        for (ContactAddress contactAddress : addressInstances) {
            OrganizationAddress address = new OrganizationAddress();
            address.setStreetAddressLine1(contactAddress.getStreetAddressLine1());
            address.setStreetAddressLine2(contactAddress.getStreetAddressLine2());
            address.setStreetAddressLine3(contactAddress.getStreetAddressLine3());
            address.setStreetAddressLine4(contactAddress.getStreetAddressLine4());
            address.setCity(contactAddress.getCity());
            address.setCountry(contactAddress.getCountry());
            StateSelect stateSelect = new StateSelect(address.getCountry());
            if (stateSelect.hasCountry(address.getCountry())) {
                address.setState(contactAddress.getState());
            } else {
                address.setOtherState(contactAddress.getOtherState());
            }
            address.setZip(contactAddress.getZip());
            address.setCounty(contactAddress.getCounty());
            address.setLatitude(contactAddress.getLatitude());
            address.setLongitude(contactAddress.getLongitude());
            address.setType(contactAddress.getType());
            if (!address.isValid()) continue;
            thisFormatter = new AddressFormatter();
            ((AddressFormatter)thisFormatter).format(address);
            if (!address.isValid()) continue;
            thisOrg.getAddressList().add(address);
        }
        ContactEmailAddressList emailInstances = thisContact.getEmailAddressList();
        for (ContactEmailAddress contactEmailAddress : emailInstances) {
            thisFormatter = new EmailAddressFormatter();
            OrganizationEmailAddress emailAddress = new OrganizationEmailAddress();
            emailAddress.setEmail(contactEmailAddress.getEmail());
            emailAddress.setType(contactEmailAddress.getType());
            if (!emailAddress.isValid()) continue;
            ((EmailAddressFormatter)thisFormatter).format(emailAddress);
            if (!emailAddress.isValid()) continue;
            thisOrg.getEmailAddressList().add(emailAddress);
        }
        ContactPhoneNumberList phoneInstances = thisContact.getPhoneNumberList();
        for (ContactPhoneNumber contactPhoneNumber : phoneInstances) {
            String phone = contactPhoneNumber.getNumber();
            String phoneExt = contactPhoneNumber.getExtension();
            int type = contactPhoneNumber.getType();
            OrganizationPhoneNumber phoneNumber = new OrganizationPhoneNumber();
            if ("".equals(StringUtils.toString(phone))) continue;
            phoneNumber.setNumber(phone);
            if (!"".equals(StringUtils.toString(phoneExt))) {
                phoneNumber.setExtension(phoneExt);
            }
            phoneNumber.setType(type);
            if (!phoneNumber.isValid()) continue;
            PhoneNumberFormatter.format(phoneNumber);
            if (!phoneNumber.isValid()) continue;
            thisOrg.getPhoneNumberList().add(phoneNumber);
        }
    }

    private static void copyPropertiesFromContactToOrganization(Contact from, Organization to) {
        to.setRevenue(from.getRevenue());
        to.setEmployees(from.getEmployees());
        to.setDunsType(from.getDunsType());
        to.setYearStarted(from.getYearStarted());
        to.setDunsNumber(from.getDunsNumber());
        to.setBusinessNameTwo(from.getBusinessNameTwo());
        to.setSicDescription(from.getSicDescription());
        to.setSicCode(from.getSicCode());
        to.setNotes(from.getNotes());
    }

    public void cancel() {
        try {
            this.importThread = null;
            this.setStatusId(5);
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.importThread = null;
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ContactImport -> Starting cleanup for ImportId: " + this.getId());
        }
        try {
            this.recordResults(this.db);
            this.fos.flush();
            this.fos.close();
            if (this.getTotalFailedRecords() > 0) {
                this.fileItem.setSubject("Error file");
                this.fileItem.setFilename(this.fileItem.getFilename() + "_error");
                this.fileItem.setClientFilename(this.getId() + "_error.csv");
                this.fileItem.setVersion(1.1);
                this.fileItem.setSize((int)this.errorFile.length());
                this.fileItem.insertVersion(this.db);
            } else {
                this.errorFile.delete();
            }
            this.manager.free(this);
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                e.printStackTrace();
            }
        }
        finally {
            this.manager.free(this.db);
        }
    }

    private void recordError(String error, String line, int lineNumber) {
        try {
            if (lineNumber == 0) {
                line = line + ",\"_ERROR\"";
            } else if (lineNumber == -1) {
                line = line + error;
            } else if (lineNumber > 0) {
                line = line + ",\"" + error + "\"";
                this.incrementTotalFailedRecords();
            }
            line = line + "\n";
            this.fos.write(line);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getValue(ArrayList thisRecord, Property type) {
        String value = null;
        if (type.getMappedColumn() > -1 && thisRecord.size() > type.getMappedColumn()) {
            value = (String)thisRecord.get(type.getMappedColumn());
        } else if (!"".equals(StringUtils.toString(type.getDefaultValue()))) {
            value = type.getDefaultValue();
        }
        return value;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        int i = 0;
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as recordcount FROM contact WHERE import_id = ? ");
        pst.setInt(++i, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = rs.getInt("recordCount");
        }
        rs.close();
        pst.close();
        Dependency thisDependency = new Dependency();
        thisDependency.setName("contacts");
        thisDependency.setCount(recordCount);
        thisDependency.setCanDelete(true);
        dependencyList.add(thisDependency);
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            if (this.getStatusId() != 1 || this.getStatusId() != 2) {
                ContactImport.deleteImportedRecords(db, this.getId());
            }
            PreparedStatement pst = db.prepareStatement("DELETE from import WHERE import_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public static boolean deleteImportedRecords(Connection db, int thisImportId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM contact_emailaddress WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_emailaddress.contact_id AND import_id = ?) ");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM contact_phone WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_phone.contact_id AND import_id = ?) ");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM contact_address WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_address.contact_id AND import_id = ?) ");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM contact WHERE import_id = ?");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

