/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.modules.contacts.base.ContactImport;
import org.aspcfs.utils.CFSFileReader;
import org.aspcfs.utils.StringUtils;

public class ContactImportValidate {
    PropertyMap propertyMap = null;
    LinkedHashMap fieldMappings = new LinkedHashMap();
    ArrayList sampleRecords = new ArrayList();
    ContactImport contactImport = null;
    HashMap errors = new HashMap();
    String filePath = null;

    public void setPropertyMap(PropertyMap tmp) {
        this.propertyMap = tmp;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setFieldMappings(LinkedHashMap tmp) {
        this.fieldMappings = tmp;
    }

    public LinkedHashMap getFieldMappings() {
        return this.fieldMappings;
    }

    public void setContactImport(ContactImport tmp) {
        this.contactImport = tmp;
    }

    public void setSampleRecords(ArrayList tmp) {
        this.sampleRecords = tmp;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public ArrayList getGeneralErrors() {
        if (this.errors.containsKey("generalErrors")) {
            return (ArrayList)this.errors.get("generalErrors");
        }
        return null;
    }

    public HashMap getFieldErrors() {
        if (this.errors.containsKey("fieldErrors")) {
            return (HashMap)this.errors.get("fieldErrors");
        }
        return null;
    }

    public ArrayList getSampleRecords() {
        return this.sampleRecords;
    }

    public ContactImport getContactImport() {
        return this.contactImport;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void initialize() {
        this.autoMapProperties();
        this.buildImportSample(5);
    }

    public void autoMapProperties() {
        ArrayList thisRecord = null;
        try {
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.contactImport.getFileType());
            CFSFileReader.Record record = null;
            record = fileReader.nextLine();
            if (record != null && ((thisRecord = record.data) == null || thisRecord.size() < 1)) {
                this.addGeneralError("Invalid Header: Could not parse line based on data or there data is insufficient");
                return;
            }
            int fieldNumber = -1;
            Iterator fields = thisRecord.iterator();
            while (fields.hasNext()) {
                ++fieldNumber;
                String field = (String)fields.next();
                if ("_ERROR".equals(field)) continue;
                if (!"".equals(StringUtils.toString(field))) {
                    if (this.fieldMappings.containsKey(field)) {
                        this.addGeneralError("Duplicate Field: Field \"" + field + "\" occurs twice in the header record");
                        continue;
                    }
                    Property thisProperty = this.propertyMap.mapProperty(field, fieldNumber);
                    this.fieldMappings.put(field, thisProperty);
                    continue;
                }
                this.addGeneralError("Invalid Field: Field Number " + fieldNumber + "is blank");
            }
            if (System.getProperty("DEBUG") != null) {
                this.printHeaderMappings();
            }
        }
        catch (FileNotFoundException e) {
            this.addGeneralError("File Not Found: Import file does not exist");
        }
        catch (Exception e) {
            System.out.println("ContactImportValidate -> EXCEPTION " + e);
        }
    }

    public void buildImportSample(int count) {
        try {
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.contactImport.getFileType());
            CFSFileReader.Record record = null;
            ArrayList header = null;
            while ((record = fileReader.nextLine()) != null && count > 0) {
                if (record.isEmpty()) continue;
                this.sampleRecords.add(record.line);
                if (this.sampleRecords.size() == 1) {
                    header = record.data;
                }
                if (this.sampleRecords.size() == 2 && header.size() != record.data.size()) {
                    this.addGeneralError("Insufficient Data: Count of columns in header and data do not match");
                }
                --count;
            }
        }
        catch (FileNotFoundException e) {
            this.addGeneralError("File Not Found: Import file does not exist");
        }
        catch (Exception e) {
            System.out.println("ContactImportValidatea -> Sampling Exception " + e);
        }
    }

    public void validate(HttpServletRequest request) {
        ArrayList thisRecord = null;
        try {
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.contactImport.getFileType());
            CFSFileReader.Record record = null;
            record = fileReader.nextLine();
            if (record != null && ((thisRecord = record.data) == null || thisRecord.size() < 1)) {
                this.addGeneralError("Invalid Header: Could not parse line based on data or there data is insufficient");
                return;
            }
            int fieldNumber = -1;
            Iterator fields = thisRecord.iterator();
            while (fields.hasNext()) {
                ++fieldNumber;
                String field = (String)fields.next();
                if ("_ERROR".equals(field)) continue;
                if (this.fieldMappings.containsKey(field)) {
                    this.addGeneralError("Duplicate Field: Field \"" + field + "\" occurs twice in the header record");
                    continue;
                }
                Property mappedProperty = null;
                if (request.getParameter(field) != null) {
                    String propertyName = request.getParameter(field);
                    String groupId = request.getParameter(field + "groupId");
                    if (!"-1".equals(propertyName)) {
                        Property thisProperty = this.propertyMap.getProperty(field, propertyName, groupId);
                        if (thisProperty.getMappedColumn() > 0) {
                            if (thisProperty.getGroupId() > 0) {
                                this.addFieldError(field, "Multiple Property Map: The property \"" + thisProperty.getDisplayName() + " has already been mapped to another field");
                            } else {
                                this.addFieldError(field, "Multiple Property Map: The property \"" + thisProperty.getDisplayName() + "\" has already been mapped to another field");
                            }
                        } else {
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("** Mapping " + field + " to " + fieldNumber);
                            }
                            thisProperty.setMappedColumn(fieldNumber);
                            mappedProperty = thisProperty;
                            if (mappedProperty.getName().equals("email")) {
                                String emailType = request.getParameter(field + "_hiddenemailtype");
                                Property emailTypeProperty = this.propertyMap.getProperty(field, "contactEmail.type", groupId);
                                emailTypeProperty.setDefaultValue(emailType);
                            }
                            if (mappedProperty.getName().equals("number")) {
                                String phoneType = request.getParameter(field + "_hiddenphonetype");
                                Property phoneTypeProperty = this.propertyMap.getProperty(field, "contactPhone.type", groupId);
                                phoneTypeProperty.setDefaultValue(phoneType);
                            }
                            if (mappedProperty.getName().equals("streetAddressLine1")) {
                                String addressType = request.getParameter(field + "_hiddenaddresstype");
                                Property addressTypeProperty = this.propertyMap.getProperty(field, "contactAddress.type", groupId);
                                addressTypeProperty.setDefaultValue(addressType);
                            }
                        }
                    }
                }
                this.fieldMappings.put(field, mappedProperty);
            }
            this.checkRequiredProperties();
            this.buildImportSample(5);
        }
        catch (FileNotFoundException e) {
            this.addGeneralError("File Not Found: Import file does not exist");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ContactImportValidate -> Sampling Exception " + e);
        }
    }

    public void checkRequiredProperties() {
        ArrayList thisList = this.propertyMap.getRequiredProperties();
        if (thisList.size() > 0) {
            for (Property p : thisList) {
                if (p.getMappedColumn() >= 0 || !p.checkIsRequired(this.fieldMappings)) continue;
                if (!"".equals(StringUtils.toString(p.getSubstitute()))) {
                    String substitute = p.getSubstitute();
                    Property thisProp = this.propertyMap.getProperty(substitute);
                    if (thisProp.getMappedColumn() >= 0) continue;
                    this.addGeneralError("Required Property: The property " + p.getDisplayName() + " or " + thisProp.getDisplayName() + " is required");
                    continue;
                }
                this.addGeneralError("Required Property: The property " + p.getDisplayName() + " is required");
            }
        }
    }

    public void addGeneralError(String error) {
        if (!this.errors.containsKey("generalErrors")) {
            this.errors.put("generalErrors", new ArrayList());
        }
        ArrayList thisList = (ArrayList)this.errors.get("generalErrors");
        thisList.add(error);
    }

    public void addFieldError(String field, String error) {
        if (!this.errors.containsKey("fieldErrors")) {
            this.errors.put("fieldErrors", new HashMap());
        }
        HashMap thisMap = (HashMap)this.errors.get("fieldErrors");
        thisMap.put(field, error);
    }

    public void printHeaderMappings() {
        System.out.println("================= Auto Mapped Fields =====================");
        for (String field : this.fieldMappings.keySet()) {
            Property property = (Property)this.fieldMappings.get(field);
            if (property == null || property.getMappedColumn() <= -1) continue;
            System.out.println(property.getUniqueName() + ":" + property.getMappedColumn());
        }
        System.out.println("===========================================================");
    }
}

