/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.io.File;
import java.util.Iterator;
import org.aspcfs.modules.base.Address;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.modules.base.InstantMessageAddress;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.modules.base.TextMessageAddress;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddressList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ContactInformationFormatter {
    public static String getContactInformation(Contact contact, String propertyFile) throws Exception {
        File configFile = new File(propertyFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        ContactEmailAddressList tmpContactEmailAddressList = contact.getEmailAddressList();
        ContactInstantMessageAddressList tmpContactInstantMessageAddressList = contact.getInstantMessageAddressList();
        ContactTextMessageAddressList tmpContactTextMessageAddressList = contact.getTextMessageAddressList();
        ContactPhoneNumberList tmpContactPhoneNumberList = contact.getPhoneNumberList();
        ContactAddressList tmpContactAddressList = contact.getAddressList();
        Template template = new Template();
        template.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "contactInformation.details")));
        ContactInformationFormatter.addSystemInfo(template, contact);
        template.addParseElement("${name}", contact.getNameFull());
        template.addParseElement("${additionalNames}", contact.getAdditionalNames());
        template.addParseElement("${nickname}", contact.getNickname());
        template.addParseElement("${birthDate}", StringUtils.toDateString(contact.getBirthDate()));
        template.addParseElement("${title}", contact.getTitle());
        template.addParseElement("${role}", contact.getRole());
        StringBuffer infoString = new StringBuffer();
        Iterator itr = tmpContactEmailAddressList.iterator();
        String noInformationString = "";
        noInformationString = template.getValue("noEmailAddresses");
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                EmailAddress tmpEmailAddress = (EmailAddress)((Object)itr.next());
                infoString.append("<b>" + tmpEmailAddress.getTypeName() + ":</b> " + tmpEmailAddress.getEmail() + "<br />");
            }
            template.addParseElement("${emailAddresses}", infoString.toString());
            template.addParseElement("${noEmailAddresses=" + noInformationString + "}", "");
        } else {
            template.addParseElement("${emailAddresses}", "");
            template.addParseElement("${noEmailAddresses=" + noInformationString + "}", noInformationString);
        }
        infoString = new StringBuffer();
        itr = tmpContactInstantMessageAddressList.iterator();
        noInformationString = template.getValue("noInstantMessageAddresses");
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                InstantMessageAddress tmpInstantMessageAddress = (InstantMessageAddress)itr.next();
                infoString.append("<b>" + tmpInstantMessageAddress.getAddressIMServiceName() + " (" + tmpInstantMessageAddress.getAddressIMTypeName() + "):</b> " + tmpInstantMessageAddress.getAddressIM() + "<br />");
            }
            template.addParseElement("${instantMessageAddresses}", infoString.toString());
            template.addParseElement("${noInstantMessageAddresses=" + noInformationString + "}", "");
        } else {
            template.addParseElement("${instantMessageAddresses}", "");
            template.addParseElement("${noInstantMessageAddresses=" + noInformationString + "}", noInformationString);
        }
        infoString = new StringBuffer();
        itr = tmpContactTextMessageAddressList.iterator();
        noInformationString = template.getValue("noTextMessageAddresses");
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                TextMessageAddress tmpTextMessageAddress = (TextMessageAddress)itr.next();
                infoString.append("<b>" + tmpTextMessageAddress.getTypeName() + ":</b> " + tmpTextMessageAddress.getTextMessageAddress() + "<br />");
            }
            template.addParseElement("${textMessageAddresses}", infoString.toString());
            template.addParseElement("${noTextMessageAddresses=" + noInformationString + "}", "");
        } else {
            template.addParseElement("${textMessageAddresses}", "");
            template.addParseElement("${noTextMessageAddresses=" + noInformationString + "}", noInformationString);
        }
        infoString = new StringBuffer();
        itr = tmpContactPhoneNumberList.iterator();
        noInformationString = template.getValue("noPhoneNumbers");
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                PhoneNumber tmpPhoneNumber = (PhoneNumber)itr.next();
                infoString.append("<b>" + tmpPhoneNumber.getTypeName() + ":</b> " + tmpPhoneNumber.getPhoneNumber() + "<br />");
            }
            template.addParseElement("${phoneNumbers}", infoString.toString());
            template.addParseElement("${noPhoneNumbers=" + noInformationString + "}", "");
        } else {
            template.addParseElement("${phoneNumbers}", "");
            template.addParseElement("${noPhoneNumbers=" + noInformationString + "}", noInformationString);
        }
        infoString = new StringBuffer();
        itr = tmpContactAddressList.iterator();
        noInformationString = template.getValue("noPostalAddresses");
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                Address tmpAddress = (Address)itr.next();
                infoString.append("<b>" + tmpAddress.getTypeName() + ":</b><br />" + tmpAddress.toString() + "<br /><br />");
            }
            template.addParseElement("${postalAddresses}", infoString.toString());
            template.addParseElement("${noPostalAddresses=" + noInformationString + "}", "");
        } else {
            template.addParseElement("${postalAddresses}", "");
            template.addParseElement("${noPostalAddresses=" + noInformationString + "}", noInformationString);
        }
        return template.getParsedText();
    }

    private static void addSystemInfo(Template template, Contact contact) throws Exception {
        if (StringUtils.hasText(contact.getSecretWord())) {
            String text = "<b>Your Secret Word:</b> ${secret_word}" + template.getText();
            template.addParseElement("${secret_word}", StringUtils.toString(contact.getSecretWord()) + "<br /><br />");
            template.setText(text);
        }
    }
}

