/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.base.InstantMessageAddress;
import org.aspcfs.utils.DatabaseUtils;

public class ContactInstantMessageAddress
extends InstantMessageAddress {
    public ContactInstantMessageAddress() {
        this.isContact = true;
    }

    public ContactInstantMessageAddress(ResultSet rs) throws SQLException {
        this.isContact = true;
        this.buildRecord(rs);
    }

    public ContactInstantMessageAddress(Connection db, int addressId) throws SQLException {
        this.queryRecord(db, addressId);
    }

    public ContactInstantMessageAddress(Connection db, String addressId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(addressId));
    }

    public void queryRecord(Connection db, int addressId) throws SQLException {
        this.isContact = true;
        if (addressId < 0) {
            throw new SQLException("Valid Instant Message Address ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT cim.*, lims.description AS service_description, limt.description AS type_description FROM contact_imaddress cim LEFT JOIN lookup_im_services lims ON (cim.imaddress_service = lims.code) LEFT JOIN lookup_im_types limt ON (cim.imaddress_type = limt.code) WHERE cim.address_id = ? ");
        pst.setInt(1, addressId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Instant Message Address record not found.");
        }
    }

    public void process(Connection db, int contactId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setContactId(contactId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getContactId(), this.getEnteredBy());
    }

    public void insert(Connection db, int contactId, int enteredBy) throws SQLException {
        this.setId(DatabaseUtils.getNextSeq(db, "contact_imaddress_address_id_seq"));
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO contact_imaddress (contact_id, imaddress_type, imaddress_service, imaddress, primary_im, ");
        if (this.getId() > -1) {
            sql.append("address_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredby, modifiedby ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ");
        if (this.getId() > -1) {
            sql.append("?, ");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (contactId > -1) {
            pst.setInt(++i, this.getContactId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getAddressIMType() > -1) {
            pst.setInt(++i, this.getAddressIMType());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getAddressIMService() > -1) {
            pst.setInt(++i, this.getAddressIMService());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getAddressIM());
        pst.setBoolean(++i, this.getPrimaryIM());
        if (this.getId() > -1) {
            pst.setInt(++i, this.getId());
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "contact_imaddress_address_id_seq", this.getId()));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact_imaddress SET imaddress_type = ?, imaddress_service = ?, imaddress = ?, primary_im = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE address_id = ? ");
        int i = 0;
        if (this.getAddressIMType() > -1) {
            pst.setInt(++i, this.getAddressIMType());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getAddressIMService() > -1) {
            pst.setInt(++i, this.getAddressIMService());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getAddressIM());
        pst.setBoolean(++i, this.getPrimaryIM());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM contact_imaddress WHERE address_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

