/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.InstantMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddress;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class ContactInstantMessageAddressList
extends InstantMessageAddressList {
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public ContactInstantMessageAddressList() {
    }

    public ContactInstantMessageAddressList(HttpServletRequest request) {
        int i = 0;
        int primaryIMAddress = -1;
        if (request.getParameter("primaryIM") != null) {
            primaryIMAddress = Integer.parseInt(request.getParameter("primaryIM"));
        }
        while (request.getParameter("instantmessage" + ++i + "type") != null) {
            ContactInstantMessageAddress thisAddress = new ContactInstantMessageAddress();
            thisAddress.buildRecord(request, i);
            if (primaryIMAddress == i) {
                thisAddress.setPrimaryIM(true);
            }
            if (!thisAddress.isValid()) continue;
            this.addElement(thisAddress);
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT cim.*, lims.description AS service_description, limt.description AS type_description FROM contact_imaddress cim LEFT JOIN lookup_im_services lims ON (cim.imaddress_service = lims.code) LEFT JOIN lookup_im_types limt ON (cim.imaddress_type = limt.code) WHERE cim.address_id > -1 ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact_imaddress cim LEFT JOIN lookup_im_services lims ON (cim.imaddress_service = lims.code) LEFT JOIN lookup_im_types limt ON (cim.imaddress_type = limt.code) WHERE cim.address_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(imaddress) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", imaddress ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY imaddress ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            ContactInstantMessageAddress thisAddress = new ContactInstantMessageAddress(rs);
            this.addElement(thisAddress);
        }
        rs.close();
        pst.close();
    }

    public String getEmptyHtmlSelect(String selectName) {
        HtmlSelect select = new HtmlSelect();
        select.addItem(-1, "-- None --");
        return select.getHtml(selectName);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect select = new HtmlSelect();
        select.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            select.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (ContactInstantMessageAddress thisAddress : this) {
            select.addItem(thisAddress.getId(), thisAddress.getAddressIM() + (thisAddress.getPrimaryIM() ? "*" : ""));
        }
        return select.getHtml(selectName, defaultKey);
    }
}

