/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.UserCentric;
import org.aspcfs.modules.communications.base.SearchCriteriaElement;
import org.aspcfs.modules.communications.base.SearchCriteriaGroup;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ContactList
extends Vector
implements UserCentric {
    private static final long serialVersionUID = -8573897895619490285L;
    public static final int EXCLUDE_PERSONAL = -1;
    public static final int IGNORE_PERSONAL = -2;
    private int includeEnabled = 1;
    private boolean includeEnabledUsersOnly = false;
    private boolean includeNonUsersOnly = false;
    private boolean includeUsersOnly = false;
    private int userRoleType = -1;
    private int defaultContactId = -1;
    private PagedListInfo pagedListInfo = null;
    private int contactUserId = -1;
    private int orgId = -1;
    private int typeId = -1;
    private int departmentId = -1;
    private int projectId = -1;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private String title = null;
    private String company = null;
    private boolean emailNotNull = false;
    private Vector ignoreTypeIdList = new Vector();
    private boolean checkUserAccess = false;
    private boolean checkEnabledUserAccess = false;
    private int checkExcludedFromCampaign = -1;
    private boolean buildDetails = true;
    private boolean buildPhoneNumbers = false;
    private boolean buildTypes = true;
    private int owner = -1;
    private String ownerIdRange = null;
    private String accountOwnerIdRange = null;
    private boolean withAccountsOnly = false;
    private boolean withProjectsOnly = false;
    private int employeesOnly = -1;
    private int leadsOnly = -1;
    private int leadStatusExists = -1;
    private boolean excludeAccountContacts = false;
    private int hierarchialUsers = -1;
    private int leadStatus = -1;
    private int source = -1;
    private int rating = -1;
    private int industry = -1;
    private String comments = null;
    private int readBy = -1;
    private Timestamp enteredStart = null;
    private Timestamp enteredEnd = null;
    private Timestamp conversionDateStart = null;
    private Timestamp conversionDateEnd = null;
    private String postalCode = null;
    private int hasConversionDate = -1;
    private String emailAddress = null;
    private String country = null;
    private boolean ownerOrReader = false;
    private String city = null;
    private String state = null;
    private String state1 = null;
    private boolean allContacts = false;
    private boolean controlledHierarchyOnly = false;
    private String permission = null;
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;
    private int sclOwnerId = -1;
    private String sclOwnerIdRange = null;
    private HashMap companyHash = null;
    private HashMap nameFirstHash = null;
    private HashMap nameLastHash = null;
    private HashMap dateHash = null;
    private HashMap zipHash = null;
    private HashMap areaCodeHash = null;
    private HashMap cityHash = null;
    private HashMap typeIdHash = null;
    private HashMap contactIdHash = null;
    private HashMap titleHash = null;
    private HashMap accountTypeIdHash = null;
    private HashMap siteIdHash = null;
    boolean firstCriteria = true;
    private String contactIdRange = null;
    private SearchCriteriaList scl = null;
    private int userId = -1;
    private String searchText = "";
    private int ruleId = -1;
    private int personalId = -1;
    AccessTypeList accessTypes = null;
    AccessTypeList generalContactAccessTypes = null;
    UserList users = new UserList();
    private int importId = -1;
    private int statusId = -1;
    private boolean excludeUnapprovedContacts = true;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private boolean showTrashedAndNormal = false;
    private int oldestFirst = -1;
    private boolean zipCodeAscPotentialDesc = false;
    private HashMap errors = new HashMap();
    private HashMap warnings = new HashMap();
    private String nextValue = null;
    private String accountName = null;
    private String contactPhoneNumber = null;
    private String accountSegment = null;
    private String contactCity = null;
    private String contactState = null;
    private String accountPostalCode = null;
    private String accountNumber = null;
    private int accountTypeId = -1;
    private int accountOwnerId = -1;
    private int includeEnabledAccount = -1;
    private String assetSerialNumber = null;
    private int orgSiteId = -1;
    private int userSiteId = -1;
    private int importSiteId = -1;
    private boolean includeContactsFromImportsOfAllSites = false;
    private boolean includeContactsFromOrganizationsWithoutSite = false;
    private boolean includeUsersWithAccessToAllSites = false;
    private int siteId = -1;
    private boolean exclusiveToSite = false;
    private boolean includeAllSites = false;
    private int portalUsersOnly = -1;
    private static long milies = -1L;
    private static Logger logger = Logger.getLogger(ContactList.class);

    public int getContactUserId() {
        return this.contactUserId;
    }

    public void setContactUserId(int tmp) {
        this.contactUserId = tmp;
    }

    public void setContactUserId(String tmp) {
        this.contactUserId = Integer.parseInt(tmp);
    }

    public void setIncludeUsersOnly(boolean includeUsersOnly) {
        this.includeUsersOnly = includeUsersOnly;
    }

    public void setIncludeUsersOnly(String includeUsersOnly) {
        this.includeUsersOnly = DatabaseUtils.parseBoolean(includeUsersOnly);
    }

    public int getUserRoleType() {
        return this.userRoleType;
    }

    public void setUserRoleType(int tmp) {
        this.userRoleType = tmp;
    }

    public void setUserRoleType(String tmp) {
        this.userRoleType = Integer.parseInt(tmp);
    }

    public int getIndustry() {
        return this.industry;
    }

    public void setIndustry(int tmp) {
        this.industry = tmp;
    }

    public void setIndustry(String tmp) {
        this.industry = Integer.parseInt(tmp);
    }

    public void setCheckExcludedFromCampaign(int checkExcludedFromCampaign) {
        this.checkExcludedFromCampaign = checkExcludedFromCampaign;
    }

    public void setContactIdRange(String contactIdRange) {
        this.contactIdRange = contactIdRange;
    }

    public void setExcludeAccountContacts(boolean excludeAccountContacts) {
        this.excludeAccountContacts = excludeAccountContacts;
    }

    public boolean getExcludeAccountContacts() {
        return this.excludeAccountContacts;
    }

    public int getEmployeesOnly() {
        return this.employeesOnly;
    }

    public void setEmployeesOnly(int tmp) {
        this.employeesOnly = tmp;
    }

    public void setEmployeesOnly(String tmp) {
        this.employeesOnly = Integer.parseInt(tmp);
    }

    public HashMap getAccountTypeIdHash() {
        return this.accountTypeIdHash;
    }

    public void setAccountTypeIdHash(HashMap accountTypeIdHash) {
        this.accountTypeIdHash = accountTypeIdHash;
    }

    public void setSiteIdHash(HashMap tmp) {
        this.siteIdHash = tmp;
    }

    public HashMap getSiteIdHash() {
        return this.siteIdHash;
    }

    public void setIncludeEnabledUsersOnly(boolean includeEnabledUsersOnly) {
        this.includeEnabledUsersOnly = includeEnabledUsersOnly;
    }

    public void setIncludeEnabledUsersOnly(String tmp) {
        this.includeEnabledUsersOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAccessTypes(AccessTypeList accessTypes) {
        this.accessTypes = accessTypes;
    }

    public AccessTypeList getAccessTypes() {
        return this.accessTypes;
    }

    public AccessTypeList getGeneralContactAccessTypes() {
        return this.generalContactAccessTypes;
    }

    public void setGeneralContactAccessTypes(AccessTypeList tmp) {
        this.generalContactAccessTypes = tmp;
    }

    public boolean getIncludeEnabledUsersOnly() {
        return this.includeEnabledUsersOnly;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setPersonalId(int personalId) {
        this.personalId = personalId;
    }

    public void setPersonalId(int personalId, AccessTypeList accessTypes) {
        this.personalId = personalId;
        this.accessTypes = accessTypes;
    }

    public int getPersonalId() {
        return this.personalId;
    }

    public HashMap getNameFirstHash() {
        return this.nameFirstHash;
    }

    public void setNameFirstHash(HashMap nameFirstHash) {
        this.nameFirstHash = nameFirstHash;
    }

    public void setAllContacts(boolean allContacts) {
        this.allContacts = allContacts;
    }

    public void setAllContacts(boolean allContacts, int owner, String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
        this.allContacts = allContacts;
        this.personalId = owner;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setContactPhoneNumber(String tmp) {
        this.contactPhoneNumber = tmp;
    }

    public void setAccountSegment(String accountSegment) {
        this.accountSegment = accountSegment;
    }

    public void setContactCity(String tmp) {
        this.contactCity = tmp;
    }

    public void setContactState(String tmp) {
        this.contactState = tmp;
    }

    public void setContactCountry(String tmp) {
        this.country = tmp;
    }

    public void setAccountPostalCode(String tmp) {
        this.accountPostalCode = tmp;
    }

    public void setOrgSiteId(int orgSiteId) {
        this.orgSiteId = orgSiteId;
    }

    public void setOrgSiteId(String orgSiteId) {
        this.orgSiteId = Integer.parseInt(orgSiteId);
    }

    public int getOrgSiteId() {
        return this.orgSiteId;
    }

    public void setUserSiteId(int tmp) {
        this.userSiteId = tmp;
    }

    public void setUserSiteId(String tmp) {
        this.userSiteId = Integer.parseInt(tmp);
    }

    public int getUserSiteId() {
        return this.userSiteId;
    }

    public void setIncludeContactsFromOrganizationsWithoutSite(boolean tmp) {
        this.includeContactsFromOrganizationsWithoutSite = tmp;
    }

    public void setIncludeContactsFromOrganizationsWithoutSite(String tmp) {
        this.includeContactsFromOrganizationsWithoutSite = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIncludeUsersWithAccessToAllSites(boolean tmp) {
        this.includeUsersWithAccessToAllSites = tmp;
    }

    public void setIncludeUsersWithAccessToAllSites(String tmp) {
        this.includeUsersWithAccessToAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeContactsFromOrganizationsWithoutSite() {
        return this.includeContactsFromOrganizationsWithoutSite;
    }

    public boolean getIncludeUsersWithAccessToAllSites() {
        return this.includeUsersWithAccessToAllSites;
    }

    public void setImportSiteId(int tmp) {
        this.importSiteId = tmp;
    }

    public void setImportSiteId(String tmp) {
        this.importSiteId = Integer.parseInt(tmp);
    }

    public void setIncludeContactsFromImportsOfAllSites(boolean tmp) {
        this.includeContactsFromImportsOfAllSites = tmp;
    }

    public void setIncludeContactsFromImportsOfAllSites(String tmp) {
        this.includeContactsFromImportsOfAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public int getImportSiteId() {
        return this.importSiteId;
    }

    public boolean getIncludeContactsFromImportsOfAllSites() {
        return this.includeContactsFromImportsOfAllSites;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setAccountNumber(String tmp) {
        this.accountNumber = tmp;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountTypeId(int tmp) {
        this.accountTypeId = tmp;
    }

    public void setAccountTypeId(String tmp) {
        this.accountTypeId = Integer.parseInt(tmp);
    }

    public int getAccountTypeId() {
        return this.accountTypeId;
    }

    public void setAccountOwnerId(int tmp) {
        this.accountOwnerId = tmp;
    }

    public void setAccountOwnerId(String tmp) {
        this.accountOwnerId = Integer.parseInt(tmp);
    }

    public int getAccountOwnerId() {
        return this.accountOwnerId;
    }

    public void setIncludeEnabledAccount(int tmp) {
        this.includeEnabledAccount = tmp;
    }

    public void setIncludeEnabledAccount(String tmp) {
        this.includeEnabledAccount = Integer.parseInt(tmp);
    }

    public int getIncludeEnabledAccount() {
        return this.includeEnabledAccount;
    }

    public void setAssetSerialNumber(String tmp) {
        this.assetSerialNumber = tmp;
    }

    public String getAssetSerialNumber() {
        return this.assetSerialNumber;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public String getAccountSegment() {
        return this.accountSegment;
    }

    public String getContactCity() {
        return this.contactCity;
    }

    public String getContactState() {
        return this.contactState;
    }

    public String getAccountPostalCode() {
        return this.accountPostalCode;
    }

    public boolean getAllContacts() {
        return this.allContacts;
    }

    public HashMap getDateHash() {
        return this.dateHash;
    }

    public void setDateHash(HashMap dateHash) {
        this.dateHash = dateHash;
    }

    public HashMap getZipHash() {
        return this.zipHash;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setZipHash(HashMap zipHash) {
        this.zipHash = zipHash;
    }

    public void setContactIdHash(HashMap contactIdHash) {
        this.contactIdHash = contactIdHash;
    }

    public HashMap getContactIdHash() {
        return this.contactIdHash;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setControlledHierarchyOnly(boolean controlledHierarchyOnly) {
        this.controlledHierarchyOnly = controlledHierarchyOnly;
    }

    public void setControlledHierarchyOnly(boolean controlledHierarchyOnly, String ownerIdRange) {
        this.controlledHierarchyOnly = controlledHierarchyOnly;
        this.ownerIdRange = ownerIdRange;
    }

    public boolean getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public boolean getFirstCriteria() {
        return this.firstCriteria;
    }

    public void setFirstCriteria(boolean firstCriteria) {
        this.firstCriteria = firstCriteria;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public HashMap getCityHash() {
        return this.cityHash;
    }

    public void setCityHash(HashMap cityHash) {
        this.cityHash = cityHash;
    }

    public void setOwnerIdRange(String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public void setEmptyHtmlSelectRecord(String emptyHtmlSelectRecord) {
        this.emptyHtmlSelectRecord = emptyHtmlSelectRecord;
    }

    public void setAccountOwnerIdRange(String tmp) {
        this.accountOwnerIdRange = tmp;
    }

    public void setWithAccountsOnly(boolean tmp) {
        this.withAccountsOnly = tmp;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public HashMap getNameLastHash() {
        return this.nameLastHash;
    }

    public void setNameLastHash(HashMap nameLastHash) {
        this.nameLastHash = nameLastHash;
    }

    public void setScl(SearchCriteriaList scl, int thisOwnerId, String thisUserRange) {
        this.scl = scl;
        this.sclOwnerId = thisOwnerId;
        this.sclOwnerIdRange = thisUserRange;
        this.buildQuery(thisOwnerId, thisUserRange);
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    public boolean getCheckEnabledUserAccess() {
        return this.checkEnabledUserAccess;
    }

    public void setCheckEnabledUserAccess(boolean checkEnabledUserAccess) {
        this.checkEnabledUserAccess = checkEnabledUserAccess;
    }

    public void setMiddleName(String tmp) {
        this.middleName = tmp;
    }

    public void setLastName(String tmp) {
        this.lastName = tmp;
    }

    public HashMap getCompanyHash() {
        return this.companyHash;
    }

    public void setCompanyHash(HashMap companyHash) {
        this.companyHash = companyHash;
    }

    public int getSclOwnerId() {
        return this.sclOwnerId;
    }

    public String getSclOwnerIdRange() {
        return this.sclOwnerIdRange;
    }

    public void setSclOwnerId(int tmp) {
        this.sclOwnerId = tmp;
    }

    public void setSclOwnerIdRange(String tmp) {
        this.sclOwnerIdRange = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setEmailNotNull(boolean emailNotNull) {
        this.emailNotNull = emailNotNull;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setCheckUserAccess(boolean tmp) {
        this.checkUserAccess = tmp;
    }

    public void setBuildDetails(boolean tmp) {
        this.buildDetails = tmp;
    }

    public void setBuildPhoneNumbers(boolean tmp) {
        this.buildPhoneNumbers = tmp;
    }

    public void setBuildPhoneNumbers(String tmp) {
        this.buildPhoneNumbers = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildTypes(boolean tmp) {
        this.buildTypes = tmp;
    }

    public void setSearchValues(HashMap[] outerHash) {
        this.companyHash = outerHash[0];
        this.nameFirstHash = outerHash[1];
        this.nameLastHash = outerHash[2];
        this.dateHash = outerHash[3];
        this.zipHash = outerHash[4];
        this.areaCodeHash = outerHash[5];
        this.cityHash = outerHash[6];
        this.typeIdHash = outerHash[7];
        this.contactIdHash = outerHash[8];
        this.titleHash = outerHash[9];
        this.accountTypeIdHash = outerHash[10];
        this.siteIdHash = outerHash[11];
    }

    public void setDepartmentId(int departmentId) {
        this.departmentId = departmentId;
    }

    public void setWithProjectsOnly(boolean withProjectsOnly) {
        this.withProjectsOnly = withProjectsOnly;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getContactIdRange() {
        return this.contactIdRange;
    }

    public int getCheckExcludedFromCampaign() {
        return this.checkExcludedFromCampaign;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public HashMap getTypeIdHash() {
        return this.typeIdHash;
    }

    public void setTypeIdHash(HashMap typeIdHash) {
        this.typeIdHash = typeIdHash;
    }

    public int getIncludeEnabled() {
        return this.includeEnabled;
    }

    public void setIncludeEnabled(int includeEnabled) {
        this.includeEnabled = includeEnabled;
    }

    public HashMap getAreaCodeHash() {
        return this.areaCodeHash;
    }

    public void setAreaCodeHash(HashMap areaCodeHash) {
        this.areaCodeHash = areaCodeHash;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public String getAccountOwnerIdRange() {
        return this.accountOwnerIdRange;
    }

    public boolean getWithAccountsOnly() {
        return this.withAccountsOnly;
    }

    public SearchCriteriaList getScl() {
        return this.scl;
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setExcludeUnapprovedContacts(boolean tmp) {
        this.excludeUnapprovedContacts = tmp;
    }

    public void setExcludeUnapprovedContacts(String tmp) {
        this.excludeUnapprovedContacts = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExcludeUnapprovedContacts() {
        return this.excludeUnapprovedContacts;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public boolean getShowTrashedAndNormal() {
        return this.showTrashedAndNormal;
    }

    public void setShowTrashedAndNormal(boolean tmp) {
        this.showTrashedAndNormal = tmp;
    }

    public void setShowTrashedAndNormal(String tmp) {
        this.showTrashedAndNormal = DatabaseUtils.parseBoolean(tmp);
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getImportId() {
        return this.importId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getEmailNotNull() {
        return this.emailNotNull;
    }

    public int getOwner() {
        return this.owner;
    }

    public String getCompany() {
        return this.company;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getIncludeNonUsersOnly() {
        return this.includeNonUsersOnly;
    }

    public void setIncludeNonUsersOnly(boolean includeNonUsersOnly) {
        this.includeNonUsersOnly = includeNonUsersOnly;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public int getHierarchialUsers() {
        return this.hierarchialUsers;
    }

    public void setHierarchialUsers(int tmp) {
        this.hierarchialUsers = tmp;
    }

    public void setHierarchialUsers(String tmp) {
        this.hierarchialUsers = Integer.parseInt(tmp);
    }

    public UserList getUsers() {
        return this.users;
    }

    public void setUsers(UserList tmp) {
        this.users = tmp;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getEmptyHtmlSelect(SystemStatus thisSystem, String selectName) {
        HtmlSelect contactListSelect = new HtmlSelect();
        contactListSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        return contactListSelect.getHtml(selectName);
    }

    public int getLeadStatus() {
        return this.leadStatus;
    }

    public void setLeadStatus(int tmp) {
        this.leadStatus = tmp;
    }

    public void setLeadStatus(String tmp) {
        this.leadStatus = Integer.parseInt(tmp);
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int tmp) {
        this.source = tmp;
    }

    public void setSource(String tmp) {
        this.source = Integer.parseInt(tmp);
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int tmp) {
        this.rating = tmp;
    }

    public void setRating(String tmp) {
        this.rating = Integer.parseInt(tmp);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public int getLeadsOnly() {
        return this.leadsOnly;
    }

    public void setLeadsOnly(int tmp) {
        this.leadsOnly = tmp;
    }

    public void setLeadsOnly(String tmp) {
        this.leadsOnly = Integer.parseInt(tmp);
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public int getLeadStatusExists() {
        return this.leadStatusExists;
    }

    public void setLeadStatusExists(int tmp) {
        this.leadStatusExists = tmp;
    }

    public void setLeadStatusExists(String tmp) {
        this.leadStatusExists = Integer.parseInt(tmp);
    }

    public int getReadBy() {
        return this.readBy;
    }

    public void setReadBy(int tmp) {
        this.readBy = tmp;
    }

    public void setReadBy(String tmp) {
        this.readBy = Integer.parseInt(tmp);
    }

    public Timestamp getEnteredStart() {
        return this.enteredStart;
    }

    public void setEnteredStart(Timestamp tmp) {
        this.enteredStart = tmp;
    }

    public void setEnteredStart(Date tmp) {
        try {
            this.enteredStart = new Timestamp(tmp.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnteredStart(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.enteredStart = new Timestamp(new java.util.Date().getTime());
            this.enteredStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.enteredStart = null;
        }
    }

    public Timestamp getEnteredEnd() {
        return this.enteredEnd;
    }

    public void setEnteredEnd(Timestamp tmp) {
        this.enteredEnd = tmp;
    }

    public void setEnteredEnd(Date tmp) {
        try {
            this.enteredEnd = new Timestamp(tmp.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnteredEnd(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.enteredEnd = new Timestamp(new java.util.Date().getTime());
            this.enteredEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.enteredEnd = null;
        }
    }

    public Timestamp getConversionDateStart() {
        return this.conversionDateStart;
    }

    public void setConversionDateStart(Timestamp tmp) {
        this.conversionDateStart = tmp;
    }

    public void setConversionDateStart(Date tmp) {
        try {
            this.conversionDateStart = new Timestamp(tmp.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConversionDateStart(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.conversionDateStart = new Timestamp(new java.util.Date().getTime());
            this.conversionDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.conversionDateStart = null;
        }
    }

    public Timestamp getConversionDateEnd() {
        return this.conversionDateEnd;
    }

    public void setConversionDateEnd(Timestamp tmp) {
        this.conversionDateEnd = tmp;
    }

    public void setConversionDateEnd(Date tmp) {
        try {
            this.conversionDateEnd = new Timestamp(tmp.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConversionDateEnd(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.conversionDateEnd = new Timestamp(new java.util.Date().getTime());
            this.conversionDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.conversionDateEnd = null;
        }
    }

    public int getHasConversionDate() {
        return this.hasConversionDate;
    }

    public void setHasConversionDate(int tmp) {
        this.hasConversionDate = tmp;
    }

    public void setHasConversionDate(String tmp) {
        this.hasConversionDate = Integer.parseInt(tmp);
    }

    public int getOldestFirst() {
        return this.oldestFirst;
    }

    public void setOldestFirst(int tmp) {
        this.oldestFirst = tmp;
    }

    public void setOldestFirst(String tmp) {
        this.oldestFirst = Integer.parseInt(tmp);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String tmp) {
        this.emailAddress = tmp;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String tmp) {
        this.country = tmp;
    }

    public boolean getOwnerOrReader() {
        return this.ownerOrReader;
    }

    public void setOwnerOrReader(boolean tmp) {
        this.ownerOrReader = tmp;
    }

    public void setOwnerOrReader(String tmp) {
        this.ownerOrReader = DatabaseUtils.parseBoolean(tmp);
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String tmp) {
        this.permission = tmp;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public String getNextValue() {
        return this.nextValue;
    }

    public void setNextValue(String tmp) {
        this.nextValue = tmp;
    }

    public int getDefaultContactId() {
        return this.defaultContactId;
    }

    public void setDefaultContactId(int defaultContactId) {
        this.defaultContactId = defaultContactId;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public boolean getZipCodeAscPotentialDesc() {
        return this.zipCodeAscPotentialDesc;
    }

    public void setZipCodeAscPotentialDesc(boolean tmp) {
        this.zipCodeAscPotentialDesc = tmp;
    }

    public void setZipCodeAscPotentialDesc(String tmp) {
        this.zipCodeAscPotentialDesc = DatabaseUtils.parseBoolean(tmp);
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String tmp) {
        this.postalCode = tmp;
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public int getPortalUsersOnly() {
        return this.portalUsersOnly;
    }

    public void setPortalUsersOnly(int tmp) {
        this.portalUsersOnly = tmp;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String tmp) {
        this.state = tmp;
    }

    public String getState1() {
        return this.state1;
    }

    public void setState1(String tmp) {
        this.state1 = tmp;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect contactListSelect = new HtmlSelect();
        contactListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            contactListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (Contact thisContact : this) {
            if (!thisContact.getEnabled() && thisContact.getId() != defaultKey) continue;
            contactListSelect.addItem(thisContact.getId(), Contact.getNameLastFirst(thisContact.getNameLast(), thisContact.getNameFirst()) + (!thisContact.getEnabled() || thisContact.isTrashed() ? " (X)" : (this.checkUserAccess ? (thisContact.hasAccount() ? " (*)" : "") : "")));
        }
        return contactListSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelectObj() {
        HtmlSelect contactListSelect = new HtmlSelect();
        contactListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            contactListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (Contact thisContact : this) {
            if (!thisContact.getEnabled()) continue;
            contactListSelect.addItem(thisContact.getId(), Contact.getNameLastFirst(thisContact.getNameLast(), thisContact.getNameFirst()) + (!thisContact.getEnabled() || thisContact.isTrashed() ? " (X)" : (this.checkUserAccess ? (thisContact.hasAccount() ? " (*)" : "") : "")));
        }
        return contactListSelect;
    }

    public void buildQuery(int thisOwnerId, String thisUserRange) {
        String readyToGo = "";
        HashMap[] outerHash = null;
        HashMap company = new HashMap();
        HashMap namefirst = new HashMap();
        HashMap namelast = new HashMap();
        HashMap entered = new HashMap();
        HashMap zip = new HashMap();
        HashMap areacode = new HashMap();
        HashMap city = new HashMap();
        HashMap typeId = new HashMap();
        HashMap contactId = new HashMap();
        HashMap title = new HashMap();
        HashMap accountTypeId = new HashMap();
        HashMap siteId = new HashMap();
        outerHash = new HashMap[]{company, namefirst, namelast, entered, zip, areacode, city, typeId, contactId, title, accountTypeId, siteId};
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ContactList-> SCL Size: " + this.getScl().size() + " name: " + this.getScl().getGroupName());
        }
        for (Integer group : this.getScl().keySet()) {
            SearchCriteriaGroup thisGroup = (SearchCriteriaGroup)this.getScl().get(group);
            for (SearchCriteriaElement thisElement : thisGroup) {
                readyToGo = this.replace(thisElement.getText().toLowerCase(), '\'', "\\'");
                HashMap tempHash = (HashMap)outerHash[thisElement.getFieldId() - 1].get(thisElement.getOperator());
                if (tempHash == null || tempHash.size() == 0 || thisElement.getDataType().equals("date")) {
                    if (thisElement.getDataType().equals("date")) {
                        int month = 0;
                        int day = 0;
                        int year = 0;
                        StringTokenizer st = new StringTokenizer(readyToGo, "/");
                        if (st.hasMoreTokens()) {
                            month = Integer.parseInt(st.nextToken());
                            day = Integer.parseInt(st.nextToken());
                            year = Integer.parseInt(st.nextToken());
                            if (year < 50) {
                                year += 2000;
                            }
                        }
                        GregorianCalendar tmpCal = new GregorianCalendar(year, month - 1, day);
                        if (thisElement.getOperatorId() == 8 || thisElement.getOperatorId() == 10) {
                            ((Calendar)tmpCal).add(5, 1);
                        }
                        HashMap<String, String> tempTable = new HashMap<String, String>();
                        String backToString = tmpCal.get(2) + 1 + "/" + tmpCal.get(5) + "/" + tmpCal.get(1);
                        tempTable.put(backToString, thisElement.getSourceId() + "|" + thisElement.getSiteId());
                        outerHash[thisElement.getFieldId() - 1].put(thisElement.getOperator(), tempTable);
                        continue;
                    }
                    HashMap<String, String> tempTable = new HashMap<String, String>();
                    tempTable.put(readyToGo, thisElement.getSourceId() + "|" + thisElement.getSiteId());
                    outerHash[thisElement.getFieldId() - 1].put(thisElement.getOperator(), tempTable);
                    continue;
                }
                tempHash.put(readyToGo, thisElement.getSourceId() + "|" + thisElement.getSiteId());
                outerHash[thisElement.getFieldId() - 1].remove(thisElement.getOperator());
                outerHash[thisElement.getFieldId() - 1].put(thisElement.getOperator(), tempHash);
            }
        }
        this.setSearchValues(outerHash);
    }

    public void accessedBy(int userId) {
        if (userId > -1) {
            this.setOwner(userId);
        }
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public boolean buildList(Connection db) throws SQLException {
        Contact thisContact;
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact c LEFT JOIN organization o ON (c.org_id = o.org_id) LEFT JOIN lookup_department d ON (c.department = d.code) LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) LEFT JOIN lookup_site_id lsi ON (c.site_id = lsi.code) WHERE c.contact_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
                logger.debug((Object)pst.toString());
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
                logger.debug((Object)(String.valueOf(milies) + " ms"));
            }
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis();
                    logger.debug((Object)pst.toString());
                }
                rs = pst.executeQuery();
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis() - milies;
                    logger.debug((Object)(String.valueOf(milies) + " ms"));
                }
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.getZipCodeAscPotentialDesc()) {
                if (this.oldestFirst == 1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered, c.namelast, c.namefirst, c.org_name");
                } else if (this.oldestFirst == 0 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered DESC, c.namelast, c.namefirst, c.org_name");
                } else if (this.oldestFirst == -1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.namelast, c.namefirst, c.org_name");
                }
            } else if (this.oldestFirst == 1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.entered, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == 0 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.entered DESC, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == -1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.namelast, c.namefirst, c.org_name");
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else if (this.getZipCodeAscPotentialDesc()) {
            if (this.oldestFirst == 1) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == 0) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered DESC, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == -1) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.namelast, c.namefirst, c.org_name");
            }
        } else if (this.oldestFirst == 1) {
            sqlOrder.append("ORDER BY c.entered, c.namelast, c.namefirst, c.org_name ");
        } else if (this.oldestFirst == 0) {
            sqlOrder.append("ORDER BY c.entered DESC, c.namelast, c.namefirst, c.org_name ");
        } else if (this.oldestFirst == -1) {
            sqlOrder.append("ORDER BY c.namelast, c.namefirst, c.org_name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.*, o.enabled AS orgenabled, o.trashed_date AS orgtrasheddate,  d.description as departmentname,  ca.city AS city,  ca.postalcode AS postalcode,  lsi.description AS site_id_name,  lind.description AS industry_name,  lcs.description AS source_name,  lcr.description AS rating_name FROM contact c LEFT JOIN organization o ON (c.org_id = o.org_id) LEFT JOIN lookup_department d ON (c.department = d.code) LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) LEFT JOIN lookup_site_id lsi ON (c.site_id = lsi.code) WHERE c.contact_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = DatabaseUtils.executeQuery(db, pst, logger, this.pagedListInfo);
        boolean foundDefaultContact = false;
        while (rs.next()) {
            thisContact = new Contact(rs);
            if (thisContact.getId() == this.defaultContactId) {
                foundDefaultContact = true;
            }
            this.addElement(thisContact);
        }
        rs.close();
        pst.close();
        if (this.defaultContactId != -1 && !foundDefaultContact) {
            thisContact = new Contact(db, this.defaultContactId);
            this.addElement(thisContact);
        }
        this.buildResources(db);
        return true;
    }

    public void addIgnoreTypeId(String tmp) {
        this.ignoreTypeIdList.addElement(tmp);
    }

    public void addIgnoreTypeId(int tmp) {
        this.ignoreTypeIdList.addElement(String.valueOf(tmp));
    }

    public void delete(Connection db, String baseFilePath, boolean forceDelete) throws SQLException {
        for (Contact thisContact : this) {
            thisContact.setForceDelete(forceDelete);
            thisContact.delete(db, baseFilePath);
        }
    }

    String replace(String str, char oldChar, String newStr) {
        String replacedStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            replacedStr = c == oldChar ? replacedStr + newStr : replacedStr + c;
        }
        return replacedStr;
    }

    private boolean buildResources(Connection db) throws SQLException {
        if (!(this.buildTypes || this.buildDetails || this.buildPhoneNumbers || this.checkUserAccess || this.checkEnabledUserAccess || this.checkExcludedFromCampaign != -1)) {
            return false;
        }
        for (Contact thisContact : this) {
            if (this.buildTypes) {
                thisContact.buildTypes(db);
            }
            if (this.buildDetails) {
                thisContact.getPhoneNumberList().setContactId(thisContact.getId());
                thisContact.getPhoneNumberList().buildList(db);
                thisContact.getAddressList().setContactId(thisContact.getId());
                thisContact.getAddressList().buildList(db);
                thisContact.getEmailAddressList().setContactId(thisContact.getId());
                thisContact.getEmailAddressList().buildList(db);
            }
            if (!this.buildDetails && this.buildPhoneNumbers) {
                thisContact.getPhoneNumberList().setContactId(thisContact.getId());
                thisContact.getPhoneNumberList().buildList(db);
            }
            if (this.checkUserAccess) {
                thisContact.checkUserAccount(db);
            }
            if (this.checkEnabledUserAccess) {
                thisContact.checkEnabledUserAccount(db);
            }
            if (this.checkExcludedFromCampaign <= -1) continue;
            thisContact.checkExcludedFromCampaign(db, this.checkExcludedFromCampaign);
        }
        return true;
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        sqlFilter.append("AND (ca.address_id IS NULL OR ca.address_id IN ( SELECT cta.address_id FROM contact_address cta WHERE cta.contact_id = c.contact_id AND cta.primary_address = ?) OR ca.address_id IN (SELECT MIN(ctadd.address_id) FROM contact_address ctadd WHERE ctadd.contact_id = c.contact_id AND  ctadd.contact_id NOT IN (SELECT contact_id FROM contact_address WHERE contact_address.primary_address = ?))) ");
        if (this.contactUserId != -1) {
            sqlFilter.append("AND c.user_id = ? ");
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND c.org_id = ? ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND c.enabled = ? ");
        }
        if (this.owner != -1 && !this.ownerOrReader) {
            sqlFilter.append("AND c.owner = ? AND ((c.org_id = 0 AND employee = ?) OR c.org_id <> 0 OR c.org_id IS NULL) ");
        }
        if (this.typeId != -1) {
            sqlFilter.append("AND (c.contact_id in (SELECT contact_id from contact_type_levels ctl where ctl.type_id = ?) )");
        }
        if (this.departmentId > -1) {
            if (this.departmentId != 0) {
                sqlFilter.append("AND c.department = ? ");
            } else {
                sqlFilter.append("AND c.department IS NULL ");
            }
        }
        if (this.ruleId != -1) {
            sqlFilter.append("AND c.access_type IN (SELECT code from lookup_access_types where rule_id = ? AND code = c.access_type) ");
        }
        if (this.projectId != -1) {
            sqlFilter.append("AND c.user_id in (SELECT DISTINCT user_id FROM project_team WHERE project_id = ?) ");
        }
        if (this.firstName != null) {
            if (this.firstName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) = ? ");
            }
        }
        if (this.middleName != null) {
            if (this.middleName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namemiddle) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namemiddle) = ? ");
            }
        }
        if (this.lastName != null) {
            if (this.lastName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) = ? ");
            }
        }
        if (this.accountName != null) {
            if (this.accountName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) = ? ");
            }
        }
        if (this.accountNumber != null) {
            if (this.accountNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.account_number) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.account_number) = ? ");
            }
        }
        if (this.accountTypeId != -1) {
            sqlFilter.append("AND EXISTS (SELECT * FROM account_type_levels atl WHERE atl.type_id = ? AND o.org_id = atl.org_id) ");
        }
        if (this.accountOwnerId != -1) {
            sqlFilter.append("AND o.owner = ? ");
        }
        if (this.includeEnabledAccount == 1 || this.includeEnabledAccount == 0) {
            sqlFilter.append("AND o.enabled = ? ");
        }
        if (this.assetSerialNumber != null) {
            sqlFilter.append("AND EXISTS (SELECT o.org_id FROM asset a WHERE o.org_id = a.account_id AND " + DatabaseUtils.toLowerCase(db) + " (a.serial_number) = ? )");
        }
        if (this.accountSegment != null) {
            if (this.accountSegment.indexOf("%") >= 0) {
                sqlFilter.append("AND o.segment_id in (select code from lookup_segments WHERE " + DatabaseUtils.toLowerCase(db) + "(description) LIKE ?) ");
            } else {
                sqlFilter.append("AND o.segment_id in (select code from lookup_segments where " + DatabaseUtils.toLowerCase(db) + "(description) = ?) ");
            }
        }
        if (this.contactPhoneNumber != null) {
            if (this.contactPhoneNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND c.contact_id IN (SELECT cp.contact_id from contact_phone cp  where " + DatabaseUtils.toLowerCase(db) + "(cp.number) like ? ) ");
            } else {
                sqlFilter.append("AND c.contact_id IN (SELECT cp.contact_id from contact_phone cp where  " + DatabaseUtils.toLowerCase(db) + "(cp.number) = ?) ");
            }
        }
        if (this.contactState != null && !"-1".equals(this.contactState)) {
            if (this.contactState.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.state) like ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.state) = ? ");
            }
        }
        if (this.accountPostalCode != null) {
            if (this.accountPostalCode.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (SELECT o.org_id FROM organization o WHERE o.org_id = c.org_id AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "postalcode") + " LIKE ? " + "AND postalcode IS NOT NULL)) ");
            } else {
                sqlFilter.append("AND EXISTS (SELECT o.org_id FROM organization o WHERE o.org_id = c.org_id AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "postalcode") + " = ? " + "AND postalcode IS NOT NULL)) ");
            }
        }
        if (this.contactCity != null) {
            if (this.contactCity.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.city) like ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.city) = ? ");
            }
        }
        if (this.title != null) {
            if (this.title.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.title) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.title) = ? ");
            }
        }
        if (this.company != null) {
            if (this.company.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) = ? ");
            }
        }
        if (this.orgSiteId != -1) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM organization o WHERE  o.org_id = c.org_id AND ( o.site_id = ? ");
            if (this.includeContactsFromOrganizationsWithoutSite) {
                sqlFilter.append(" OR o.site_id IS NULL ");
            }
            sqlFilter.append("))");
        }
        if (this.orgSiteId == -1 && this.includeContactsFromOrganizationsWithoutSite) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM organization o WHERE  o.org_id = c.org_id AND o.site_id IS NULL )");
        }
        if (this.userSiteId != -1) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a WHERE  a.contact_id = c.contact_id AND ( a.site_id = ? ");
            if (this.includeUsersWithAccessToAllSites) {
                sqlFilter.append(" OR a.site_id IS NULL ");
            }
            sqlFilter.append(")) ");
        }
        if (this.userSiteId == -1 && this.includeUsersWithAccessToAllSites) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a WHERE  a.contact_id = c.contact_id AND a.site_id IS NULL )");
        }
        if (this.importSiteId != -1) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM import i WHERE  i.import_id = c.import_id AND ( i.site_id = ? ");
            if (this.includeContactsFromImportsOfAllSites) {
                sqlFilter.append(" OR i.site_id IS NULL ");
            }
            sqlFilter.append(")) ");
        }
        if (this.importSiteId == -1 && this.includeContactsFromImportsOfAllSites) {
            sqlFilter.append("AND EXISTS (SELECT c.contact_id FROM import i WHERE  i.import_id = c.import_id AND i.site_id IS NULL )");
        }
        if (!(this.includeAllSites || this.orgId != -1 || this.scl != null && this.scl.size() > 0)) {
            if (this.siteId != -1) {
                sqlFilter.append("AND ( c.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append(" OR c.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append(" AND c.site_id IS NULL ");
            }
        }
        if (this.controlledHierarchyOnly) {
            sqlFilter.append("AND (c.owner IN (" + this.ownerIdRange + ") OR c.owner IS NULL ) ");
        }
        if (this.contactIdRange != null && this.scl.getOnlyContactIds()) {
            sqlFilter.append("AND c.contact_id IN (" + this.contactIdRange + ") ");
        }
        if (this.withAccountsOnly) {
            sqlFilter.append("AND c.org_id > 0 ");
        }
        if (this.withProjectsOnly) {
            sqlFilter.append("AND c.user_id in (Select distinct pt.user_id from project_team pt LEFT JOIN " + DatabaseUtils.addQuotes(db, "access") + " a ON (pt.user_id = a.user_id) ");
            if (!this.includeAllSites && this.orgId == -1) {
                if (this.siteId != -1) {
                    sqlFilter.append("WHERE (a.site_id = ? ");
                    if (!this.exclusiveToSite) {
                        sqlFilter.append("OR a.site_id IS NULL ");
                    }
                    sqlFilter.append(") ");
                } else {
                    sqlFilter.append("WHERE a.site_id IS NULL ");
                }
            }
            sqlFilter.append(") ");
        }
        if (this.includeEnabledUsersOnly) {
            if (this.userRoleType > -1) {
                sqlFilter.append("AND EXISTS (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE c.user_id = a.user_id AND a.enabled = ? " + "AND a.role_id IN (SELECT r.role_id FROM " + DatabaseUtils.addQuotes(db, "role") + " r WHERE r.role_type = ?)) ");
            } else {
                sqlFilter.append("AND c.user_id IN (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE enabled = ?) ");
            }
        }
        if (this.portalUsersOnly == 1) {
            sqlFilter.append("AND EXISTS (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE c.user_id = a.user_id AND a.enabled = ? " + "AND a.role_id IN (SELECT r.role_id FROM " + DatabaseUtils.addQuotes(db, "role") + " r WHERE r.role_type = ?)) ");
        } else if (this.portalUsersOnly == 0) {
            sqlFilter.append("AND EXISTS (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE c.user_id = a.user_id " + "AND a.role_id IN (SELECT r.role_id FROM " + DatabaseUtils.addQuotes(db, "role") + " r WHERE r.role_type != ?)) ");
        }
        if (this.includeNonUsersOnly) {
            sqlFilter.append("AND c.contact_id NOT IN (SELECT contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + ") ");
        }
        if (this.includeUsersOnly) {
            sqlFilter.append("AND c.user_id IN (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + ") ");
        }
        if ((this.includeEnabledUsersOnly || this.includeUsersOnly) && this.permission != null && !"".equals(this.permission)) {
            sqlFilter.append("AND EXISTS (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE c.user_id = a.user_id AND a.role_id IN " + "(SELECT rp.role_id FROM role_permission rp " + "LEFT JOIN permission p ON (rp.permission_id = p.permission_id) " + "WHERE rp.role_id > 0 ");
            String[] temp = this.permission.split(",");
            for (int i = 0; i < temp.length; ++i) {
                String str = temp[i];
                if (i == 0) {
                    sqlFilter.append("AND ( ");
                }
                sqlFilter.append("p.permission = ? AND role_" + str.substring(str.lastIndexOf("-") + 1, str.length()) + " = ? ");
                if (i < temp.length - 1) {
                    sqlFilter.append(") OR ( ");
                    continue;
                }
                if (i != temp.length - 1) continue;
                sqlFilter.append(") ");
            }
            sqlFilter.append(")) ");
        }
        if (this.employeesOnly != -1) {
            sqlFilter.append("AND c.employee = ? ");
        }
        if (this.accountOwnerIdRange != null) {
            sqlFilter.append("AND c.org_id IN (SELECT org_id FROM organization WHERE owner IN (" + this.accountOwnerIdRange + ")) ");
        }
        if (this.excludeAccountContacts) {
            sqlFilter.append("AND c.org_id IS NULL ");
        }
        if (this.importId != -1) {
            sqlFilter.append("AND c.import_id = ? ");
        }
        if (this.statusId != -1) {
            sqlFilter.append("AND c.status_id = ? ");
        }
        if (this.excludeUnapprovedContacts) {
            sqlFilter.append("AND (c.status_id IS NULL OR c.status_id = ?) ");
        }
        if (!this.showTrashedAndNormal) {
            if (this.includeOnlyTrashed) {
                sqlFilter.append("AND c.trashed_date IS NOT NULL ");
            } else if (this.trashedDate != null) {
                sqlFilter.append("AND trashed_date = ? ");
            } else {
                sqlFilter.append("AND c.trashed_date IS NULL ");
            }
        }
        if (this.leadsOnly != -1) {
            sqlFilter.append("AND c.lead = ? ");
        }
        if (this.leadStatus > 0 && this.employeesOnly == -1) {
            if (this.leadStatus == 1 || this.leadStatus == 3 || this.leadStatus == 2) {
                sqlFilter.append("AND c.lead_status = ? ");
            }
        } else if (this.leadsOnly == 1 && this.leadStatus == 0 && this.readBy == -1 && !this.ownerOrReader && this.employeesOnly == -1) {
            sqlFilter.append("AND c.lead_status = ? ");
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT contact_id FROM contact_lead_read_map WHERE user_id <> ? ) AND c.contact_id NOT IN ( SELECT contact_id FROM contact_lead_skipped_map WHERE user_id = ?) ");
        } else if (this.leadStatus == -1 && this.readBy == -1 && this.employeesOnly == -1 && this.leadsOnly == 1) {
            sqlFilter.append("AND c.lead_status IN (?, ?, ?) ");
        }
        if (this.source > -1) {
            sqlFilter.append("AND c.source = ? ");
        }
        if (this.rating > -1) {
            sqlFilter.append("AND c.rating = ? ");
        }
        if (this.industry > -1) {
            sqlFilter.append("AND c.industry_temp_code = ? ");
        }
        if (this.leadsOnly == 1 && this.readBy > -1 && !this.ownerOrReader) {
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT contact_id FROM contact_lead_skipped_map WHERE user_id = ?) AND c.contact_id IN ( SELECT contact_id FROM contact_lead_read_map WHERE user_id = ? ) ");
        }
        if (this.leadStatusExists == 1) {
            sqlFilter.append("AND c.lead_status IS NOT NULL ");
        } else if (this.leadStatusExists == 0) {
            sqlFilter.append("AND c.lead_status IS NULL ");
        }
        if (this.enteredStart != null) {
            sqlFilter.append("AND c.entered >= ? ");
        }
        if (this.enteredEnd != null) {
            sqlFilter.append("AND c.entered <= ? ");
        }
        if (this.conversionDateStart != null) {
            sqlFilter.append("AND c.conversion_date >= ? ");
        }
        if (this.conversionDateEnd != null) {
            sqlFilter.append("AND c.conversion_date <= ? ");
        }
        if (this.emailAddress != null) {
            if (this.emailAddress.indexOf("%") >= 0) {
                sqlFilter.append("AND c.contact_id IN (SELECT cc.contact_id FROM contact cc LEFT JOIN contact_emailaddress ce ON (cc.contact_id = ce.contact_id ) WHERE cc.contact_id = c.contact_id AND (" + DatabaseUtils.toLowerCase(db) + "(ce.email) LIKE ?)) ");
            } else {
                sqlFilter.append("AND c.contact_id IN (SELECT cc.contact_id FROM contact cc LEFT JOIN contact_emailaddress ce ON (cc.contact_id = ce.contact_id ) WHERE cc.contact_id = c.contact_id AND ce.email = ? ) ");
            }
        }
        if (this.postalCode != null) {
            sqlFilter.append("AND ca.postalcode LIKE ? ");
        }
        if (this.city != null) {
            sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.city) = ? ");
        }
        if (this.state != null && !"-1".equals(this.state)) {
            sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.state) = ? ");
        } else if (this.state1 != null) {
            sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(ca.state) = ? ");
        }
        if (this.hasConversionDate == 1) {
            sqlFilter.append("AND c.conversion_date IS NOT NULL ");
        } else if (this.hasConversionDate == 0) {
            sqlFilter.append("AND c.conversion_date IS NULL ");
        }
        if (this.country != null && !"-1".equals(this.country)) {
            sqlFilter.append("AND ca.country = ? ");
        }
        if (this.ownerOrReader) {
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT contact_id FROM contact_lead_skipped_map WHERE user_id = ?) AND (c.owner = ? OR c.contact_id IN (SELECT contact_id FROM contact_lead_read_map WHERE user_id = ?)) ");
        }
        if (this.getHierarchialUsers() != -1) {
            try {
                this.users = new UserList();
                User thisRec = new User(db, this.getHierarchialUsers());
                thisRec.setBuildHierarchy(true);
                thisRec.buildResources(db);
                UserList shortChildList = thisRec.getShortChildList();
                UserList newUserList = thisRec.getFullChildList(shortChildList, new UserList());
                sqlFilter.append("AND c.user_id IN ( ? ");
                this.users.add(thisRec);
                for (User thisUser : newUserList) {
                    this.users.add(thisUser);
                    sqlFilter.append(",?");
                }
                sqlFilter.append(") ");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.allContacts) {
            sqlFilter.append("AND (c.owner IN (" + this.ownerIdRange + ") " + "OR c.access_type IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = c.access_type)) " + "AND ((c.org_id = 0 AND employee = ?) OR c.org_id <> 0 OR c.org_id IS NULL) ");
        }
        switch (this.personalId) {
            case -2: {
                break;
            }
            case -1: {
                if (this.accessTypes == null) {
                    sqlFilter.append("AND c.access_type NOT IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = c.access_type) ");
                    break;
                }
                sqlFilter.append("AND c.access_type NOT IN (" + this.accessTypes.getCode(626030333) + ") ");
                break;
            }
            default: {
                if (this.accessTypes == null) {
                    sqlFilter.append("AND (c.access_type NOT IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = c.access_type)  OR (c.access_type IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = c.access_type) AND c.owner = ?)) ");
                    break;
                }
                sqlFilter.append("AND (c.access_type NOT IN (" + this.accessTypes.getCode(626030333) + ")  OR (c.access_type IN (" + this.accessTypes.getCode(626030333) + ") AND c.owner = ?)) ");
            }
        }
        if (this.searchText != null && !"".equals(this.searchText)) {
            sqlFilter.append("AND ( " + DatabaseUtils.toLowerCase(db) + "(c.namelast) LIKE ? " + "OR " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) LIKE ? " + "OR " + DatabaseUtils.toLowerCase(db) + "(c.org_name) LIKE ? " + ")");
        }
        if (this.ignoreTypeIdList.size() > 0) {
            for (String nextValue : this.ignoreTypeIdList) {
                if (nextValue.equals("1")) {
                    sqlFilter.append("AND c.employee = ? ");
                    continue;
                }
                if (!nextValue.equals("2")) continue;
                sqlFilter.append("AND c.lead = ? ");
            }
        }
        if (this.contactIdHash != null && this.contactIdHash.size() > 0) {
            boolean newTerm = true;
            HashMap innerHash = (HashMap)this.contactIdHash.get("=");
            if (innerHash != null) {
                int termsProcessed = 0;
                for (String key2 : innerHash.keySet()) {
                    newTerm = this.processElementHeader(sqlFilter, newTerm, termsProcessed);
                    sqlFilter.append(" (c.contact_id  = " + key2 + ") ");
                    ++termsProcessed;
                }
                if (!newTerm) {
                    sqlFilter.append(") ");
                }
            }
        }
        for (int y = 1; y < 5; ++y) {
            String site;
            int elementType;
            String elementTypeString;
            HashMap innerHash;
            String key1;
            String previousKey;
            Iterator outer;
            boolean newTerm = true;
            int termsProcessed = 0;
            if (this.companyHash != null && this.companyHash.size() > 0) {
                outer = this.companyHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.companyHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("( ");
                        }
                        sqlFilter.append(" (" + DatabaseUtils.toLowerCase(db) + "(c.org_name) " + key1 + " '" + key2 + "' ) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (this.nameFirstHash != null && this.nameFirstHash.size() > 0) {
                outer = this.nameFirstHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.nameFirstHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (" + DatabaseUtils.toLowerCase(db) + "(c.namefirst) " + key1 + " '" + key2 + "' )");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (this.nameLastHash != null && this.nameLastHash.size() > 0) {
                outer = this.nameLastHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.nameLastHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (" + DatabaseUtils.toLowerCase(db) + "(c.namelast) " + key1 + " '" + key2 + "' )");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(") ");
                }
            }
            if (this.dateHash != null && this.dateHash.size() > 0) {
                outer = this.dateHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.dateHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("<") && !key1.equals(">") && !key1.equals("<=") && !key1.equals(">=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed);
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (c.entered " + key1 + " '" + key2 + "') ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (this.zipHash != null && this.zipHash.size() > 0) {
                outer = this.zipHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.zipHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (c.contact_id in (select distinct contact_id from contact_address where address_type = 1 AND " + DatabaseUtils.toLowerCase(db) + " (postalcode) " + key1 + " '" + key2 + "' )) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (this.typeIdHash != null && this.typeIdHash.size() > 0) {
                outer = this.typeIdHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.typeIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" ( c.contact_id in (SELECT contact_id from contact_type_levels ctl where ctl.type_id " + key1 + " '" + key2 + "' ) ) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(") ");
                }
            }
            if (this.accountTypeIdHash != null && this.accountTypeIdHash.size() > 0) {
                outer = this.accountTypeIdHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.accountTypeIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (c.org_id in (SELECT org_id FROM account_type_levels WHERE type_id " + key1 + " " + key2 + ")) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(") ");
                }
            }
            if (this.siteIdHash != null && this.siteIdHash.size() > 0) {
                outer = this.siteIdHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.siteIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        if (Integer.parseInt(key2) != -1) {
                            System.out.println("key1: " + key1);
                            System.out.println("key2: " + key2);
                            sqlFilter.append(" EXISTS (SELECT c.contact_id FROM contact ic WHERE c.site_id " + key1 + " " + key2 + " ) ");
                        } else {
                            System.out.println("none");
                            sqlFilter.append(" EXISTS (SELECT c.contact_id FROM contact ic WHERE (c.site_id IS NULL OR c.site_id IS NOT NULL) ) ");
                        }
                        this.processElementType(db, sqlFilter, elementType);
                        previousKey = key1;
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(") ");
                }
            }
            if (this.areaCodeHash != null && this.areaCodeHash.size() > 0) {
                outer = this.areaCodeHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.areaCodeHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (c.contact_id in (select distinct contact_id from contact_phone where phone_type = 1 and " + DatabaseUtils.getSubString(db, "" + DatabaseUtils.addQuotes(db, "number") + "", 2, 3) + " " + key1 + " '" + key2 + "' )) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (this.cityHash != null && this.cityHash.size() > 0) {
                outer = this.cityHash.keySet().iterator();
                termsProcessed = 0;
                previousKey = null;
                while (outer.hasNext()) {
                    key1 = (String)outer.next();
                    innerHash = (HashMap)this.cityHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        site = this.processSite(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        newTerm = termsProcessed > 0 && !previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : (termsProcessed > 0 && key1.equals("!=") && previousKey.equals(key1) ? this.processElementHeader(sqlFilter, newTerm, 0) : this.processElementHeader(sqlFilter, newTerm, termsProcessed));
                        if (termsProcessed == 0) {
                            sqlFilter.append("(");
                        }
                        sqlFilter.append(" (c.contact_id IN (SELECT distinct contact_id FROM contact_address WHERE address_type = 1 AND " + DatabaseUtils.toLowerCase(db) + "(city) " + key1 + " '" + key2 + "' )) ");
                        previousKey = key1;
                        this.processElementType(db, sqlFilter, elementType);
                        this.processSite(sqlFilter, elementType, site);
                        ++termsProcessed;
                    }
                }
                if (termsProcessed > 0) {
                    sqlFilter.append(")");
                }
            }
            if (newTerm) continue;
            sqlFilter.append(") ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        if (this.contactUserId != -1) {
            pst.setInt(++i, this.contactUserId);
        }
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.owner != -1 && !this.ownerOrReader) {
            pst.setInt(++i, this.owner);
            pst.setBoolean(++i, true);
        }
        if (this.typeId != -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.departmentId > 0) {
            pst.setInt(++i, this.departmentId);
        }
        if (this.ruleId != -1) {
            pst.setInt(++i, this.ruleId);
        }
        if (this.projectId != -1) {
            pst.setInt(++i, this.projectId);
        }
        if (this.firstName != null) {
            pst.setString(++i, this.firstName.toLowerCase());
        }
        if (this.middleName != null) {
            pst.setString(++i, this.middleName.toLowerCase());
        }
        if (this.lastName != null) {
            pst.setString(++i, this.lastName.toLowerCase());
        }
        if (this.accountName != null) {
            pst.setString(++i, this.accountName.toLowerCase());
        }
        if (this.accountNumber != null) {
            pst.setString(++i, this.accountNumber.toLowerCase());
        }
        if (this.accountTypeId != -1) {
            pst.setInt(++i, this.accountTypeId);
        }
        if (this.accountOwnerId != -1) {
            pst.setInt(++i, this.accountOwnerId);
        }
        if (this.includeEnabledAccount == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabledAccount == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.assetSerialNumber != null) {
            pst.setString(++i, this.assetSerialNumber.toLowerCase());
        }
        if (this.accountSegment != null) {
            pst.setString(++i, this.accountSegment.toLowerCase());
        }
        if (this.contactPhoneNumber != null) {
            pst.setString(++i, this.contactPhoneNumber.toLowerCase());
        }
        if (this.contactState != null && !"-1".equals(this.contactState)) {
            pst.setString(++i, this.contactState.toLowerCase());
        }
        if (this.accountPostalCode != null) {
            pst.setString(++i, this.accountPostalCode.toLowerCase());
        }
        if (this.contactCity != null) {
            pst.setString(++i, this.contactCity.toLowerCase());
        }
        if (this.title != null) {
            pst.setString(++i, this.title.toLowerCase());
        }
        if (this.company != null) {
            pst.setString(++i, this.company.toLowerCase());
        }
        if (this.orgSiteId != -1) {
            pst.setInt(++i, this.orgSiteId);
        }
        if (this.userSiteId != -1) {
            pst.setInt(++i, this.userSiteId);
        }
        if (this.importSiteId != -1) {
            pst.setInt(++i, this.importSiteId);
        }
        if (!this.includeAllSites && this.siteId != -1 && this.orgId == -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.withProjectsOnly && !this.includeAllSites && this.orgId == -1 && this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.includeEnabledUsersOnly) {
            if (this.userRoleType > -1) {
                pst.setBoolean(++i, true);
                pst.setInt(++i, this.userRoleType);
            } else {
                pst.setBoolean(++i, true);
            }
        }
        if (this.portalUsersOnly != -1) {
            pst.setInt(++i, 1);
        }
        if ((this.includeEnabledUsersOnly || this.includeUsersOnly) && this.permission != null && !"".equals(this.permission)) {
            String[] temp = this.permission.split(",");
            for (int j = 0; j < temp.length; ++j) {
                String str = temp[j];
                pst.setString(++i, str.substring(0, str.lastIndexOf("-")));
                pst.setBoolean(++i, true);
            }
        }
        if (this.employeesOnly != -1) {
            pst.setBoolean(++i, this.employeesOnly == 1);
        }
        if (this.importId != -1) {
            pst.setInt(++i, this.importId);
        }
        if (this.statusId != -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.excludeUnapprovedContacts) {
            pst.setInt(++i, 7);
        }
        if (!this.showTrashedAndNormal && !this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.leadsOnly != -1) {
            pst.setBoolean(++i, this.leadsOnly == 1);
        }
        if (this.leadStatus > 0 && this.employeesOnly == -1) {
            if (this.leadStatus == 1 || this.leadStatus == 3 || this.leadStatus == 2) {
                pst.setInt(++i, this.leadStatus);
            }
        } else if (this.leadsOnly == 1 && this.leadStatus == 0 && this.readBy == -1 && !this.ownerOrReader && this.employeesOnly == -1) {
            pst.setInt(++i, 1);
            pst.setInt(++i, this.userId);
            pst.setInt(++i, this.userId);
        } else if (this.leadStatus == -1 && this.readBy == -1 && this.employeesOnly == -1 && this.leadsOnly == 1) {
            pst.setInt(++i, 3);
            pst.setInt(++i, 2);
            pst.setInt(++i, 1);
        }
        if (this.source > -1) {
            pst.setInt(++i, this.source);
        }
        if (this.rating > -1) {
            pst.setInt(++i, this.rating);
        }
        if (this.industry > -1) {
            pst.setInt(++i, this.industry);
        }
        if (this.leadsOnly == 1 && this.readBy > -1 && !this.ownerOrReader) {
            pst.setInt(++i, this.readBy);
            pst.setInt(++i, this.readBy);
        }
        if (this.enteredStart != null) {
            pst.setTimestamp(++i, this.enteredStart);
        }
        if (this.enteredEnd != null) {
            pst.setTimestamp(++i, this.enteredEnd);
        }
        if (this.conversionDateStart != null) {
            pst.setTimestamp(++i, this.conversionDateStart);
        }
        if (this.conversionDateEnd != null) {
            pst.setTimestamp(++i, this.conversionDateEnd);
        }
        if (this.emailAddress != null) {
            pst.setString(++i, this.emailAddress.toLowerCase());
        }
        if (this.postalCode != null) {
            pst.setString(++i, this.postalCode);
        }
        if (this.city != null) {
            pst.setString(++i, this.city.toLowerCase());
        }
        if (this.state != null && !"-1".equals(this.state)) {
            pst.setString(++i, this.state.toLowerCase());
        } else if (this.state1 != null) {
            pst.setString(++i, this.state1.toLowerCase());
        }
        if (this.country != null && !"-1".equals(this.country)) {
            pst.setString(++i, this.country);
        }
        if (this.ownerOrReader) {
            pst.setInt(++i, this.getReadBy());
            pst.setInt(++i, this.getOwner());
            pst.setInt(++i, this.getReadBy());
        }
        if (this.getHierarchialUsers() != -1) {
            for (User thisUser : this.users) {
                pst.setInt(++i, thisUser.getId());
            }
        }
        if (this.allContacts) {
            pst.setInt(++i, 626030334);
            pst.setBoolean(++i, true);
        }
        switch (this.personalId) {
            case -2: {
                break;
            }
            case -1: {
                if (this.accessTypes != null) break;
                pst.setInt(++i, 626030333);
                break;
            }
            default: {
                if (this.accessTypes == null) {
                    pst.setInt(++i, 626030333);
                    pst.setInt(++i, 626030333);
                }
                pst.setInt(++i, this.personalId);
            }
        }
        if (this.searchText != null && !"".equals(this.searchText)) {
            pst.setString(++i, this.searchText.toLowerCase());
            pst.setString(++i, this.searchText.toLowerCase());
            pst.setString(++i, this.searchText.toLowerCase());
        }
        if (this.ignoreTypeIdList.size() > 0) {
            Iterator iterator = this.ignoreTypeIdList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                pst.setBoolean(++i, false);
            }
        }
        for (int y = 1; y < 5; ++y) {
            int elementType;
            String elementTypeString;
            HashMap innerHash;
            if (this.companyHash != null && this.companyHash.size() > 0) {
                for (String key1 : this.companyHash.keySet()) {
                    innerHash = (HashMap)this.companyHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.nameFirstHash != null && this.nameFirstHash.size() > 0) {
                for (String key1 : this.nameFirstHash.keySet()) {
                    innerHash = (HashMap)this.nameFirstHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.nameLastHash != null && this.nameLastHash.size() > 0) {
                for (String key1 : this.nameLastHash.keySet()) {
                    innerHash = (HashMap)this.nameLastHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.dateHash != null && this.dateHash.size() > 0) {
                for (String key1 : this.dateHash.keySet()) {
                    innerHash = (HashMap)this.dateHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("<") && !key1.equals(">") && !key1.equals("<=") && !key1.equals(">=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.zipHash != null && this.zipHash.size() > 0) {
                for (String key1 : this.zipHash.keySet()) {
                    innerHash = (HashMap)this.zipHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.typeIdHash != null && this.typeIdHash.size() > 0) {
                for (String key1 : this.typeIdHash.keySet()) {
                    innerHash = (HashMap)this.typeIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.accountTypeIdHash != null && this.accountTypeIdHash.size() > 0) {
                for (String key1 : this.accountTypeIdHash.keySet()) {
                    innerHash = (HashMap)this.accountTypeIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.siteIdHash != null && this.siteIdHash.size() > 0) {
                for (String key1 : this.siteIdHash.keySet()) {
                    innerHash = (HashMap)this.siteIdHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.areaCodeHash != null && this.areaCodeHash.size() > 0) {
                for (String key1 : this.areaCodeHash.keySet()) {
                    innerHash = (HashMap)this.areaCodeHash.get(key1);
                    for (String key2 : innerHash.keySet()) {
                        elementTypeString = ((String)innerHash.get(key2)).toString();
                        elementType = this.processType(elementTypeString);
                        if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                        i = this.processElementTypeParam(pst, i, elementType);
                    }
                }
            }
            if (this.cityHash == null || this.cityHash.size() <= 0) continue;
            for (String key1 : this.cityHash.keySet()) {
                innerHash = (HashMap)this.cityHash.get(key1);
                for (String key2 : innerHash.keySet()) {
                    elementTypeString = ((String)innerHash.get(key2)).toString();
                    elementType = this.processType(elementTypeString);
                    if (elementType != y || !key1.equals("=") && !key1.equals("!=")) continue;
                    i = this.processElementTypeParam(pst, i, elementType);
                }
            }
        }
        return i;
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (Contact thisContact : this) {
            if (!thisContact.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Contact thisContact : this) {
            thisContact.setModifiedBy(userId);
            if (!thisContact.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    private void processElementType(Connection db, StringBuffer sqlFilter, int type) {
        switch (type) {
            case 1: {
                sqlFilter.append("AND c.owner = ? ");
                sqlFilter.append("AND c.employee = ? ");
                break;
            }
            case 2: {
                if (this.getGeneralContactAccessTypes() != null) {
                    sqlFilter.append("AND ((c.owner IN (" + this.sclOwnerIdRange + ") AND c.access_type = " + this.getGeneralContactAccessTypes().getCode(626030335) + ") OR (c.access_type = " + this.getGeneralContactAccessTypes().getCode(626030334) + "))");
                } else {
                    sqlFilter.append("AND c.owner IN (" + this.sclOwnerIdRange + ") ");
                }
                sqlFilter.append("AND c.employee = ? ");
                break;
            }
            case 3: {
                sqlFilter.append("AND c.org_id > 0 ");
                sqlFilter.append("AND c.employee = ? ");
                break;
            }
            case 4: {
                sqlFilter.append("AND c.employee = ? ");
                break;
            }
        }
    }

    private int processElementTypeParam(PreparedStatement pst, int i, int type) throws SQLException {
        switch (type) {
            case 1: {
                pst.setInt(++i, this.sclOwnerId);
                pst.setBoolean(++i, false);
                break;
            }
            case 2: {
                pst.setBoolean(++i, false);
                break;
            }
            case 3: {
                pst.setBoolean(++i, false);
                break;
            }
            case 4: {
                pst.setBoolean(++i, true);
                break;
            }
        }
        return i;
    }

    public void processSite(StringBuffer sqlFilter, int type, String site) {
        if (Integer.parseInt(site) != -1) {
            sqlFilter.append(" AND EXISTS (SELECT c.contact_id FROM contact ic WHERE c.site_id = " + site + " ) ");
        } else {
            sqlFilter.append(" AND EXISTS (SELECT c.contact_id FROM contact ic WHERE (c.site_id IS NULL OR c.site_id IS NOT NULL)) ");
        }
    }

    public boolean processElementHeader(StringBuffer sqlFilter, boolean newTerm, int termsProcessed) {
        if (this.firstCriteria && newTerm) {
            sqlFilter.append(" AND (");
            this.firstCriteria = false;
            newTerm = false;
        } else if (newTerm && !this.firstCriteria) {
            sqlFilter.append(" OR (");
            newTerm = false;
        } else if (termsProcessed > 0) {
            sqlFilter.append(" OR ");
        } else {
            sqlFilter.append(" AND ");
        }
        return newTerm;
    }

    private int processType(String inputString) {
        StringTokenizer st = new StringTokenizer(inputString, "[*|]");
        int type = -1;
        if (st.hasMoreTokens()) {
            type = Integer.parseInt(st.nextToken());
        }
        return type;
    }

    private String processSite(String inputString) {
        StringTokenizer st = new StringTokenizer(inputString, "[*|]");
        String site = "";
        if (st.hasMoreTokens()) {
            int type = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            site = st.nextToken();
        }
        return site;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId, boolean tmpEnabled) throws SQLException {
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM contact c WHERE contact_id > 0 AND c.enabled = ? " + (tmpEnabled ? "AND c.trashed_date IS NULL " : ""));
        if (moduleId == 1) {
            sql.append("AND c.org_id = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setBoolean(1, tmpEnabled);
        if (moduleId == 1) {
            pst.setInt(2, itemId);
        }
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
            logger.debug((Object)(String.valueOf(milies) + " ms"));
        }
        if (rs.next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static void updateOrgName(Connection db, Organization thisOrg) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact SET org_name = ? WHERE org_id = ?");
        pst.setString(1, thisOrg.getName());
        pst.setInt(2, thisOrg.getOrgId());
        pst.executeUpdate();
        pst.close();
    }

    public Contact getContactFromId(int id) {
        for (Contact contact : this) {
            if (contact.getUserId() != id) continue;
            return contact;
        }
        return null;
    }

    public HashMap getHashMapOfContacts() {
        HashMap<Integer, String> contactList = new HashMap<Integer, String>();
        for (Contact thisContact : this) {
            contactList.put(new Integer(thisContact.getId()), (thisContact.isTrashed() ? "<font color=\"red\">" : "") + Contact.getNameLastFirst(thisContact.getNameLast(), thisContact.getNameFirst()) + (this.checkUserAccess ? (thisContact.hasAccount() ? " (*)" : "") : "") + (thisContact.isTrashed() ? "</font>" : ""));
        }
        return contactList;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        for (Contact tmpContact : this) {
            tmpContact.updateStatus(db, context, toTrash, tmpUserId);
        }
        return true;
    }

    public int revertBackToLead(Connection db, ActionContext context, int userId) throws SQLException {
        int contactId = -1;
        for (Contact tmpContact : this) {
            contactId = tmpContact.getId();
            tmpContact.setOrgId(-1);
            tmpContact.setIsLead(true);
            tmpContact.setLeadStatus(2);
            tmpContact.setCompany(tmpContact.getCompany());
            tmpContact.setConversionDate((Timestamp)null);
            tmpContact.setCheckRevertingBackToLead(true);
            tmpContact.updateStatus(db, context, true, userId);
            tmpContact.update(db, true);
            if (tmpContact.getEnabled()) continue;
            tmpContact.enable(db);
        }
        return contactId;
    }

    public void buildShortList(Connection db) throws SQLException {
        Contact thisContact;
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact c LEFT JOIN organization o ON (c.org_id = o.org_id) LEFT JOIN lookup_department d ON (c.department = d.code) LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) LEFT JOIN lookup_site_id lsi ON (c.site_id = lsi.code) WHERE c.contact_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis();
                logger.debug((Object)pst.toString());
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                milies = System.currentTimeMillis() - milies;
                logger.debug((Object)(String.valueOf(milies) + " ms"));
            }
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis();
                    logger.debug((Object)pst.toString());
                }
                rs = pst.executeQuery();
                if (System.getProperty("DEBUG") != null) {
                    milies = System.currentTimeMillis() - milies;
                    logger.debug((Object)(String.valueOf(milies) + " ms"));
                }
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.getZipCodeAscPotentialDesc()) {
                if (this.oldestFirst == 1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered, c.namelast, c.namefirst, c.org_name");
                } else if (this.oldestFirst == 0 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered DESC, c.namelast, c.namefirst, c.org_name");
                } else if (this.oldestFirst == -1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                    this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.namelast, c.namefirst, c.org_name");
                }
            } else if (this.oldestFirst == 1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.entered, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == 0 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.entered DESC, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == -1 && (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy()))) {
                this.pagedListInfo.setColumnToSortBy("c.namelast, c.namefirst, c.org_name");
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else if (this.getZipCodeAscPotentialDesc()) {
            if (this.oldestFirst == 1) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == 0) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.entered DESC, c.namelast, c.namefirst, c.org_name");
            } else if (this.oldestFirst == -1) {
                this.pagedListInfo.setColumnToSortBy("ca.postalcode asc, c.potential desc, c.namelast, c.namefirst, c.org_name");
            }
        } else if (this.oldestFirst == 1) {
            sqlOrder.append("ORDER BY c.entered, c.namelast, c.namefirst, c.org_name ");
        } else if (this.oldestFirst == 0) {
            sqlOrder.append("ORDER BY c.entered DESC, c.namelast, c.namefirst, c.org_name ");
        } else if (this.oldestFirst == -1) {
            sqlOrder.append("ORDER BY c.namelast, c.namefirst, c.org_name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.user_id, c.contact_id, c.namelast, c.namefirst, o.name, c.owner, c.status_id, c.entered, c.lead, c.lead_status, c.org_id, c.site_id FROM contact c LEFT JOIN organization o ON (c.org_id = o.org_id) LEFT JOIN lookup_department d ON (c.department = d.code) LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) LEFT JOIN lookup_site_id lsi ON (c.site_id = lsi.code) WHERE c.contact_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            milies = System.currentTimeMillis() - milies;
            logger.debug((Object)(String.valueOf(milies) + " ms"));
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        boolean foundDefaultContact = false;
        while (rs.next()) {
            thisContact = new Contact();
            thisContact.buildShortRecord(rs);
            if (thisContact.getId() == this.defaultContactId) {
                foundDefaultContact = true;
            }
            this.addElement(thisContact);
        }
        rs.close();
        pst.close();
        if (this.defaultContactId != -1 && !foundDefaultContact) {
            thisContact = new Contact(db, this.defaultContactId);
            this.addElement(thisContact);
        }
        this.buildResources(db);
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            logger.setLevel(Level.DEBUG);
        }
    }
}

