/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.utils.DatabaseUtils;

public class ContactPhoneNumber
extends PhoneNumber {
    public ContactPhoneNumber() {
        this.isContact = true;
    }

    public ContactPhoneNumber(ResultSet rs) throws SQLException {
        this.isContact = true;
        this.buildRecord(rs);
    }

    public ContactPhoneNumber(Connection db, int phoneNumberId) throws SQLException {
        this.queryRecord(db, phoneNumberId);
    }

    public ContactPhoneNumber(Connection db, String phoneNumberId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(phoneNumberId));
    }

    public void queryRecord(Connection db, int phoneNumberId) throws SQLException {
        this.isContact = true;
        if (phoneNumberId <= 0) {
            throw new SQLException("Invalid Phone Number ID specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM contact_phone p, lookup_contactphone_types l WHERE p.phone_type = l.code AND phone_id = ? ");
        pst.setInt(1, phoneNumberId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Phone record not found.");
        }
    }

    public void process(Connection db, int contactId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setContactId(contactId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getContactId(), this.getEnteredBy());
    }

    public void insert(Connection db, int contactId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.setId(DatabaseUtils.getNextSeq(db, "contact_phone_phone_id_seq"));
        int id = this.getId();
        sql.append("INSERT INTO contact_phone (contact_id, phone_type, " + DatabaseUtils.addQuotes(db, "number") + ", extension, primary_number, ");
        if (id > -1) {
            sql.append("phone_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ");
        if (id > -1) {
            sql.append("?, ");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (contactId > -1) {
            pst.setInt(++i, this.getContactId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getNumber());
        pst.setString(++i, this.getExtension());
        pst.setBoolean(++i, this.getPrimaryNumber());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "contact_phone_phone_id_seq", id));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact_phone SET phone_type = ?, " + DatabaseUtils.addQuotes(db, "number") + " = ?, extension = ?, primary_number = ?, modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE phone_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getNumber());
        pst.setString(++i, this.getExtension());
        pst.setBoolean(++i, this.getPrimaryNumber());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM contact_phone WHERE phone_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

