/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.modules.base.PhoneNumberList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class ContactPhoneNumberList
extends PhoneNumberList {
    public static final String tableName = "contact_emailaddress";
    public static final String uniqueField = "emailaddress_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public ContactPhoneNumberList() {
    }

    public ContactPhoneNumberList(ActionContext context) {
        int i = 0;
        int primaryNumber = -1;
        if (context.getRequest().getParameter("primaryNumber") != null) {
            primaryNumber = Integer.parseInt(context.getRequest().getParameter("primaryNumber"));
        }
        while (context.getRequest().getParameter("phone" + ++i + "type") != null) {
            ContactPhoneNumber thisPhoneNumber = new ContactPhoneNumber();
            thisPhoneNumber.buildRecord(context, i);
            if (primaryNumber == i) {
                thisPhoneNumber.setPrimaryNumber(true);
            }
            if (!thisPhoneNumber.isValid()) continue;
            this.addElement(thisPhoneNumber);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect emailListSelect = new HtmlSelect();
        for (PhoneNumber thisNumber : this) {
            String elementText = null;
            elementText = String.valueOf(thisNumber.getTypeName().charAt(0)) + ":";
            elementText = elementText + thisNumber.getNumber();
            emailListSelect.addItem(thisNumber.getId(), elementText + (thisNumber.getPrimaryNumber() ? "*" : ""));
        }
        return emailListSelect.getHtml(selectName, defaultKey);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM contact_phone p, lookup_contactphone_types l WHERE p.phone_type = l.code ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact_phone p, lookup_contactphone_types l WHERE p.phone_type = l.code ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(phone_type) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", phone_type ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY phone_type ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        } else {
            sqlOrder.append("ORDER BY phone_type ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            ContactPhoneNumber thisPhoneNumber = new ContactPhoneNumber(rs);
            this.addElement(thisPhoneNumber);
        }
        rs.close();
        pst.close();
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

