/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationReport;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.Report;
import org.aspcfs.modules.base.ReportRow;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;

public class ContactReport
extends ContactList {
    protected Report rep = new Report();
    protected String delimiter = ",";
    protected String header = null;
    protected String tdFormat = "";
    protected String filePath = "";
    protected String filenameToUse = "";
    protected FileItem thisItem = new FileItem();
    protected String subject = "";
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected int limitId = -1;
    protected ArrayList criteria = null;
    protected String[] params = new String[]{"id", "nameLast", "nameFirst", "company", "type", "nameMiddle", "title", "department", "entered", "enteredBy", "modified", "modifiedBy", "owner", "businessEmail", "businessPhone", "businessAddress", "city", "state", "zip", "country", "notes", "status", "source", "rating", "industry", "potential"};
    protected OrganizationReport orgReportJoin = new OrganizationReport();
    protected boolean joinOrgs = false;
    protected boolean includeFolders = false;
    protected int folderId = -1;
    protected int type = -1;

    public int getType() {
        return this.type;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setRep(Report tmp) {
        this.rep = tmp;
    }

    public void setDelimiter(String tmp) {
        this.delimiter = tmp;
    }

    public void setHeader(String tmp) {
        this.header = tmp;
    }

    public void setTdFormat(String tmp) {
        this.tdFormat = tmp;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public void setFolderId(int folderId) {
        this.folderId = folderId;
    }

    public boolean getIncludeFolders() {
        return this.includeFolders;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public Report getRep() {
        return this.rep;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getHeader() {
        return this.header;
    }

    public String getTdFormat() {
        return this.tdFormat;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileItem getThisItem() {
        return this.thisItem;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setThisItem(FileItem tmp) {
        this.thisItem = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public OrganizationReport getOrgReportJoin() {
        return this.orgReportJoin;
    }

    public boolean getJoinOrgs() {
        return this.joinOrgs;
    }

    public void setOrgReportJoin(OrganizationReport tmp) {
        this.orgReportJoin = tmp;
    }

    public void setJoinOrgs(boolean tmp) {
        this.joinOrgs = tmp;
    }

    public int getLimitId() {
        return this.limitId;
    }

    public void setLimitId(int limitId) {
        this.limitId = limitId;
    }

    public ArrayList getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String[] criteriaString) {
        if (criteriaString != null) {
            this.params = criteriaString;
        }
        this.criteria = new ArrayList<String>(Arrays.asList(this.params));
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getFilenameToUse() {
        return this.filenameToUse;
    }

    public void setFilenameToUse(String filenameToUse) {
        this.filenameToUse = filenameToUse;
    }

    public void buildReportBaseInfo() {
        this.rep.setDelimitedCharacter(this.delimiter);
        if (this.header != null) {
            this.rep.setHeader(this.header + (!this.header.equals("") && !this.subject.equals("") ? ": " : "") + this.subject);
        }
    }

    public void buildReportHeaders() {
        if (this.joinOrgs) {
            this.orgReportJoin.buildReportHeaders(this.rep);
        }
        for (String param : this.criteria) {
            if (param.equals("id")) {
                if (this.type == 2) {
                    this.rep.addColumn("Lead Id");
                } else if (this.type == 1) {
                    this.rep.addColumn("Employee Id");
                } else {
                    this.rep.addColumn("Contact Id");
                }
            }
            if (param.equals("type")) {
                this.rep.addColumn("Type");
            }
            if (param.equals("nameLast")) {
                this.rep.addColumn("Last Name", "Last Name");
            }
            if (param.equals("nameFirst")) {
                this.rep.addColumn("First Name", "First Name");
            }
            if (param.equals("nameMiddle")) {
                this.rep.addColumn("Middle Name", "Middle Name");
            }
            if (param.equals("company")) {
                this.rep.addColumn("Company");
            }
            if (param.equals("title")) {
                this.rep.addColumn("Title");
            }
            if (param.equals("department")) {
                this.rep.addColumn("Department");
            }
            if (param.equals("entered")) {
                this.rep.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                this.rep.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                this.rep.addColumn("Modified");
            }
            if (param.equals("modifiedBy")) {
                this.rep.addColumn("Modified By");
            }
            if (param.equals("owner")) {
                this.rep.addColumn("Owner");
            }
            if (param.equals("businessEmail")) {
                this.rep.addColumn("Business Email");
            }
            if (param.equals("businessPhone")) {
                this.rep.addColumn("Business Phone");
            }
            if (param.equals("businessAddress")) {
                this.rep.addColumn("Business Address Line 1");
                this.rep.addColumn("Business Address Line 2");
                this.rep.addColumn("Business Address Line 3");
            }
            if (param.equals("city")) {
                this.rep.addColumn("City");
            }
            if (param.equals("state")) {
                this.rep.addColumn("State");
            }
            if (param.equals("zip")) {
                this.rep.addColumn("Zip");
            }
            if (param.equals("country")) {
                this.rep.addColumn("Country");
            }
            if (param.equals("notes")) {
                this.rep.addColumn("Notes");
            }
            if (this.type != 2) continue;
            if (param.equals("status")) {
                this.rep.addColumn("Status");
            }
            if (param.equals("source")) {
                this.rep.addColumn("Source");
            }
            if (param.equals("rating")) {
                this.rep.addColumn("Rating");
            }
            if (param.equals("industry")) {
                this.rep.addColumn("Industry");
            }
            if (!param.equals("potential")) continue;
            this.rep.addColumn("Potential");
        }
        if (this.includeFolders) {
            this.rep.addColumn("Folder Name");
            this.rep.addColumn("Record Name");
            this.rep.addColumn("Group Name");
            this.rep.addColumn("Field Name");
            this.rep.addColumn("Field Value");
            this.rep.addColumn("Entered");
            this.rep.addColumn("Modified");
        }
    }

    public void buildData(Connection db, Hashtable userTable) throws SQLException {
        this.buildList(db);
        this.buildReportData(db, userTable);
    }

    public void buildData(Connection db) throws SQLException {
        this.buildData(db, null);
    }

    public void buildReportData(Connection db) throws SQLException {
        this.buildReportData(db, null);
    }

    public void buildReportData(Connection db, Hashtable userTable) throws SQLException {
        boolean writeOut = false;
        Organization tempOrg = null;
        CustomFieldCategoryList thisList = new CustomFieldCategoryList();
        CustomFieldCategory thisCat2 = null;
        CustomFieldGroup thisGroup2 = new CustomFieldGroup();
        if (this.includeFolders) {
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(true);
            thisList.buildList(db);
        } else if (this.folderId > -1) {
            thisCat2 = new CustomFieldCategory(db, this.folderId);
            thisCat2.buildResources(db);
            for (CustomFieldGroup thisGroup2 : thisCat2) {
                thisGroup2.buildResources(db);
                for (CustomField thisField : thisGroup2) {
                    this.rep.addColumn(thisField.getNameHtml());
                }
            }
        }
        for (Contact thisContact : this) {
            Iterator fields;
            CustomFieldRecordList recordList;
            if (userTable != null) {
                thisContact.setOwnerName(this.lookupName(thisContact.getOwner(), userTable));
                thisContact.setEnteredByName(this.lookupName(thisContact.getEnteredBy(), userTable));
                thisContact.setModifiedByName(this.lookupName(thisContact.getModifiedBy(), userTable));
            }
            if (this.includeFolders) {
                recordList = new CustomFieldRecordList();
                thisGroup2 = new CustomFieldGroup();
                for (CustomFieldCategory thisCat2 : thisList) {
                    recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(2);
                    recordList.setLinkItemId(thisContact.getId());
                    recordList.setCategoryId(thisCat2.getId());
                    recordList.buildList(db);
                    for (CustomFieldRecord thisRec : recordList) {
                        Iterator grp = thisCat2.iterator();
                        while (grp.hasNext()) {
                            thisGroup2 = new CustomFieldGroup();
                            thisGroup2 = (CustomFieldGroup)grp.next();
                            thisGroup2.buildResources(db);
                            fields = thisGroup2.iterator();
                            if (!fields.hasNext()) continue;
                            while (fields.hasNext()) {
                                ReportRow thisRow = new ReportRow();
                                CustomField thisField = (CustomField)fields.next();
                                thisField.setRecordId(thisRec.getId());
                                thisField.buildResources(db);
                                this.addDataRow(thisRow, thisContact);
                                thisRow.addCell(thisCat2.getName());
                                thisRow.addCell(thisCat2.getName() + " #" + thisRec.getId());
                                thisRow.addCell(thisGroup2.getName());
                                thisRow.addCell(thisField.getNameHtml());
                                thisRow.addCell(thisField.getValueHtml());
                                thisRow.addCell(thisRec.getEnteredString());
                                thisRow.addCell(thisRec.getModifiedDateTimeString());
                                this.rep.addRow(thisRow);
                            }
                        }
                    }
                }
                continue;
            }
            if (this.folderId > -1) {
                recordList = new CustomFieldRecordList();
                recordList.setLinkModuleId(2);
                recordList.setLinkItemId(thisContact.getId());
                recordList.setCategoryId(thisCat2.getId());
                recordList.buildList(db);
                Iterator rec = recordList.iterator();
                while (rec.hasNext()) {
                    CustomFieldRecord thisRec;
                    ReportRow thisRow = new ReportRow();
                    this.addDataRow(thisRow, thisContact);
                    thisRec = (CustomFieldRecord)rec.next();
                    for (CustomFieldGroup thisGroup2 : thisCat2) {
                        thisGroup2.buildResources(db);
                        fields = thisGroup2.iterator();
                        if (!fields.hasNext()) continue;
                        while (fields.hasNext()) {
                            CustomField thisField = (CustomField)fields.next();
                            thisField.setRecordId(thisRec.getId());
                            thisField.buildResources(db);
                            thisRow.addCell(thisField.getValueHtml());
                        }
                    }
                    this.rep.addRow(thisRow);
                }
                continue;
            }
            ReportRow thisRow = new ReportRow();
            if (this.joinOrgs && thisContact.getOrgId() > 0) {
                tempOrg = new Organization(db, thisContact.getOrgId());
                if (this.limitId > -1) {
                    if (tempOrg.getOwner() == this.limitId) {
                        this.orgReportJoin.addDataRow(thisRow, tempOrg);
                        writeOut = true;
                    }
                } else {
                    this.orgReportJoin.addDataRow(thisRow, tempOrg);
                    writeOut = true;
                }
            }
            if (!this.joinOrgs || writeOut) {
                this.addDataRow(thisRow, thisContact);
                this.rep.addRow(thisRow);
            }
            writeOut = false;
        }
    }

    private String lookupName(int userId, Hashtable userTable) {
        Contact thisContact;
        User thisUser = (User)((Object)userTable.get(new Integer(userId)));
        if (thisUser != null && (thisContact = thisUser.getContact()) != null) {
            return thisContact.getNameLastFirst();
        }
        return "";
    }

    public void addDataRow(ReportRow thisRow, Contact thisContact) throws SQLException {
        for (String param : this.criteria) {
            if (param.equals("id")) {
                thisRow.addCell(thisContact.getId());
            }
            if (param.equals("type")) {
                thisRow.addCell(thisContact.getTypesNameString());
            }
            if (param.equals("nameLast")) {
                thisRow.addCell(thisContact.getNameLast());
            }
            if (param.equals("nameFirst")) {
                thisRow.addCell(thisContact.getNameFirst());
            }
            if (param.equals("nameMiddle")) {
                thisRow.addCell(thisContact.getNameMiddle());
            }
            if (param.equals("company")) {
                thisRow.addCell(thisContact.getCompany());
            }
            if (param.equals("title")) {
                thisRow.addCell(thisContact.getTitle());
            }
            if (param.equals("department")) {
                thisRow.addCell(thisContact.getDepartmentName());
            }
            if (param.equals("entered")) {
                thisRow.addCell(thisContact.getEnteredString());
            }
            if (param.equals("enteredBy")) {
                thisRow.addCell(thisContact.getEnteredByName());
            }
            if (param.equals("modified")) {
                thisRow.addCell(thisContact.getModifiedString());
            }
            if (param.equals("modifiedBy")) {
                thisRow.addCell(thisContact.getModifiedByName());
            }
            if (param.equals("owner")) {
                thisRow.addCell(thisContact.getOwnerName());
            }
            if (param.equals("businessEmail")) {
                thisRow.addCell(thisContact.getEmailAddress("Business"));
            }
            if (param.equals("businessPhone")) {
                thisRow.addCell(thisContact.getPhoneNumber("Business"));
            }
            if (param.equals("businessAddress")) {
                thisRow.addCell(thisContact.getAddress("Business").getStreetAddressLine1());
                thisRow.addCell(thisContact.getAddress("Business").getStreetAddressLine2());
                thisRow.addCell(thisContact.getAddress("Business").getStreetAddressLine3());
            }
            if (param.equals("city")) {
                thisRow.addCell(thisContact.getAddress("Business").getCity());
            }
            if (param.equals("state")) {
                thisRow.addCell(thisContact.getAddress("Business").getState());
            }
            if (param.equals("zip")) {
                thisRow.addCell(thisContact.getAddress("Business").getZip());
            }
            if (param.equals("country")) {
                thisRow.addCell(thisContact.getAddress("Business").getCountry());
            }
            if (param.equals("notes")) {
                thisRow.addCell(thisContact.getNotes());
            }
            if (this.type != 2) continue;
            if (param.equals("status")) {
                thisRow.addCell(thisContact.getLeadStatusString());
            }
            if (param.equals("source")) {
                thisRow.addCell(thisContact.getSourceName());
            }
            if (param.equals("rating")) {
                thisRow.addCell(thisContact.getRatingName());
            }
            if (param.equals("industry")) {
                thisRow.addCell(thisContact.getIndustryName());
            }
            if (!param.equals("potential")) continue;
            thisRow.addCell(String.valueOf(thisContact.getPotential()));
        }
    }

    public void buildReportFull(Connection db, Hashtable userTable) throws SQLException {
        this.buildReportBaseInfo();
        this.buildReportHeaders();
        this.buildData(db, userTable);
    }

    public void buildReportFull(Connection db) throws SQLException {
        this.buildReportFull(db, null);
    }

    public boolean saveAndInsert(Connection db) throws Exception {
        int fileSize = this.save();
        if (this.joinOrgs) {
            this.thisItem.setLinkModuleId(10);
        } else if (this.type == 2) {
            this.thisItem.setLinkModuleId(2006031313);
        } else {
            this.thisItem.setLinkModuleId(11);
        }
        this.thisItem.setLinkItemId(0);
        this.thisItem.setEnteredBy(this.enteredBy);
        this.thisItem.setModifiedBy(this.modifiedBy);
        this.thisItem.setSubject(this.subject);
        if (this.type == 2) {
            this.thisItem.setClientFilename("leadreport-" + this.filenameToUse + ".csv");
        } else {
            this.thisItem.setClientFilename("contactreport-" + this.filenameToUse + ".csv");
        }
        this.thisItem.setFilename(this.filenameToUse);
        this.thisItem.setSize(fileSize);
        this.thisItem.insert(db);
        return true;
    }

    public int save() throws Exception {
        this.generateFilename();
        File f = new File(this.filePath);
        f.mkdirs();
        this.rep.saveHtml(this.filePath + this.filenameToUse + ".html");
        this.rep.saveDelimited(this.filePath + this.filenameToUse + ".csv");
        File fileLink = new File(this.filePath + this.filenameToUse + ".csv");
        return (int)fileLink.length();
    }

    public String generateFilename() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this.filenameToUse = formatter.format(new Date());
        return this.filenameToUse;
    }
}

