/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.base.TextMessageAddress;
import org.aspcfs.utils.DatabaseUtils;

public class ContactTextMessageAddress
extends TextMessageAddress {
    public ContactTextMessageAddress() {
        this.isContact = true;
    }

    public ContactTextMessageAddress(ResultSet rs) throws SQLException {
        this.isContact = true;
        this.buildRecord(rs);
    }

    public ContactTextMessageAddress(Connection db, int addressId) throws SQLException {
        this.queryRecord(db, addressId);
    }

    public ContactTextMessageAddress(Connection db, String addressId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(addressId));
    }

    public void queryRecord(Connection db, int addressId) throws SQLException {
        this.isContact = true;
        if (addressId < 0) {
            throw new SQLException("Valid Text Message Address ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM contact_textmessageaddress c, lookup_textmessage_types l WHERE c.textmessageaddress_type = l.code AND c.address_id = " + addressId + " ");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Email record not found.");
        }
    }

    public void process(Connection db, int contactId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setContactId(contactId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getContactId(), this.getEnteredBy());
    }

    public void insert(Connection db, int contactId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.setId(DatabaseUtils.getNextSeq(db, "contact_textmessageaddress_address_id_seq"));
        int id = this.getId();
        sql.append("INSERT INTO contact_textmessageaddress (contact_id, textmessageaddress_type, textmessageaddress, primary_textmessage_address, ");
        if (id > -1) {
            sql.append("address_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ");
        if (id > -1) {
            sql.append("?, ");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (contactId > -1) {
            pst.setInt(++i, this.getContactId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getTextMessageAddress());
        pst.setBoolean(++i, this.getPrimaryTextMessageAddress());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "contact_textmessageaddress_address_id_seq", id));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE contact_textmessageaddress SET textmessageaddress_type = ?, textmessageaddress = ?, primary_textmessage_address = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE address_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getTextMessageAddress());
        pst.setBoolean(++i, this.getPrimaryTextMessageAddress());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM contact_textmessageaddress WHERE address_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

