/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.TextMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactTextMessageAddress;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class ContactTextMessageAddressList
extends TextMessageAddressList {
    public static final String tableName = "contact_textmessageaddress";
    public static final String uniqueField = "address_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;

    public ContactTextMessageAddressList() {
    }

    public ContactTextMessageAddressList(HttpServletRequest request) {
        int i = 0;
        int primaryTextMessageAddress = -1;
        if (request.getParameter("primaryTextMessageAddress") != null) {
            primaryTextMessageAddress = Integer.parseInt(request.getParameter("primaryTextMessageAddress"));
        }
        while (request.getParameter("textmessage" + ++i + "type") != null) {
            ContactTextMessageAddress thisAddress = new ContactTextMessageAddress();
            thisAddress.buildRecord(request, i);
            if (primaryTextMessageAddress == i) {
                thisAddress.setPrimaryTextMessageAddress(true);
            }
            if (!thisAddress.isValid()) continue;
            this.addElement(thisAddress);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM contact_textmessageaddress t, lookup_textmessage_types l WHERE t.textmessageaddress_type = l.code ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact_textmessageaddress t, lookup_textmessage_types l WHERE t.textmessageaddress_type = l.code ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(textmessageaddress) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", textmessageaddress ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY textmessageaddress ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            ContactTextMessageAddress thisAddress = new ContactTextMessageAddress(rs);
            this.addElement(thisAddress);
        }
        rs.close();
        pst.close();
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getEmptyHtmlSelect(SystemStatus thisSystem, String selectName) {
        HtmlSelect emailListSelect = new HtmlSelect();
        emailListSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        return emailListSelect.getHtml(selectName);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect emailListSelect = new HtmlSelect();
        emailListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            emailListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (ContactTextMessageAddress thisAddress : this) {
            emailListSelect.addItem(thisAddress.getId(), thisAddress.getTextMessageAddress() + (thisAddress.getPrimaryTextMessageAddress() ? "*" : ""));
        }
        return emailListSelect.getHtml(selectName, defaultKey);
    }
}

