/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ContactType {
    public static final int GENERAL = 0;
    public static final int ACCOUNT = 1;
    private int id = 0;
    private String description = null;
    private boolean enabled = true;
    private int category = -1;
    private int userId = -1;
    private int level = 0;

    public ContactType() {
    }

    public ContactType(ResultSet rs) throws SQLException {
        this.id = rs.getInt("code");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
        this.category = rs.getInt("category");
        this.userId = DatabaseUtils.getInt(rs, "user_id");
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setCategory(String category) {
        this.category = Integer.parseInt(category);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getCategory() {
        return this.category;
    }

    public int getId() {
        return this.id;
    }

    public int getCode() {
        return this.id;
    }

    public String getCodeString() {
        return String.valueOf(this.id);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Connection db, boolean tmp) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Contact Type ID not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE lookup_contact_types SET enabled = ? WHERE code = ? ");
            int i = 0;
            pst.setBoolean(++i, tmp);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public boolean insert(Connection db) throws SQLException {
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "lookup_contact_types_code_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_contact_types (" + (this.id > -1 ? "code, " : "") + "description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, category" + (this.userId > -1 ? ", user_id" : "") + ") " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?" + (this.userId > -1 ? ", ?" : "") + ") ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getLevel());
        pst.setBoolean(++i, true);
        pst.setInt(++i, this.category);
        if (this.userId > -1) {
            pst.setInt(++i, this.userId);
        }
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "lookup_contact_types_code_seq", this.id);
        return true;
    }

    public int setNewOrder(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == 0) {
            throw new SQLException("ContactType Id not specified.");
        }
        PreparedStatement pst = null;
        int i = 0;
        pst = db.prepareStatement("UPDATE lookup_contact_types SET " + DatabaseUtils.addQuotes(db, "level") + " = ? " + "WHERE code = ? ");
        pst.setInt(++i, this.getLevel());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

