/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.contacts.base.ContactType;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public class ContactTypeList
extends ArrayList {
    private String jsEvent = "";
    private int defaultKey = -1;
    private int size = 1;
    private int category = -1;
    private boolean multiple = false;
    private boolean showDisabled = true;
    private int includeDefinedByUser = -1;
    private int includeSelectedByUser = -1;
    private String includeIds = null;
    protected PagedListInfo pagedListInfo = null;

    public ContactTypeList() {
    }

    public ContactTypeList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public ContactTypeList(String[] vals, String[] names) throws SQLException {
        for (int i = 0; i < vals.length; ++i) {
            ContactType thisType = new ContactType();
            thisType.setDescription(names[i]);
            if (!vals[i].startsWith("*")) {
                thisType.setId(Integer.parseInt(vals[i]));
            }
            thisType.setLevel(i);
            this.add(thisType);
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setDefaultKey(int tmp) {
        this.defaultKey = tmp;
    }

    public void setDefaultKey(String tmp) {
        this.defaultKey = Integer.parseInt(tmp);
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setCategory(String category) {
        this.category = Integer.parseInt(category);
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setIncludeDefinedByUser(int includeDefinedByUser) {
        this.includeDefinedByUser = includeDefinedByUser;
    }

    public void setIncludeSelectedByUser(int includeSelectedByUser) {
        this.includeSelectedByUser = includeSelectedByUser;
    }

    public void setShowDisabled(boolean showDisabled) {
        this.showDisabled = showDisabled;
    }

    public void setIncludeIds(String includeIds) {
        this.includeIds = includeIds;
    }

    public boolean getShowDisabled() {
        return this.showDisabled;
    }

    public int getIncludeSelectedByUser() {
        return this.includeSelectedByUser;
    }

    public int getIncludeDefinedByUser() {
        return this.includeDefinedByUser;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getCategory() {
        return this.category;
    }

    public int getSize() {
        return this.size;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getDefaultKey() {
        return this.defaultKey;
    }

    public String getHtmlSelect(SystemStatus thisSystem, String selectName) {
        return this.getHtmlSelect(thisSystem, selectName, this.defaultKey);
    }

    public String getHtmlSelect(SystemStatus thisSystem, String selectName, int defaultKey) {
        LookupList contactTypeSelect = this.getLookupList(thisSystem, selectName, defaultKey);
        return contactTypeSelect.getHtmlSelect(selectName, defaultKey);
    }

    public LookupList getLookupList(SystemStatus thisSystem, String selectName, int defaultKey) {
        LookupList contactTypeSelect = new LookupList();
        contactTypeSelect.setTableName("lookup_contact_types");
        contactTypeSelect.setJsEvent(this.jsEvent);
        contactTypeSelect.setSelectSize(this.getSize());
        contactTypeSelect.setMultiple(this.getMultiple());
        int category = -1;
        for (ContactType thisContactType : this) {
            if (thisContactType.getCategory() != category) {
                category = thisContactType.getCategory();
                switch (category) {
                    case 0: {
                        if (thisSystem != null) {
                            contactTypeSelect.addGroup(thisSystem.getLabel("contacts.typeList.contactTypes"));
                            break;
                        }
                        contactTypeSelect.addGroup("Contact Types");
                        break;
                    }
                    case 1: {
                        if (thisSystem != null) {
                            contactTypeSelect.addGroup(thisSystem.getLabel("contacts.typeList.accountContactTypes"));
                            break;
                        }
                        contactTypeSelect.addGroup("Account Contact Types");
                        break;
                    }
                }
            }
            if (thisContactType.getEnabled()) {
                contactTypeSelect.appendItem(thisContactType.getId(), thisContactType.getDescription());
                continue;
            }
            if (thisContactType.getId() != defaultKey) continue;
            contactTypeSelect.appendItem(thisContactType.getId(), thisContactType.getDescription() + " (X)");
        }
        return contactTypeSelect;
    }

    public void addItem(int key, String name) {
        ContactType thisContactType = new ContactType();
        thisContactType.setId(key);
        thisContactType.setDescription(name);
        this.add(thisContactType);
    }

    public int getEnabledElementCount() {
        int count = 0;
        for (ContactType thisElement : this) {
            if (!thisElement.getEnabled()) continue;
            ++count;
        }
        return count;
    }

    public ContactType getElement(int code) {
        ContactType thisType = null;
        for (ContactType thisElement : this) {
            if (thisElement.getId() != code) continue;
            thisType = thisElement;
        }
        return thisType;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlFilterTail = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM lookup_contact_types lct WHERE code > -1 ");
        this.createFilter(db, sqlFilter);
        this.addSqlFilterTail(sqlFilterTail);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + sqlFilterTail.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(lct.description) < ? " + sqlFilterTail.toString());
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("lct.category, lct.user_id, lct." + DatabaseUtils.addQuotes(db, "level") + ", lct.description ", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY lct.category, lct.user_id, lct." + DatabaseUtils.addQuotes(db, "level") + ", lct.description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("lct.* FROM lookup_contact_types lct WHERE lct.code > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlFilterTail.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ContactType thisContactType = new ContactType(rs);
            this.add(thisContactType);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.category != -1) {
            sqlFilter.append("AND lct.category = ? ");
        }
        if (!this.showDisabled) {
            sqlFilter.append("AND lct.enabled = ? ");
        }
        if (this.includeDefinedByUser > 0) {
            sqlFilter.append("AND (lct.user_id = ? OR lct.user_id IS NULL) ");
        } else {
            sqlFilter.append("AND lct.user_id IS NULL ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.category != -1) {
            pst.setInt(++i, this.category);
        }
        if (!this.showDisabled) {
            pst.setBoolean(++i, true);
        }
        if (this.includeDefinedByUser > 0) {
            pst.setInt(++i, this.includeDefinedByUser);
        }
        return i;
    }

    private void addSqlFilterTail(StringBuffer sqlFilterTail) {
        if (sqlFilterTail == null) {
            sqlFilterTail = new StringBuffer();
        }
        boolean i = false;
        if (this.includeSelectedByUser != -1) {
            sqlFilterTail.append("OR (lct.code in (select type_id from contact_type_levels where contact_id = " + this.includeSelectedByUser + ") ) ");
        }
        if (this.includeIds != null && !"".equals(this.includeIds)) {
            sqlFilterTail.append("OR (lct.code in (" + this.includeIds + ") ) ");
        }
    }
}

