/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.io.File;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.RequestUtils;
import org.w3c.dom.Element;

public class SalesEmail {
    private String subject = null;
    private String body = null;

    public SalesEmail(String templateFile, Contact contact, ActionContext context, String type) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", type + ".email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        messageSubject.addParseElement("${" + type + ".email.subject}", "Centric CRM: Lead Assigned");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "" + type + ".email.body")));
        messageBody.addParseElement("${contact.name}", contact.getNameFull());
        if (contact.getCompany() != null && !"".equals(contact.getCompany().trim())) {
            messageBody.addParseElement("${contact.company}", "/ " + contact.getCompany());
        } else {
            messageBody.addParseElement("${contact.company}", "");
        }
        messageBody.addParseElement("${link}", RequestUtils.getLink(context, "Sales.do?command=Details&contactId=" + contact.getId() + "&from=dashboard"));
        this.body = messageBody.getParsedText();
    }

    public SalesEmail(String templateFile, Contact contact, ActionContext context) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "leads.worked.email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        messageSubject.addParseElement("${leads.worked.email.subject}", "Centric CRM: Prospect Assigned");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "leads.worked.email.body")));
        if (contact.getNameLastFirst() == null || "".equals(contact.getNameLastFirst())) {
            messageBody.addParseElement("${contact.name}", contact.getNameFull());
            messageBody.addParseElement("${contact.company}", "");
        } else {
            messageBody.addParseElement("${contact.name}", contact.getNameFull());
            if (contact.getCompany() != null && !"".equals(contact.getCompany().trim())) {
                messageBody.addParseElement("${contact.company}", "/ " + contact.getCompany());
            } else {
                messageBody.addParseElement("${contact.company}", "");
            }
        }
        if (contact.getOrgId() == -1) {
            messageBody.addParseElement("${link}", RequestUtils.getLink(context, "ExternalContacts.do?command=Details&id=" + contact.getId()));
        } else {
            messageBody.addParseElement("${link}", RequestUtils.getLink(context, "Accounts.do?command=Details&orgId=" + contact.getOrgId()));
        }
        this.body = messageBody.getParsedText();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }
}

