/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.aspcfs.modules.contacts.utils.QualifiedLeadsCount;
import org.aspcfs.utils.DatabaseUtils;

public class QualifiedLeadsCounter {
    private String QUERY = "select ac.user_id, ac.manager_id, co.count_of_conversion,  co.conversion_date FROM access ac, (select  count('x') as count_of_conversion,   ## as conversion_date,  owner    from contact  where @@ > ? group by owner, conversion_date) co where owner = user_id";
    private HashMap rawData = new HashMap();
    private HashMap result = new HashMap();

    private QualifiedLeadsCounter(Connection db) throws SQLException {
        Calendar startDate = Calendar.getInstance();
        startDate.add(4, -8);
        this.QUERY = this.QUERY.replaceAll("##", DatabaseUtils.getTruncDateDialect("conversion_date", 1, DatabaseUtils.getType(db)));
        this.QUERY = this.QUERY.replaceAll("@@", DatabaseUtils.castDateTimeToDate(db, "conversion_date"));
        this.QUERY = this.QUERY.replaceAll(" access ", " " + DatabaseUtils.addQuotes(db, "access") + " ");
        PreparedStatement ps = db.prepareStatement(this.QUERY);
        ps.setDate(1, new Date(startDate.getTimeInMillis()));
        int rowNum = this.populateRawData(ps.executeQuery());
        ps.close();
        this.buildHierarchy(rowNum, -1, null);
    }

    private double buildHierarchy(int size, int parentItemId, Date conversionDate) throws SQLException {
        double count = 0.0;
        double cCount = 0.0;
        ArrayList itemList = null;
        for (int i = 0; i <= size; ++i) {
            QualifiedLeadsCount qlc;
            Integer key = new Integer(i);
            if (!this.rawData.containsKey(key) || (qlc = (QualifiedLeadsCount)this.rawData.get(key)).getManagerId() != parentItemId || !qlc.getConversionDate().equals(conversionDate) && conversionDate != null) continue;
            this.rawData.remove(key);
            cCount = this.buildHierarchy(size, qlc.getUserId(), qlc.getConversionDate());
            qlc.setCountOfConversion(qlc.getCountOfConversion() + cCount);
            key = new Integer(qlc.getUserId());
            if (qlc.getCountOfConversion() > 0.0) {
                itemList = this.result.containsKey(key) ? (ArrayList)this.result.get(key) : new ArrayList();
                itemList.add(qlc);
                this.result.put(key, itemList);
            }
            count += qlc.getCountOfConversion();
        }
        return count;
    }

    private int populateRawData(ResultSet rs) throws SQLException {
        int rowNum = 0;
        this.rawData = new HashMap();
        while (rs.next()) {
            QualifiedLeadsCount qualifiedLeadsCounter = new QualifiedLeadsCount();
            qualifiedLeadsCounter.setUserId(rs.getInt("user_id"));
            qualifiedLeadsCounter.setManagerId(DatabaseUtils.getInt(rs, "manager_id", -1));
            qualifiedLeadsCounter.setConversionDate(rs.getDate("conversion_date"));
            qualifiedLeadsCounter.setCountOfConversion(rs.getDouble("count_of_conversion"));
            this.rawData.put(new Integer(rowNum++), qualifiedLeadsCounter);
        }
        rs.close();
        return rowNum;
    }

    public List getQualifiedLeadsCounter(int userId) {
        Integer id = new Integer(userId);
        if (this.result.containsKey(id)) {
            return (List)this.result.get(id);
        }
        return new ArrayList();
    }

    public static QualifiedLeadsCounter getQualifiedLeadsCounter(Connection db) throws SQLException {
        return new QualifiedLeadsCounter(db);
    }
}

