/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.contacts.webservices;

import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.utils.CRMConnection;

public class ContactServices {
    private CRMConnection crm = new CRMConnection();

    public void setAuthenticationInfo(AuthenticationItem auth) {
        this.crm.setUrl(auth.getUrl());
        this.crm.setId(auth.getId());
        this.crm.setSystemId(auth.getSystemId());
        this.crm.setClientId(auth.getClientId());
        this.crm.setUsername(auth.getUsername());
        this.crm.setCode(auth.getCode());
    }

    public boolean addContact(AuthenticationItem in0, Contact in1, ContactEmailAddress in2, ContactPhoneNumber in3, ContactAddress in4) {
        try {
            AuthenticationItem auth = in0;
            Contact contact = in1;
            ContactEmailAddress email = in2;
            ContactPhoneNumber phone = in3;
            ContactAddress address = in4;
            this.setAuthenticationInfo(auth);
            this.crm.setAutoCommit(false);
            DataRecord contactData = new DataRecord();
            contactData.setName("contact");
            contactData.setAction("insert");
            contactData.setShareKey(true);
            contactData.addField("nameSalutation", contact.getNameSalutation());
            contactData.addField("nameFirst", contact.getNameFirst());
            contactData.addField("nameLast", contact.getNameLast());
            contactData.addField("company", contact.getCompany());
            contactData.addField("title", contact.getTitle());
            contactData.addField("source", contact.getSource());
            contactData.addField("rating", contact.getRating());
            contactData.addField("industryTempCode", contact.getIndustryTempCode());
            contactData.addField("comments", contact.getComments());
            contactData.addField("notes", contact.getNotes());
            contactData.addField("isLead", contact.getIsLead());
            contactData.addField("leadStatus", contact.getLeadStatus());
            contactData.addField("accessType", contact.getAccessType());
            contactData.addField("owner", contact.getOwner());
            contactData.addField("enteredBy", contact.getEnteredBy());
            contactData.addField("modifiedBy", contact.getModifiedBy());
            this.crm.save(contactData);
            if (email.getEmail() != null && !"".equals(email.getEmail().trim())) {
                DataRecord emailData = new DataRecord();
                emailData.setName("contactEmailAddress");
                emailData.setAction("insert");
                emailData.addField("contactId", "$C{contact.id}");
                emailData.addField("type", email.getType());
                emailData.addField("email", email.getEmail());
                emailData.addField("enteredBy", email.getEnteredBy());
                emailData.addField("modifiedBy", email.getModifiedBy());
                this.crm.save(emailData);
            }
            if (phone.getNumber() != null && !"".equals(phone.getNumber().trim())) {
                DataRecord phoneData = new DataRecord();
                phoneData.setName("contactPhoneNumber");
                phoneData.setAction("insert");
                phoneData.addField("contactId", "$C{contact.id}");
                phoneData.addField("type", phone.getType());
                phoneData.addField("number", phone.getNumber());
                phoneData.addField("extension", phone.getExtension());
                phoneData.addField("enteredBy", phone.getEnteredBy());
                phoneData.addField("modifiedBy", phone.getModifiedBy());
                this.crm.save(phoneData);
            }
            DataRecord addressData = new DataRecord();
            addressData.setName("contactAddress");
            addressData.setAction("insert");
            addressData.addField("contactId", "$C{contact.id}");
            addressData.addField("type", address.getType());
            addressData.addField("streetAddressLine1", address.getStreetAddressLine1());
            addressData.addField("streetAddressLine2", address.getStreetAddressLine2());
            addressData.addField("city", address.getCity());
            addressData.addField("state", address.getState());
            addressData.addField("zip", address.getZip());
            addressData.addField("country", address.getCountry());
            addressData.addField("enteredBy", address.getEnteredBy());
            addressData.addField("modifiedBy", address.getModifiedBy());
            this.crm.save(addressData);
            this.crm.commit();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Response-> " + this.crm.getLastResponse());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return this.crm.getStatus() == 0;
    }
}

