/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.Timestamp;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.documents.actions.DocumentStoreManagementFileFolders;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreList;
import org.aspcfs.modules.documents.base.DocumentStorePermissionCategoryLookupList;
import org.aspcfs.modules.documents.base.DocumentStorePermissionList;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class DocumentManagement
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandEnterpriseView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnterpriseView(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "documents-view")) {
            return "PermissionError";
        }
        Connection db = null;
        DocumentStoreList documentStoreList = new DocumentStoreList();
        PagedListInfo documentStoreListInfo = this.getPagedListInfo(context, "documentStoreListInfo");
        documentStoreListInfo.setLink("DocumentManagement.do?command=EnterpriseView");
        if (documentStoreListInfo.getListView() == null) {
            documentStoreListInfo.setListView("Open");
        }
        if (documentStoreListInfo.getListView().equals("Open")) {
            documentStoreList.setOpenDocumentStoresOnly(true);
        } else if (documentStoreListInfo.getListView().equals("Archived")) {
            documentStoreList.setClosedDocumentStoresOnly(true);
        } else if (documentStoreListInfo.getListView().equals("Trashed")) {
            documentStoreList.setIncludeOnlyTrashed(true);
        }
        try {
            db = this.getConnection(context);
            int tmpUserId = this.getUserId(context);
            User tmpUser = this.getUser(context, tmpUserId);
            int tmpUserRoleId = tmpUser.getRoleId();
            Contact tmpContact = new Contact(db, tmpUser.getContactId());
            int tmpDepartmentId = tmpContact.getDepartment();
            documentStoreList.setDocumentStoresForUser(this.getUserId(context));
            documentStoreList.setUserRole(tmpUserRoleId);
            documentStoreList.setDepartmentId(tmpDepartmentId);
            documentStoreList.setSiteId(tmpUser.getSiteId());
            documentStoreList.setPagedListInfo(documentStoreListInfo);
            documentStoreList.buildList(db);
            context.getRequest().setAttribute("documentStoreList", (Object)documentStoreList);
            this.getDocumentStoreUserLevel(context, db, 5);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "EnterpriseViewOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddDocumentStore(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "documents_documentstore-add")) {
            return "PermissionError";
        }
        try {
            DocumentStore thisDocumentStore = (DocumentStore)((Object)context.getFormBean());
            if (thisDocumentStore.getRequestDate() == null) {
                thisDocumentStore.setRequestDate(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        return "AddDocumentStoreOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertDocumentStore(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "documents_documentstore-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        User user = this.getUser(context, this.getUserId(context));
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = (DocumentStore)((Object)context.getFormBean());
            thisDocumentStore.setEnteredBy(this.getUserId(context));
            thisDocumentStore.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisDocumentStore);
            if (isValid) {
                thisDocumentStore.insert(db);
                this.updateDocumentStoreCache(context, thisDocumentStore.getId(), thisDocumentStore.getTitle());
                this.indexAddItem(context, (Object)thisDocumentStore);
                DocumentStoreTeamMember thisMember = new DocumentStoreTeamMember();
                thisMember.setDocumentStoreId(thisDocumentStore.getId());
                thisMember.setStatus(-1);
                thisMember.setItemId(this.getUserId(context));
                thisMember.setUserLevel(this.getDocumentStoreUserLevel(context, db, 1));
                thisMember.setSiteId(user.getSiteId());
                thisMember.setEnteredBy(this.getUserId(context));
                thisMember.setModifiedBy(this.getUserId(context));
                thisMember.insert(db, "user");
                context.getRequest().setAttribute("documentStoreId", (Object)String.valueOf(thisDocumentStore.getId()));
                String string = this.executeCommandDefault(context);
                return string;
            }
            String string = this.executeCommandAddDocumentStore(context);
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyDocumentStore(ActionContext context) {
        if (!this.hasPermission(context, "documents_documentstore-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-edit")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"modify_document_store".toLowerCase());
            String string = "DocumentStoreCenterOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfigurePermissions(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-setup-permissions")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"setup_permissions".toLowerCase());
            DocumentStorePermissionCategoryLookupList categories = new DocumentStorePermissionCategoryLookupList();
            categories.setIncludeEnabled(1);
            categories.buildList(db);
            categories.buildResources(db);
            context.getRequest().setAttribute("categories", (Object)categories);
            String string = "DocumentStoreCenterOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdatePermissions(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-setup-permissions")) {
                String string = "PermissionError";
                return string;
            }
            DocumentStorePermissionList.updateDocumentStorePermissions(db, context.getRequest(), Integer.parseInt(documentStoreId));
            String string = "UpdatePermissionsOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateDocumentStore(ActionContext context) {
        if (!this.hasPermission(context, "documents_documentstore-edit")) {
            return "PermissionError";
        }
        boolean isValid = false;
        DocumentStore thisDocumentStore = (DocumentStore)((Object)context.getFormBean());
        Connection db = null;
        int resultCount = 0;
        try {
            db = this.getConnection(context);
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-edit")) {
                String string = "PermissionError";
                return string;
            }
            thisDocumentStore.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisDocumentStore);
            if (isValid) {
                resultCount = thisDocumentStore.update(db);
            }
            if (resultCount == 1) {
                this.updateDocumentStoreCache(context, thisDocumentStore.getId(), thisDocumentStore.getTitle());
                this.indexAddItem(context, (Object)thisDocumentStore);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1 || !isValid) {
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"modify_document_store".toLowerCase());
            return "DocumentStoreCenterOK";
        }
        if (resultCount == 1) {
            context.getRequest().setAttribute("documentStoreId", (Object)("" + thisDocumentStore.getId()));
            return "UpdateDocumentStoreOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDocumentStoreCenter(ActionContext context) {
        if (!this.hasPermission(context, "documents_documentstore-view")) {
            return "PermissionError";
        }
        Connection db = null;
        DocumentStore thisDocumentStore = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        if (documentStoreId == null) {
            documentStoreId = (String)context.getRequest().getAttribute("documentStoreId");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        String section = context.getRequest().getParameter("section");
        try {
            db = this.getConnection(context);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (section == null || "".equals(section) || "File_Library".equals(section)) {
                section = "File_Library";
                if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-view")) {
                    String string = "PermissionError";
                    return string;
                }
                String folderId = context.getRequest().getParameter("folderId");
                if (folderId == null) {
                    folderId = (String)context.getRequest().getAttribute("folderId");
                }
                FileFolderList folders = new FileFolderList();
                if (folderId == null || "-1".equals(folderId) || "0".equals(folderId)) {
                    folders.setTopLevelOnly(true);
                } else {
                    folders.setParentId(Integer.parseInt(folderId));
                    DocumentStoreManagementFileFolders.buildHierarchy(db, context);
                }
                folders.setLinkModuleId(20041083);
                folders.setLinkItemId(thisDocumentStore.getId());
                folders.setBuildItemCount(true);
                folders.buildList(db);
                context.getRequest().setAttribute("fileFolderList", (Object)folders);
                FileItemList files = new FileItemList();
                if (folderId == null || "-1".equals(folderId) || "0".equals(folderId)) {
                    files.setTopLevelOnly(true);
                    this.deletePagedListInfo(context, "documentStoreDocumentsGalleryInfo");
                } else {
                    files.setFolderId(Integer.parseInt(folderId));
                }
                files.setLinkModuleId(20041083);
                files.setLinkItemId(thisDocumentStore.getId());
                files.buildList(db);
                thisDocumentStore.setFiles(files);
            } else if ("Team".equals(section)) {
                User thisUser;
                if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-team-view")) {
                    String folderId = "PermissionError";
                    return folderId;
                }
                PagedListInfo documentStoreUserTeamInfo = this.getPagedListInfo(context, "documentStoreUserTeamInfo");
                documentStoreUserTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStoreUserTeamInfo.setItemsPerPage(0);
                PagedListInfo documentStoreEmployeeTeamInfo = this.getPagedListInfo(context, "documentStoreEmployeeTeamInfo");
                documentStoreEmployeeTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStoreEmployeeTeamInfo.setItemsPerPage(0);
                PagedListInfo documentStoreAccountContactTeamInfo = this.getPagedListInfo(context, "documentStoreAccountContactTeamInfo");
                documentStoreAccountContactTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStoreAccountContactTeamInfo.setItemsPerPage(0);
                PagedListInfo documentStoreRoleTeamInfo = this.getPagedListInfo(context, "documentStoreRoleTeamInfo");
                documentStoreRoleTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStoreRoleTeamInfo.setItemsPerPage(0);
                PagedListInfo documentStoreDepartmentTeamInfo = this.getPagedListInfo(context, "documentStoreDepartmentTeamInfo");
                documentStoreDepartmentTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStoreDepartmentTeamInfo.setItemsPerPage(0);
                PagedListInfo documentStorePortalUserTeamInfo = this.getPagedListInfo(context, "documentStorePortalUserTeamInfo");
                documentStorePortalUserTeamInfo.setLink("DocumentManagement.do?command=DocumentStoreCenter&section=Team&documentStoreId=" + thisDocumentStore.getId());
                documentStorePortalUserTeamInfo.setItemsPerPage(0);
                thisDocumentStore.getUserTeam().setPagedListInfo(documentStoreUserTeamInfo);
                thisDocumentStore.getEmployeeTeam().setPagedListInfo(documentStoreEmployeeTeamInfo);
                thisDocumentStore.getAccountContactTeam().setPagedListInfo(documentStoreAccountContactTeamInfo);
                thisDocumentStore.getRoleTeam().setPagedListInfo(documentStoreRoleTeamInfo);
                thisDocumentStore.getDepartmentTeam().setPagedListInfo(documentStoreDepartmentTeamInfo);
                thisDocumentStore.getPortalUserTeam().setPagedListInfo(documentStorePortalUserTeamInfo);
                thisDocumentStore.buildTeamMemberList(db);
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getUserTeam()) {
                    thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, thisMember.getItemId());
                    thisMember.setUser((Object)thisUser);
                }
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getEmployeeTeam()) {
                    thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, thisMember.getItemId());
                    thisMember.setUser((Object)thisUser);
                }
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getAccountContactTeam()) {
                    thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, thisMember.getItemId());
                    thisMember.setUser((Object)thisUser);
                }
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getRoleTeam()) {
                    Role thisRole = new Role(db, thisMember.getItemId());
                    thisMember.setUser(thisRole.getRole());
                }
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getDepartmentTeam()) {
                    LookupList departmentList = new LookupList(db, "lookup_department");
                    thisMember.setUser(departmentList.getValueFromId(thisMember.getItemId()));
                }
                for (DocumentStoreTeamMember thisMember : thisDocumentStore.getPortalUserTeam()) {
                    thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, thisMember.getItemId());
                    thisMember.setUser((Object)thisUser);
                }
            } else if ("Details".equals(section)) {
                if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-view")) {
                    String documentStoreUserTeamInfo = "PermissionError";
                    return documentStoreUserTeamInfo;
                }
            } else if ("Setup".equals(section) && !this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-setup-permissions")) {
                String documentStoreUserTeamInfo = "PermissionError";
                return documentStoreUserTeamInfo;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)section.toLowerCase());
            User user = this.getUser(context, this.getUserId(context));
            DocumentStoreTeamMember.updateLastAccessed(db, thisDocumentStore.getId(), user.getId(), user.getSiteId());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreCenterOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteDocumentStore(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-delete")) {
                String string = "PermissionError";
                return string;
            }
            thisDocumentStore.delete(db, DocumentManagement.getDbNamePath(context));
            this.updateDocumentStoreCache(context, thisDocumentStore.getId(), null);
            this.indexDeleteItem(context, (Object)thisDocumentStore);
            String string = "DeleteDocumentStoreOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrashDocumentStore(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-delete")) {
                String string = "PermissionError";
                return string;
            }
            thisDocumentStore.updateStatus(db, true, this.getUserId(context));
            this.updateDocumentStoreCache(context, thisDocumentStore.getId(), null);
            this.indexDeleteItem(context, (Object)thisDocumentStore);
            String string = "DeleteDocumentStoreOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestoreDocumentStore(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-details-delete")) {
                String string = "PermissionError";
                return string;
            }
            thisDocumentStore.updateStatus(db, false, this.getUserId(context));
            thisDocumentStore.setTrashedDate((Timestamp)null);
            this.updateDocumentStoreCache(context, thisDocumentStore.getId(), null);
            this.indexAddItem(context, (Object)thisDocumentStore);
            String string = "DeleteDocumentStoreOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

