/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItemIndexer;
import com.zeroio.utils.SearchUtils;
import java.sql.Connection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreIndexer;
import org.aspcfs.modules.documents.beans.DocumentsSearchBean;
import org.aspcfs.modules.documents.search.DocumentsSearchQuery;
import org.aspcfs.utils.web.PagedListInfo;

public final class DocumentManagementSearch
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String executeCommandIndex(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Directory index = null;
        IndexWriter writer = null;
        try {
            index = this.getDirectory(context, true);
            writer = new IndexWriter(index, (Analyzer)new StandardAnalyzer(), true);
            db = this.getConnection(context);
            DocumentStoreIndexer.add(writer, db, context);
            FileItemIndexer.add((IndexWriter)writer, (Connection)db, (String)this.getPath(context, "documents"), (ActionContext)context);
            writer.optimize();
            IndexSearcher searcher = new IndexSearcher(index);
            context.getServletContext().setAttribute("indexSearcher", (Object)searcher);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        try {
            if (writer != null) {
                writer.close();
            }
            writer = null;
        }
        catch (Exception ie) {
            // empty catch block
        }
        try {
            if (index == null) return "IndexOK";
            index.close();
            return "IndexOK";
        }
        catch (Exception ie) {
            return "IndexOK";
        }
        finally {
            this.freeConnection(context, db);
            try {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
            catch (Exception ie) {}
            try {
                if (index != null) {
                    index.close();
                }
                index = null;
            }
            catch (Exception ie) {}
        }
    }

    public String executeCommandShowForm(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        return "SearchFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        DocumentsSearchBean search = (DocumentsSearchBean)((Object)context.getFormBean());
        PagedListInfo searchBeanInfo = this.getPagedListInfo(context, "searchBeanInfo");
        searchBeanInfo.setLink("DocumentManagementSearch.do?command=Default");
        Connection db = null;
        try {
            search.parseQuery();
            if (!search.isValid()) {
                String string = "SearchResultsERROR";
                return string;
            }
            IndexSearcher searcher = SearchUtils.getSharedSearcher((ActionContext)context, (Directory)this.getDirectory(context));
            db = this.getConnection(context);
            if (System.getProperty("DEBUG") != null) {
                FilterIndexReader fir = new FilterIndexReader(IndexReader.open((Directory)this.getDirectory(context)));
                int nd = fir.numDocs();
                int i = 0;
                while (i < nd) {
                    Document d = fir.document(i++);
                }
            }
            String queryString = null;
            if (search.getScope() != 2) {
                search.setDocumentStoreId(-1);
            }
            if (search.getDocumentStoreId() > -1) {
                DocumentStore thisDocumentStore = new DocumentStore(db, search.getDocumentStoreId());
                context.getRequest().setAttribute("DocumentStore", (Object)thisDocumentStore);
                queryString = "(" + DocumentsSearchQuery.buildDocumentStoreSearchQuery(context, search, db, this.getUserId(context), search.getDocumentStoreId()) + ") AND (" + search.getParsedQuery() + ")";
            } else {
                queryString = "(" + DocumentsSearchQuery.buildDocumentStoreSearchQuery(context, search, db, this.getUserId(context), -1) + ") AND (" + search.getParsedQuery() + ")";
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Query String --> " + queryString);
            }
            SearchUtils.buildSearchResults((ActionContext)context, (String)queryString, (IndexSearcher)searcher, (PagedListInfo)searchBeanInfo);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SearchResultsERROR";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SearchResultsOK";
    }

    public String executeCommandTips(ActionContext context) {
        return "TipsOK";
    }
}

