/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.documents.base.AccountDocument;
import org.aspcfs.modules.documents.base.AccountDocumentList;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.utils.web.PagedListInfo;

public class DocumentStoreManagementAccounts
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "documents-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "accounts-accounts-documentstore-view")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"accounts".toLowerCase());
            PagedListInfo accountDocumentInfo = this.getPagedListInfo(context, "documentStoreAccountInfo");
            accountDocumentInfo.setLink("DocumentStoreManagementAccounts.do?command=View&section=Accounts&documentStoreId=" + thisDocumentStore.getId());
            accountDocumentInfo.setItemsPerPage(0);
            AccountDocumentList accountDocumentList = new AccountDocumentList();
            accountDocumentList.setPagedListInfo(accountDocumentInfo);
            accountDocumentList.setDocumentStoreId(thisDocumentStore.getId());
            accountDocumentList.buildList(db);
            context.getRequest().setAttribute("accountDocumentList", (Object)accountDocumentList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String popUp = context.getRequest().getParameter("popup");
        if (popUp != null && !"null".equals(popUp)) {
            return "DocumentStorePopupOK";
        }
        return "DocumentStoreOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLinkAccount(ActionContext context) {
        if (!this.hasPermission(context, "documents-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String orgId = context.getRequest().getParameter("orgId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "accounts-accounts-documentstore-add")) {
                String string = "PermissionError";
                return string;
            }
            AccountDocumentList accountDocumentList = new AccountDocumentList();
            accountDocumentList.setDocumentStoreId(Integer.parseInt(documentStoreId));
            accountDocumentList.setOrgId(Integer.parseInt(orgId));
            accountDocumentList.buildList(db);
            if (accountDocumentList.size() == 0) {
                AccountDocument thisAccountDocument = new AccountDocument();
                thisAccountDocument.setDocumentStoreId(Integer.parseInt(documentStoreId));
                thisAccountDocument.setOrgId(Integer.parseInt(orgId));
                thisAccountDocument.insert(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreAddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveAccount(ActionContext context) {
        if (!this.hasPermission(context, "documents-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String orgId = context.getRequest().getParameter("orgId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "accounts-accounts-documentstore-delete")) {
                String string = "PermissionError";
                return string;
            }
            AccountDocumentList accountDocumentList = new AccountDocumentList();
            accountDocumentList.setDocumentStoreId(Integer.parseInt(documentStoreId));
            accountDocumentList.setOrgId(Integer.parseInt(orgId));
            accountDocumentList.buildList(db);
            System.out.println("account document list size " + accountDocumentList.size());
            for (AccountDocument thisAccountDocument : accountDocumentList) {
                thisAccountDocument.delete(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreRemoveOK";
    }
}

