/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileFolder;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.documents.base.DocumentStore;

public final class DocumentStoreManagementFileFolders
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Exception errorMessage = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        Connection db = null;
        try {
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setParentId(context.getRequest().getParameter("parentId"));
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-add")) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_folder".toLowerCase());
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DocumentStoreCenterOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        Connection db = null;
        int resultCount = 0;
        boolean recordInserted = false;
        boolean isValid = false;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        try {
            boolean newFolder;
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            boolean bl = newFolder = thisFolder.getId() == -1;
            if (newFolder) {
                thisFolder.setEnteredBy(this.getUserId(context));
            }
            thisFolder.setModifiedBy(this.getUserId(context));
            thisFolder.setLinkModuleId(20041083);
            thisFolder.setLinkItemId(thisDocumentStore.getId());
            if (newFolder) {
                if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-add")) {
                    String string = "PermissionError";
                    return string;
                }
                isValid = this.validateObject(context, db, thisFolder);
                if (isValid) {
                    recordInserted = thisFolder.insert(db);
                }
            } else {
                if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-edit")) {
                    String string = "PermissionError";
                    return string;
                }
                isValid = this.validateObject(context, db, thisFolder);
                if (isValid) {
                    resultCount = thisFolder.update(db);
                }
            }
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        if (resultCount == 1) {
            return "UpdateOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-delete")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            thisFolder.setParentId(Integer.parseInt(folderId));
            recordDeleted = thisFolder.delete(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteRecursive(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-delete")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            this.indexDeleteItem(context, thisFolder);
            FileFolderHierarchy thisFolderHierarchy = new FileFolderHierarchy();
            thisFolderHierarchy.setLinkModuleId(20041083);
            thisFolderHierarchy.setLinkItemId(Integer.parseInt(documentStoreId));
            thisFolderHierarchy.build(db, Integer.parseInt(itemId));
            FileFolderList hierarchy = thisFolderHierarchy.getHierarchy();
            for (FileFolder tmpFolder : hierarchy) {
                this.indexDeleteItem(context, tmpFolder);
            }
            recordDeleted = thisFolderHierarchy.deleteFolderHierarchy(db, "documents", Integer.parseInt(itemId));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setId(Integer.parseInt(itemId));
            thisFolder.queryRecord(db, Integer.parseInt(itemId));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandAdd(context);
    }

    public static final void buildHierarchy(Connection db, ActionContext context) throws SQLException {
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null && !"-1".equals(folderId) && !"0".equals(folderId)) {
            LinkedHashMap folderLevels = new LinkedHashMap();
            FileFolder.buildHierarchy((Connection)db, folderLevels, (int)Integer.parseInt(folderId));
            context.getRequest().setAttribute("folderLevels", folderLevels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-edit")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("FileFolder", (Object)thisFolder);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(20041083);
            hierarchy.setLinkItemId(thisDocumentStore.getId());
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-folders-edit")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("return", (Object)"DocumentsFiles");
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            int folderId = Integer.parseInt(newFolderId);
            if (folderId != 0 && folderId != -1) {
                FileFolder newParent = new FileFolder(db, folderId);
                FileFolderHierarchy thisHierarchy = new FileFolderHierarchy();
                thisHierarchy.setLinkModuleId(20041083);
                thisHierarchy.setLinkItemId(thisDocumentStore.getId());
                thisHierarchy.build(db, thisFolder.getId());
                if (thisHierarchy.getHierarchy().hasFolder(Integer.parseInt(newFolderId))) {
                    thisFolder.buildSubFolders(db);
                    for (FileFolder childFolder : thisFolder.getSubFolders()) {
                        childFolder.updateParentId(db, thisFolder.getParentId());
                    }
                }
            }
            thisFolder.updateParentId(db, folderId);
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

