/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.iteam.base.Thumbnail;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.documents.actions.DocumentStoreManagementFileFolders;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.utils.ImageUtils;

public final class DocumentStoreManagementFiles
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        String folderId;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        if (documentStoreId == null) {
            documentStoreId = (String)context.getRequest().getAttribute("documentStoreId");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null || "".equals(folderId)) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        context.getRequest().setAttribute("folderId", (Object)folderId);
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-upload")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_upload".toLowerCase());
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreCenterOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        String documentStoreId = "";
        String subject = "";
        String folderId = "";
        String itemId = "";
        String versionId = "";
        try {
            String filePath = this.getPath(context, "documents");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            documentStoreId = (String)parts.get("documentStoreId");
            subject = (String)parts.get("subject");
            folderId = (String)parts.get("folderId");
            itemId = (String)parts.get("fid");
            versionId = (String)parts.get("versionId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-upload")) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("DocumentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_library".toLowerCase());
            if (parts.get("id" + documentStoreId) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + documentStoreId);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(20041083);
                thisItem.setLinkItemId(thisDocumentStore.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setSize(newFileInfo.getSize());
                if (itemId == null || "-1".equals(itemId)) {
                    thisItem.setVersion(1.0);
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid) {
                        recordInserted = thisItem.insert(db);
                        thisItem.setDirectory(filePath);
                        this.indexAddItem(context, thisItem);
                    }
                } else {
                    thisItem.setId(Integer.parseInt(itemId));
                    thisItem.setVersion(Double.parseDouble(versionId));
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid) {
                        recordInserted = thisItem.insertVersion(db);
                        thisItem.setDirectory(filePath);
                        this.indexAddItem(context, thisItem);
                    }
                }
                if (recordInserted && isValid && thisItem.isImageFormat()) {
                    File thumbnailFile = new File(newFileInfo.getLocalFile().getPath() + "TH");
                    ImageUtils.saveThumbnail(newFileInfo.getLocalFile(), thumbnailFile, 133.0, 133.0);
                    Thumbnail thumbnail = new Thumbnail();
                    thumbnail.setId(thisItem.getId());
                    thumbnail.setFilename(newFileInfo.getRealFilename() + "TH");
                    thumbnail.setVersion(thisItem.getVersion());
                    thumbnail.setSize((int)thumbnailFile.length());
                    thumbnail.setEnteredBy(thisItem.getEnteredBy());
                    thumbnail.setModifiedBy(thisItem.getModifiedBy());
                    boolean bl = isValid = this.validateObject(context, db, thumbnail) && isValid;
                    if (isValid) {
                        recordInserted = thumbnail.insert(db);
                    }
                }
            } else {
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            context.getRequest().setAttribute("folderId", (Object)folderId);
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return "AddOK";
        }
        if (itemId == null || "-1".equals(itemId)) {
            return this.executeCommandAdd(context);
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String itemId;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        if (documentStoreId == null) {
            documentStoreId = (String)context.getRequest().getAttribute("documentStoreId");
        }
        if ((itemId = context.getRequest().getParameter("fid")) == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-upload")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_upload".toLowerCase());
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(documentStoreId), 20041083);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreCenterOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "documents");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String documentStoreId = (String)parts.get("documentStoreId");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            FileInfo newFileInfo = (FileInfo)parts.get("id" + documentStoreId);
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-upload")) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_library".toLowerCase());
            FileItem thisItem = new FileItem();
            thisItem.setLinkModuleId(20041083);
            thisItem.setLinkItemId(thisDocumentStore.getId());
            thisItem.setId(Integer.parseInt(itemId));
            thisItem.setEnteredBy(this.getUserId(context));
            thisItem.setModifiedBy(this.getUserId(context));
            thisItem.setSubject(subject);
            thisItem.setClientFilename(newFileInfo.getClientFileName());
            thisItem.setFilename(newFileInfo.getRealFilename());
            thisItem.setVersion(Double.parseDouble(versionId));
            thisItem.setSize(newFileInfo.getSize());
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.insertVersion(db);
            }
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            context.getRequest().setAttribute("fid", (Object)itemId);
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return "AddOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        Exception errorMessage = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        if (documentStoreId == null) {
            documentStoreId = (String)context.getRequest().getAttribute("documentStoreId");
        }
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-view")) {
                String string = "PermissionError";
                return string;
            }
            thisDocumentStore.buildFileItemList(db);
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_details".toLowerCase());
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DocumentStoreCenterOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("fid");
        String version = context.getRequest().getParameter("ver");
        String view = context.getRequest().getParameter("view");
        FileItemVersion thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-download")) {
                String string = "PermissionError";
                return string;
            }
            thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            if (version != null) {
                thisItem.buildVersionList(db);
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_library".toLowerCase());
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItemVersion itemToDownload;
            if (version == null) {
                itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "documents") + DocumentStoreManagementFiles.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                } else {
                    System.err.println("PMF-> Trying to send a file that does not exist");
                }
            } else {
                itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "documents") + DocumentStoreManagementFiles.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                } else {
                    System.err.println("PMF-> Trying to send a file that does not exist");
                }
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Exception errorMessage = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-rename")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"file_modify".toLowerCase());
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            DocumentStoreManagementFileFolders.buildHierarchy(db, context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DocumentStoreCenterOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Exception errorMessage = null;
        boolean recordInserted = false;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-rename")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            String filePath = this.getPath(context, "documents");
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            recordInserted = thisItem.update(db);
            thisItem.setDirectory(filePath);
            this.indexAddItem(context, thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordInserted) {
                return "UpdateOK";
            }
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            context.getRequest().setAttribute("fid", (Object)itemId);
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        boolean recordDeleted = false;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("fid");
        String version = context.getRequest().getParameter("ver");
        Connection db = null;
        boolean isVersion = false;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-deletee")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            if (version != null) {
                thisItem.buildVersionList(db);
                if (thisItem.getVersionList().size() > 1) {
                    isVersion = true;
                    if (Double.parseDouble(version) == ((FileItemVersion)thisItem.getVersionList().get(0)).getVersion()) {
                        recordDeleted = ((FileItemVersion)thisItem.getVersionList().get(0)).delete(db, this.getPath(context, "documents"));
                        thisItem.updateVersion(db, (FileItemVersion)thisItem.getVersionList().get(1));
                    } else {
                        recordDeleted = thisItem.getVersion(Double.parseDouble(version)).delete(db, this.getPath(context, "documents"));
                    }
                } else {
                    recordDeleted = thisItem.delete(db, this.getPath(context, "documents"));
                    this.indexDeleteItem(context, thisItem);
                }
            } else {
                recordDeleted = thisItem.delete(db, this.getPath(context, "documents"));
                this.indexDeleteItem(context, thisItem);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            if (isVersion) {
                return "DeleteVersionOK";
            }
            return "DeleteOK";
        }
        return "DeleteERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-rename")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(20041083);
            hierarchy.setLinkItemId(thisDocumentStore.getId());
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-rename")) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("return", (Object)"DocumentsFiles");
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowThumbnail(ActionContext context) {
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("i");
        String version = context.getRequest().getParameter("v");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-download")) {
                String string = "PermissionError";
                return string;
            }
            thisItem = new FileItem(db, Integer.parseInt(itemId), thisDocumentStore.getId(), 20041083);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            String filePath = null;
            filePath = context.getRequest().getParameter("s") != null ? this.getPath(context, "documents") + DocumentStoreManagementFiles.getDatePath(thisItem.getModified()) + thisItem.getFilename() : this.getPath(context, "documents") + DocumentStoreManagementFiles.getDatePath(thisItem.getModified()) + thisItem.getThumbnailFilename();
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(thisItem.getThumbnailFilename());
            if (fileDownload.fileExists()) {
                fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                fileDownload.streamContent(context);
                return "-none-";
            }
            return "SystemError";
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return "-none-";
    }
}

