/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMemberList;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;

public final class DocumentStoreManagementTeam
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String type = context.getRequest().getParameter("modifyTeam");
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-team-edit")) {
                String string = "PermissionError";
                return string;
            }
            DocumentStoreTeamMemberList userTeam = new DocumentStoreTeamMemberList();
            DocumentStoreTeamMemberList roleTeam = new DocumentStoreTeamMemberList();
            DocumentStoreTeamMemberList departmentTeam = new DocumentStoreTeamMemberList();
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            if (type.equals("user")) {
                context.getRequest().setAttribute("IncludeSection", (Object)"user_membership_modify".toLowerCase());
                userTeam.setDocumentStoreId(thisDocumentStore.getId());
                userTeam.setMemberType("user");
                userTeam.buildList(db);
            } else if (type.equals("group")) {
                context.getRequest().setAttribute("IncludeSection", (Object)"group_membership_modify".toLowerCase());
                roleTeam.setDocumentStoreId(thisDocumentStore.getId());
                roleTeam.setMemberType("role");
                roleTeam.buildList(db);
                departmentTeam.setDocumentStoreId(thisDocumentStore.getId());
                departmentTeam.setMemberType("department");
                departmentTeam.buildList(db);
            }
            StringBuffer vectorUserId = new StringBuffer();
            StringBuffer vectorState = new StringBuffer();
            HtmlSelect selCurrentTeam = new HtmlSelect();
            Iterator iTeam = userTeam.iterator();
            if (type.equals("user")) {
                while (iTeam.hasNext()) {
                    DocumentStoreTeamMember thisMember = (DocumentStoreTeamMember)iTeam.next();
                    User tmpUser = this.getUser(context, thisMember.getItemId());
                    if (tmpUser.getContact().getOrgId() == 0) {
                        selCurrentTeam.addItem(thisMember.getItemId(), tmpUser.getContact().getNameFirstLast() + (!tmpUser.getEnabled() ? " (X)" : ""));
                    } else {
                        Organization organization = new Organization(db, tmpUser.getContact().getOrgId());
                        String userNameForDisplay = tmpUser.getContact().getNameFirstLast() + " (" + organization.getName() + ")" + (!tmpUser.getEnabled() || !tmpUser.getContact().getEnabled() || tmpUser.getContact().isTrashed() ? " (X)" : "");
                        if (organization.getPrimaryContact() != null && organization.getPrimaryContact().getId() == tmpUser.getContact().getId()) {
                            userNameForDisplay = tmpUser.getContact().getNameFirstLast() + (!tmpUser.getEnabled() || !tmpUser.getContact().getEnabled() || tmpUser.getContact().isTrashed() ? " (X)" : "");
                        }
                        selCurrentTeam.addItem(thisMember.getItemId(), userNameForDisplay);
                    }
                    vectorUserId.append(thisMember.getItemId());
                    vectorState.append("user");
                    if (!iTeam.hasNext()) continue;
                    vectorUserId.append("|");
                    vectorState.append("|");
                }
            } else if (type.equals("group")) {
                DocumentStoreTeamMember thisMember;
                iTeam = roleTeam.iterator();
                if (iTeam.hasNext()) {
                    while (iTeam.hasNext()) {
                        thisMember = (DocumentStoreTeamMember)iTeam.next();
                        Role role = new Role(db, thisMember.getItemId());
                        selCurrentTeam.addItem(thisMember.getItemId() + "-R" + thisMember.getSiteId(), role.getRole() + " " + "(Role)" + (thisMember.getSiteId() != -1 ? " (" + siteList.getSelectedValue(thisMember.getSiteId()) + ")" : ""));
                        vectorUserId.append(thisMember.getItemId() + "-R" + thisMember.getSiteId());
                        vectorState.append("role");
                        if (!iTeam.hasNext()) continue;
                        vectorUserId.append("|");
                        vectorState.append("|");
                    }
                }
                if ((iTeam = departmentTeam.iterator()).hasNext()) {
                    vectorUserId.append("|");
                    vectorState.append("|");
                    while (iTeam.hasNext()) {
                        thisMember = (DocumentStoreTeamMember)iTeam.next();
                        LookupList departmentList = new LookupList(db, "lookup_department");
                        selCurrentTeam.addItem(thisMember.getItemId() + "-D" + thisMember.getSiteId(), departmentList.getValueFromId(thisMember.getItemId()) + " " + "(Dept)" + (thisMember.getSiteId() != -1 ? " (" + siteList.getSelectedValue(thisMember.getSiteId()) + ")" : ""));
                        vectorUserId.append(thisMember.getItemId() + "-D" + thisMember.getSiteId());
                        vectorState.append("department");
                        if (!iTeam.hasNext()) continue;
                        vectorUserId.append("|");
                        vectorState.append("|");
                    }
                }
            }
            context.getRequest().setAttribute("currentTeam", (Object)selCurrentTeam);
            context.getRequest().setAttribute("vectorUserId", (Object)vectorUserId.toString());
            context.getRequest().setAttribute("vectorState", (Object)vectorState.toString());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DocumentStoreCenterOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandUpdateUserList(ActionContext context) {
        if (!"true".equals((String)context.getServletContext().getAttribute("DEPARTMENT"))) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            String deptId = context.getRequest().getParameter("deptId");
            db = this.getConnection(context);
            UserList userList = new UserList();
            if (deptId != null) {
                userList.setDepartment(Integer.parseInt(deptId));
            }
            userList.buildList(db);
            context.getRequest().setAttribute("UserList", (Object)userList);
        }
        catch (SQLException sQLException) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "MakeUserListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String memberType = context.getRequest().getParameter("memberType");
        boolean recordInserted = false;
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            thisDocumentStore.buildPermissionList(db);
            context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
            context.getRequest().setAttribute("IncludeSection", (Object)"team_modify".toLowerCase());
            context.getRequest().setAttribute("documentStoreId", (Object)documentStoreId);
            DocumentStoreTeamMemberList thisTeam = (DocumentStoreTeamMemberList)context.getFormBean();
            thisTeam.setDocumentStoreId(thisDocumentStore.getId());
            thisTeam.setUserLevel(this.getDocumentStoreUserLevel(context, db, 5));
            thisTeam.setEnteredBy(this.getUserId(context));
            thisTeam.setModifiedBy(this.getUserId(context));
            if ("user".equals(memberType)) {
                thisTeam.setSiteIdForMembers(this.getSystemStatus(context));
                recordInserted = thisTeam.updateUserMembership(db);
            } else {
                recordInserted = thisTeam.updateGroupMembership(db);
            }
            if (recordInserted) {
                String string = "ModifyOK";
                return string;
            }
            String string = "ModifyERROR";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandChangeRole(ActionContext context) {
        Connection db = null;
        String documentStoreId = context.getRequest().getParameter("documentStoreId");
        String itemId = context.getRequest().getParameter("id");
        String newRole = context.getRequest().getParameter("role");
        String memberType = context.getRequest().getParameter("memberType");
        String siteId = context.getRequest().getParameter("siteId");
        try {
            db = this.getConnection(context);
            DocumentStore thisDocumentStore = new DocumentStore(db, Integer.parseInt(documentStoreId));
            if (thisDocumentStore.getId() == -1) {
                throw new Exception("Invalid access to document store");
            }
            thisDocumentStore.buildPermissionList(db);
            if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-team-edit-role")) {
                String string = "PermissionError";
                return string;
            }
            int tmpUserId = this.getUserId(context);
            User tmpUser = this.getUser(context, tmpUserId);
            int tmpUserRoleId = tmpUser.getRoleId();
            Contact tmpContact = new Contact(db, tmpUser.getContactId());
            int tmpDepartmentId = tmpContact.getDepartment();
            DocumentStoreTeamMember currentMember = new DocumentStoreTeamMember(db, thisDocumentStore.getId(), tmpUserId, tmpUserRoleId, tmpDepartmentId, tmpUser.getSiteId());
            if (currentMember.getRoleId() <= Integer.parseInt(newRole)) {
                boolean changed = DocumentStoreTeamMember.changeRole(db, thisDocumentStore.getId(), Integer.parseInt(itemId), Integer.parseInt(newRole), memberType, Integer.parseInt(siteId));
                if (!changed) {
                    String string = "ChangeRoleERROR";
                    return string;
                }
                String string = "ChangeRoleOK";
                return string;
            }
            String string = "ChangeRoleERROR";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            errorMessage.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

