/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class AccountDocument
extends GenericBean {
    private int id = -1;
    private int documentStoreId = -1;
    private int orgId = -1;
    private String documentStoreName = null;
    private Timestamp entered = null;
    private String accountName = null;

    public AccountDocument() {
    }

    public AccountDocument(Connection db, int tmpId) throws SQLException {
        this.queryRecord(db, tmpId);
    }

    public AccountDocument(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getDocumentStoreName() {
        return this.documentStoreName;
    }

    public void setDocumentStoreName(String documentStoreName) {
        this.documentStoreName = documentStoreName;
    }

    public void setDocumentStoreId(int documentStoreId) {
        this.documentStoreId = documentStoreId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    private void queryRecord(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Invalid Document Store");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT da.*, ds.title AS store_name, org.name AS org_name FROM document_accounts da LEFT JOIN document_store ds ON (da.document_store_id = ds.document_store_id) LEFT JOIN organization org ON (da.org_id = org.org_id) WHERE da.id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(Connection db) throws SQLException {
        Exception errorMessage = null;
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            this.id = DatabaseUtils.getNextSeq(db, "document_accounts_id_seq");
            int i = 0;
            pst = db.prepareStatement("INSERT INTO document_accounts (" + (this.id > -1 ? "id, " : "") + "document_store_id , " + " org_id , " + " entered )" + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?," + DatabaseUtils.getCurrentTimestamp(db) + ")");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.documentStoreId);
            pst.setInt(++i, this.orgId);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "document_accounts_id_seq", this.id);
            if (autoCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            errorMessage = e;
            if (autoCommit) {
                db.rollback();
            }
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
        if (errorMessage != null) {
            throw new SQLException(errorMessage.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int recordCount = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement(" DELETE FROM document_accounts  WHERE id = ? ");
            pst.setInt(1, this.id);
            recordCount = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            e.printStackTrace(System.out);
        }
        finally {
            db.setAutoCommit(true);
        }
        if (recordCount == 0) {
            this.errors.put("actionError", "Document Store Account could not be deleted because it no longer exists.");
            return false;
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE document_accounts  SET  document_store_id = ? ,  org_id = ? ,  entered = ?  WHERE id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.documentStoreId);
        pst.setInt(++i, this.orgId);
        pst.setTimestamp(++i, this.entered);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.documentStoreId = rs.getInt("document_store_id");
        this.orgId = rs.getInt("org_id");
        this.entered = rs.getTimestamp("entered");
        this.documentStoreName = rs.getString("store_name");
        this.accountName = rs.getString("org_name");
    }

    public void setHasAccess(boolean b) {
    }
}

