/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.documents.base.AccountDocument;
import org.aspcfs.utils.web.PagedListInfo;

public class AccountDocumentList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int documentStoreId = -1;
    private int orgId = -1;
    private int userId = -1;
    private int buildPortalRecords = -1;

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public void setDocumentStoreId(int documentStoreId) {
        this.documentStoreId = documentStoreId;
    }

    public void setDocumentStoreId(String documentStoreId) {
        this.documentStoreId = Integer.parseInt(documentStoreId);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public int getBuildPortalRecords() {
        return this.buildPortalRecords;
    }

    public void setBuildPortalRecords(int buildPortalRecords) {
        this.buildPortalRecords = buildPortalRecords;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM document_accounts da WHERE da.document_store_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        this.pagedListInfo.setDefaultSort("title", null);
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("da.*, ds.title AS store_name, org.name AS org_name FROM document_accounts da LEFT JOIN document_store ds ON (da.document_store_id = ds.document_store_id) LEFT JOIN organization org ON (da.org_id = org.org_id) WHERE da.document_store_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            AccountDocument thisAccountDocument = new AccountDocument(rs);
            this.add(thisAccountDocument);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.documentStoreId > -1) {
            sqlFilter.append("AND (da.document_store_id = ?) ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND (da.org_id = ?) ");
        }
        if (this.buildPortalRecords == 1) {
            sqlFilter.append("AND da.document_store_id IN (SELECT document_store_id FROM document_store_user_member WHERE item_id = ?)");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.documentStoreId > -1) {
            pst.setInt(++i, this.documentStoreId);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.buildPortalRecords == 1) {
            pst.setInt(++i, this.userId);
        }
        return i;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }
}

