/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.aspcfs.modules.documents.base.DocumentStorePermissionList;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMemberList;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStore
extends GenericBean {
    private int id = -1;
    private int templateId = -1;
    private String title = "";
    private String shortDescription = "";
    private String requestedBy = "";
    private String requestedDept = "";
    private Timestamp requestDate = null;
    private String requestDateTimeZone = null;
    private boolean approved = false;
    private Timestamp approvalDate = null;
    private int approvalBy = -1;
    private boolean closed = false;
    private Timestamp closeDate = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Timestamp trashedDate = null;
    private DocumentStoreTeamMemberList userTeam = new DocumentStoreTeamMemberList();
    private DocumentStoreTeamMemberList roleTeam = new DocumentStoreTeamMemberList();
    private DocumentStoreTeamMemberList departmentTeam = new DocumentStoreTeamMemberList();
    private DocumentStoreTeamMemberList employeeTeam = new DocumentStoreTeamMemberList();
    private DocumentStoreTeamMemberList accountContactTeam = new DocumentStoreTeamMemberList();
    private DocumentStoreTeamMemberList portalUserTeam = new DocumentStoreTeamMemberList();
    private FileItemList files = new FileItemList();
    private DocumentStorePermissionList permissions = new DocumentStorePermissionList();

    public DocumentStore() {
    }

    public DocumentStore(Connection db, int tmpId) throws SQLException {
        this.queryRecord(db, tmpId);
    }

    public DocumentStore(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setTemplateId(int tmp) {
        this.templateId = tmp;
    }

    public void setTemplateId(String tmp) {
        this.templateId = Integer.parseInt(tmp);
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setRequestedBy(String tmp) {
        this.requestedBy = tmp;
    }

    public void setRequestedDept(String tmp) {
        this.requestedDept = tmp;
    }

    public void setRequestDate(Timestamp tmp) {
        this.requestDate = tmp;
    }

    public void setRequestDate(String tmp) {
        this.requestDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setRequestDateTimeZone(String tmp) {
        this.requestDateTimeZone = tmp;
    }

    public void setApproved(boolean tmp) {
        this.approved = tmp;
    }

    public void setApproved(String tmp) {
        this.approved = DatabaseUtils.parseBoolean(tmp);
    }

    public void setApprovalDate(Timestamp tmp) {
        this.approvalDate = tmp;
    }

    public void setApprovalDate(String tmp) {
        this.approvalDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setApprovalBy(int tmp) {
        this.approvalBy = tmp;
    }

    public void setApprovalBy(String tmp) {
        this.approvalBy = Integer.parseInt(tmp);
    }

    public void setClosed(boolean tmp) {
        this.closed = tmp;
    }

    public void setClosed(String tmp) {
        this.closed = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCloseDate(Timestamp tmp) {
        this.closeDate = tmp;
    }

    public void setCloseDate(String tmp) {
        this.closeDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void setUserTeam(DocumentStoreTeamMemberList tmp) {
        this.userTeam = tmp;
    }

    public void setRoleTeam(DocumentStoreTeamMemberList tmp) {
        this.roleTeam = tmp;
    }

    public void setDepartmentTeam(DocumentStoreTeamMemberList tmp) {
        this.departmentTeam = tmp;
    }

    public void setEmployeeTeam(DocumentStoreTeamMemberList tmp) {
        this.employeeTeam = tmp;
    }

    public void setAccountContactTeam(DocumentStoreTeamMemberList tmp) {
        this.accountContactTeam = tmp;
    }

    public void setPortalUserTeam(DocumentStoreTeamMemberList tmp) {
        this.portalUserTeam = tmp;
    }

    public void setFiles(FileItemList tmp) {
        this.files = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public String getRequestedDept() {
        return this.requestedDept;
    }

    public Timestamp getRequestDate() {
        return this.requestDate;
    }

    public String getRequestDateTimeZone() {
        return this.requestDateTimeZone;
    }

    public boolean getApproved() {
        return this.approved;
    }

    public Timestamp getApprovalDate() {
        return this.approvalDate;
    }

    public int getApprovalBy() {
        return this.approvalBy;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public Timestamp getCloseDate() {
        return this.closeDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public DocumentStoreTeamMemberList getUserTeam() {
        return this.userTeam;
    }

    public DocumentStoreTeamMemberList getRoleTeam() {
        return this.roleTeam;
    }

    public DocumentStoreTeamMemberList getDepartmentTeam() {
        return this.departmentTeam;
    }

    public DocumentStoreTeamMemberList getEmployeeTeam() {
        return this.employeeTeam;
    }

    public DocumentStoreTeamMemberList getAccountContactTeam() {
        return this.accountContactTeam;
    }

    public DocumentStoreTeamMemberList getPortalUserTeam() {
        return this.portalUserTeam;
    }

    public FileItemList getFiles() {
        return this.files;
    }

    public void buildTeamMemberList(Connection db) throws SQLException {
        this.userTeam.setDocumentStore(this);
        this.userTeam.setDocumentStoreId(this.getId());
        this.userTeam.setMemberType("user");
        this.userTeam.buildList(db);
        this.employeeTeam.setDocumentStore(this);
        this.employeeTeam.setDocumentStoreId(this.getId());
        this.employeeTeam.setMemberType("user");
        this.employeeTeam.setEmployeesOnly(true);
        this.employeeTeam.buildList(db);
        this.accountContactTeam.setDocumentStore(this);
        this.accountContactTeam.setDocumentStoreId(this.getId());
        this.accountContactTeam.setMemberType("user");
        this.accountContactTeam.setAccountContactsOnly(true);
        this.accountContactTeam.buildList(db);
        this.roleTeam.setDocumentStore(this);
        this.roleTeam.setDocumentStoreId(this.getId());
        this.roleTeam.setMemberType("role");
        this.roleTeam.buildList(db);
        this.departmentTeam.setDocumentStore(this);
        this.departmentTeam.setDocumentStoreId(this.getId());
        this.departmentTeam.setMemberType("department");
        this.departmentTeam.buildList(db);
        this.portalUserTeam.setDocumentStore(this);
        this.portalUserTeam.setDocumentStoreId(this.getId());
        this.portalUserTeam.setMemberType("user");
        this.portalUserTeam.setPortalUsersOnly(true);
        this.portalUserTeam.buildList(db);
    }

    public int buildPermissionList(Connection db) throws SQLException {
        this.permissions.setDocumentStoreId(this.getId());
        this.permissions.buildList(db);
        return this.permissions.size();
    }

    public int buildFileItemList(Connection db) throws SQLException {
        this.files.setLinkModuleId(20041083);
        this.files.setLinkItemId(this.getId());
        this.files.buildList(db);
        return this.files.size();
    }

    private void queryRecord(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Invalid Document Store");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM document_store ds WHERE ds.document_store_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(Connection db) throws SQLException {
        Exception errorMessage = null;
        boolean autoCommit = db.getAutoCommit();
        try {
            Date tmpDate;
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            this.id = DatabaseUtils.getNextSeq(db, "document_store_document_store_id_seq");
            int i = 0;
            pst = db.prepareStatement("INSERT INTO document_store (" + (this.id > -1 ? "document_store_id, " : "") + "template_id , " + " title , " + " shortDescription , " + " requestedBy , " + " requestedDept , " + " requestDate , " + " requestDate_timezone , " + " approvalDate , " + " approvalBy , " + " closeDate , " + " enteredBy , " + " modifiedBy) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?,?,?)");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            DatabaseUtils.setInt(pst, ++i, this.templateId);
            pst.setString(++i, this.title);
            pst.setString(++i, this.shortDescription);
            pst.setString(++i, this.requestedBy);
            pst.setString(++i, this.requestedDept);
            pst.setTimestamp(++i, this.requestDate);
            pst.setString(++i, this.requestDateTimeZone);
            if (this.approved) {
                tmpDate = new Date();
                this.approvalDate = new Timestamp(tmpDate.getTime());
                this.approvalDate.setNanos(0);
                pst.setTimestamp(++i, this.approvalDate);
                pst.setInt(++i, this.enteredBy);
            } else {
                pst.setNull(++i, 91);
                DatabaseUtils.setInt(pst, ++i, -1);
            }
            if (this.closed) {
                DatabaseUtils.setInt(pst, ++i, this.enteredBy);
                tmpDate = new Date();
                this.closeDate = new Timestamp(tmpDate.getTime());
                this.closeDate.setNanos(0);
                pst.setTimestamp(++i, this.closeDate);
            } else {
                pst.setTimestamp(++i, this.closeDate);
            }
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "document_store_document_store_id_seq", this.id);
            DocumentStorePermissionList.insertDefaultPermissions(db, this.id);
            if (autoCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            errorMessage = e;
            if (autoCommit) {
                db.rollback();
            }
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
        if (errorMessage != null) {
            throw new SQLException(errorMessage.getMessage());
        }
        return true;
    }

    public boolean delete(Connection db, String basePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int recordCount = 0;
        try {
            db.setAutoCommit(false);
            this.buildTeamMemberList(db);
            this.userTeam.delete(db, "user");
            this.roleTeam.delete(db, "role");
            this.departmentTeam.delete(db, "department");
            this.buildFileItemList(db);
            this.files.delete(db, this.getFileLibraryPath(basePath, "documents"));
            FileFolderList folders = new FileFolderList();
            folders.setLinkModuleId(20041083);
            folders.setLinkItemId(this.id);
            folders.buildList(db);
            folders.delete(db);
            DocumentStorePermissionList.delete(db, this.id);
            PreparedStatement pst = db.prepareStatement(" DELETE FROM document_store  WHERE document_store_id = ? ");
            pst.setInt(1, this.id);
            recordCount = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        if (recordCount == 0) {
            this.errors.put("actionError", "Document Store could not be deleted because it no longer exists.");
            return false;
        }
        return true;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE document_store SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE document_store_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.id);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        Date tmpDate;
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int resultCount = 0;
        boolean previouslyApproved = false;
        Timestamp previousApprovalDate = null;
        boolean previouslyClosed = false;
        Timestamp previousCloseDate = null;
        PreparedStatement pst = db.prepareStatement(" SELECT *  FROM document_store  WHERE document_store_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            previousApprovalDate = rs.getTimestamp("approvaldate");
            previouslyApproved = previousApprovalDate != null;
            previousCloseDate = rs.getTimestamp("closedate");
            previouslyClosed = previousCloseDate != null;
        }
        rs.close();
        pst.close();
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE document_store  SET  template_id = ? ,  title = ? ,  shortDescription = ? ,  requestedBy = ? ,  requestedDept = ? ,  requestDate = ? ,  requestDate_timezone = ? , ");
        if (previouslyApproved && this.approved) {
            sql.append(" approvalDate = ? , ");
        } else if (!previouslyApproved && this.approved) {
            sql.append(" approvalDate = ? , ");
            sql.append(" approvalBy = ? , ");
        } else if (!this.approved) {
            sql.append(" approvalDate = ? , ");
            sql.append(" approvalBy = ? , ");
        }
        sql.append(" closeDate = ? ,  modifiedby = ? ,  modified = CURRENT_TIMESTAMP  WHERE document_store_id = ?  AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.templateId);
        pst.setString(++i, this.title);
        pst.setString(++i, this.shortDescription);
        pst.setString(++i, this.requestedBy);
        pst.setString(++i, this.requestedDept);
        pst.setTimestamp(++i, this.requestDate);
        pst.setString(++i, this.requestDateTimeZone);
        if (previouslyApproved && this.approved) {
            pst.setTimestamp(++i, previousApprovalDate);
        } else if (!previouslyApproved && this.approved) {
            tmpDate = new Date();
            this.approvalDate = new Timestamp(tmpDate.getTime());
            this.approvalDate.setNanos(0);
            pst.setTimestamp(++i, this.approvalDate);
            DatabaseUtils.setInt(pst, ++i, this.modifiedBy);
        } else if (!this.approved) {
            pst.setNull(++i, 91);
            DatabaseUtils.setInt(pst, ++i, -1);
        }
        if (previouslyClosed && this.closed) {
            pst.setTimestamp(++i, previousCloseDate);
        } else if (!previouslyClosed && this.closed) {
            tmpDate = new Date();
            this.closeDate = new Timestamp(tmpDate.getTime());
            this.closeDate.setNanos(0);
            pst.setTimestamp(++i, this.closeDate);
        } else if (!this.closed) {
            pst.setNull(++i, 91);
        }
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("document_store_id");
        this.templateId = rs.getInt("template_id");
        this.title = rs.getString("title");
        this.shortDescription = rs.getString("shortDescription");
        this.requestedBy = rs.getString("requestedBy");
        this.requestedDept = rs.getString("requestedDept");
        this.requestDate = rs.getTimestamp("requestDate");
        this.requestDateTimeZone = rs.getString("requestDate_timezone");
        this.approvalDate = rs.getTimestamp("approvalDate");
        this.approvalBy = DatabaseUtils.getInt(rs, "approvalBy");
        this.closeDate = rs.getTimestamp("closeDate");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredBy");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedBy");
        this.trashedDate = rs.getTimestamp("trashed_date");
    }

    public int getAccessUserLevel(String permission) {
        return this.permissions.getAccessLevel(permission);
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("requestDate");
        return thisList;
    }
}

