/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Indexer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStoreIndexer
implements Indexer {
    public static void add(IndexWriter writer, Connection db, ActionContext context) throws SQLException, IOException {
        PreparedStatement pst = db.prepareStatement("SELECT document_store_id, title, shortdescription, requestedby, requesteddept, modified FROM document_store WHERE document_store_id > -1 ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            DocumentStore documentStore = new DocumentStore();
            documentStore.setId(rs.getInt("document_store_id"));
            documentStore.setTitle(rs.getString("title"));
            documentStore.setShortDescription(rs.getString("shortdescription"));
            documentStore.setRequestedBy(rs.getString("requestedby"));
            documentStore.setRequestedDept(rs.getString("requesteddept"));
            documentStore.setModified(rs.getTimestamp("modified"));
            DocumentStoreIndexer.add(writer, documentStore, false);
            DatabaseUtils.renewConnection(context, db);
        }
        rs.close();
        pst.close();
    }

    public static void add(IndexWriter writer, DocumentStore documentStore, boolean modified) throws IOException {
        Document document = new Document();
        document.add(Field.Keyword((String)"type", (String)"documentstoredetails"));
        document.add(Field.Keyword((String)"documentStoreKeyId", (String)String.valueOf(documentStore.getId())));
        document.add(Field.Keyword((String)"documentStoreId", (String)String.valueOf(documentStore.getId())));
        document.add(Field.Text((String)"trashed", (String)(documentStore.getTrashedDate() != null ? "Trashed" : "")));
        document.add(Field.Text((String)"title", (String)documentStore.getTitle()));
        document.add(Field.Text((String)"contents", (String)(documentStore.getTitle() + " " + documentStore.getShortDescription() + " " + documentStore.getRequestedBy() + " " + documentStore.getRequestedDept())));
        if (modified) {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(System.currentTimeMillis())));
        } else {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(documentStore.getModified().getTime())));
        }
        writer.addDocument(document);
        if (System.getProperty("DEBUG") != null && modified) {
            System.out.println("DocumentStoreIndexer-> Added: " + documentStore.getId());
        }
    }

    public static Term getSearchTerm(DocumentStore documentStore) {
        Term searchTerm = new Term("documentStoreKeyId", String.valueOf(documentStore.getId()));
        return searchTerm;
    }

    public static Term getDeleteTerm(DocumentStore documentStore) {
        Term searchTerm = new Term("documentStoreId", String.valueOf(documentStore.getId()));
        return searchTerm;
    }
}

