/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class DocumentStoreList
extends ArrayList {
    public static final String tableName = "document_store";
    public static final String uniqueField = "document_store_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    private int groupId = -1;
    private int documentStoreId = -1;
    private int documentStoresForUser = -1;
    private int userRole = -1;
    private int departmentId = -1;
    private int enteredByUser = -1;
    private String enteredByUserRange = null;
    private String userRange = null;
    private boolean openDocumentStoresOnly = false;
    private boolean closedDocumentStoresOnly = false;
    private boolean invitationPendingOnly = false;
    private boolean invitationAcceptedOnly = false;
    private int daysLastAccessed = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    int siteId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void setDocumentStoreId(int tmp) {
        this.documentStoreId = tmp;
    }

    public void setDocumentStoreId(String tmp) {
        this.documentStoreId = Integer.parseInt(tmp);
    }

    public void setDocumentStoresForUser(int tmp) {
        this.documentStoresForUser = tmp;
    }

    public void setDocumentStoresForUser(String tmp) {
        this.documentStoresForUser = Integer.parseInt(tmp);
    }

    public void setUserRole(int tmp) {
        this.userRole = tmp;
    }

    public void setUserRole(String tmp) {
        this.userRole = Integer.parseInt(tmp);
    }

    public void setDepartmentId(int tmp) {
        this.departmentId = tmp;
    }

    public void setDepartmentId(String tmp) {
        this.departmentId = Integer.parseInt(tmp);
    }

    public void setEnteredByUser(int tmp) {
        this.enteredByUser = tmp;
    }

    public void setEnteredByUser(String tmp) {
        this.enteredByUser = Integer.parseInt(tmp);
    }

    public void setEnteredByUserRange(String tmp) {
        this.enteredByUserRange = tmp;
    }

    public void setUserRange(String tmp) {
        this.userRange = tmp;
    }

    public void setOpenDocumentStoresOnly(boolean tmp) {
        this.openDocumentStoresOnly = tmp;
    }

    public void setOpenDocumentStoresOnly(String tmp) {
        this.openDocumentStoresOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setClosedDocumentStoresOnly(boolean tmp) {
        this.closedDocumentStoresOnly = tmp;
    }

    public void setClosedDocumentStoresOnly(String tmp) {
        this.closedDocumentStoresOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setInvitationPendingOnly(boolean tmp) {
        this.invitationPendingOnly = tmp;
    }

    public void setInvitationPendingOnly(String tmp) {
        this.invitationPendingOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setInvitationAcceptedOnly(boolean tmp) {
        this.invitationAcceptedOnly = tmp;
    }

    public void setInvitationAcceptedOnly(String tmp) {
        this.invitationAcceptedOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDaysLastAccessed(int tmp) {
        this.daysLastAccessed = tmp;
    }

    public void setDaysLastAccessed(String tmp) {
        this.daysLastAccessed = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAlertRangeStart(Timestamp tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setAlertRangeEnd(Timestamp tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = DatabaseUtils.parseTimestamp(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public int getDocumentStoresForUser() {
        return this.documentStoresForUser;
    }

    public int getUserRole() {
        return this.userRole;
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public int getEnteredByUser() {
        return this.enteredByUser;
    }

    public String getEnteredByUserRange() {
        return this.enteredByUserRange;
    }

    public String getUserRange() {
        return this.userRange;
    }

    public boolean getOpenDocumentStoresOnly() {
        return this.openDocumentStoresOnly;
    }

    public boolean getClosedDocumentStoresOnly() {
        return this.closedDocumentStoresOnly;
    }

    public boolean getInvitationPendingOnly() {
        return this.invitationPendingOnly;
    }

    public boolean getInvitationAcceptedOnly() {
        return this.invitationAcceptedOnly;
    }

    public int getDaysLastAccessed() {
        return this.daysLastAccessed;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public Timestamp getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Timestamp getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect listSelect = this.getHtmlSelect();
        return listSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelect() {
        HtmlSelect listSelect = new HtmlSelect();
        if (this.emptyHtmlSelectRecord != null) {
            listSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (DocumentStore thisDocumentStore : this) {
            listSelect.addItem(thisDocumentStore.getId(), thisDocumentStore.getTitle());
        }
        return listSelect;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM document_store ds WHERE ds.document_store_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        if (!this.pagedListInfo.getCurrentLetter().equals("")) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(title) < ? ");
            items = this.prepareFilter(pst);
            pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
            rs = pst.executeQuery();
            if (rs.next()) {
                int offsetCount = rs.getInt("recordcount");
                this.pagedListInfo.setCurrentOffset(offsetCount);
            }
            rs.close();
            pst.close();
        }
        this.pagedListInfo.setDefaultSort("title", null);
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("ds.* FROM document_store ds WHERE ds.document_store_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            DocumentStore thisDocumentStore = new DocumentStore(rs);
            this.add(thisDocumentStore);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.groupId > -1) {
            sqlFilter.append("AND (group_id = ?) ");
        }
        if (this.documentStoreId > -1) {
            sqlFilter.append("AND (document_store_id = ?) ");
        }
        if (this.openDocumentStoresOnly) {
            sqlFilter.append("AND (closedate IS NULL) ");
        }
        if (this.closedDocumentStoresOnly) {
            sqlFilter.append("AND (closedate IS NOT NULL) ");
        }
        if (this.documentStoresForUser > -1) {
            sqlFilter.append("AND ((ds.document_store_id IN (SELECT DISTINCT document_store_id FROM document_store_user_member WHERE item_id = ? )) ");
            sqlFilter.append("OR (ds.document_store_id IN (SELECT DISTINCT document_store_id FROM document_store_role_member WHERE item_id = ? AND site_id " + (this.siteId == -1 ? "IS NULL " : " = ? ") + "))");
            sqlFilter.append("OR (ds.document_store_id IN (SELECT DISTINCT document_store_id FROM " + DatabaseUtils.getTableName(db, "document_store_department_member") + " WHERE item_id = ? AND site_id " + (this.siteId == -1 ? "IS NULL " : " = ? ") + ")))");
        }
        if (this.userRange != null) {
            sqlFilter.append("AND (ds.document_store_id IN (SELECT DISTINCT document_store_id FROM document_store_user_member WHERE item_id IN (" + this.userRange + ")) " + "OR ds.enteredBy IN (" + this.userRange + ")) ");
        }
        if (this.enteredByUser > -1) {
            sqlFilter.append("AND (ds.enteredby = ?) ");
        }
        if (this.enteredByUserRange != null) {
            sqlFilter.append("AND (ds.enteredby IN (" + this.enteredByUserRange + ")) ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND ds.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND ds.trashed_date = ? ");
        } else {
            sqlFilter.append("AND ds.trashed_date IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.groupId > -1) {
            pst.setInt(++i, this.groupId);
        }
        if (this.documentStoreId > -1) {
            pst.setInt(++i, this.documentStoreId);
        }
        if (this.documentStoresForUser > -1) {
            pst.setInt(++i, this.documentStoresForUser);
            pst.setInt(++i, this.userRole);
            if (this.siteId != -1) {
                pst.setInt(++i, this.siteId);
            }
            pst.setInt(++i, this.departmentId);
            if (this.siteId != -1) {
                pst.setInt(++i, this.siteId);
            }
        }
        if (this.enteredByUser > -1) {
            pst.setInt(++i, this.enteredByUser);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static HashMap buildNameList(Connection db) throws SQLException {
        HashMap<Integer, String> nameList = new HashMap<Integer, String>();
        PreparedStatement pst = db.prepareStatement("SELECT document_store_id, title FROM document_store");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            nameList.put(new Integer(rs.getInt(uniqueField)), rs.getString("title"));
        }
        rs.close();
        pst.close();
        return nameList;
    }

    public static int buildDocumentStoreCount(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS recordcount FROM document_store WHERE document_store_id > -1 ");
        ResultSet rs = pst.executeQuery();
        rs.next();
        int count = rs.getInt("recordcount");
        rs.close();
        pst.close();
        return count;
    }

    public static int buildDocumentStoreCount(Connection db, int tmpUserId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS recordcount FROM document_store WHERE document_store_id > -1 AND enteredby = ? ");
        pst.setInt(1, tmpUserId);
        ResultSet rs = pst.executeQuery();
        rs.next();
        int count = rs.getInt("recordcount");
        rs.close();
        pst.close();
        return count;
    }

    public void delete(Connection db, String filePath) throws SQLException {
        for (DocumentStore thisDocumentStore : this) {
            thisDocumentStore.delete(db, filePath);
        }
    }
}

