/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.documents.base.DocumentStorePermissionLookupList;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStorePermissionCategoryLookup
extends GenericBean {
    private int id = -1;
    private String description = null;
    private boolean defaultItem = false;
    private int level = -1;
    private boolean enabled = false;
    private DocumentStorePermissionLookupList permissions = null;

    public DocumentStorePermissionCategoryLookup() {
    }

    public DocumentStorePermissionCategoryLookup(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(boolean defaultItem) {
        this.defaultItem = defaultItem;
    }

    public void setDefaultItem(String defaultItem) {
        this.defaultItem = DatabaseUtils.parseBoolean(defaultItem);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = Integer.parseInt(level);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = DatabaseUtils.parseBoolean(enabled);
    }

    public DocumentStorePermissionLookupList getPermissions() {
        return this.permissions;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("code");
        this.description = rs.getString("description");
    }

    public void buildResources(Connection db, int includeEnabled) throws SQLException {
        this.permissions = new DocumentStorePermissionLookupList(db, this.id, includeEnabled);
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "lookup_document_store_permission_category_code_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "lookup_document_store_permission_category") + " " + "(" + (this.id > -1 ? "code, " : "") + "description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.defaultItem);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "lookup_document_store_permission_category_code_seq", this.id);
        return true;
    }
}

