/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.documents.base.DocumentStorePermissionCategoryLookup;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStorePermissionCategoryLookupList
extends ArrayList {
    private int includeEnabled = -1;

    public void setIncludeEnabled(int tmp) {
        this.includeEnabled = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + DatabaseUtils.getTableName(db, "lookup_document_store_permission_category") + " " + "WHERE code > 0 ");
        this.createFilter(sql);
        sql.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", description ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            DocumentStorePermissionCategoryLookup thisCategory = new DocumentStorePermissionCategoryLookup(rs);
            this.add(thisCategory);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.includeEnabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.includeEnabled != -1) {
            pst.setBoolean(++i, this.includeEnabled == 1);
        }
        return i;
    }

    public void buildResources(Connection db) throws SQLException {
        for (DocumentStorePermissionCategoryLookup category : this) {
            category.buildResources(db, this.includeEnabled);
        }
    }

    public static int retrieveMaxLevel(Connection db) throws SQLException {
        int maxLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") AS max_level " + "FROM " + DatabaseUtils.getTableName(db, "lookup_document_store_permission_category") + " ");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            maxLevel = rs.getInt("max_level");
        }
        rs.close();
        pst.close();
        return maxLevel;
    }
}

