/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.documents.base.DocumentStorePermissionLookup;
import org.aspcfs.modules.documents.base.DocumentStorePermissionLookupList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class DocumentStorePermissionList
extends HashMap {
    public static final String tableName = "document_store_permissions";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int documentStoreId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setDocumentStoreId(int tmp) {
        this.documentStoreId = tmp;
    }

    public void setDocumentStoreId(String tmp) {
        this.documentStoreId = Integer.parseInt(tmp);
    }

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT lp.permission, p.userlevel FROM document_store_permissions p, " + DatabaseUtils.getTableName(db, "lookup_document_store_permission") + " lp " + "WHERE p.permission_id = lp.code ");
        this.createFilter(sql);
        PreparedStatement pst = db.prepareStatement(sql.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            this.put(rs.getString("permission"), new Integer(rs.getInt("userlevel")));
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.documentStoreId > -1) {
            sqlFilter.append("AND document_store_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.documentStoreId > -1) {
            pst.setInt(++i, this.documentStoreId);
        }
        return i;
    }

    public boolean hasPermission(String permissionName, int userLevel) {
        Integer value = (Integer)this.get(permissionName);
        return true;
    }

    public int getAccessLevel(String permissionName) {
        Integer value = (Integer)this.get(permissionName);
        if (value == null) {
            return 1;
        }
        return value;
    }

    public static void updateDocumentStorePermissions(Connection db, HttpServletRequest request, int tmpDocumentStoreId) throws SQLException {
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM document_store_permissions WHERE document_store_id = ? ");
            pst.setInt(1, tmpDocumentStoreId);
            pst.execute();
            pst.close();
            int count = 0;
            String permissionId = null;
            while ((permissionId = request.getParameter("perm" + ++count)) != null) {
                int id = DatabaseUtils.getNextSeq(db, "document_store_permissions_id_seq");
                pst = db.prepareStatement("INSERT INTO document_store_permissions (" + (id > -1 ? "id, " : "") + "document_store_id, permission_id, userlevel) " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?)");
                int i = 0;
                if (id > -1) {
                    pst.setInt(++i, id);
                }
                pst.setInt(++i, tmpDocumentStoreId);
                pst.setInt(++i, Integer.parseInt(permissionId));
                pst.setInt(++i, Integer.parseInt(request.getParameter("perm" + count + "level")));
                pst.execute();
                pst.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public static void delete(Connection db, int tmpDocumentStoreId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM document_store_permissions WHERE document_store_id = ? ");
        pst.setInt(1, tmpDocumentStoreId);
        pst.execute();
        pst.close();
    }

    public static void insertDefaultPermissions(Connection db, int tmpDocumentStoreId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS perm_count FROM document_store_permissions WHERE document_store_id = ? ");
        pst.setInt(1, tmpDocumentStoreId);
        ResultSet rs = pst.executeQuery();
        rs.next();
        int count = rs.getInt("perm_count");
        rs.close();
        pst.close();
        if (count == 0) {
            DocumentStorePermissionLookupList list = new DocumentStorePermissionLookupList();
            list.setIncludeEnabled(1);
            list.buildList(db);
            for (DocumentStorePermissionLookup thisPermission : list) {
                int id = DatabaseUtils.getNextSeq(db, "document_store_permissions_id_seq");
                pst = db.prepareStatement("INSERT INTO document_store_permissions (" + (id > -1 ? "id, " : "") + "document_store_id, permission_id, userlevel) " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?) ");
                int i = 0;
                if (id > -1) {
                    pst.setInt(++i, id);
                }
                pst.setInt(++i, tmpDocumentStoreId);
                pst.setInt(++i, thisPermission.getId());
                pst.setInt(++i, thisPermission.getDefaultRole());
                pst.execute();
                id = DatabaseUtils.getCurrVal(db, "document_store_permissions_id_seq", id);
                pst.close();
            }
        }
    }
}

