/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.documents.base.DocumentStorePermissionLookup;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStorePermissionLookupList
extends ArrayList {
    private int categoryId = -1;
    private int includeEnabled = -1;

    public DocumentStorePermissionLookupList() {
    }

    public DocumentStorePermissionLookupList(Connection db, int categoryId, int includeEnabled) throws SQLException {
        this.categoryId = categoryId;
        this.includeEnabled = includeEnabled;
        this.buildList(db);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setIncludeEnabled(int tmp) {
        this.includeEnabled = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + DatabaseUtils.getTableName(db, "lookup_document_store_permission") + " " + "WHERE code > 0 ");
        this.createFilter(sql);
        sql.append("ORDER BY category_id, " + DatabaseUtils.addQuotes(db, "level") + ", description ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            DocumentStorePermissionLookup thisPermission = new DocumentStorePermissionLookup(rs);
            this.add(thisPermission);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND category_id = ? ");
        }
        if (this.includeEnabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.includeEnabled != -1) {
            pst.setBoolean(++i, this.includeEnabled == 1);
        }
        return i;
    }
}

