/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentStoreTeamMember {
    public static final int DOCUMENTSTORE_MANAGER = 1;
    public static final int CONTRIBUTOR_LEVEL3 = 2;
    public static final int CONTRIBUTOR_LEVEL2 = 3;
    public static final int CONTRIBUTOR_LEVEL1 = 4;
    public static final int GUEST = 5;
    public static final int STATUS_ADDED = -1;
    private DocumentStore documentStore = null;
    private Object contact = null;
    private Object user = null;
    private int documentStoreId = -1;
    private int itemId = -1;
    private int userLevel = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private int roleId = -1;
    private int roleType = -1;
    private int status = -1;
    private Timestamp lastAccessed = null;
    private int siteId = -1;
    private String teamMemberType = "user";

    public void setTeamMemberType(String tmp) {
        this.teamMemberType = tmp;
    }

    public String getTeamMemberType() {
        return this.teamMemberType;
    }

    public DocumentStoreTeamMember() {
    }

    public DocumentStoreTeamMember(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public DocumentStoreTeamMember(Connection db, int tmpDocumentStoreId, int tmpTeamId, int tmpRoleId, int tmpDepartmentId, int siteId) throws SQLException {
        this.queryRecord(db, tmpDocumentStoreId, tmpTeamId, tmpRoleId, tmpDepartmentId, siteId);
    }

    public void setDocumentStore(DocumentStore tmp) {
        this.documentStore = tmp;
    }

    public void setContact(Object tmp) {
        this.contact = tmp;
    }

    public void setUser(Object tmp) {
        this.user = tmp;
    }

    public void setDocumentStoreId(int tmp) {
        this.documentStoreId = tmp;
    }

    public void setDocumentStoreId(String tmp) {
        this.documentStoreId = Integer.parseInt(tmp);
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setUserLevel(int tmp) {
        this.userLevel = tmp;
    }

    public void setUserLevel(String tmp) {
        this.userLevel = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setRoleId(int tmp) {
        this.roleId = tmp;
    }

    public void setRoleId(String tmp) {
        this.roleId = Integer.parseInt(tmp);
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setLastAccessed(Timestamp tmp) {
        this.lastAccessed = tmp;
    }

    public void setLastAccessed(String tmp) {
        this.lastAccessed = DatabaseUtils.parseTimestamp(tmp);
    }

    public DocumentStore getDocumentStore() {
        return this.documentStore;
    }

    public Object getContact() {
        return this.contact;
    }

    public Object getUser() {
        return this.user;
    }

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public int getStatus() {
        return this.status;
    }

    public Timestamp getLastAccessed() {
        return this.lastAccessed;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    private void queryRecord(Connection db, int tmpDocumentStoreId, int tmpTeamId, int tmpUserRoleId, int tmpDepartmentId, int tmpSiteId) throws SQLException {
        ResultSet rs;
        PreparedStatement pst = null;
        int tmpDocumentStoreRoleId = -1;
        int tmpDocumentStoreUserLevel = -1;
        pst = db.prepareStatement("SELECT m.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM document_store_user_member m, lookup_document_store_role r " + "WHERE m.document_store_id = ? " + "AND m.item_id = ? " + "AND m.userlevel = r.code " + "AND m.site_id " + (tmpSiteId == -1 ? " IS NULL " : " = ? "));
        pst.setInt(1, tmpDocumentStoreId);
        pst.setInt(2, tmpTeamId);
        if (tmpSiteId > -1) {
            pst.setInt(3, tmpSiteId);
        }
        if ((rs = pst.executeQuery()).next()) {
            this.buildRecord(rs);
            tmpDocumentStoreRoleId = this.getRoleId();
            tmpDocumentStoreUserLevel = this.getUserLevel();
        }
        rs.close();
        pst.close();
        if (tmpDocumentStoreRoleId == -1) {
            pst = db.prepareStatement("SELECT m.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM document_store_role_member m, lookup_document_store_role r " + "WHERE m.document_store_id = ? " + "AND m.item_id = ? " + "AND m.userlevel = r.code " + "AND m.site_id " + (tmpSiteId == -1 ? " IS NULL " : " = ? "));
            pst.setInt(1, tmpDocumentStoreId);
            pst.setInt(2, tmpUserRoleId);
            if (tmpSiteId > -1) {
                pst.setInt(3, tmpSiteId);
            }
            if ((rs = pst.executeQuery()).next()) {
                this.buildRecord(rs);
                tmpDocumentStoreRoleId = this.getRoleId();
                tmpDocumentStoreUserLevel = this.getUserLevel();
            }
            rs.close();
            pst.close();
            if (tmpDepartmentId != -1) {
                pst = db.prepareStatement("SELECT m.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM " + DatabaseUtils.getTableName(db, "document_store_department_member") + " m, lookup_document_store_role r " + "WHERE m.document_store_id = ? " + "AND m.item_id = ? " + "AND m.userlevel = r.code " + "AND m.site_id " + (tmpSiteId == -1 ? " IS NULL " : " = ? "));
                pst.setInt(1, tmpDocumentStoreId);
                pst.setInt(2, tmpDepartmentId);
                if (tmpSiteId > -1) {
                    pst.setInt(3, tmpSiteId);
                }
                if ((rs = pst.executeQuery()).next()) {
                    this.buildRecord(rs);
                }
                rs.close();
                pst.close();
                if (tmpDocumentStoreRoleId > this.getRoleId()) {
                    tmpDocumentStoreRoleId = this.getRoleId();
                    tmpDocumentStoreUserLevel = this.getUserLevel();
                }
            }
        }
        if (tmpDocumentStoreRoleId == -1) {
            throw new SQLException("Member record not found.");
        }
        this.setRoleId(tmpDocumentStoreRoleId);
        this.setUserLevel(tmpDocumentStoreUserLevel);
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.documentStoreId = rs.getInt("document_store_id");
        this.itemId = rs.getInt("item_id");
        this.userLevel = rs.getInt("userlevel");
        this.status = DatabaseUtils.getInt(rs, "status");
        this.lastAccessed = rs.getTimestamp("last_accessed");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.roleType = DatabaseUtils.getInt(rs, "role_type");
        this.roleId = rs.getInt("level");
    }

    public String getLastAccessedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.lastAccessed);
        }
        catch (NullPointerException nullPointerException) {
            return "--";
        }
    }

    public boolean insert(Connection db) throws SQLException {
        return this.insert(db, this.teamMemberType);
    }

    public boolean insert(Connection db, String tmpMemberType) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String tableName = DocumentStoreTeamMember.getTableName(tmpMemberType, db);
        sql.append("INSERT INTO " + tableName);
        sql.append(" (document_store_id, item_id, userlevel, role_type, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        if (this.lastAccessed != null) {
            sql.append("last_accessed, ");
        }
        sql.append("enteredby, modifiedby, status, site_id) ");
        sql.append("VALUES (?, ?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        if (this.lastAccessed != null) {
            sql.append("?, ");
        }
        sql.append("?, ?, ?, ?) ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.documentStoreId);
        pst.setInt(++i, this.itemId);
        pst.setInt(++i, this.userLevel);
        DatabaseUtils.setInt(pst, ++i, this.roleType);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        if (this.lastAccessed != null) {
            pst.setTimestamp(++i, this.lastAccessed);
        }
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.status);
        DatabaseUtils.setInt(pst, ++i, this.siteId);
        pst.execute();
        pst.close();
        return true;
    }

    public void delete(Connection db, String tmpMemberType) throws SQLException {
        String tableName = DocumentStoreTeamMember.getTableName(tmpMemberType, db);
        if (tmpMemberType.equals("role")) {
            tableName = "document_store_role_member";
        } else if (tmpMemberType.equals("department")) {
            tableName = DatabaseUtils.getTableName(db, "document_store_department_member");
        }
        PreparedStatement pst = db.prepareStatement(" DELETE FROM " + tableName + " WHERE document_store_id = ? " + " AND item_id = ? AND site_id " + (this.siteId == -1 ? " IS NULL " : " = ? "));
        pst.setInt(1, this.documentStoreId);
        pst.setInt(2, this.itemId);
        if (this.siteId > -1) {
            pst.setInt(3, this.siteId);
        }
        pst.execute();
        pst.close();
    }

    public static boolean changeRole(Connection db, int tmpDocumentStoreId, int tmpItemId, int tmpUserLevel, String tmpMemberType, int siteId) throws SQLException {
        String tableName = DocumentStoreTeamMember.getTableName(tmpMemberType, db);
        PreparedStatement pst = db.prepareStatement(" SELECT " + DatabaseUtils.addQuotes(db, "level") + " " + " FROM lookup_document_store_role " + " WHERE code IN (SELECT userlevel FROM " + tableName + " WHERE document_store_id = ? AND item_id = ? AND site_id " + (siteId == -1 ? " IS NULL) " : "= ?) "));
        pst.setInt(1, tmpDocumentStoreId);
        pst.setInt(2, tmpItemId);
        if (siteId != -1) {
            DatabaseUtils.setInt(pst, 3, siteId);
        }
        ResultSet rs = pst.executeQuery();
        int previousLevel = -1;
        while (rs.next() && (previousLevel = rs.getInt("level")) > 1) {
        }
        rs.close();
        pst.close();
        if (previousLevel <= 1) {
            pst = db.prepareStatement(" SELECT count(item_id) AS other  FROM " + tableName + " WHERE document_store_id = ? " + " AND userlevel IN (SELECT code FROM lookup_document_store_role WHERE " + DatabaseUtils.addQuotes(db, "level") + " <= ?) " + " AND (item_id <> ? OR site_id " + (siteId == -1 ? " IS NOT NULL) " : " <> ?) "));
            pst.setInt(1, tmpDocumentStoreId);
            pst.setInt(2, 1);
            pst.setInt(3, tmpItemId);
            if (siteId != -1) {
                pst.setInt(4, siteId);
            }
            rs = pst.executeQuery();
            int otherCount = -1;
            if (rs.next()) {
                otherCount = rs.getInt("other");
            }
            rs.close();
            pst.close();
            if (otherCount == 0) {
                return false;
            }
        }
        pst = db.prepareStatement(" UPDATE " + tableName + " SET userlevel = ? " + " WHERE document_store_id = ? " + " AND item_id = ? AND site_id " + (siteId == -1 ? " IS NULL" : "= ? "));
        pst.setInt(1, tmpUserLevel);
        pst.setInt(2, tmpDocumentStoreId);
        pst.setInt(3, tmpItemId);
        if (siteId != -1) {
            DatabaseUtils.setInt(pst, 4, siteId);
        }
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void updateStatus(Connection db, String tmpMemberType) throws SQLException {
        String tableName = DocumentStoreTeamMember.getTableName(tmpMemberType, db);
        PreparedStatement pst = db.prepareStatement("UPDATE " + tableName + " " + "SET status = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE document_store_id = ? " + "AND item_id = ? AND site_id " + (this.siteId == -1 ? " IS NULL " : "= ? "));
        DatabaseUtils.setInt(pst, 1, this.status);
        pst.setInt(2, this.documentStoreId);
        pst.setInt(3, this.itemId);
        DatabaseUtils.setInt(pst, 4, this.siteId);
        pst.execute();
        pst.close();
    }

    public static void updateLastAccessed(Connection db, int tmpDocumentStoreId, int tmpItemId, int siteId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE document_store_user_member SET last_accessed = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE document_store_id = ? " + "AND item_id = ? AND site_id " + (siteId == -1 ? " IS NULL" : "= ? "));
        pst.setInt(1, tmpDocumentStoreId);
        pst.setInt(2, tmpItemId);
        if (siteId > -1) {
            pst.setInt(3, siteId);
        }
        pst.execute();
        pst.close();
    }

    public static String getTableName(String tmpMemberType, Connection db) {
        String tableName = "document_store_user_member";
        if (tmpMemberType.equals("role")) {
            tableName = "document_store_role_member";
        } else if (tmpMemberType.equals("department")) {
            tableName = DatabaseUtils.getTableName(db, "document_store_department_member");
        }
        return tableName;
    }
}

