/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class DocumentStoreTeamMemberList
extends ArrayList {
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ROLE = "role";
    public static final String DEPARTMENT = "department";
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    private DocumentStore documentStore = null;
    private String memberType = null;
    private String groupType = null;
    private int documentStoreId = -1;
    private int userLevel = -1;
    private String insertMembers = null;
    private String deleteMembers = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int forDocumentStoreUser = -1;
    private boolean employeesOnly = false;
    private boolean accountContactsOnly = false;
    private boolean portalUsersOnly = false;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setDocumentStore(DocumentStore tmp) {
        this.documentStore = tmp;
    }

    public void setMemberType(String tmp) {
        this.memberType = tmp;
    }

    public void setGroupType(String tmp) {
        this.groupType = tmp;
    }

    public void setDocumentStoreId(int tmp) {
        this.documentStoreId = tmp;
    }

    public void setDocumentStoreId(String tmp) {
        this.documentStoreId = Integer.parseInt(tmp);
    }

    public void setUserLevel(int tmp) {
        this.userLevel = tmp;
    }

    public void setUserLevel(String tmp) {
        this.userLevel = Integer.parseInt(tmp);
    }

    public void setInsertMembers(String tmp) {
        this.insertMembers = tmp;
    }

    public void setDeleteMembers(String tmp) {
        this.deleteMembers = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setForDocumentStoreUser(int tmp) {
        this.forDocumentStoreUser = tmp;
    }

    public void setForDocumentStoreUser(String tmp) {
        this.forDocumentStoreUser = Integer.parseInt(tmp);
    }

    public void setEmployeesOnly(boolean tmp) {
        this.employeesOnly = tmp;
    }

    public void setEmployeesOnly(String tmp) {
        this.employeesOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAccountContactsOnly(boolean tmp) {
        this.accountContactsOnly = tmp;
    }

    public void setAccountContactsOnly(String tmp) {
        this.accountContactsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public DocumentStore getDocumentStore() {
        return this.documentStore;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public int getDocumentStoreId() {
        return this.documentStoreId;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public String getInsertMembers() {
        return this.insertMembers;
    }

    public String getDeleteMembers() {
        return this.deleteMembers;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getForDocumentStoreUser() {
        return this.forDocumentStoreUser;
    }

    public boolean getEmployeesOnly() {
        return this.employeesOnly;
    }

    public boolean getAccountContactsOnly() {
        return this.accountContactsOnly;
    }

    public boolean getPortalUsersOnly() {
        return this.portalUsersOnly;
    }

    public void setPortalUsersOnly(boolean portalUsersOnly) {
        this.portalUsersOnly = portalUsersOnly;
    }

    public boolean hasUserId(int thisId) {
        for (DocumentStoreTeamMember thisMember : this) {
            if (thisMember.getItemId() != thisId) continue;
            return true;
        }
        return false;
    }

    public void buildList(Connection db) throws SQLException {
        String tableName = "";
        if (this.memberType.equals(USER)) {
            tableName = "document_store_user_member";
        }
        if (this.memberType.equals(ROLE)) {
            tableName = "document_store_role_member";
        }
        if (this.memberType.equals(DEPARTMENT)) {
            tableName = DatabaseUtils.getTableName(db, "document_store_department_member");
        }
        if ("".equals(tableName)) {
            throw new SQLException("table not specified");
        }
        this.buildMemberList(db, tableName);
    }

    private void buildMemberList(Connection db, String tableName) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        if (this.memberType.equals(USER)) {
            sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + tableName + " um, contact u, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = u.user_id " + "AND um.userlevel = r.code ");
        }
        if (this.memberType.equals(ROLE)) {
            sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + tableName + " um, " + DatabaseUtils.addQuotes(db, ROLE) + " rl, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = rl.role_id " + "AND um.userlevel = r.code ");
        }
        if (this.memberType.equals(DEPARTMENT)) {
            sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + tableName + " um, lookup_department d, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = d.code " + "AND um.userlevel = r.code ");
        }
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(-1);
        }
        this.createFilter(sqlFilter, tableName);
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        this.pagedListInfo.setDefaultSort("r." + DatabaseUtils.addQuotes(db, "level") + "", null);
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        if (this.memberType.equals(USER)) {
            sqlSelect.append("um.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM " + tableName + " um, contact u, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = u.user_id " + "AND um.userlevel = r.code ");
        }
        if (this.memberType.equals(ROLE)) {
            sqlSelect.append("um.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM " + tableName + " um, " + DatabaseUtils.addQuotes(db, ROLE) + " rl, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = rl.role_id " + "AND um.userlevel = r.code ");
        }
        if (this.memberType.equals(DEPARTMENT)) {
            sqlSelect.append("um.*, r." + DatabaseUtils.addQuotes(db, "level") + " " + "FROM " + tableName + " um, lookup_department d, lookup_document_store_role r " + "WHERE um.document_store_id > -1 " + "AND um.item_id = d.code " + "AND um.userlevel = r.code ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            DocumentStoreTeamMember thisTeamMember = new DocumentStoreTeamMember(rs);
            thisTeamMember.setDocumentStore(this.documentStore);
            thisTeamMember.setTeamMemberType(this.memberType);
            this.add(thisTeamMember);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, String tableName) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.documentStoreId > -1) {
            sqlFilter.append("AND document_store_id = ? ");
        }
        if (this.forDocumentStoreUser > -1) {
            sqlFilter.append("AND item_id = ?  AND  status = -1 ");
        }
        if (this.userLevel > -1) {
            sqlFilter.append("AND userlevel = ? ");
        }
        if (this.memberType.equals(USER) && this.employeesOnly) {
            sqlFilter.append(" AND u.org_id = 0 ");
        }
        if (this.memberType.equals(USER) && this.accountContactsOnly) {
            sqlFilter.append(" AND u.org_id > 0 ");
            sqlFilter.append(" AND um.role_type != ").append(1).append(" ");
        }
        if (this.memberType.equals(USER) && this.portalUsersOnly) {
            sqlFilter.append(" AND u.org_id > 0 ");
            sqlFilter.append(" AND um.role_type = ").append(1).append(" ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.documentStoreId > -1) {
            pst.setInt(++i, this.documentStoreId);
        }
        if (this.forDocumentStoreUser > -1) {
            pst.setInt(++i, this.forDocumentStoreUser);
        }
        if (this.userLevel > -1) {
            pst.setInt(++i, this.userLevel);
        }
        return i;
    }

    public boolean updateUserMembership(Connection db) throws SQLException {
        try {
            StringTokenizer items;
            db.setAutoCommit(false);
            if (this.insertMembers != null && !this.insertMembers.equals("") && this.documentStoreId > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("TeamMemberList-> New: " + this.insertMembers);
                }
                items = new StringTokenizer(this.insertMembers, "|");
                while (items.hasMoreTokens()) {
                    int itemId = -1;
                    String itemIdValue = items.nextToken();
                    itemId = itemIdValue.indexOf("@") > 0 ? User.getIdByEmailAddress(db, itemIdValue) : Integer.parseInt(itemIdValue);
                    if (itemId == -1) continue;
                    User user = new User(db, itemId);
                    if (DocumentStoreTeamMemberList.isUserOnTeam(db, this.documentStoreId, itemId)) continue;
                    PreparedStatement pst = db.prepareStatement("INSERT INTO document_store_user_member (document_store_id, item_id, userlevel, enteredby, modifiedby, status, role_type) VALUES (?, ?, ?, ?, ?, ?, ?) ");
                    int i = 0;
                    pst.setInt(++i, this.documentStoreId);
                    pst.setInt(++i, itemId);
                    DatabaseUtils.setInt(pst, ++i, this.userLevel);
                    pst.setInt(++i, this.enteredBy);
                    pst.setInt(++i, this.modifiedBy);
                    pst.setInt(++i, -1);
                    DatabaseUtils.setInt(pst, ++i, user.getRoleType());
                    pst.execute();
                    pst.close();
                }
            }
            if (this.deleteMembers != null && !this.deleteMembers.equals("") && this.documentStoreId > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("TeamMemberList-> Del: " + this.deleteMembers);
                }
                items = new StringTokenizer(this.deleteMembers, "|");
                while (items.hasMoreTokens()) {
                    String itemId = items.nextToken();
                    if (Integer.parseInt(itemId) == this.modifiedBy) continue;
                    PreparedStatement pst = db.prepareStatement("DELETE FROM document_store_user_member WHERE document_store_id = ? AND item_id = ?");
                    pst.setInt(1, this.documentStoreId);
                    pst.setInt(2, Integer.parseInt(itemId));
                    pst.execute();
                    pst.close();
                }
            }
            db.commit();
            db.setAutoCommit(true);
        }
        catch (SQLException e) {
            db.rollback();
            db.setAutoCommit(true);
            throw new SQLException(e.getMessage());
        }
        return true;
    }

    public void delete(Connection db, String tmpMemberType) throws SQLException {
        for (DocumentStoreTeamMember thisMember : this) {
            thisMember.delete(db, tmpMemberType);
        }
    }

    public static boolean isUserOnTeam(Connection db, int documentStoreId, int userId) throws SQLException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT userlevel FROM document_store_user_member WHERE document_store_id = ? AND item_id = ? ");
        pst.setInt(1, documentStoreId);
        pst.setInt(2, userId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public boolean updateGroupMembership(Connection db) throws SQLException {
        try {
            PreparedStatement pst;
            StringTokenizer items;
            db.setAutoCommit(false);
            if (this.insertMembers != null && !this.insertMembers.equals("") && this.documentStoreId > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("TeamMemberList-> New: " + this.insertMembers);
                }
                items = new StringTokenizer(this.insertMembers, "|");
                while (items.hasMoreTokens()) {
                    int itemId = -1;
                    int siteId = -1;
                    String itemIdValue = items.nextToken();
                    int indexValue = -1;
                    String tableName = "";
                    if (itemIdValue.indexOf("-D") > -1) {
                        indexValue = itemIdValue.indexOf("-D");
                        tableName = DatabaseUtils.getTableName(db, "document_store_department_member");
                    } else {
                        indexValue = itemIdValue.indexOf("-R");
                        tableName = "document_store_role_member";
                    }
                    itemId = Integer.parseInt(itemIdValue.substring(0, indexValue));
                    siteId = Integer.parseInt(itemIdValue.substring(indexValue + 2, itemIdValue.length()).trim());
                    if (itemId == -1 || DocumentStoreTeamMemberList.isGroupOnTeam(db, this.documentStoreId, itemId, tableName, siteId)) continue;
                    pst = db.prepareStatement("INSERT INTO " + tableName + " (document_store_id, item_id, userlevel, enteredby, modifiedby, status, site_id) " + " VALUES (?, ?, ?, ?, ?, ?, ?) ");
                    int i = 0;
                    pst.setInt(++i, this.documentStoreId);
                    pst.setInt(++i, itemId);
                    DatabaseUtils.setInt(pst, ++i, this.userLevel);
                    pst.setInt(++i, this.enteredBy);
                    pst.setInt(++i, this.modifiedBy);
                    pst.setInt(++i, -1);
                    DatabaseUtils.setInt(pst, ++i, siteId);
                    pst.execute();
                    pst.close();
                }
            }
            if (this.deleteMembers != null && !this.deleteMembers.equals("") && this.documentStoreId > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("TeamMemberList-> Del: " + this.deleteMembers);
                }
                items = new StringTokenizer(this.deleteMembers, "|");
                while (items.hasMoreTokens()) {
                    String itemIdValue = items.nextToken();
                    int indexValue = -1;
                    String tableName = "";
                    if (itemIdValue.indexOf("-D") > -1) {
                        indexValue = itemIdValue.indexOf("-D");
                        tableName = DatabaseUtils.getTableName(db, "document_store_department_member");
                    } else {
                        indexValue = itemIdValue.indexOf("-R");
                        tableName = "document_store_role_member";
                    }
                    int itemId = Integer.parseInt(itemIdValue.substring(0, indexValue));
                    int siteId = Integer.parseInt(itemIdValue.substring(indexValue + 2, itemIdValue.length()).trim());
                    pst = db.prepareStatement(" DELETE FROM " + tableName + " WHERE document_store_id = ? " + " AND item_id = ? " + " AND " + (siteId == -1 ? " site_id IS NULL " : " site_id = ? "));
                    pst.setInt(1, this.documentStoreId);
                    pst.setInt(2, itemId);
                    if (siteId > -1) {
                        pst.setInt(3, siteId);
                    }
                    pst.execute();
                    pst.close();
                }
            }
            db.commit();
            db.setAutoCommit(true);
        }
        catch (SQLException e) {
            db.rollback();
            db.setAutoCommit(true);
            throw new SQLException(e.getMessage());
        }
        return true;
    }

    public static boolean isGroupOnTeam(Connection db, int documentStoreId, int roleId, String tableName, int tmpSiteId) throws SQLException {
        ResultSet rs;
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement(" SELECT userlevel  FROM " + tableName + " WHERE document_store_id = ? " + " AND item_id = ? " + " AND " + (tmpSiteId == -1 ? "site_id IS NULL " : "site_id = ? "));
        pst.setInt(1, documentStoreId);
        pst.setInt(2, roleId);
        if (tmpSiteId > -1) {
            pst.setInt(3, tmpSiteId);
        }
        if ((rs = pst.executeQuery()).next()) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public static void reassignElements(Connection db, int fromUserId, int toUserItemId) throws SQLException {
        PreparedStatement pst = db.prepareStatement(" UPDATE document_store_user_member  SET item_id = ?  WHERE item_id = ?  AND userlevel = ? ");
        int i = 0;
        pst.setInt(++i, toUserItemId);
        pst.setInt(++i, fromUserId);
        pst.setInt(++i, 1);
        pst.execute();
        pst.close();
    }

    public static void reassignElements(Connection db, int fromUserId, int toUserItemId, int userId) throws SQLException {
        PreparedStatement pst = db.prepareStatement(" UPDATE document_store_user_member  SET item_id = ?, modifiedby = ?  WHERE item_id = ?  AND userlevel = ? ");
        int i = 0;
        pst.setInt(++i, toUserItemId);
        pst.setInt(++i, userId);
        pst.setInt(++i, fromUserId);
        pst.setInt(++i, 1);
        pst.execute();
        pst.close();
    }

    public void setSiteIdForMembers(SystemStatus systemStatus) throws SQLException {
        for (DocumentStoreTeamMember member : this) {
            User user;
            if (member.getItemId() == -1 || (user = systemStatus.getUser(member.getItemId())) == null) continue;
            member.setSiteId(user.getSiteId());
        }
    }
}

