/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.search;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.documents.base.DocumentStorePermissionList;
import org.aspcfs.modules.documents.beans.DocumentsSearchBean;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentsSearchQuery {
    public static String buildDocumentStoreSearchQuery(ActionContext context, DocumentsSearchBean search, Connection db, int userId, int specificDocumentStoreId) throws SQLException {
        HashMap<Integer, Integer> documentStoreListForUser = new HashMap<Integer, Integer>();
        PreparedStatement pst = db.prepareStatement("SELECT document_store_id, userlevel FROM document_store_user_member WHERE item_id = ? " + (specificDocumentStoreId > -1 ? "AND document_store_id = ? " : ""));
        pst.setInt(1, userId);
        if (specificDocumentStoreId > -1) {
            pst.setInt(2, specificDocumentStoreId);
        }
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            int documentStoreId = rs.getInt("document_store_id");
            int roleId = rs.getInt("userlevel");
            documentStoreListForUser.put(new Integer(documentStoreId), new Integer(roleId));
        }
        rs.close();
        pst.close();
        HashMap<Integer, Integer> documentStoreListForGroup = new HashMap<Integer, Integer>();
        UserBean tmpUser = (UserBean)((Object)context.getRequest().getSession().getAttribute("User"));
        int tmpUserRoleId = tmpUser.getRoleId();
        pst = db.prepareStatement("SELECT document_store_id, userlevel FROM document_store_role_member WHERE item_id = ? " + (specificDocumentStoreId > -1 ? "AND document_store_id = ? " : ""));
        pst.setInt(1, tmpUserRoleId);
        if (specificDocumentStoreId > -1) {
            pst.setInt(2, specificDocumentStoreId);
        }
        rs = pst.executeQuery();
        while (rs.next()) {
            int documentStoreId = rs.getInt("document_store_id");
            int roleId = rs.getInt("userlevel");
            documentStoreListForGroup.put(new Integer(documentStoreId), new Integer(roleId));
        }
        rs.close();
        pst.close();
        Contact tmpContact = new Contact(db, tmpUser.getContact().getId());
        int tmpDepartmentId = tmpContact.getDepartment();
        pst = db.prepareStatement("SELECT document_store_id, userlevel FROM " + DatabaseUtils.getTableName(db, "document_store_department_member") + " " + "WHERE item_id = ? " + (specificDocumentStoreId > -1 ? "AND document_store_id = ? " : ""));
        pst.setInt(1, tmpDepartmentId);
        if (specificDocumentStoreId > -1) {
            pst.setInt(2, specificDocumentStoreId);
        }
        rs = pst.executeQuery();
        while (rs.next()) {
            int documentStoreId = rs.getInt("document_store_id");
            int roleId = rs.getInt("userlevel");
            if (!documentStoreListForGroup.containsKey(new Integer(documentStoreId))) {
                documentStoreListForGroup.put(new Integer(documentStoreId), new Integer(roleId));
                continue;
            }
            int tmpUserLevel = (Integer)documentStoreListForGroup.get(new Integer(documentStoreId));
            if (tmpUserLevel <= roleId) continue;
            documentStoreListForGroup.put(new Integer(documentStoreId), new Integer(roleId));
        }
        rs.close();
        pst.close();
        HashMap<Integer, Integer> documentStoreList = new HashMap<Integer, Integer>();
        documentStoreList.putAll(documentStoreListForGroup);
        documentStoreList.putAll(documentStoreListForUser);
        StringBuffer documentStoreBuffer = new StringBuffer();
        Iterator documentStores = documentStoreList.keySet().iterator();
        while (documentStores.hasNext()) {
            StringBuffer permissionBuffer = new StringBuffer();
            Integer documentStoreId = (Integer)documentStores.next();
            Integer roleId = (Integer)documentStoreList.get(documentStoreId);
            DocumentStorePermissionList permissionList = new DocumentStorePermissionList();
            permissionList.setDocumentStoreId(documentStoreId);
            permissionList.buildList(db);
            if ((search.getSection() == 2 || search.getSection() == -1) && permissionList.getAccessLevel("documentcenter-details-view") >= roleId) {
                if (permissionBuffer.length() > 0) {
                    permissionBuffer.append(" OR ");
                }
                permissionBuffer.append("type:documentstoredetails");
            }
            if ((search.getSection() == 1 || search.getSection() == -1) && permissionList.getAccessLevel("documentcenter-documents-view") >= roleId) {
                if (permissionBuffer.length() > 0) {
                    permissionBuffer.append(" OR ");
                }
                permissionBuffer.append("type:file");
            }
            if (permissionBuffer.length() > 0) {
                if (documentStoreBuffer.length() > 0) {
                    documentStoreBuffer.append(" OR ");
                }
                documentStoreBuffer.append("(documentStoreId:" + documentStoreId + " AND (" + permissionBuffer.toString() + ")) ");
            }
            if (System.getProperty("DEBUG") == null || permissionBuffer.length() != 0) continue;
            System.out.println("NO PERMISSIONS FOR DOCUMENT STORE: " + documentStoreId);
        }
        if (documentStoreBuffer.length() == 0) {
            return "documentStoreId:-1";
        }
        return documentStoreBuffer.toString();
    }
}

