/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.documents.webdav;

import com.zeroio.webdav.context.BaseWebdavContext;
import com.zeroio.webdav.context.ItemContext;
import com.zeroio.webdav.context.ModuleContext;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.NamingException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class DocumentsWebdavContext
extends BaseWebdavContext
implements ModuleContext {
    private static final String DOCUMENTS = "documents";
    private int linkModuleId = 20041083;
    private int userId = -1;
    private String fileLibraryPath = null;
    private String permission = "documents-view";

    public DocumentsWebdavContext() {
    }

    public DocumentsWebdavContext(String name, int linkModuleId) {
        this.contextName = name;
        this.linkModuleId = linkModuleId;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public int getUserId() {
        return this.userId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public void setPermission(String tmp) {
        this.permission = tmp;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public String getFileLibraryPath() {
        return this.fileLibraryPath;
    }

    public String getPermission() {
        return this.permission;
    }

    public void buildResources(SystemStatus thisSystem, Connection db, int userId, String fileLibraryPath) throws SQLException {
        this.fileLibraryPath = fileLibraryPath;
        this.userId = userId;
        this.bindings.clear();
        if (this.hasPermission(thisSystem, userId, "documents-view")) {
            this.populateBindings(db);
        }
    }

    public void populateBindings(Connection db) throws SQLException {
        if (this.linkModuleId == -1) {
            throw new SQLException("Module ID not specified");
        }
        User user = new User(db, this.userId);
        Contact contact = new Contact(db, user.getContactId());
        PreparedStatement pst = db.prepareStatement("SELECT document_store_id, title, entered, modified FROM document_store WHERE document_store_id > -1 AND ((document_store_id in (SELECT DISTINCT document_store_id FROM document_store_user_member WHERE item_id = ? )) OR (document_store_id in (SELECT DISTINCT document_store_id FROM document_store_role_member WHERE item_id = ? )) OR (document_store_id in (SELECT DISTINCT document_store_id FROM " + DatabaseUtils.getTableName(db, "document_store_department_member") + " WHERE item_id = ? ))) " + "AND trashed_date IS NULL ");
        int i = 0;
        pst.setInt(++i, this.userId);
        pst.setInt(++i, user.getRoleId());
        pst.setInt(++i, contact.getDepartment());
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ItemContext item = new ItemContext();
            item.setContextName(rs.getString("title"));
            item.setLinkModuleId(this.linkModuleId);
            item.setLinkItemId(rs.getInt("document_store_id"));
            item.setPath(this.fileLibraryPath + DOCUMENTS + fs);
            item.setUserId(this.userId);
            item.setPermission("documentcenter-documents");
            this.bindings.put(item.getContextName(), item);
            Timestamp entered = rs.getTimestamp("entered");
            Timestamp modified = rs.getTimestamp("modified");
            this.buildProperties(item.getContextName(), entered, modified, new Integer(0));
        }
        rs.close();
        pst.close();
    }

    public boolean createSubcontext(SystemStatus thisSystem, Connection db, String folderName) throws SQLException, FileNotFoundException, NamingException {
        return false;
    }
}

